/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.phpdoc;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.util.ObjectUtils;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.config.PhpLanguageFeature;
import com.jetbrains.php.lang.documentation.phpdoc.PhpDocUtil;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocComment;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.inspections.phpdoc.GeneratePhpDocQuickFix;
import com.jetbrains.php.lang.inspections.phpdoc.PhpAddDocCommentFromBaseQuickFix;
import com.jetbrains.php.lang.psi.elements.Constant;
import com.jetbrains.php.lang.psi.elements.Field;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpClassMember;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.elements.PhpPropertyHook;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public abstract class PhpMissingDocCommentBaseInspection
extends PhpInspection {
    private static final LocalQuickFix[] GENERATE_FIX = new LocalQuickFix[]{GeneratePhpDocQuickFix.INSTANCE};
    private static final LocalQuickFix[] GENERATE_FIX_ON_THE_FLY = new LocalQuickFix[]{GeneratePhpDocQuickFix.ON_THE_FLY};
    private static final LocalQuickFix[] GENERATE_AND_COPY_FIXES = new LocalQuickFix[]{GeneratePhpDocQuickFix.INSTANCE, PhpAddDocCommentFromBaseQuickFix.INSTANCE};
    private static final LocalQuickFix[] GENERATE_ON_THE_FLY_AND_COPY_FIXES = new LocalQuickFix[]{GeneratePhpDocQuickFix.ON_THE_FLY, PhpAddDocCommentFromBaseQuickFix.INSTANCE};
    public boolean CHECK_CONSTANT = false;
    public boolean CHECK_FUNCTION = true;
    public boolean CHECK_CLASS = true;
    public boolean CHECK_METHOD = true;
    public boolean CHECK_FIELD = false;
    public boolean CHECK_CLASS_CONSTANT = false;
    public boolean IGNORE_PRIVATE_MEMBERS = false;

    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, final boolean isOnTheFly) {
        if (holder == null) {
            PhpMissingDocCommentBaseInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(){

            public void visitPhpConstant(Constant constant) {
                if (PhpMissingDocCommentBaseInspection.this.CHECK_CONSTANT) {
                    PhpMissingDocCommentBaseInspection.this.checkElement((PhpNamedElement)constant, PhpMissingDocCommentBaseInspection.getErrorBatchConstant(), holder, isOnTheFly);
                }
            }

            public void visitPhpFunction(Function function) {
                if (PhpMissingDocCommentBaseInspection.this.CHECK_FUNCTION) {
                    PhpMissingDocCommentBaseInspection.this.checkElement((PhpNamedElement)function, PhpMissingDocCommentBaseInspection.getErrorBatchFunction(), holder, isOnTheFly);
                }
            }

            public void visitPhpClass(PhpClass clazz) {
                if (PhpMissingDocCommentBaseInspection.this.CHECK_CLASS) {
                    PhpMissingDocCommentBaseInspection.this.checkElement((PhpNamedElement)clazz, PhpMissingDocCommentBaseInspection.getErrorBatchClass(), holder, isOnTheFly);
                }
            }

            public void visitPhpMethod(Method method) {
                if (PhpMissingDocCommentBaseInspection.this.CHECK_METHOD) {
                    PhpMissingDocCommentBaseInspection.this.checkElement((PhpNamedElement)method, PhpMissingDocCommentBaseInspection.getErrorBatchMethod(), holder, isOnTheFly);
                }
            }

            public void visitPhpField(Field field) {
                if (field.isConstant()) {
                    if (PhpMissingDocCommentBaseInspection.this.CHECK_CLASS_CONSTANT) {
                        PhpMissingDocCommentBaseInspection.this.checkElement((PhpNamedElement)field, PhpMissingDocCommentBaseInspection.getErrorBatchClassConstant(), holder, isOnTheFly);
                    }
                } else if (PhpMissingDocCommentBaseInspection.this.CHECK_FIELD) {
                    if (PhpLanguageFeature.TYPED_PROPERTIES.isSupported(field.getProject()) && field.getTypeDeclaration() != null) {
                        return;
                    }
                    PhpMissingDocCommentBaseInspection.this.checkElement((PhpNamedElement)field, PhpMissingDocCommentBaseInspection.getErrorBatchField(), holder, isOnTheFly);
                }
            }
        };
    }

    private void checkElement(@NotNull PhpNamedElement namedElement, @NotNull @InspectionMessage String batchErrorMessage, @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        ASTNode nameNode;
        if (namedElement == null) {
            PhpMissingDocCommentBaseInspection.$$$reportNull$$$0(1);
        }
        if (batchErrorMessage == null) {
            PhpMissingDocCommentBaseInspection.$$$reportNull$$$0(2);
        }
        if (holder == null) {
            PhpMissingDocCommentBaseInspection.$$$reportNull$$$0(3);
        }
        if (namedElement instanceof PhpPropertyHook) {
            return;
        }
        if (this.IGNORE_PRIVATE_MEMBERS && PhpMissingDocCommentBaseInspection.hasPrivateVisibility(namedElement)) {
            return;
        }
        if (!this.isDocCommentNeededFor(namedElement)) {
            return;
        }
        PhpDocComment comment = namedElement.getDocComment();
        if ((comment == null || PhpDocUtil.hasOnlyNoInspectionTag(comment)) && (nameNode = namedElement.getNameNode()) != null) {
            PhpDocComment docComment = PhpAddDocCommentFromBaseQuickFix.getBaseDocComment((PsiElement)namedElement);
            holder.registerProblem(nameNode.getPsi(), isOnTheFly ? PhpMissingDocCommentBaseInspection.getErrorOnTheFly() : batchErrorMessage, PhpMissingDocCommentBaseInspection.getFixes(docComment, isOnTheFly));
        }
    }

    private static boolean hasPrivateVisibility(@NotNull PhpNamedElement namedElement) {
        PhpClassMember classMember;
        if (namedElement == null) {
            PhpMissingDocCommentBaseInspection.$$$reportNull$$$0(4);
        }
        return (classMember = (PhpClassMember)ObjectUtils.tryCast((Object)namedElement, PhpClassMember.class)) != null && classMember.getModifier().isPrivate();
    }

    private static LocalQuickFix @NotNull [] getFixes(@Nullable PhpDocComment docComment, boolean onTheFly) {
        if (onTheFly) {
            LocalQuickFix[] localQuickFixArray = docComment == null ? GENERATE_FIX_ON_THE_FLY : GENERATE_ON_THE_FLY_AND_COPY_FIXES;
            if (localQuickFixArray == null) {
                PhpMissingDocCommentBaseInspection.$$$reportNull$$$0(5);
            }
            return localQuickFixArray;
        }
        LocalQuickFix[] localQuickFixArray = docComment == null ? GENERATE_FIX : GENERATE_AND_COPY_FIXES;
        if (localQuickFixArray == null) {
            PhpMissingDocCommentBaseInspection.$$$reportNull$$$0(6);
        }
        return localQuickFixArray;
    }

    protected boolean isDocCommentNeededFor(@NotNull PhpNamedElement element) {
        if (element == null) {
            PhpMissingDocCommentBaseInspection.$$$reportNull$$$0(7);
        }
        return true;
    }

    public static boolean isConstructor(@NotNull Function function) {
        if (function == null) {
            PhpMissingDocCommentBaseInspection.$$$reportNull$$$0(8);
        }
        return function instanceof Method && ((Method)function).getMethodType(false) == Method.MethodType.CONSTRUCTOR;
    }

    @Override
    @NotNull
    public OptPane getOptionsPane() {
        OptPane optPane = OptPane.pane((OptRegularComponent[])new OptRegularComponent[]{OptPane.checkbox((String)"IGNORE_PRIVATE_MEMBERS", (String)PhpBundle.message("inspection.missing.doc.comment.options.panel.ignore.private.members", new Object[0]), (OptRegularComponent[])new OptRegularComponent[0]), OptPane.checkbox((String)"CHECK_CONSTANT", (String)PhpBundle.message("inspection.missing.doc.comment.options.panel.constant", new Object[0]), (OptRegularComponent[])new OptRegularComponent[0]), OptPane.checkbox((String)"CHECK_FUNCTION", (String)PhpBundle.message("inspection.missing.doc.comment.options.panel.function", new Object[0]), (OptRegularComponent[])new OptRegularComponent[0]), OptPane.checkbox((String)"CHECK_CLASS", (String)PhpBundle.message("inspection.missing.doc.comment.options.panel.class", new Object[0]), (OptRegularComponent[])new OptRegularComponent[0]), OptPane.checkbox((String)"CHECK_METHOD", (String)PhpBundle.message("inspection.missing.doc.comment.options.panel.method", new Object[0]), (OptRegularComponent[])new OptRegularComponent[0]), OptPane.checkbox((String)"CHECK_FIELD", (String)PhpBundle.message("inspection.missing.doc.comment.options.panel.field", new Object[0]), (OptRegularComponent[])new OptRegularComponent[0]), OptPane.checkbox((String)"CHECK_CLASS_CONSTANT", (String)PhpBundle.message("inspection.missing.doc.comment.options.panel.class.constant", new Object[0]), (OptRegularComponent[])new OptRegularComponent[0])});
        if (optPane == null) {
            PhpMissingDocCommentBaseInspection.$$$reportNull$$$0(9);
        }
        return optPane;
    }

    @InspectionMessage
    private static String getErrorOnTheFly() {
        return PhpBundle.message("inspection.missing.doc.comment.problem", new Object[0]);
    }

    @InspectionMessage
    private static String getErrorBatchConstant() {
        return PhpBundle.message("inspection.missing.doc.comment.problem.batch", "constant");
    }

    @InspectionMessage
    private static String getErrorBatchFunction() {
        return PhpBundle.message("inspection.missing.doc.comment.problem.batch", "function");
    }

    @InspectionMessage
    private static String getErrorBatchClass() {
        return PhpBundle.message("inspection.missing.doc.comment.problem.batch", "class");
    }

    @InspectionMessage
    private static String getErrorBatchMethod() {
        return PhpBundle.message("inspection.missing.doc.comment.problem.batch", "method");
    }

    @InspectionMessage
    private static String getErrorBatchField() {
        return PhpBundle.message("inspection.missing.doc.comment.problem.batch", "field");
    }

    @InspectionMessage
    private static String getErrorBatchClassConstant() {
        return PhpBundle.message("inspection.missing.doc.comment.problem.batch", "class constant");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 6, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namedElement";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "batchErrorMessage";
                break;
            }
            case 5: 
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/phpdoc/PhpMissingDocCommentBaseInspection";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/phpdoc/PhpMissingDocCommentBaseInspection";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getFixes";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsPane";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "checkElement";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "hasPrivateVisibility";
                break;
            }
            case 5: 
            case 6: 
            case 9: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isDocCommentNeededFor";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isConstructor";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 6, 9 -> new IllegalStateException(string);
        };
    }
}

