/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.phpunit;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.MethodReference;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpClassMember;
import com.jetbrains.php.phpunit.PhpUnitUtil;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpUnitAssertUtil {
    private static final String PHPUNIT_ASSERT_FQN = "\\PHPUnit_Framework_Assert";
    private static final String PHPUNIT6_ASSERT_FQN = "\\PHPUnit\\Framework\\Assert";

    private PhpUnitAssertUtil() {
    }

    public static boolean isInsideTestClass(@Nullable PsiElement psiElement) {
        PhpClass currentClass = PhpPsiUtil.getParentOfClass(psiElement, PhpClass.class);
        return currentClass != null && PhpUnitUtil.extendsRootTestClass(currentClass);
    }

    public static boolean isImplementedInPhpUnitAssertClass(@NotNull MethodReference methodReference) {
        Set classes;
        if (methodReference == null) {
            PhpUnitAssertUtil.$$$reportNull$$$0(0);
        }
        return !(classes = methodReference.multiResolveStrict(Method.class).stream().map(PhpClassMember::getContainingClass).filter(Objects::nonNull).collect(Collectors.toSet())).isEmpty() && ContainerUtil.and(classes, c -> StringUtil.equalsIgnoreCase((CharSequence)PHPUNIT_ASSERT_FQN, (CharSequence)c.getFQN()) || StringUtil.equalsIgnoreCase((CharSequence)PHPUNIT6_ASSERT_FQN, (CharSequence)c.getFQN()));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodReference", "com/jetbrains/php/lang/inspections/phpunit/PhpUnitAssertUtil", "isImplementedInPhpUnitAssertClass"));
    }
}

