/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.phpunit;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.inspections.phpunit.PhpUnitAssertArrayHasKeyInspection;
import com.jetbrains.php.lang.inspections.phpunit.quickfix.PhpUnitReplaceDeprecatedUsageExpectExceptionQuickFix;
import com.jetbrains.php.lang.psi.elements.ClassConstantReference;
import com.jetbrains.php.lang.psi.elements.ClassReference;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.MethodReference;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpClassMember;
import com.jetbrains.php.lang.psi.elements.PhpExpression;
import com.jetbrains.php.lang.psi.elements.PhpModifier;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import com.jetbrains.php.phpunit.PhpUnitUtil;
import com.jetbrains.php.util.PhpStringUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpUnitDeprecatedExpectExceptionInspection
extends PhpInspection {
    @NonNls
    private static final String METHOD_NAME = "expectException";
    @NonNls
    private static final String CLASS_CONSTANT = "class";
    @NonNls
    private static final Map<String, String> REPLACEMENTS_FOR_DEPRECATED_USAGE = Map.of("\\PHPUnit\\Framework\\Error\\Deprecated", "expectDeprecation", "\\PHPUnit\\Framework\\Error\\Error", "expectError", "\\PHPUnit\\Framework\\Error\\Notice", "expectNotice", "\\PHPUnit\\Framework\\Error\\Warning", "expectWarning");
    private static final Collection<String> NEW_METHODS = REPLACEMENTS_FOR_DEPRECATED_USAGE.values().stream().collect(PhpStringUtil.toCaseInsensitiveSet());

    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpUnitDeprecatedExpectExceptionInspection.$$$reportNull$$$0(0);
        }
        if (!PhpUnitDeprecatedExpectExceptionInspection.existAllNewMethods(holder.getProject())) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            if (psiElementVisitor == null) {
                PhpUnitDeprecatedExpectExceptionInspection.$$$reportNull$$$0(1);
            }
            return psiElementVisitor;
        }
        return new PhpElementVisitor(this){

            public void visitPhpMethodReference(MethodReference reference) {
                if (!PhpUnitDeprecatedExpectExceptionInspection.isSuitableMethod(reference)) {
                    return;
                }
                String classFqn = PhpUnitDeprecatedExpectExceptionInspection.getClassFqnOfDeprecatedParameter(reference);
                if (classFqn == null) {
                    return;
                }
                String newMethodName = REPLACEMENTS_FOR_DEPRECATED_USAGE.get(classFqn);
                if (newMethodName == null) {
                    return;
                }
                ASTNode nameNode = reference.getNameNode();
                if (nameNode == null) {
                    return;
                }
                PsiElement identifier = nameNode.getPsi();
                holder.registerProblem(identifier, PhpUnitDeprecatedExpectExceptionInspection.buildDescription(classFqn, newMethodName), new LocalQuickFix[]{new PhpUnitReplaceDeprecatedUsageExpectExceptionQuickFix(newMethodName)});
            }
        };
    }

    @Nullable
    public static String getClassFqnOfDeprecatedParameter(MethodReference reference) {
        ClassConstantReference parameter = (ClassConstantReference)ObjectUtils.tryCast((Object)PhpUnitAssertArrayHasKeyInspection.findArgumentWithMappedParamIndex((FunctionReference)reference, 0), ClassConstantReference.class);
        if (parameter == null) {
            return null;
        }
        if (!CLASS_CONSTANT.equalsIgnoreCase(parameter.getName())) {
            return null;
        }
        PhpExpression classReference = parameter.getClassReference();
        if (classReference == null) {
            return null;
        }
        return ((ClassReference)classReference).getFQN();
    }

    private static boolean isSuitableMethod(@NotNull MethodReference reference) {
        if (reference == null) {
            PhpUnitDeprecatedExpectExceptionInspection.$$$reportNull$$$0(2);
        }
        if (!METHOD_NAME.equalsIgnoreCase(reference.getName())) {
            return false;
        }
        Set classes = reference.multiResolveStrict(Method.class).stream().map(PhpClassMember::getContainingClass).filter(Objects::nonNull).collect(Collectors.toSet());
        return !classes.isEmpty() && ContainerUtil.and(classes, c -> "\\PHPUnit\\Framework\\TestCase".equals(c.getFQN()));
    }

    private static boolean existAllNewMethods(@NotNull Project project) {
        if (project == null) {
            PhpUnitDeprecatedExpectExceptionInspection.$$$reportNull$$$0(3);
        }
        Collection<PhpClass> phpUnitTestCaseClasses = PhpUnitUtil.getTestCaseClasses(project);
        return phpUnitTestCaseClasses.stream().flatMap(clazz -> Arrays.stream(clazz.getOwnMethods())).filter(method -> method.getAccess().isWeakerThan(PhpModifier.Access.PRIVATE)).map(method -> method.getName()).anyMatch(methodName -> NEW_METHODS.contains(methodName));
    }

    @NotNull
    @InspectionMessage
    private static String buildDescription(String className, String methodName) {
        String string = PhpBundle.message("inspection.phpunit.expectException", className, methodName);
        if (string == null) {
            PhpUnitDeprecatedExpectExceptionInspection.$$$reportNull$$$0(4);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/phpunit/PhpUnitDeprecatedExpectExceptionInspection";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/phpunit/PhpUnitDeprecatedExpectExceptionInspection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "buildDescription";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: 
            case 4: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isSuitableMethod";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "existAllNewMethods";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 4 -> new IllegalStateException(string);
        };
    }
}

