/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.probablyBug;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.codeInsight.PhpCodeInsightUtil;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.inspections.controlFlow.PhpSideEffectDetector;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.ParameterList;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import org.jetbrains.annotations.NotNull;

public final class PhpVarExportUsedWithoutReturnArgumentInspection
extends PhpInspection {
    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpVarExportUsedWithoutReturnArgumentInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(this){

            public void visitPhpFunctionCall(FunctionReference reference) {
                String constantReturnResult;
                boolean isFalse = PhpType.global((PsiElement[])new PsiElement[]{reference.getParameter(1)}).equals((Object)PhpType.FALSE);
                if ((reference.getParameters().length == 1 || isFalse) && (constantReturnResult = PhpSideEffectDetector.getExportFunctionConstantReturnResult(reference, true)) != null && PhpCodeInsightUtil.isResultUsed((PsiElement)reference)) {
                    if (isFalse) {
                        holder.registerProblem((PsiElement)reference, PhpBundle.message("inspection.message.var.export.with.return.argument.equals.false.always.returns.null", reference.getName(), constantReturnResult), new LocalQuickFix[]{PhpReplaceReturnArgumentWithTrueQuickFix.INSTANCE});
                    } else {
                        holder.registerProblem((PsiElement)reference, PhpBundle.message("inspection.message.var.export.without.return.argument.always.returns.null", reference.getName(), constantReturnResult), new LocalQuickFix[]{PhpAddTrueArgumentQuickFix.INSTANCE});
                    }
                }
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/jetbrains/php/lang/inspections/probablyBug/PhpVarExportUsedWithoutReturnArgumentInspection", "buildVisitor"));
    }

    private static class PhpAddTrueArgumentQuickFix
    extends PsiUpdateModCommandQuickFix {
        static final LocalQuickFix INSTANCE = new PhpAddTrueArgumentQuickFix();

        private PhpAddTrueArgumentQuickFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("intention.family.name.add.true.argument.to.var.export.call", new Object[0]);
            if (string == null) {
                PhpAddTrueArgumentQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            FunctionReference functionReference;
            ParameterList list;
            if (project == null) {
                PhpAddTrueArgumentQuickFix.$$$reportNull$$$0(1);
            }
            if (element == null) {
                PhpAddTrueArgumentQuickFix.$$$reportNull$$$0(2);
            }
            if (updater == null) {
                PhpAddTrueArgumentQuickFix.$$$reportNull$$$0(3);
            }
            if ((list = (functionReference = (FunctionReference)element).getParameterList()) == null) {
                return;
            }
            if (!PhpPsiUtil.isOfType(list.getLastChild(), PhpTokenTypes.opCOMMA)) {
                list.add(PhpPsiElementFactory.createComma(project));
            }
            list.add((PsiElement)PhpPsiElementFactory.createConstantReference(project, "true"));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/probablyBug/PhpVarExportUsedWithoutReturnArgumentInspection$PhpAddTrueArgumentQuickFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/probablyBug/PhpVarExportUsedWithoutReturnArgumentInspection$PhpAddTrueArgumentQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }

    private static class PhpReplaceReturnArgumentWithTrueQuickFix
    extends PsiUpdateModCommandQuickFix {
        static final LocalQuickFix INSTANCE = new PhpReplaceReturnArgumentWithTrueQuickFix();

        private PhpReplaceReturnArgumentWithTrueQuickFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("intention.family.name.replace.true.argument.with.false", new Object[0]);
            if (string == null) {
                PhpReplaceReturnArgumentWithTrueQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            PsiElement parameter;
            if (project == null) {
                PhpReplaceReturnArgumentWithTrueQuickFix.$$$reportNull$$$0(1);
            }
            if (element == null) {
                PhpReplaceReturnArgumentWithTrueQuickFix.$$$reportNull$$$0(2);
            }
            if (updater == null) {
                PhpReplaceReturnArgumentWithTrueQuickFix.$$$reportNull$$$0(3);
            }
            if ((parameter = ((FunctionReference)element).getParameter(1)) == null) {
                return;
            }
            parameter.replace((PsiElement)PhpPsiElementFactory.createConstantReference(project, "true"));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/probablyBug/PhpVarExportUsedWithoutReturnArgumentInspection$PhpReplaceReturnArgumentWithTrueQuickFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/probablyBug/PhpVarExportUsedWithoutReturnArgumentInspection$PhpReplaceReturnArgumentWithTrueQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }
}

