/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.quickfix;

import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ControlStatement;
import com.jetbrains.php.lang.psi.elements.ElseIf;
import com.jetbrains.php.lang.psi.elements.PhpCase;
import com.jetbrains.php.lang.psi.elements.Statement;
import com.jetbrains.php.surroundWith.PhpTryCatchSurrounder;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\b\u001a\u00020\u0007H\u0016J3\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u0003H\u0096\u0002J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u00a8\u0006\u0014"}, d2={"Lcom/jetbrains/php/lang/inspections/quickfix/PhpSurroundWithTryCatchQuickFix;", "Lcom/intellij/codeInspection/LocalQuickFixAndIntentionActionOnPsiElement;", "element", "Lcom/intellij/psi/PsiElement;", "<init>", "(Lcom/intellij/psi/PsiElement;)V", "getText", "", "getFamilyName", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "psiFile", "Lcom/intellij/psi/PsiFile;", "editor", "Lcom/intellij/openapi/editor/Editor;", "endElement", "findStatement", "Lcom/jetbrains/php/lang/psi/elements/Statement;", "intellij.php.impl"})
public final class PhpSurroundWithTryCatchQuickFix
extends LocalQuickFixAndIntentionActionOnPsiElement {
    public PhpSurroundWithTryCatchQuickFix(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        super(element);
    }

    @NotNull
    public String getText() {
        String string = PhpBundle.message("php.surround.with.try.catch.quick.fix", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    @NotNull
    public String getFamilyName() {
        return this.getText();
    }

    public void invoke(@NotNull Project project, @NotNull PsiFile psiFile, @Nullable Editor editor, @NotNull PsiElement element, @NotNull PsiElement endElement) {
        CaretModel caretModel;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)endElement, (String)"endElement");
        Statement statement = this.findStatement(element);
        Editor editor2 = editor;
        CaretModel caretModel2 = caretModel = editor2 != null ? editor2.getCaretModel() : null;
        if (caretModel2 != null) {
            caretModel2.moveToLogicalPosition(new LogicalPosition(0, 0));
        }
        PhpTryCatchSurrounder phpTryCatchSurrounder = new PhpTryCatchSurrounder();
        Editor editor3 = editor;
        Intrinsics.checkNotNull((Object)editor3);
        Statement[] statementArray = new Statement[]{statement};
        TextRange textRange = phpTryCatchSurrounder.surroundElements(project, editor3, (PsiElement[])statementArray);
        Intrinsics.checkNotNull((Object)textRange);
        TextRange range = textRange;
        if (caretModel != null) {
            editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
            editor.getSelectionModel().setSelection(range.getStartOffset(), range.getEndOffset());
        }
    }

    private final Statement findStatement(PsiElement element) {
        Statement statement;
        Object t = PhpPsiUtil.getParentByCondition(element, false, (Condition<? super PsiElement>)Statement.INSTANCEOF);
        Intrinsics.checkNotNull(t);
        Statement statement2 = (Statement)t;
        if (statement2 instanceof ElseIf || statement2 instanceof PhpCase) {
            PsiElement psiElement = ((ControlStatement)statement2).getParent();
            Intrinsics.checkNotNull((Object)psiElement, (String)"null cannot be cast to non-null type com.jetbrains.php.lang.psi.elements.Statement");
            statement = (Statement)psiElement;
        } else {
            statement = statement2;
        }
        return statement;
    }
}

