/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.quickfix.type;

import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.psi.PsiElement;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.codeInsight.PhpCodeInsightUtil;
import com.jetbrains.php.lang.documentation.phpdoc.PhpDocUtil;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocComment;
import com.jetbrains.php.lang.documentation.phpdoc.psi.tags.PhpDocReturnTag;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpNamespace;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.PhpTypeDeclaration;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class PhpExtendReturnTypeQuickFix
extends PsiUpdateModCommandQuickFix {
    private final PhpType myCurrentType;
    private final PhpType myNewType;

    public PhpExtendReturnTypeQuickFix(@NotNull PhpType currentType, @NotNull PhpType newType) {
        if (currentType == null) {
            PhpExtendReturnTypeQuickFix.$$$reportNull$$$0(0);
        }
        if (newType == null) {
            PhpExtendReturnTypeQuickFix.$$$reportNull$$$0(1);
        }
        this.myCurrentType = currentType;
        this.myNewType = newType;
    }

    @Nls
    @NotNull
    public String getName() {
        String string = PhpBundle.message("quickfix.strict.type.checking.extend.return.type.name", this.myCurrentType, this.myNewType);
        if (string == null) {
            PhpExtendReturnTypeQuickFix.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Nls
    @NotNull
    public String getFamilyName() {
        String string = PhpBundle.message("quickfix.strict.type.checking.extend.return.type.family", new Object[0]);
        if (string == null) {
            PhpExtendReturnTypeQuickFix.$$$reportNull$$$0(3);
        }
        return string;
    }

    protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
        if (project == null) {
            PhpExtendReturnTypeQuickFix.$$$reportNull$$$0(4);
        }
        if (element == null) {
            PhpExtendReturnTypeQuickFix.$$$reportNull$$$0(5);
        }
        if (updater == null) {
            PhpExtendReturnTypeQuickFix.$$$reportNull$$$0(6);
        }
        Condition stopAt = Conditions.or((Condition)PhpClass.INSTANCEOF, (Condition)PhpNamespace.INSTANCEOF);
        Function function = (Function)PhpPsiUtil.getParentByCondition(element, (Condition<? super PsiElement>)Function.INSTANCEOF, (Condition<? super PsiElement>)stopAt);
        assert (function != null);
        PhpDocComment phpDoc = function.getDocComment();
        if (phpDoc != null) {
            PhpDocReturnTag returnTag;
            PhpTypeDeclaration returnType = function.getTypeDeclaration();
            if (returnType != null) {
                PsiElement colon = PhpPsiUtil.findPrevSiblingOfAnyType((PsiElement)returnType, PhpTokenTypes.opCOLON);
                if (colon != null) {
                    returnType.getParent().deleteChildRange(colon, (PsiElement)returnType);
                } else {
                    returnType.delete();
                }
            }
            if ((returnTag = phpDoc.getReturnTag()) != null) {
                PhpPsiElement scope = PhpCodeInsightUtil.findScopeForUseOperator((PsiElement)function);
                String presentation = PhpDocUtil.getTypePresentation(project, this.myNewType, scope);
                String template = "/** @return " + presentation + " */";
                PhpDocReturnTag newReturnTag = PhpPsiElementFactory.createPhpPsiFromText(project, PhpDocReturnTag.class, template);
                returnTag.replace((PsiElement)newReturnTag);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentType";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newType";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/quickfix/type/PhpExtendReturnTypeQuickFix";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updater";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/quickfix/type/PhpExtendReturnTypeQuickFix";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3 -> new IllegalStateException(string);
        };
    }
}

