/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.reference;

import com.intellij.codeInspection.ex.GlobalInspectionContextBase;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.ex.Tools;
import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefElementImpl;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.reference.RefManager;
import com.intellij.codeInspection.reference.RefManagerImpl;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.impl.RenameableFakePsiElement;
import com.intellij.psi.stubs.StubElementFactory;
import com.intellij.psi.stubs.StubElementUtil;
import com.intellij.util.ObjectUtils;
import com.jetbrains.php.codeInsight.PhpCodeInsightUtil;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocComment;
import com.jetbrains.php.lang.inspections.deadcode.PhpUnusedDeclarationInspection;
import com.jetbrains.php.lang.inspections.reference.PhpEntryPointsManager;
import com.jetbrains.php.lang.inspections.reference.PhpEntryPointsManagerImpl;
import com.jetbrains.php.lang.inspections.reference.PhpRefManager;
import com.jetbrains.php.lang.inspections.reference.elements.PhpRefClass;
import com.jetbrains.php.lang.inspections.reference.elements.PhpRefClassImpl;
import com.jetbrains.php.lang.inspections.reference.elements.PhpRefConstant;
import com.jetbrains.php.lang.inspections.reference.elements.PhpRefConstantImpl;
import com.jetbrains.php.lang.inspections.reference.elements.PhpRefElementImpl;
import com.jetbrains.php.lang.inspections.reference.elements.PhpRefEntity;
import com.jetbrains.php.lang.inspections.reference.elements.PhpRefField;
import com.jetbrains.php.lang.inspections.reference.elements.PhpRefFieldImpl;
import com.jetbrains.php.lang.inspections.reference.elements.PhpRefFileImpl;
import com.jetbrains.php.lang.inspections.reference.elements.PhpRefFunction;
import com.jetbrains.php.lang.inspections.reference.elements.PhpRefFunctionImpl;
import com.jetbrains.php.lang.inspections.reference.elements.PhpRefGlobalVariable;
import com.jetbrains.php.lang.inspections.reference.elements.PhpRefGlobalVariableImpl;
import com.jetbrains.php.lang.inspections.reference.elements.PhpRefMethod;
import com.jetbrains.php.lang.inspections.reference.elements.PhpRefMethodImpl;
import com.jetbrains.php.lang.inspections.reference.elements.PhpRefNamespace;
import com.jetbrains.php.lang.inspections.reference.elements.PhpRefNamespaceImpl;
import com.jetbrains.php.lang.inspections.reference.elements.PhpRefParameter;
import com.jetbrains.php.lang.inspections.reference.elements.PhpRefParameterImpl;
import com.jetbrains.php.lang.inspections.reference.elements.PhpRefPromotedFieldParameterImpl;
import com.jetbrains.php.lang.inspections.reference.elements.PhpRefUtil;
import com.jetbrains.php.lang.inspections.suppression.PhpSuppressionUtil;
import com.jetbrains.php.lang.psi.PhpFile;
import com.jetbrains.php.lang.psi.elements.Constant;
import com.jetbrains.php.lang.psi.elements.Field;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpClassMember;
import com.jetbrains.php.lang.psi.elements.PhpNamespace;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.lang.psi.stubs.stub_factories.PhpVariableStubFactory;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import one.util.streamex.StreamEx;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpRefManagerImpl
extends PhpRefManager {
    @NotNull
    private final RefManagerImpl myRefManager;
    @Nullable
    private PhpElementVisitor myProjectIterator;
    @Nullable
    private PhpEntryPointsManager myEntryPointsManager;
    @Nullable
    private Map<String, PhpRefNamespace> myNamespaces;
    private boolean isGraphCanContainGlobalVariables;

    PhpRefManagerImpl(@NotNull RefManager refManager) {
        if (refManager == null) {
            PhpRefManagerImpl.$$$reportNull$$$0(0);
        }
        this.myRefManager = (RefManagerImpl)refManager;
    }

    public void cleanup() {
        if (this.myEntryPointsManager != null) {
            Disposer.dispose((Disposable)this.myEntryPointsManager);
            this.myEntryPointsManager = null;
        }
        this.cleanupNamespaces();
        this.myProjectIterator = null;
    }

    private synchronized void cleanupNamespaces() {
        this.myNamespaces = null;
    }

    @Nullable
    public RefEntity getReference(String type, String fqName) {
        if ("phpNamespace".equals(type)) {
            return PhpRefNamespaceImpl.namespaceFromExternalName(this.myRefManager, fqName);
        }
        if ("phpClass".equals(type)) {
            return PhpRefClassImpl.classFromExternalName(this.myRefManager, fqName);
        }
        if ("phpField".equals(type)) {
            return PhpRefFieldImpl.fieldFromExternalName(this.myRefManager, fqName);
        }
        if ("phpMethod".equals(type)) {
            return PhpRefMethodImpl.methodFromExternalName(this.myRefManager, fqName);
        }
        if ("phpFunction".equals(type)) {
            return PhpRefFunctionImpl.functionFromExternalName(this.myRefManager, fqName);
        }
        if ("phpParameter".equals(type)) {
            return PhpRefParameterImpl.parameterFromExternalName(this.myRefManager, fqName);
        }
        if ("phpConst".equals(type)) {
            return PhpRefConstantImpl.constantFromExternalName(this.myRefManager, fqName);
        }
        if ("phpVariable".equals(type) && this.isGraphCanContainGlobalVariables) {
            return PhpRefGlobalVariableImpl.variableFromExternalName(this.myRefManager, fqName);
        }
        return null;
    }

    @Nullable
    public String getType(@NotNull RefEntity ref) {
        if (ref == null) {
            PhpRefManagerImpl.$$$reportNull$$$0(1);
        }
        if (ref instanceof PhpRefNamespace) {
            return "phpNamespace";
        }
        if (ref instanceof PhpRefClass) {
            return "phpClass";
        }
        if (ref instanceof PhpRefField) {
            return "phpField";
        }
        if (ref instanceof PhpRefMethod) {
            return "phpMethod";
        }
        if (ref instanceof PhpRefFunction) {
            return "phpFunction";
        }
        if (ref instanceof PhpRefParameter) {
            return "phpParameter";
        }
        if (ref instanceof PhpRefConstant) {
            return "phpConst";
        }
        if (ref instanceof PhpRefGlobalVariable && this.isGraphCanContainGlobalVariables) {
            return "phpVariable";
        }
        return null;
    }

    @Nullable
    private PhpUnusedDeclarationInspection getDeadCodeTool(@NotNull RefElement element) {
        PsiFile file;
        if (element == null) {
            PhpRefManagerImpl.$$$reportNull$$$0(2);
        }
        if (!((file = ((RefElementImpl)element).getContainingFile()) instanceof PhpFile)) {
            return null;
        }
        return this.getDeadCodeTool(file);
    }

    @Nullable
    private PhpUnusedDeclarationInspection getDeadCodeTool(@NotNull PsiFile file) {
        InspectionToolWrapper toolWrapper;
        GlobalInspectionContextBase contextBase;
        Tools tools;
        if (file == null) {
            PhpRefManagerImpl.$$$reportNull$$$0(3);
        }
        if ((tools = (Tools)(contextBase = (GlobalInspectionContextBase)this.myRefManager.getContext()).getTools().get("PhpUnused")) == null) {
            String singleTool = contextBase.getCurrentProfile().getSingleTool();
            if (singleTool != null && !"PhpUnused".equals(singleTool)) {
                tools = InspectionProjectProfileManager.getInstance((Project)this.myRefManager.getProject()).getCurrentProfile().getTools("PhpUnused", this.myRefManager.getProject());
            } else {
                return null;
            }
        }
        return (PhpUnusedDeclarationInspection)((Object)ObjectUtils.tryCast((Object)((toolWrapper = tools.getEnabledTool((PsiElement)file)) != null ? toolWrapper.getTool() : null), PhpUnusedDeclarationInspection.class));
    }

    public void onEntityInitialized(@NotNull RefElement refElement, @NotNull PsiElement psiElement) {
        if (refElement == null) {
            PhpRefManagerImpl.$$$reportNull$$$0(4);
        }
        if (psiElement == null) {
            PhpRefManagerImpl.$$$reportNull$$$0(5);
        }
        if (this.myRefManager.isOfflineView() || !this.myRefManager.isDeclarationsFound()) {
            return;
        }
        if ((refElement instanceof PhpRefElementImpl || refElement instanceof PhpRefFileImpl) && this.isSuitedForEntryPoint(refElement)) {
            this.getEntryPointsManager().addEntryPoint(refElement, false);
        }
    }

    public boolean isSuitedForEntryPoint(@NotNull RefElement refElement) {
        PhpUnusedDeclarationInspection tool;
        if (refElement == null) {
            PhpRefManagerImpl.$$$reportNull$$$0(6);
        }
        return (tool = this.getDeadCodeTool(refElement)) != null && tool.isSuitedForEntryPoint(refElement);
    }

    @NotNull
    public PhpEntryPointsManager getEntryPointsManager() {
        PhpEntryPointsManager entryPointsManager = this.myEntryPointsManager;
        if (entryPointsManager == null) {
            Project project = this.myRefManager.getProject();
            this.myEntryPointsManager = entryPointsManager = new PhpEntryPointsManagerImpl();
            PhpEntryPointsManager pointsManagerService = PhpEntryPointsManager.getProjectInstance((Project)project);
            Disposer.register((Disposable)pointsManagerService, (Disposable)entryPointsManager);
            ((PhpEntryPointsManagerImpl)entryPointsManager).addAllPersistentEntries(pointsManagerService);
        }
        PhpEntryPointsManager phpEntryPointsManager = entryPointsManager;
        if (phpEntryPointsManager == null) {
            PhpRefManagerImpl.$$$reportNull$$$0(7);
        }
        return phpEntryPointsManager;
    }

    public void setWithGlobalVariables() {
        this.isGraphCanContainGlobalVariables = true;
    }

    public boolean isWithGlobalVariables() {
        return this.isGraphCanContainGlobalVariables;
    }

    @Nullable
    public RefElement createRefElement(@NotNull PsiElement psi) {
        if (psi == null) {
            PhpRefManagerImpl.$$$reportNull$$$0(8);
        }
        if (!this.getLanguages().contains(psi.getLanguage()) || psi instanceof RenameableFakePsiElement) {
            return null;
        }
        if (psi instanceof PhpClassMember) {
            if (psi instanceof Parameter && psi instanceof Field && ((Parameter)psi).isPromotedField()) {
                return new PhpRefPromotedFieldParameterImpl((Field)psi, PhpCodeInsightUtil.getParameterIndex(psi), (RefManager)this.myRefManager);
            }
            if (psi instanceof Field) {
                return new PhpRefFieldImpl((Field)psi, (RefManager)this.myRefManager);
            }
            if (psi instanceof Method) {
                return new PhpRefMethodImpl((Method)psi, (RefManager)this.myRefManager);
            }
        } else {
            if (psi instanceof PsiFile) {
                return new PhpRefFileImpl((PsiFile)psi, (RefManager)this.myRefManager);
            }
            if (psi instanceof PhpClass) {
                return new PhpRefClassImpl((PhpClass)psi, (RefManager)this.myRefManager);
            }
            if (psi instanceof Function) {
                return new PhpRefFunctionImpl((Function)psi, (RefManager)this.myRefManager);
            }
            if (psi instanceof Constant) {
                return new PhpRefConstantImpl((Constant)psi, (RefManager)this.myRefManager);
            }
            if (psi instanceof Variable && this.isGraphCanContainGlobalVariables && StubElementUtil.shouldCreateStubForPsi((StubElementFactory)PhpVariableStubFactory.INSTANCE, (PsiElement)psi)) {
                return new PhpRefGlobalVariableImpl((Variable)psi, (RefManager)this.myRefManager);
            }
        }
        return null;
    }

    @Nullable
    public PhpRefNamespace getNamespace(@NotNull PhpNamespace namespace) {
        String fqn;
        if (namespace == null) {
            PhpRefManagerImpl.$$$reportNull$$$0(9);
        }
        if (PhpLangUtil.isGlobalNamespaceFQN(fqn = namespace.getFQN())) {
            return null;
        }
        return this.getCachedNamespace(namespace, fqn);
    }

    @NotNull
    private synchronized PhpRefNamespace getCachedNamespace(@NotNull PhpNamespace namespace, @NotNull String fqn) {
        if (namespace == null) {
            PhpRefManagerImpl.$$$reportNull$$$0(10);
        }
        if (fqn == null) {
            PhpRefManagerImpl.$$$reportNull$$$0(11);
        }
        this.myNamespaces = (Map)ObjectUtils.notNull(this.myNamespaces, HashMap::new);
        PhpRefNamespace phpRefNamespace = this.myNamespaces.computeIfAbsent(fqn, __ -> new PhpRefNamespaceImpl(namespace, (RefManager)this.myRefManager));
        if (phpRefNamespace == null) {
            PhpRefManagerImpl.$$$reportNull$$$0(12);
        }
        return phpRefNamespace;
    }

    @Nullable
    public PhpRefParameter createRefParameter(@NotNull Parameter psi, int order, @NotNull PhpRefFunction refFunction) {
        if (psi == null) {
            PhpRefManagerImpl.$$$reportNull$$$0(13);
        }
        if (refFunction == null) {
            PhpRefManagerImpl.$$$reportNull$$$0(14);
        }
        return (PhpRefParameter)this.myRefManager.getFromRefTableOrCache((PsiElement)psi, () -> {
            PhpRefParameterImpl refParameter = new PhpRefParameterImpl(psi, (RefManager)this.myRefManager, order, refFunction);
            refParameter.initializeIfNeeded();
            return refParameter;
        });
    }

    public void visitElement(@NotNull PsiElement element) {
        if (element == null) {
            PhpRefManagerImpl.$$$reportNull$$$0(15);
        }
        if (this.myProjectIterator == null) {
            this.myProjectIterator = new PhpElementVisitor(){

                private void visitDeclaration(@NotNull PhpPsiElement psiElement) {
                    RefElement refElement;
                    if (psiElement == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if ((refElement = PhpRefUtil.getReferenceEx((PsiElement)psiElement, PhpRefManagerImpl.this.myRefManager)) instanceof PhpRefEntity) {
                        PhpRefManagerImpl.this.myRefManager.buildReferences(refElement);
                        1.processDocComments(refElement, psiElement);
                        this.propagateEntryPointForInitializers(refElement);
                    }
                }

                public void visitPhpFile(PhpFile phpFile) {
                    this.visitDeclaration((PhpPsiElement)phpFile);
                }

                public void visitPhpClass(PhpClass clazz) {
                    this.visitDeclaration((PhpPsiElement)clazz);
                }

                public void visitPhpMethod(Method method) {
                    this.visitDeclaration((PhpPsiElement)method);
                }

                public void visitPhpField(Field field) {
                    this.visitDeclaration((PhpPsiElement)field);
                }

                public void visitPhpFunction(Function function) {
                    this.visitDeclaration((PhpPsiElement)function);
                }

                public void visitPhpConstant(Constant constant) {
                    if (constant.getNameNode() != null) {
                        this.visitDeclaration((PhpPsiElement)constant);
                    }
                }

                public void visitPhpVariable(Variable variable) {
                    if (variable.isDeclaration()) {
                        this.visitDeclaration((PhpPsiElement)variable);
                    }
                }

                private static void processDocComments(@NotNull RefElement refElement, @NotNull PhpPsiElement psiElement) {
                    if (refElement == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    if (psiElement == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    if (refElement instanceof RefElementImpl) {
                        1.applySuppressions((RefElementImpl)refElement, PhpSuppressionUtil.getPhpDocComments((PsiElement)psiElement));
                    }
                }

                private static void applySuppressions(@NotNull RefElementImpl declaration, @NotNull List<PhpDocComment> comments) {
                    String suppressions;
                    if (declaration == null) {
                        1.$$$reportNull$$$0(3);
                    }
                    if (comments == null) {
                        1.$$$reportNull$$$0(4);
                    }
                    if (!(suppressions = ((StreamEx)StreamEx.of(comments).flatArray(comment -> comment.getTagElementsByName("@noinspection")).map(tag -> PhpSuppressionUtil.getInspectionIdsList(tag)).filter(StringUtil::isNotEmpty)).joining((CharSequence)", ")).isEmpty()) {
                        declaration.addSuppression(suppressions);
                    }
                }

                private void propagateEntryPointForInitializers(@NotNull RefElement refElement) {
                    if (refElement == null) {
                        1.$$$reportNull$$$0(5);
                    }
                    if (refElement.isEntry()) {
                        PhpRefManagerImpl.this.getEntryPointsManager().addEntryPointsForInitializers(refElement, false);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "psiElement";
                            break;
                        }
                        case 1: 
                        case 5: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "refElement";
                            break;
                        }
                        case 3: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "declaration";
                            break;
                        }
                        case 4: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "comments";
                            break;
                        }
                    }
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/reference/PhpRefManagerImpl$1";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "visitDeclaration";
                            break;
                        }
                        case 1: 
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[2] = "processDocComments";
                            break;
                        }
                        case 3: 
                        case 4: {
                            objectArray = objectArray2;
                            objectArray2[2] = "applySuppressions";
                            break;
                        }
                        case 5: {
                            objectArray = objectArray2;
                            objectArray2[2] = "propagateEntryPointForInitializers";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            };
        }
        element.accept((PsiElementVisitor)this.myProjectIterator);
    }

    public void export(@NotNull RefEntity refEntity, @NotNull Element element) {
        if (refEntity == null) {
            PhpRefManagerImpl.$$$reportNull$$$0(16);
        }
        if (element == null) {
            PhpRefManagerImpl.$$$reportNull$$$0(17);
        }
    }

    @Nullable
    public PsiNamedElement getElementContainer(@NotNull PsiElement psiElement) {
        if (psiElement == null) {
            PhpRefManagerImpl.$$$reportNull$$$0(18);
        }
        return psiElement.getContainingFile();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7, 12 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refManager";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 2: 
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refElement";
                break;
            }
            case 5: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 7: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/reference/PhpRefManagerImpl";
                break;
            }
            case 8: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psi";
                break;
            }
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namespace";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fqn";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refFunction";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refEntity";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/reference/PhpRefManagerImpl";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getEntryPointsManager";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getCachedNamespace";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getType";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getDeadCodeTool";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "onEntityInitialized";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isSuitedForEntryPoint";
                break;
            }
            case 7: 
            case 12: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createRefElement";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getNamespace";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getCachedNamespace";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "createRefParameter";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "visitElement";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "export";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getElementContainer";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 7, 12 -> new IllegalStateException(string);
        };
    }
}

