/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.regexp;

import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.modcommand.ActionContext;
import com.intellij.modcommand.ModCommandAction;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.config.PhpLanguageLevel;
import com.jetbrains.php.lang.inspections.regexp.PhpRegExpModifierInspectionBase;
import com.jetbrains.php.lang.psi.elements.StringLiteralExpression;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.intellij.lang.regexp.inspection.RegExpReplacementUtil;
import org.intellij.lang.regexp.psi.RegExpGroup;
import org.intellij.lang.regexp.psi.RegExpPattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpNModifierCanBeReplacedWithNonCapturingGroupInspection
extends PhpRegExpModifierInspectionBase {
    @Override
    protected void doCheck(@NotNull ProblemsHolder holder, @NotNull List<Character> phpRegExpModifiers, @NotNull Character modifier, @NotNull TextRange textRange, @NotNull StringLiteralExpression expression, @NotNull RegExpPattern pattern) {
        if (holder == null) {
            PhpNModifierCanBeReplacedWithNonCapturingGroupInspection.$$$reportNull$$$0(0);
        }
        if (phpRegExpModifiers == null) {
            PhpNModifierCanBeReplacedWithNonCapturingGroupInspection.$$$reportNull$$$0(1);
        }
        if (modifier == null) {
            PhpNModifierCanBeReplacedWithNonCapturingGroupInspection.$$$reportNull$$$0(2);
        }
        if (textRange == null) {
            PhpNModifierCanBeReplacedWithNonCapturingGroupInspection.$$$reportNull$$$0(3);
        }
        if (expression == null) {
            PhpNModifierCanBeReplacedWithNonCapturingGroupInspection.$$$reportNull$$$0(4);
        }
        if (pattern == null) {
            PhpNModifierCanBeReplacedWithNonCapturingGroupInspection.$$$reportNull$$$0(5);
        }
        if (!modifier.equals(Character.valueOf(PhpRegExpModifierInspectionBase.PhpRegExpModifier.PCRE_N.getCharacter()))) {
            return;
        }
        Collection capturingGroups = PsiTreeUtil.findChildrenOfType((PsiElement)pattern, RegExpGroup.class).stream().filter(RegExpGroup::isCapturing).filter(Predicate.not(RegExpGroup::isAnyNamedGroup)).collect(Collectors.toList());
        if (capturingGroups.isEmpty()) {
            return;
        }
        holder.problem((PsiElement)expression, PhpBundle.message("inspection.php.regexp.n.modifier.can.be.replaced.with.non.capturing.groups", new Object[0])).range(textRange).fix((ModCommandAction)new PhpReplaceNModifierWithNonCapturingGroupQuickFix(expression, capturingGroups, modifier.charValue())).register();
    }

    @Override
    @Nullable
    protected PhpLanguageLevel getMinimumSupportedLanguageLevel() {
        return PhpLanguageLevel.PHP820;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "holder";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "phpRegExpModifiers";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "modifier";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[0] = "textRange";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[0] = "expression";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[0] = "pattern";
                break;
            }
        }
        objectArray[1] = "com/jetbrains/php/lang/inspections/regexp/PhpNModifierCanBeReplacedWithNonCapturingGroupInspection";
        objectArray[2] = "doCheck";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class PhpReplaceNModifierWithNonCapturingGroupQuickFix
    extends PsiUpdateModCommandAction<StringLiteralExpression> {
        private final Collection<SmartPsiElementPointer<RegExpGroup>> myGroups;
        private final char myModifierToDelete;

        protected PhpReplaceNModifierWithNonCapturingGroupQuickFix(@NotNull StringLiteralExpression element, @NotNull Collection<RegExpGroup> groups, char modifierToDelete) {
            if (element == null) {
                PhpReplaceNModifierWithNonCapturingGroupQuickFix.$$$reportNull$$$0(0);
            }
            if (groups == null) {
                PhpReplaceNModifierWithNonCapturingGroupQuickFix.$$$reportNull$$$0(1);
            }
            super((PsiElement)element);
            SmartPointerManager manager = SmartPointerManager.getInstance((Project)element.getProject());
            this.myGroups = ContainerUtil.map(groups, g -> manager.createSmartPsiElementPointer((PsiElement)g));
            this.myModifierToDelete = modifierToDelete;
        }

        protected void invoke(@NotNull ActionContext context, @NotNull StringLiteralExpression startElement, @NotNull ModPsiUpdater updater) {
            if (context == null) {
                PhpReplaceNModifierWithNonCapturingGroupQuickFix.$$$reportNull$$$0(2);
            }
            if (startElement == null) {
                PhpReplaceNModifierWithNonCapturingGroupQuickFix.$$$reportNull$$$0(3);
            }
            if (updater == null) {
                PhpReplaceNModifierWithNonCapturingGroupQuickFix.$$$reportNull$$$0(4);
            }
            List<RegExpGroup> groups = this.myGroups.stream().map(SmartPsiElementPointer::getElement).filter(Objects::nonNull).map(arg_0 -> ((ModPsiUpdater)updater).getWritable(arg_0)).toList();
            Project project = context.project();
            PhpRegExpModifierInspectionBase.PhpRemoveRegExpModifierQuickFix.deleteModifier(startElement, this.myModifierToDelete, project);
            groups.forEach(group -> RegExpReplacementUtil.replaceInContext((PsiElement)group, (String)("(?:" + group.getPattern().getUnescapedText() + ")")));
        }

        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("inspection.php.regexp.replace.n.modifier.with.non.capturing.groups", new Object[0]);
            if (string == null) {
                PhpReplaceNModifierWithNonCapturingGroupQuickFix.$$$reportNull$$$0(5);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 5 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "groups";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "startElement";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/regexp/PhpNModifierCanBeReplacedWithNonCapturingGroupInspection$PhpReplaceNModifierWithNonCapturingGroupQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/regexp/PhpNModifierCanBeReplacedWithNonCapturingGroupInspection$PhpReplaceNModifierWithNonCapturingGroupQuickFix";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "invoke";
                    break;
                }
                case 5: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 5 -> new IllegalStateException(string);
            };
        }
    }
}

