/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.suppression;

import com.intellij.codeInspection.util.IntentionName;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocComment;
import com.jetbrains.php.lang.inspections.suppression.AbstractPhpSuppressFix;
import com.jetbrains.php.lang.inspections.suppression.PhpSuppressForDocCommentFix;
import com.jetbrains.php.lang.inspections.suppression.PhpSuppressionUtil;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.Method;
import org.jetbrains.annotations.NotNull;

public class PhpSuppressForFunctionCommentFix
extends AbstractPhpSuppressFix {
    @IntentionName
    public static final String FUNCTION_NAME = PhpBundle.message("suppress.for.function", new Object[0]);
    @IntentionName
    public static final String METHOD_NAME = PhpBundle.message("suppress.for.method", new Object[0]);

    public PhpSuppressForFunctionCommentFix(String toolId) {
        super(toolId, false);
    }

    public PsiElement getContainer(PsiElement context) {
        return PhpSuppressionUtil.getTopmostFunction(context);
    }

    @Override
    protected void createSuppression(@NotNull Project project, @NotNull PsiElement element, @NotNull PsiElement container) throws IncorrectOperationException {
        Function function;
        PhpDocComment comment;
        if (project == null) {
            PhpSuppressForFunctionCommentFix.$$$reportNull$$$0(0);
        }
        if (element == null) {
            PhpSuppressForFunctionCommentFix.$$$reportNull$$$0(1);
        }
        if (container == null) {
            PhpSuppressForFunctionCommentFix.$$$reportNull$$$0(2);
        }
        if ((comment = (PhpDocComment)ObjectUtils.tryCast((Object)(function = (Function)container).getPrevPsiSibling(), PhpDocComment.class)) != null) {
            PhpSuppressForDocCommentFix.addSuppressTagToComment((PsiElement)comment, this.getSuppressionTagText());
        } else {
            PhpSuppressionUtil.addCommentWithSuppressionTag((PsiElement)function, this.getSuppressionTagText());
        }
    }

    public boolean isAvailable(@NotNull Project project, @NotNull PsiElement context) {
        if (project == null) {
            PhpSuppressForFunctionCommentFix.$$$reportNull$$$0(3);
        }
        if (context == null) {
            PhpSuppressForFunctionCommentFix.$$$reportNull$$$0(4);
        }
        if (!context.isValid()) {
            return false;
        }
        PsiElement container = this.getContainer(context);
        if (container == null) {
            return false;
        }
        this.setText(container instanceof Method ? METHOD_NAME : FUNCTION_NAME);
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "container";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/lang/inspections/suppression/PhpSuppressForFunctionCommentFix";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "createSuppression";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "isAvailable";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

