/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.type;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.codeInsight.dataFlow.PhpConditionDFAnalyzer;
import com.jetbrains.php.lang.psi.elements.Variable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpBooleanConstantValueDfaAnalyzer
extends PhpConditionDFAnalyzer<Map<String, BooleanConstantState>> {
    @Override
    @NotNull
    public Map<String, BooleanConstantState> performDFA(@Nullable PsiElement condition, boolean result) {
        if (condition instanceof Variable && StringUtil.isNotEmpty((String)((Variable)condition).getName())) {
            BooleanConstantState state = result ? BooleanConstantState.TRUE : BooleanConstantState.FALSE;
            Map<String, BooleanConstantState> map = Collections.singletonMap(((Variable)condition).getName(), state);
            if (map == null) {
                PhpBooleanConstantValueDfaAnalyzer.$$$reportNull$$$0(0);
            }
            return map;
        }
        Map map = (Map)super.performDFA(condition, result);
        if (map == null) {
            PhpBooleanConstantValueDfaAnalyzer.$$$reportNull$$$0(1);
        }
        return map;
    }

    @Override
    @Nullable
    protected Map<String, BooleanConstantState> performDFAFromBooleanComparison(PsiElement left, PsiElement right, IElementType operationType, boolean result) {
        return (Map)super.doPerformDFAFromBooleanComparison(left, right, operationType, result);
    }

    @Override
    @NotNull
    public Map<String, BooleanConstantState> and(@NotNull Map<String, BooleanConstantState> leftOperand, @NotNull Map<String, BooleanConstantState> rightOperand, boolean conditionResult) {
        if (leftOperand == null) {
            PhpBooleanConstantValueDfaAnalyzer.$$$reportNull$$$0(2);
        }
        if (rightOperand == null) {
            PhpBooleanConstantValueDfaAnalyzer.$$$reportNull$$$0(3);
        }
        Map<String, BooleanConstantState> map = PhpBooleanConstantValueDfaAnalyzer.merge(leftOperand, rightOperand, conditionResult);
        if (map == null) {
            PhpBooleanConstantValueDfaAnalyzer.$$$reportNull$$$0(4);
        }
        return map;
    }

    @Override
    @NotNull
    public Map<String, BooleanConstantState> or(@NotNull Map<String, BooleanConstantState> leftOperand, @NotNull Map<String, BooleanConstantState> rightOperand, boolean conditionResult) {
        if (leftOperand == null) {
            PhpBooleanConstantValueDfaAnalyzer.$$$reportNull$$$0(5);
        }
        if (rightOperand == null) {
            PhpBooleanConstantValueDfaAnalyzer.$$$reportNull$$$0(6);
        }
        Map<String, BooleanConstantState> map = PhpBooleanConstantValueDfaAnalyzer.merge(leftOperand, rightOperand, !conditionResult);
        if (map == null) {
            PhpBooleanConstantValueDfaAnalyzer.$$$reportNull$$$0(7);
        }
        return map;
    }

    private static Map<String, BooleanConstantState> merge(@NotNull Map<String, BooleanConstantState> leftOperand, @NotNull Map<String, BooleanConstantState> rightOperand, boolean result) {
        if (leftOperand == null) {
            PhpBooleanConstantValueDfaAnalyzer.$$$reportNull$$$0(8);
        }
        if (rightOperand == null) {
            PhpBooleanConstantValueDfaAnalyzer.$$$reportNull$$$0(9);
        }
        if (leftOperand.isEmpty() && rightOperand.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<String, BooleanConstantState> resultState = new HashMap<String, BooleanConstantState>();
        for (String leftVariableName : leftOperand.keySet()) {
            BooleanConstantState leftState = leftOperand.get(leftVariableName);
            BooleanConstantState rightState = rightOperand.get(leftVariableName);
            ContainerUtil.putIfNotNull((Object)leftVariableName, (Object)((Object)PhpBooleanConstantValueDfaAnalyzer.merge(leftState, rightState, result)), resultState);
        }
        for (String restRightOperandVariableName : rightOperand.keySet()) {
            if (leftOperand.containsKey(restRightOperandVariableName)) continue;
            ContainerUtil.putIfNotNull((Object)restRightOperandVariableName, (Object)((Object)PhpBooleanConstantValueDfaAnalyzer.merge(null, rightOperand.get(restRightOperandVariableName), result)), resultState);
        }
        return resultState;
    }

    @Nullable
    private static BooleanConstantState merge(@Nullable BooleanConstantState leftOperand, @Nullable BooleanConstantState rightOperand, boolean result) {
        if (leftOperand == rightOperand) {
            return leftOperand;
        }
        if (leftOperand == null) {
            return result ? rightOperand : BooleanConstantState.AMBIGUOUS;
        }
        if (rightOperand == null) {
            return result ? leftOperand : BooleanConstantState.AMBIGUOUS;
        }
        return null;
    }

    @Override
    public Map<String, BooleanConstantState> getEmpty() {
        return Collections.emptyMap();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3, 5, 6, 8, 9 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/type/PhpBooleanConstantValueDfaAnalyzer";
                break;
            }
            case 2: 
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "leftOperand";
                break;
            }
            case 3: 
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rightOperand";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "performDFA";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/type/PhpBooleanConstantValueDfaAnalyzer";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "and";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "or";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "and";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "or";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "merge";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 3, 5, 6, 8, 9 -> new IllegalArgumentException(string);
        };
    }

    public static enum BooleanConstantState {
        TRUE,
        FALSE,
        AMBIGUOUS;

    }
}

