/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.type;

import com.intellij.codeInsight.intention.preview.IntentionPreviewInfo;
import com.intellij.codeInsight.intention.preview.IntentionPreviewUtils;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.PhpClassHierarchyUtils;
import com.jetbrains.php.config.PhpLanguageLevel;
import com.jetbrains.php.lang.documentation.phpdoc.psi.tags.PhpDocParamTag;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.inspections.phpdoc.PhpUpdateSignatureFromPhpDocQuickFix;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.lang.psi.elements.PhpReturnType;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import com.jetbrains.php.refactoring.changeSignature.PhpChangeInfo;
import com.jetbrains.php.refactoring.changeSignature.PhpMethodDescriptor;
import com.jetbrains.php.refactoring.changeSignature.PhpParameterInfo;
import java.util.List;
import one.util.streamex.EntryStream;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpMissingParamTypeInspection
extends PhpInspection {
    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpMissingParamTypeInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(){

            public void visitPhpParameter(Parameter parameter) {
                PhpMissingParamTypeInspection.this.doCheck(parameter, holder);
            }
        };
    }

    public void doCheck(Parameter parameter, @NotNull ProblemsHolder holder) {
        PhpType type;
        if (holder == null) {
            PhpMissingParamTypeInspection.$$$reportNull$$$0(1);
        }
        if (!(type = parameter.getDeclaredType()).isEmpty()) {
            return;
        }
        Function function = PhpPsiUtil.getParentOfClass((PsiElement)parameter, Function.class);
        if (function == null) {
            return;
        }
        if (PhpMissingParamTypeInspection.isSuperMethodParameterTypeIncompatible(function, parameter)) {
            return;
        }
        PhpDocParamTag docTag = parameter.getDocTag();
        if (docTag == null) {
            return;
        }
        String hint = PhpUpdateSignatureFromPhpDocQuickFix.getParameterTypeString(function, docTag);
        if (StringUtil.isEmpty((String)hint)) {
            return;
        }
        holder.registerProblem((PsiElement)parameter, PhpBundle.message("inspection.php.missing.param.type.description", new Object[0]), new LocalQuickFix[]{new PhpAddParamTypeQuickFix(hint, holder.isOnTheFly())});
    }

    private static boolean isSuperMethodParameterTypeIncompatible(@NotNull Function function, @NotNull Parameter parameter) {
        Method method;
        if (function == null) {
            PhpMissingParamTypeInspection.$$$reportNull$$$0(2);
        }
        if (parameter == null) {
            PhpMissingParamTypeInspection.$$$reportNull$$$0(3);
        }
        if ((method = (Method)ObjectUtils.tryCast((Object)function, Method.class)) == null) {
            return false;
        }
        PhpType newType = parameter.getDocType();
        int index = ArrayUtil.indexOf((Object[])function.getParameters(), (Object)parameter);
        if (index < 0) {
            return false;
        }
        Ref result = new Ref((Object)false);
        PhpClassHierarchyUtils.processSuperMethods((Method)method, (superMethod, subClass, baseClass) -> {
            Parameter param = superMethod.getParameter(index);
            if (param != null && !param.getDeclaredType().equals((Object)newType)) {
                result.set((Object)true);
            }
            return (Boolean)result.get() == false;
        });
        return (Boolean)result.get();
    }

    @Override
    @Nullable
    protected PhpLanguageLevel getMinimumSupportedLanguageLevel() {
        return PhpLanguageLevel.PHP700;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/lang/inspections/type/PhpMissingParamTypeInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "buildVisitor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "doCheck";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isSuperMethodParameterTypeIncompatible";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class PhpAddParamTypeQuickFix
    implements LocalQuickFix {
        @NotNull
        private final String myTypeHint;
        private final boolean myIsOnTheFly;
        private static final PhpParameterInfo[] EMPTY_ARRAY = new PhpParameterInfo[0];

        private PhpAddParamTypeQuickFix(@NotNull String typeHint, boolean isOnTheFly) {
            if (typeHint == null) {
                PhpAddParamTypeQuickFix.$$$reportNull$$$0(0);
            }
            this.myTypeHint = typeHint;
            this.myIsOnTheFly = isOnTheFly;
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getName() {
            String string = PhpBundle.message("quickfix.php.missing.param.type.description", this.myTypeHint);
            if (string == null) {
                PhpAddParamTypeQuickFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("quickfix.php.missing.param.type.batch.description", new Object[0]);
            if (string == null) {
                PhpAddParamTypeQuickFix.$$$reportNull$$$0(2);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            Parameter updatingParameter;
            if (project == null) {
                PhpAddParamTypeQuickFix.$$$reportNull$$$0(3);
            }
            if (descriptor == null) {
                PhpAddParamTypeQuickFix.$$$reportNull$$$0(4);
            }
            if ((updatingParameter = (Parameter)ObjectUtils.tryCast((Object)descriptor.getStartElement(), Parameter.class)) == null) {
                return;
            }
            Function function = PhpPsiUtil.getParentOfClass((PsiElement)updatingParameter, Function.class);
            if (function == null) {
                return;
            }
            List parametersInfo = EntryStream.of((Object[])function.getParameters()).mapKeyValue((index, parameter) -> PhpAddParamTypeQuickFix.createNewInfoOnlyForUpdatedParameter(updatingParameter, function, index, parameter)).toList();
            PhpMethodDescriptor methodDescriptor = new PhpMethodDescriptor(function);
            PhpReturnType returnType = function.getReturnType();
            PhpChangeInfo changeInfo = new PhpChangeInfo(methodDescriptor, parametersInfo.toArray(EMPTY_ARRAY), methodDescriptor.getVisibility(), methodDescriptor.getName(), returnType != null ? returnType.getText() : null, null, false, true);
            PhpUpdateSignatureFromPhpDocQuickFix.changeFunctionSignature(function, changeInfo, this.myIsOnTheFly, IntentionPreviewUtils.isPreviewElement((PsiElement)function));
        }

        @NotNull
        public IntentionPreviewInfo generatePreview(@NotNull Project project, @NotNull ProblemDescriptor previewDescriptor) {
            if (project == null) {
                PhpAddParamTypeQuickFix.$$$reportNull$$$0(5);
            }
            if (previewDescriptor == null) {
                PhpAddParamTypeQuickFix.$$$reportNull$$$0(6);
            }
            this.applyFix(project, previewDescriptor);
            IntentionPreviewInfo intentionPreviewInfo = IntentionPreviewInfo.DIFF;
            if (intentionPreviewInfo == null) {
                PhpAddParamTypeQuickFix.$$$reportNull$$$0(7);
            }
            return intentionPreviewInfo;
        }

        @NotNull
        private static PhpParameterInfo createNewInfoOnlyForUpdatedParameter(Parameter updatedParameter, Function function, Integer index, Parameter parameter) {
            if (parameter != updatedParameter) {
                return new PhpParameterInfo((int)index, parameter);
            }
            PhpParameterInfo phpParameterInfo = PhpUpdateSignatureFromPhpDocQuickFix.createParameterInfo(function, function.getParameters(), updatedParameter.getDocTag());
            if (phpParameterInfo == null) {
                PhpAddParamTypeQuickFix.$$$reportNull$$$0(8);
            }
            return phpParameterInfo;
        }

        public boolean startInWriteAction() {
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 2, 7, 8 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "typeHint";
                    break;
                }
                case 1: 
                case 2: 
                case 7: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/type/PhpMissingParamTypeInspection$PhpAddParamTypeQuickFix";
                    break;
                }
                case 3: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "previewDescriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/type/PhpMissingParamTypeInspection$PhpAddParamTypeQuickFix";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "generatePreview";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createNewInfoOnlyForUpdatedParameter";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 7: 
                case 8: {
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "generatePreview";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 2, 7, 8 -> new IllegalStateException(string);
            };
        }
    }
}

