/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.intentions;

import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.codeInspection.util.IntentionName;
import com.intellij.lang.ASTNode;
import com.intellij.modcommand.ActionContext;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.Presentation;
import com.intellij.modcommand.PsiUpdateModCommandAction;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.PhpWorkaroundUtil;
import com.jetbrains.php.lang.intentions.stringDoc.PhpHeredocToStringIntention;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.StringLiteralExpression;
import com.jetbrains.php.util.PhpStringUtil;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpReplaceQuotesIntention
extends PsiUpdateModCommandAction<PsiElement> {
    @IntentionName
    @IntentionFamilyName
    public static final String TEXT = PhpBundle.message("replace.quotes", new Object[0]);
    private static final char SINGLE_QUOTE = '\'';
    private static final char DOUBLE_QUOTE = '\"';
    private static final Set<Character> SET = Set.of(Character.valueOf('\n'), Character.valueOf('\t'));

    public PhpReplaceQuotesIntention() {
        super(PsiElement.class);
    }

    @Nullable
    protected Presentation getPresentation(@NotNull ActionContext context, @NotNull PsiElement element) {
        if (context == null) {
            PhpReplaceQuotesIntention.$$$reportNull$$$0(0);
        }
        if (element == null) {
            PhpReplaceQuotesIntention.$$$reportNull$$$0(1);
        }
        if (!PhpWorkaroundUtil.isIntentionAvailable(element) || !PhpReplaceQuotesIntention.isStringLiteral(element)) {
            return null;
        }
        return Presentation.of((String)this.getFamilyName());
    }

    public static boolean isStringLiteral(@NotNull PsiElement element) {
        ASTNode node;
        if (element == null) {
            PhpReplaceQuotesIntention.$$$reportNull$$$0(2);
        }
        if ((node = element.getNode()) == null) {
            return false;
        }
        IElementType type = node.getElementType();
        IElementType parentType = node.getTreeParent().getElementType();
        return type == PhpTokenTypes.STRING_LITERAL || parentType == PhpElementTypes.STRING || type == PhpTokenTypes.STRING_LITERAL_SINGLE_QUOTE || element.getParent() != null && element.getParent().getParent() instanceof StringLiteralExpression;
    }

    @NotNull
    public String getFamilyName() {
        String string = TEXT;
        if (string == null) {
            PhpReplaceQuotesIntention.$$$reportNull$$$0(3);
        }
        return string;
    }

    protected void invoke(@NotNull ActionContext context, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
        StringLiteralExpression string;
        if (context == null) {
            PhpReplaceQuotesIntention.$$$reportNull$$$0(4);
        }
        if (element == null) {
            PhpReplaceQuotesIntention.$$$reportNull$$$0(5);
        }
        if (updater == null) {
            PhpReplaceQuotesIntention.$$$reportNull$$$0(6);
        }
        if ((string = PhpPsiUtil.getParentOfClass(element, false, StringLiteralExpression.class)) == null || string.isHeredoc() || PhpHeredocToStringIntention.isNowdoc((PsiElement)string)) {
            return;
        }
        if (!PhpStringUtil.isUnescapableText(string.getText(), PhpReplaceQuotesIntention.getNewQuote(string.isSingleQuote()) == '\"')) {
            updater.cancel(PhpBundle.message("intention.replace.quotes", new Object[0]));
        }
        StringLiteralExpression newElement = PhpReplaceQuotesIntention.createLiteralWithChangedQuotes(string);
        ASTNode parentNode = string.getNode();
        ASTNode tempNode = parentNode.getTreeParent();
        tempNode.replaceChild(parentNode, newElement.getNode());
    }

    public static StringLiteralExpression createLiteralWithChangedQuotes(@NotNull StringLiteralExpression string) {
        if (string == null) {
            PhpReplaceQuotesIntention.$$$reportNull$$$0(7);
        }
        return PhpPsiElementFactory.createPhpPsiFromText(string.getProject(), StringLiteralExpression.class, PhpReplaceQuotesIntention.createTextWithChangedQuotes(string));
    }

    @NotNull
    public static String createTextWithChangedQuotes(@NotNull StringLiteralExpression string) {
        if (string == null) {
            PhpReplaceQuotesIntention.$$$reportNull$$$0(8);
        }
        return string.isHeredoc() ? PhpReplaceQuotesIntention.createHeredocTextWithChangedQuotes(string) : PhpReplaceQuotesIntention.createTextWithChangedQuotes(string.getText(), string.isSingleQuote());
    }

    @NotNull
    private static String createHeredocTextWithChangedQuotes(@NotNull StringLiteralExpression string) {
        char newQuote;
        if (string == null) {
            PhpReplaceQuotesIntention.$$$reportNull$$$0(9);
        }
        char oldQuote = (newQuote = PhpReplaceQuotesIntention.getNewQuote(string.isSingleQuote())) == '\"' ? (char)'\'' : '\"';
        String contents = string.getContents();
        String escapedContent = PhpReplaceQuotesIntention.escapeString(contents, newQuote, oldQuote);
        String elementText = string.getText();
        String heredocStart = elementText.substring(0, string.getValueRange().getStartOffset());
        String heredocEnd = elementText.substring(string.getValueRange().getEndOffset());
        String string2 = heredocStart + escapedContent + heredocEnd;
        if (string2 == null) {
            PhpReplaceQuotesIntention.$$$reportNull$$$0(10);
        }
        return string2;
    }

    @NotNull
    public static String createTextWithChangedQuotes(String data, boolean singleQuote) {
        char newQuote = PhpReplaceQuotesIntention.getNewQuote(singleQuote);
        char oldQuote = newQuote == '\"' ? (char)'\'' : '\"';
        String isBinary = "";
        if (data.startsWith("b") || data.startsWith("B")) {
            isBinary = data.substring(0, 1);
        }
        data = data.substring(1 + isBinary.length(), data.length() - 1);
        data = PhpReplaceQuotesIntention.escapeString(data, newQuote, oldQuote);
        String string = isBinary + newQuote + data + newQuote;
        if (string == null) {
            PhpReplaceQuotesIntention.$$$reportNull$$$0(11);
        }
        return string;
    }

    private static char getNewQuote(boolean singleQuote) {
        return !singleQuote ? (char)'\'' : '\"';
    }

    public static String escapeString(String t, char newQuote, char oldQuote) {
        String temp = PhpStringUtil.unescapeText(t, oldQuote == '\'');
        return PhpStringUtil.escapeText(temp, newQuote == '\'', SET);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 10, 11 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: 
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/intentions/PhpReplaceQuotesIntention";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updater";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "string";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/intentions/PhpReplaceQuotesIntention";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "createHeredocTextWithChangedQuotes";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "createTextWithChangedQuotes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getPresentation";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isStringLiteral";
                break;
            }
            case 3: 
            case 10: 
            case 11: {
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createLiteralWithChangedQuotes";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createTextWithChangedQuotes";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createHeredocTextWithChangedQuotes";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 10, 11 -> new IllegalStateException(string);
        };
    }
}

