/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.intentions;

import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.lang.ASTNode;
import com.intellij.modcommand.ActionContext;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.Presentation;
import com.intellij.modcommand.PsiUpdateModCommandAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocComment;
import com.jetbrains.php.lang.formatter.PhpFormatterUtil;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.elements.Variable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpVariableAddPhpDocCommentIntention
extends PsiUpdateModCommandAction<Variable> {
    private static final String TYPE_NAME = "TYPE_NAME";
    private static final String PHP_DOC_TEMPLATE_VAR = "/** @var TYPE_NAME $<var> */";

    public PhpVariableAddPhpDocCommentIntention() {
        super(Variable.class);
    }

    @NotNull
    public String getFamilyName() {
        String string = PhpVariableAddPhpDocCommentIntention.getTitle();
        if (string == null) {
            PhpVariableAddPhpDocCommentIntention.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Nullable
    protected Presentation getPresentation(@NotNull ActionContext context, @NotNull Variable variable) {
        if (context == null) {
            PhpVariableAddPhpDocCommentIntention.$$$reportNull$$$0(1);
        }
        if (variable == null) {
            PhpVariableAddPhpDocCommentIntention.$$$reportNull$$$0(2);
        }
        if (!PsiManager.getInstance((Project)context.project()).isInProject((PsiElement)variable)) {
            return null;
        }
        return Presentation.of((String)this.getFamilyName());
    }

    protected void invoke(@NotNull ActionContext context, @NotNull Variable variable, @NotNull ModPsiUpdater updater) {
        if (context == null) {
            PhpVariableAddPhpDocCommentIntention.$$$reportNull$$$0(3);
        }
        if (variable == null) {
            PhpVariableAddPhpDocCommentIntention.$$$reportNull$$$0(4);
        }
        if (updater == null) {
            PhpVariableAddPhpDocCommentIntention.$$$reportNull$$$0(5);
        }
        String actualCode = PHP_DOC_TEMPLATE_VAR.replace("<var>", variable.getName());
        ASTNode statementNode = PhpFormatterUtil.getBoundStatement((ASTNode)variable.getNode());
        if (statementNode == null) {
            return;
        }
        PsiElement statement = statementNode.getPsi();
        PsiElement parent = statement.getParent();
        if (parent != null) {
            Project project = context.project();
            PhpDocComment elementToInsert = PhpPsiElementFactory.createFromText(project, PhpDocComment.class, actualCode);
            PsiWhiteSpace newLine = PhpPsiElementFactory.createFromText(project, PsiWhiteSpace.class, "");
            if (elementToInsert != null) {
                PsiElement inserted = parent.addBefore((PsiElement)elementToInsert, statement);
                if (newLine != null) {
                    parent.addAfter((PsiElement)newLine, inserted);
                }
                Document document = parent.getContainingFile().getFileDocument();
                PsiDocumentManager manager = PsiDocumentManager.getInstance((Project)project);
                manager.doPostponedOperationsAndUnblockDocument(document);
                String selection = TYPE_NAME;
                int selectionPos = inserted.getText().indexOf(TYPE_NAME);
                if (selectionPos >= 0) {
                    int selectionStart = inserted.getTextOffset() + selectionPos;
                    updater.select(TextRange.from((int)selectionStart, (int)TYPE_NAME.length()));
                }
                int line = document.getLineNumber(inserted.getTextOffset());
                CodeStyleManager.getInstance((Project)project).adjustLineIndent(document, document.getLineStartOffset(line));
            }
        }
    }

    @IntentionFamilyName
    public static String getTitle() {
        return PhpBundle.message("intention.variable.add.phpdoc.comment.family.name", new Object[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/intentions/PhpVariableAddPhpDocCommentIntention";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updater";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/intentions/PhpVariableAddPhpDocCommentIntention";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getPresentation";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 5 -> new IllegalArgumentException(string);
        };
    }
}

