/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.intentions.groupUse;

import com.intellij.modcommand.ActionContext;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.Presentation;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.PhpWorkaroundUtil;
import com.jetbrains.php.codeInsight.PhpCodeInsightUtil;
import com.jetbrains.php.config.PhpLanguageFeature;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.intentions.groupUse.PhpConvertUseIntentionBase;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.psi.PhpCodeEditUtil;
import com.jetbrains.php.lang.psi.PhpGroupUseElement;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.PhpReference;
import com.jetbrains.php.lang.psi.elements.PhpUse;
import com.jetbrains.php.lang.psi.elements.PhpUseList;
import com.jetbrains.php.lang.psi.elements.impl.PhpUseImpl;
import java.util.ArrayList;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpGroupUseStatementsIntention
extends PhpConvertUseIntentionBase {
    @Nullable
    protected Presentation getPresentation(@NotNull ActionContext context, @NotNull PsiElement element) {
        if (context == null) {
            PhpGroupUseStatementsIntention.$$$reportNull$$$0(0);
        }
        if (element == null) {
            PhpGroupUseStatementsIntention.$$$reportNull$$$0(1);
        }
        if (!PhpWorkaroundUtil.isIntentionAvailable(element)) {
            return null;
        }
        if (!PhpLanguageFeature.GROUPED_USE.isSupported(context.project())) {
            return null;
        }
        PhpUseList useList = PhpUseImpl.getUseList(element);
        if (useList == null || useList.isTraitImport() || PhpPsiUtil.getChildOfType((PsiElement)useList, PhpElementTypes.USE_BRACES) != null) {
            return null;
        }
        PhpUse useToConvert = this.findNearestUse(element);
        if (useToConvert == null || this.getElementToConvert(element, useToConvert) == null) {
            return null;
        }
        return PhpCodeInsightUtil.findScopeForUseOperator(element) != null ? Presentation.of((String)this.getFamilyName()) : null;
    }

    protected void invoke(@NotNull ActionContext context, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
        if (context == null) {
            PhpGroupUseStatementsIntention.$$$reportNull$$$0(2);
        }
        if (element == null) {
            PhpGroupUseStatementsIntention.$$$reportNull$$$0(3);
        }
        if (updater == null) {
            PhpGroupUseStatementsIntention.$$$reportNull$$$0(4);
        }
        PhpUseList useList = PhpUseImpl.getUseList(element);
        assert (useList != null);
        PsiElement dummy = PhpGroupUseStatementsIntention.addDummyBefore(context.project(), useList);
        PhpUse useToConvert = this.findNearestUse(element);
        assert (useToConvert != null);
        PsiElement elementToConvert = this.getElementToConvert(element, useToConvert);
        assert (elementToConvert != null);
        PhpReference targetReference = useToConvert.getTargetReference();
        assert (targetReference != null);
        String fqn = targetReference.getFQN();
        assert (fqn != null);
        PhpPsiElement scope = PhpCodeInsightUtil.findScopeForUseOperator(element);
        assert (scope != null);
        String keyword = PhpGroupUseElement.getKeyword(useToConvert, useList);
        String name = this.getName(elementToConvert, targetReference, element.getContainingFile().getFileDocument());
        String newFqn = PhpLangUtil.equalsNamespaceNames(fqn, PhpLangUtil.toFQN(name)) ? PhpLangUtil.concat(fqn, "\\") : fqn.substring(0, fqn.length() - name.length());
        ArrayList<PhpGroupUseElement> uses = new ArrayList<PhpGroupUseElement>();
        for (PhpUseList currentUseList : PhpCodeInsightUtil.collectImports(scope)) {
            for (PhpUse currentUse : currentUseList.getDeclarations()) {
                String currentFqn;
                if (!keyword.equals(PhpGroupUseElement.getKeyword(currentUse, currentUseList)) || !(currentFqn = currentUse.getFQN()).startsWith(newFqn)) continue;
                uses.add(new PhpGroupUseElement(null, currentFqn.substring(newFqn.length()), currentUse.getAliasName()));
                PhpCodeEditUtil.deleteUseOrUseList(currentUse, currentUseList);
            }
        }
        if (!uses.isEmpty()) {
            PhpUseList newUseList = PhpPsiElementFactory.createGroupUseStatementWithKeyword(context.project(), keyword, newFqn, uses);
            dummy.replace((PsiElement)newUseList);
        } else {
            dummy.delete();
        }
    }

    @NotNull
    private static PsiElement addDummyBefore(@NotNull Project project, @NotNull PhpUseList useList) {
        if (project == null) {
            PhpGroupUseStatementsIntention.$$$reportNull$$$0(5);
        }
        if (useList == null) {
            PhpGroupUseStatementsIntention.$$$reportNull$$$0(6);
        }
        PhpUseList dummy = PhpPsiElementFactory.createUseStatement(project, "\\", null);
        PsiElement psiElement = useList.getParent().addBefore((PsiElement)dummy, (PsiElement)useList);
        if (psiElement == null) {
            PhpGroupUseStatementsIntention.$$$reportNull$$$0(7);
        }
        return psiElement;
    }

    @Nls
    @NotNull
    public String getFamilyName() {
        String string = PhpBundle.message("group.use.statements.by.selected.prefix", new Object[0]);
        if (string == null) {
            PhpGroupUseStatementsIntention.$$$reportNull$$$0(8);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updater";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "useList";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/intentions/groupUse/PhpGroupUseStatementsIntention";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/intentions/groupUse/PhpGroupUseStatementsIntention";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "addDummyBefore";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getPresentation";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addDummyBefore";
                break;
            }
            case 7: 
            case 8: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 7, 8 -> new IllegalStateException(string);
        };
    }
}

