/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.intentions.strings;

import com.intellij.modcommand.ActionContext;
import com.intellij.modcommand.ModCommand;
import com.intellij.modcommand.Presentation;
import com.intellij.modcommand.PsiBasedModCommandAction;
import com.intellij.psi.PsiElement;
import com.intellij.util.ObjectUtils;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.intentions.strings.converters.PhpConcatenationStringRepresentationConverter;
import com.jetbrains.php.lang.intentions.strings.converters.PhpStringPartDescriptor;
import com.jetbrains.php.lang.psi.elements.BinaryExpression;
import com.jetbrains.php.lang.psi.elements.ClassConstantReference;
import com.jetbrains.php.lang.psi.elements.Constant;
import com.jetbrains.php.lang.psi.elements.ConstantReference;
import com.jetbrains.php.lang.psi.elements.Field;
import com.jetbrains.php.lang.psi.elements.StringLiteralExpression;
import com.jetbrains.php.util.PhpStringUtil;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpCopyConcatenatedStringToClipboardIntention
extends PsiBasedModCommandAction<PsiElement> {
    private static final String UNKNOWN_EXPRESSION_SYMBOL = "?";
    private static final PhpConcatenationStringRepresentationConverter CONVERTER = PhpConcatenationStringRepresentationConverter.INSTANCE;

    public PhpCopyConcatenatedStringToClipboardIntention() {
        super(PsiElement.class);
    }

    @Nullable
    protected Presentation getPresentation(@NotNull ActionContext context, @NotNull PsiElement element) {
        BinaryExpression expression;
        if (context == null) {
            PhpCopyConcatenatedStringToClipboardIntention.$$$reportNull$$$0(0);
        }
        if (element == null) {
            PhpCopyConcatenatedStringToClipboardIntention.$$$reportNull$$$0(1);
        }
        return (expression = CONVERTER.getTargetElement(element)) != null && PhpConcatenationStringRepresentationConverter.isConcatenation((PsiElement)expression) ? Presentation.of((String)this.getFamilyName()) : null;
    }

    @NotNull
    protected ModCommand perform(@NotNull ActionContext context, @NotNull PsiElement element) {
        BinaryExpression expression;
        if (context == null) {
            PhpCopyConcatenatedStringToClipboardIntention.$$$reportNull$$$0(2);
        }
        if (element == null) {
            PhpCopyConcatenatedStringToClipboardIntention.$$$reportNull$$$0(3);
        }
        if ((expression = CONVERTER.getTargetElement(element)) != null) {
            String concatenationResult = StreamEx.of(CONVERTER.getStringParts(expression)).map(PhpStringPartDescriptor::getElement).map(PhpCopyConcatenatedStringToClipboardIntention::resolveConstantDefaultValue).map(PhpCopyConcatenatedStringToClipboardIntention::getContentForClipboard).joining();
            ModCommand modCommand = ModCommand.copyToClipboard((String)concatenationResult);
            if (modCommand == null) {
                PhpCopyConcatenatedStringToClipboardIntention.$$$reportNull$$$0(4);
            }
            return modCommand;
        }
        ModCommand modCommand = ModCommand.nop();
        if (modCommand == null) {
            PhpCopyConcatenatedStringToClipboardIntention.$$$reportNull$$$0(5);
        }
        return modCommand;
    }

    @NotNull
    private static PsiElement resolveConstantDefaultValue(@NotNull PsiElement element) {
        Field field;
        PsiElement value;
        Constant constant;
        if (element == null) {
            PhpCopyConcatenatedStringToClipboardIntention.$$$reportNull$$$0(6);
        }
        if (element instanceof ConstantReference && (constant = (Constant)ObjectUtils.tryCast((Object)((ConstantReference)element).resolve(), Constant.class)) != null && (value = constant.getValue()) != null) {
            PsiElement psiElement = value;
            if (psiElement == null) {
                PhpCopyConcatenatedStringToClipboardIntention.$$$reportNull$$$0(7);
            }
            return psiElement;
        }
        if (element instanceof ClassConstantReference && (field = (Field)ObjectUtils.tryCast((Object)((ClassConstantReference)element).resolve(), Field.class)) != null && (value = field.getDefaultValue()) != null) {
            PsiElement psiElement = value;
            if (psiElement == null) {
                PhpCopyConcatenatedStringToClipboardIntention.$$$reportNull$$$0(8);
            }
            return psiElement;
        }
        PsiElement psiElement = element;
        if (psiElement == null) {
            PhpCopyConcatenatedStringToClipboardIntention.$$$reportNull$$$0(9);
        }
        return psiElement;
    }

    private static String getContentForClipboard(PsiElement element) {
        return element instanceof StringLiteralExpression ? PhpStringUtil.unescapeText(((StringLiteralExpression)element).getContents(), false) : UNKNOWN_EXPRESSION_SYMBOL;
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getFamilyName() {
        String string = PhpBundle.message("copy.concatenated.string.to.clipboard", new Object[0]);
        if (string == null) {
            PhpCopyConcatenatedStringToClipboardIntention.$$$reportNull$$$0(10);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5, 7, 8, 9, 10 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: 
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/intentions/strings/PhpCopyConcatenatedStringToClipboardIntention";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/intentions/strings/PhpCopyConcatenatedStringToClipboardIntention";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "perform";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveConstantDefaultValue";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getPresentation";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "perform";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "resolveConstantDefaultValue";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5, 7, 8, 9, 10 -> new IllegalStateException(string);
        };
    }
}

