/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.intentions.strings.converters;

import com.intellij.modcommand.ActionContext;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.jetbrains.php.lang.inspections.codeStyle.PhpParenthesesPrecedenceAnalyzer;
import com.jetbrains.php.lang.intentions.strings.converters.PhpStringPartDescriptor;
import com.jetbrains.php.lang.intentions.strings.converters.PhpStringPartDescriptorImpl;
import com.jetbrains.php.lang.intentions.strings.converters.PhpStringRepresentationConverter;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.BinaryExpression;
import com.jetbrains.php.lang.psi.elements.ParenthesizedExpression;
import java.util.Collections;
import java.util.List;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpConcatenationStringRepresentationConverter
implements PhpStringRepresentationConverter<BinaryExpression> {
    public static final PhpConcatenationStringRepresentationConverter INSTANCE = new PhpConcatenationStringRepresentationConverter();
    private static final int RECURSION_LIMIT = 200;

    @Override
    @NotNull
    public List<PhpStringPartDescriptor> getStringParts(@NotNull BinaryExpression expression, @NotNull ActionContext context) {
        if (expression == null) {
            PhpConcatenationStringRepresentationConverter.$$$reportNull$$$0(0);
        }
        if (context == null) {
            PhpConcatenationStringRepresentationConverter.$$$reportNull$$$0(1);
        }
        List<PhpStringPartDescriptor> list = this.getStringParts(expression);
        if (list == null) {
            PhpConcatenationStringRepresentationConverter.$$$reportNull$$$0(2);
        }
        return list;
    }

    @NotNull
    public List<PhpStringPartDescriptor> getStringParts(@NotNull BinaryExpression expression) {
        if (expression == null) {
            PhpConcatenationStringRepresentationConverter.$$$reportNull$$$0(3);
        }
        return PhpConcatenationStringRepresentationConverter.getStringPartsInner((PsiElement)expression, 0);
    }

    @NotNull
    private static List<PhpStringPartDescriptor> getStringPartsInner(@NotNull PsiElement expression, int recursionDepth) {
        if (expression == null) {
            PhpConcatenationStringRepresentationConverter.$$$reportNull$$$0(4);
        }
        if (recursionDepth >= 200) {
            List<PhpStringPartDescriptor> list = Collections.singletonList(new PhpStringPartDescriptorImpl(expression));
            if (list == null) {
                PhpConcatenationStringRepresentationConverter.$$$reportNull$$$0(5);
            }
            return list;
        }
        if (PhpConcatenationStringRepresentationConverter.isConcatenation(expression)) {
            PsiElement rightOperand;
            SmartList elements = new SmartList();
            PsiElement leftOperand = PhpConcatenationStringRepresentationConverter.unparenthesize(((BinaryExpression)expression).getLeftOperand());
            if (leftOperand != null) {
                elements.addAll(PhpConcatenationStringRepresentationConverter.getStringPartsInner(leftOperand, recursionDepth + 1));
            }
            if ((rightOperand = PhpConcatenationStringRepresentationConverter.unparenthesize(((BinaryExpression)expression).getRightOperand())) != null) {
                elements.addAll(PhpConcatenationStringRepresentationConverter.getStringPartsInner(rightOperand, recursionDepth + 1));
            }
            SmartList smartList = elements;
            if (smartList == null) {
                PhpConcatenationStringRepresentationConverter.$$$reportNull$$$0(6);
            }
            return smartList;
        }
        List<PhpStringPartDescriptor> list = Collections.singletonList(new PhpStringPartDescriptorImpl(expression));
        if (list == null) {
            PhpConcatenationStringRepresentationConverter.$$$reportNull$$$0(7);
        }
        return list;
    }

    @Override
    public boolean isAvailable(@NotNull BinaryExpression expression, @NotNull ActionContext context) {
        if (expression == null) {
            PhpConcatenationStringRepresentationConverter.$$$reportNull$$$0(8);
        }
        if (context == null) {
            PhpConcatenationStringRepresentationConverter.$$$reportNull$$$0(9);
        }
        return PhpConcatenationStringRepresentationConverter.isConcatenation((PsiElement)expression);
    }

    @Override
    @NotNull
    public BinaryExpression createExpression(@NotNull Project project, @NotNull List<PsiElement> parts) {
        if (project == null) {
            PhpConcatenationStringRepresentationConverter.$$$reportNull$$$0(10);
        }
        if (parts == null) {
            PhpConcatenationStringRepresentationConverter.$$$reportNull$$$0(11);
        }
        String text = StreamEx.of(parts).map(element -> PhpConcatenationStringRepresentationConverter.needParenthesize(element) ? "(" + element.getText() + ")" : element.getText()).joining((CharSequence)" . ");
        BinaryExpression binaryExpression = (BinaryExpression)PsiTreeUtil.findChildOfType((PsiElement)PhpPsiElementFactory.createPsiFileFromText(project, text), BinaryExpression.class);
        if (binaryExpression == null) {
            PhpConcatenationStringRepresentationConverter.$$$reportNull$$$0(12);
        }
        return binaryExpression;
    }

    private static boolean needParenthesize(PsiElement element) {
        return PhpParenthesesPrecedenceAnalyzer.getPrecedence(element) < (Integer)PhpParenthesesPrecedenceAnalyzer.getPrecedenceOfConcatOperation((Project)element.getProject()).first;
    }

    @Override
    @Nullable
    public BinaryExpression getTargetElement(@NotNull PsiElement element) {
        BinaryExpression expression;
        if (element == null) {
            PhpConcatenationStringRepresentationConverter.$$$reportNull$$$0(13);
        }
        while ((expression = PhpPsiUtil.getParentOfClass(element, BinaryExpression.class)) != null) {
            element = expression;
        }
        return (BinaryExpression)ObjectUtils.tryCast((Object)element, BinaryExpression.class);
    }

    public static boolean isConcatenation(@Nullable PsiElement element) {
        return element instanceof BinaryExpression && ((BinaryExpression)element).getOperationType() == PhpTokenTypes.opCONCAT;
    }

    @Nullable
    private static PsiElement unparenthesize(@Nullable PsiElement element) {
        return element instanceof ParenthesizedExpression ? ((ParenthesizedExpression)element).extract() : element;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 5, 6, 7, 12 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 1: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/intentions/strings/converters/PhpConcatenationStringRepresentationConverter";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parts";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/intentions/strings/converters/PhpConcatenationStringRepresentationConverter";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getStringParts";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getStringPartsInner";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "createExpression";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getStringParts";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 12: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getStringPartsInner";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createExpression";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getTargetElement";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 5, 6, 7, 12 -> new IllegalStateException(string);
        };
    }
}

