/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.psi;

import com.intellij.extapi.psi.PsiFileBase;
import com.intellij.lang.Language;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.Strings;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiRecursiveElementVisitor;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.MultiMap;
import com.jetbrains.php.PhpPresentationUtil;
import com.jetbrains.php.codeInsight.PhpScopeHolder;
import com.jetbrains.php.codeInsight.PhpScopeImpl;
import com.jetbrains.php.codeInsight.controlFlow.PhpControlFlow;
import com.jetbrains.php.lang.PhpFileType;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocComment;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.psi.PhpFile;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ArrayCreationExpression;
import com.jetbrains.php.lang.psi.elements.AssignmentExpression;
import com.jetbrains.php.lang.psi.elements.BinaryExpression;
import com.jetbrains.php.lang.psi.elements.Constant;
import com.jetbrains.php.lang.psi.elements.ControlStatement;
import com.jetbrains.php.lang.psi.elements.Else;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.GroupStatement;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpDefine;
import com.jetbrains.php.lang.psi.elements.PhpExpression;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.elements.PhpNamespace;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.PhpSwitch;
import com.jetbrains.php.lang.psi.elements.PhpUse;
import com.jetbrains.php.lang.psi.elements.Statement;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.lang.psi.elements.impl.ArrayCreationExpressionImpl;
import com.jetbrains.php.lang.psi.resolve.types.PhpTypeAnalyserVisitor;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpFileImpl
extends PsiFileBase
implements PhpFile {
    @NonNls
    private static final Pattern DEFINE_DECL_PATTERN = Pattern.compile("/\\*\\*\\s+@define \"([^\"]*)\" \"([^\"]*)\".*");
    private final CachedValue<Map<String, String>> myDefinedVars = CachedValuesManager.getManager((Project)this.getProject()).createCachedValue(this.createImplicitVarsProvider(), false);
    private final CachedValue<MultiMap<String, PhpNamedElement>> myTopLevelDefs = CachedValuesManager.getManager((Project)this.getProject()).createCachedValue(this.createTopLevelDefsProvider(), false);
    private PhpScopeImpl myScope;

    private CachedValueProvider<Map<String, String>> createImplicitVarsProvider() {
        return new CachedValueProvider<Map<String, String>>(){

            public CachedValueProvider.Result<Map<String, String>> compute() {
                final HashMap result = new HashMap();
                PhpFileImpl.this.accept((PsiElementVisitor)new PsiRecursiveElementVisitor(this){

                    public void visitElement(@NotNull PsiElement element) {
                        PsiElement comment;
                        String text;
                        Matcher variableMatcher;
                        if (element == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        if (element instanceof PhpDocComment && (variableMatcher = DEFINE_DECL_PATTERN.matcher(text = (comment = element).getText())).matches()) {
                            String name = variableMatcher.group(1);
                            String value = variableMatcher.group(2);
                            if (!result.containsKey(name)) {
                                result.put(name, value);
                            }
                        }
                        if (element instanceof ArrayCreationExpression) {
                            ArrayCreationExpression arrayCreationExpression = (ArrayCreationExpression)element;
                            ArrayCreationExpressionImpl.children(arrayCreationExpression).limit(PhpTypeAnalyserVisitor.MAX_ARRAY_VALUES).forEach(x$0 -> super.visitElement(x$0));
                        } else {
                            super.visitElement(element);
                        }
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/php/lang/psi/PhpFileImpl$1$1", "visitElement"));
                    }
                });
                return CachedValueProvider.Result.create(result, (Object[])new Object[]{PhpFileImpl.this});
            }
        };
    }

    private CachedValueProvider<MultiMap<String, PhpNamedElement>> createTopLevelDefsProvider() {
        return new CachedValueProvider<MultiMap<String, PhpNamedElement>>(){

            public CachedValueProvider.Result<MultiMap<String, PhpNamedElement>> compute() {
                final MultiMap map = new MultiMap(CollectionFactory.createCaseInsensitiveStringMap());
                PhpFileImpl.this.withGreenStubTreeOrAst(stubTree -> {
                    stubTree.getPlainList().forEach(e -> this.mapEntity((MultiMap<String, PhpNamedElement>)map, e.getPsi()));
                    return null;
                }, astTree -> {
                    PhpFileImpl.this.accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor(){

                        public void visitElement(@NotNull PsiElement element) {
                            if (element == null) {
                                1.$$$reportNull$$$0(0);
                            }
                            this.mapEntity((MultiMap<String, PhpNamedElement>)map, element);
                            if (element instanceof PhpClass || element instanceof PhpDocComment || element instanceof Function) {
                                return;
                            }
                            if (element instanceof PhpExpression && !1.isDefine(element)) {
                                return;
                            }
                            if (element instanceof Statement) {
                                PhpPsiElement firstPsiChild = ((Statement)element).getFirstPsiChild();
                                if (firstPsiChild instanceof AssignmentExpression) {
                                    PhpPsiElement variable = ((AssignmentExpression)firstPsiChild).getVariable();
                                    if (variable != null) {
                                        this.visitElement((PsiElement)variable);
                                    }
                                    return;
                                }
                                if (!(element instanceof GroupStatement || element instanceof ControlStatement || element instanceof PhpSwitch || element instanceof Else || firstPsiChild instanceof Constant || PhpPsiUtil.isOfType((PsiElement)firstPsiChild, PhpElementTypes.SILENCE_EXPRESSION) || PhpPsiUtil.isOfType((PsiElement)firstPsiChild, PhpElementTypes.LOGICAL_EXPRESSION) || PhpPsiUtil.isOfType((PsiElement)firstPsiChild, PhpElementTypes.LITERAL_LOGICAL_EXPRESSION))) {
                                    return;
                                }
                            }
                            super.visitElement(element);
                        }

                        private static boolean isDefine(PsiElement element) {
                            return PhpPsiUtil.isOfType(element, PhpElementTypes.SILENCE_EXPRESSION) && ((PhpExpression)element).getFirstPsiChild() instanceof PhpDefine || PhpPsiUtil.isOfType(element, PhpElementTypes.LOGICAL_EXPRESSION) && ((BinaryExpression)element).getRightOperand() instanceof PhpDefine || PhpPsiUtil.isOfType(element, PhpElementTypes.LITERAL_LOGICAL_EXPRESSION) && ((BinaryExpression)element).getRightOperand() instanceof PhpDefine;
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/php/lang/psi/PhpFileImpl$2$1", "visitElement"));
                        }
                    });
                    return null;
                });
                return CachedValueProvider.Result.create((Object)map, (Object[])new Object[]{PhpFileImpl.this});
            }

            private void mapEntity(MultiMap<String, PhpNamedElement> map, PsiElement element) {
                if (element instanceof PhpNamespace) {
                    map.putValue((Object)((PhpNamespace)element).getName(), (Object)((PhpNamespace)element));
                } else if (element instanceof PhpUse) {
                    String name = ((PhpUse)element).getAliasName();
                    if (name == null) {
                        name = ((PhpUse)element).getName();
                    }
                    map.putValue((Object)(((PhpUse)element).getNamespaceName() + name), (Object)((PhpUse)element));
                } else if (element instanceof PhpClass && !((PhpClass)element).isAnonymous()) {
                    map.putValue((Object)((PhpClass)element).getFQN(), (Object)((PhpClass)element));
                } else if (element instanceof Function && !(element instanceof Method) && !((Function)element).isClosure()) {
                    map.putValue((Object)((Function)element).getFQN(), (Object)((Function)element));
                } else if (element instanceof Variable) {
                    map.putValue((Object)((Variable)element).getName(), (Object)((Variable)element));
                } else if (element instanceof Constant) {
                    map.putValue((Object)((Constant)element).getFQN(), (Object)((Constant)element));
                }
            }
        };
    }

    public PhpFileImpl(FileViewProvider viewProvider) {
        this(viewProvider, PhpFileType.INSTANCE.getLanguage());
    }

    public PhpFileImpl(FileViewProvider viewProvider, Language language) {
        super(viewProvider, language);
    }

    public PhpPsiElement getFirstPsiChild() {
        PsiElement[] children = this.getChildren();
        if (children.length > 0 && children[0] instanceof PhpPsiElement) {
            return (PhpPsiElement)children[0];
        }
        return null;
    }

    public PhpPsiElement getNextPsiSibling() {
        return null;
    }

    public PhpPsiElement getPrevPsiSibling() {
        return null;
    }

    @NotNull
    public FileType getFileType() {
        PhpFileType phpFileType = PhpFileType.INSTANCE;
        if (phpFileType == null) {
            PhpFileImpl.$$$reportNull$$$0(0);
        }
        return phpFileType;
    }

    public String toString() {
        return "PHP file";
    }

    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            PhpFileImpl.$$$reportNull$$$0(1);
        }
        if (visitor instanceof PhpElementVisitor) {
            ((PhpElementVisitor)visitor).visitPhpFile((PhpFile)this);
        } else {
            super.accept(visitor);
        }
    }

    public ItemPresentation getPresentation() {
        return PhpPresentationUtil.getFilePresentation(this);
    }

    @Nullable
    public String findDefinedVariableValue(String name) {
        return (String)((Map)this.myDefinedVars.getValue()).get(name);
    }

    @NotNull
    public MultiMap<String, PhpNamedElement> getTopLevelDefs() {
        MultiMap multiMap = (MultiMap)this.myTopLevelDefs.getValue();
        if (multiMap == null) {
            PhpFileImpl.$$$reportNull$$$0(2);
        }
        return multiMap;
    }

    @NotNull
    public PhpControlFlow getControlFlow() {
        PhpControlFlow phpControlFlow = this.getScope().getControlFlow();
        if (phpControlFlow == null) {
            PhpFileImpl.$$$reportNull$$$0(3);
        }
        return phpControlFlow;
    }

    @NotNull
    public PhpScopeImpl getScope() {
        if (this.myScope == null) {
            this.myScope = new PhpScopeImpl((PhpScopeHolder)this);
        }
        PhpScopeImpl phpScopeImpl = this.myScope;
        if (phpScopeImpl == null) {
            PhpFileImpl.$$$reportNull$$$0(4);
        }
        return phpScopeImpl;
    }

    public void subtreeChanged() {
        super.subtreeChanged();
        if (this.myScope != null) {
            this.myScope.clear();
        }
    }

    @NotNull
    public Set<CharSequence> getPredefinedVariables() {
        Set<CharSequence> set = PhpLangUtil.getPredefinedVariables(this);
        if (set == null) {
            PhpFileImpl.$$$reportNull$$$0(5);
        }
        return set;
    }

    public String getMainNamespaceName() {
        if (Strings.areSameInstance((String)this.getScope().namespaceName, (String)"$ NOT INITIALISED $")) {
            Stream stream = (Stream)this.withGreenStubOrAst(stub -> stub.getChildrenStubs().stream().map(e -> e.getPsi()), ast -> {
                PhpPsiElement child = this.getFirstPsiChild();
                if (!(child instanceof GroupStatement)) {
                    return Stream.empty();
                }
                return PhpPsiUtil.getChildren((PsiElement)child, (Condition<? super PsiElement>)((Condition)e -> e instanceof PhpNamedElement)).stream();
            });
            Map<Boolean, List<PsiElement>> map = stream.collect(Collectors.partitioningBy(e -> e instanceof PhpNamespace));
            int nsCount = map.get(true).size();
            int othersCount = map.get(false).size();
            if (nsCount == 0) {
                this.getScope().namespaceName = "";
            } else if (nsCount == 1 && othersCount == 0) {
                List<PsiElement> elements = map.get(true);
                this.getScope().namespaceName = ((PhpNamespace)elements.get(0)).getFQN();
            } else {
                this.getScope().namespaceName = null;
            }
        }
        return this.getScope().namespaceName;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/psi/PhpFileImpl";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileType";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/psi/PhpFileImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getTopLevelDefs";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getControlFlow";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getScope";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getPredefinedVariables";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1 -> new IllegalArgumentException(string);
        };
    }
}

