/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.psi.elements.impl;

import com.intellij.lang.ASTNode;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.TokenType;
import com.intellij.psi.tree.IElementType;
import com.intellij.ui.IconManager;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpClassHierarchyUtils;
import com.jetbrains.php.PhpClassMemberIconProvider;
import com.jetbrains.php.PhpIcons;
import com.jetbrains.php.PhpPresentationUtil;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpReturnInstruction;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocComment;
import com.jetbrains.php.lang.documentation.phpdoc.psi.impl.PhpDocTypeImpl;
import com.jetbrains.php.lang.documentation.phpdoc.psi.tags.PhpDocReturnTag;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.parser.PhpStubElementTypes;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpClassMember;
import com.jetbrains.php.lang.psi.elements.PhpModifier;
import com.jetbrains.php.lang.psi.elements.PhpModifierList;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.PhpReturnType;
import com.jetbrains.php.lang.psi.elements.impl.FunctionImpl;
import com.jetbrains.php.lang.psi.elements.impl.ParameterImpl;
import com.jetbrains.php.lang.psi.elements.impl.PhpClassFieldsListImpl;
import com.jetbrains.php.lang.psi.elements.impl.PhpClassImpl;
import com.jetbrains.php.lang.psi.resolve.types.PhpOptionalCompletionTP;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.resolve.types.PhpTypeInfo;
import com.jetbrains.php.lang.psi.resolve.types.PhpTypeSignatureKey;
import com.jetbrains.php.lang.psi.stubs.PhpMethodStub;
import com.jetbrains.php.lang.psi.stubs.PhpNamedStub;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import kotlin.jvm.functions.Function1;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class MethodImpl
extends FunctionImpl
implements Method {
    private static final Function1<Method, Icon> METHOD_ICON_EVALUATOR = method -> PhpClassMemberIconProvider.getMethodIcon(method);

    public MethodImpl(ASTNode node) {
        super(node);
    }

    public static Icon getIcon(Method method) {
        return IconManager.getInstance().createDeferredIcon(PhpIcons.METHOD, (Object)method, METHOD_ICON_EVALUATOR);
    }

    @Override
    public void processDocs(Processor<PhpDocComment> processor2) {
        if (!processor2.process((Object)this.getDocComment())) {
            return;
        }
        PhpClassHierarchyUtils.processSuperMethods((Method)this, (method, subClass, baseClass) -> processor2.process((Object)method.getDocComment()));
    }

    public MethodImpl(PhpMethodStub stub) {
        super((PhpNamedStub)stub, (IElementType)PhpStubElementTypes.CLASS_METHOD);
    }

    @Override
    public PsiElement setName(@NonNls @NotNull String name) throws IncorrectOperationException {
        if (name == null) {
            MethodImpl.$$$reportNull$$$0(0);
        }
        ASTNode nameNode = this.getNameNode();
        String oldName = this.getName();
        if (nameNode != null && !PhpLangUtil.isNewStyleConstructor(oldName) && !oldName.equals(name)) {
            Method method = PhpPsiElementFactory.createMethod(this.getProject(), "function " + name + "(){}");
            ASTNode newChild = method.getNameNode();
            assert (newChild != null);
            nameNode.getTreeParent().replaceChild(nameNode, newChild);
        }
        return this;
    }

    @Override
    @NotNull
    public Icon getIcon() {
        Icon icon = MethodImpl.getIcon(this);
        if (icon == null) {
            MethodImpl.$$$reportNull$$$0(1);
        }
        return icon;
    }

    @Override
    public ItemPresentation getPresentation() {
        return PhpPresentationUtil.getMethodPresentation(this);
    }

    @Override
    protected void accept(@NotNull PhpElementVisitor phpElementVisitor) {
        if (phpElementVisitor == null) {
            MethodImpl.$$$reportNull$$$0(2);
        }
        phpElementVisitor.visitPhpMethod((Method)this);
    }

    @NotNull
    public PhpModifier getModifier() {
        PhpModifier.Abstractness abstractness = PhpModifier.Abstractness.IMPLEMENTED;
        PhpModifier.State state = PhpModifier.State.DYNAMIC;
        if (this.isStatic()) {
            state = PhpModifier.State.STATIC;
        }
        if (this.isAbstract()) {
            abstractness = PhpModifier.Abstractness.ABSTRACT;
        } else if (this.isFinal()) {
            abstractness = PhpModifier.Abstractness.FINAL;
        }
        PhpModifier phpModifier = PhpModifier.instance((PhpModifier.Access)this.getAccess(), (PhpModifier.Abstractness)abstractness, (PhpModifier.State)state);
        if (phpModifier == null) {
            MethodImpl.$$$reportNull$$$0(3);
        }
        return phpModifier;
    }

    public boolean isFinal() {
        ASTNode[] nodes;
        PhpNamedStub stub = (PhpNamedStub)this.getGreenStub();
        if (stub != null) {
            return ((PhpMethodStub)stub).isFinal();
        }
        PhpPsiElement modifierList = this.getModifierList();
        for (ASTNode node : nodes = modifierList.getNode().getChildren(PhpTokenTypes.tsMODIFIERS)) {
            if (node.getElementType() != PhpTokenTypes.kwFINAL) continue;
            return true;
        }
        return false;
    }

    @Override
    @Nullable
    public ASTNode getNameNode() {
        ASTNode next = this.getNode().findChildByType(PhpTokenTypes.kwFUNCTION).getTreeNext();
        while (PhpPsiUtil.isOfType(next, PhpTokenTypes.opBIT_AND) || next instanceof PsiWhiteSpace || next instanceof PsiComment) {
            next = next.getTreeNext();
        }
        return PhpPsiUtil.isOfType(next, TokenType.ERROR_ELEMENT) ? null : next;
    }

    public boolean isAbstract() {
        ASTNode[] nodes;
        PhpMethodStub stub = (PhpMethodStub)this.getGreenStub();
        if (stub != null) {
            return stub.isAbstract();
        }
        PhpPsiElement modifierList = this.getModifierList();
        for (ASTNode node : nodes = modifierList.getNode().getChildren(PhpTokenTypes.tsMODIFIERS)) {
            if (node.getElementType() != PhpTokenTypes.kwABSTRACT) continue;
            return true;
        }
        PhpClass phpInterface = PhpPsiUtil.getParentOfClass((PsiElement)this, PhpClass.class);
        if (phpInterface != null && phpInterface.isInterface()) {
            return !PhpClassImpl.isImplicitEnumFQN(phpInterface.getFQN());
        }
        return false;
    }

    @Override
    public boolean isReturningByReference() {
        PhpMethodStub stub = (PhpMethodStub)this.getGreenStub();
        if (stub != null) {
            return stub.isReturningByReference();
        }
        return this.getReturnByReferenceTokenFromAST() != null;
    }

    public PhpModifier.Access getAccess() {
        PhpNamedStub stub = (PhpNamedStub)this.getGreenStub();
        if (stub != null) {
            if (((PhpMethodStub)stub).isPrivate()) {
                return PhpModifier.Access.PRIVATE;
            }
            if (((PhpMethodStub)stub).isProtected()) {
                return PhpModifier.Access.PROTECTED;
            }
            return PhpModifier.Access.PUBLIC;
        }
        return MethodImpl.getAccess(this.getModifierList().getNode());
    }

    @NotNull
    public PhpPsiElement getModifierList() {
        PhpPsiElement phpPsiElement = (PhpPsiElement)PhpClassFieldsListImpl.getFirstChildNodeSkippingAttributes((PsiElement)this).getPsi();
        if (phpPsiElement == null) {
            MethodImpl.$$$reportNull$$$0(4);
        }
        return phpPsiElement;
    }

    @NotNull
    public static PhpModifier.Access getAccess(ASTNode astNode) {
        ASTNode[] nodes;
        for (ASTNode node : nodes = astNode.getChildren(PhpTokenTypes.tsMODIFIERS)) {
            if (node.getElementType() == PhpTokenTypes.kwPRIVATE) {
                PhpModifier.Access access = PhpModifier.Access.PRIVATE;
                if (access == null) {
                    MethodImpl.$$$reportNull$$$0(5);
                }
                return access;
            }
            if (node.getElementType() == PhpTokenTypes.kwPROTECTED) {
                PhpModifier.Access access = PhpModifier.Access.PROTECTED;
                if (access == null) {
                    MethodImpl.$$$reportNull$$$0(6);
                }
                return access;
            }
            if (node.getElementType() != PhpTokenTypes.kwPUBLIC) continue;
            PhpModifier.Access access = PhpModifier.Access.PUBLIC;
            if (access == null) {
                MethodImpl.$$$reportNull$$$0(7);
            }
            return access;
        }
        PhpModifier.Access access = PhpModifier.Access.PUBLIC;
        if (access == null) {
            MethodImpl.$$$reportNull$$$0(8);
        }
        return access;
    }

    @NotNull
    public Method.MethodType getMethodType(boolean allowAmbiguity) {
        CharSequence methodName = this.getNameCS();
        if (PhpLangUtil.isNewStyleConstructor(methodName)) {
            Method.MethodType methodType = Method.MethodType.CONSTRUCTOR;
            if (methodType == null) {
                MethodImpl.$$$reportNull$$$0(9);
            }
            return methodType;
        }
        PhpClass clazz = this.getContainingClass();
        if (clazz == null || !"\\".equals(clazz.getNamespaceName()) || !PhpLangUtil.equalsMethodNames(methodName, clazz.getNameCS())) {
            Method.MethodType methodType = Method.MethodType.REGULAR_METHOD;
            if (methodType == null) {
                MethodImpl.$$$reportNull$$$0(10);
            }
            return methodType;
        }
        Method.MethodType methodType = allowAmbiguity ? Method.MethodType.UNDEFINED : (clazz.findOwnMethodByName((CharSequence)"__construct") == null ? Method.MethodType.CONSTRUCTOR : Method.MethodType.REGULAR_METHOD);
        if (methodType == null) {
            MethodImpl.$$$reportNull$$$0(11);
        }
        return methodType;
    }

    public boolean isStatic() {
        PhpNamedStub stub = (PhpNamedStub)this.getGreenStub();
        if (stub != null) {
            return ((PhpMethodStub)stub).isStatic();
        }
        PhpModifierList modifierList = (PhpModifierList)PhpPsiUtil.getChildByCondition((PsiElement)this, (Condition<? super PsiElement>)PhpModifierList.INSTANCEOF);
        if (modifierList != null) {
            return PhpPsiUtil.getChildOfType((PsiElement)modifierList, PhpTokenTypes.kwSTATIC) != null;
        }
        return false;
    }

    @Nullable
    public PhpClass getContainingClass() {
        PsiElement stub = this.getParent();
        return stub instanceof PhpClass ? (PhpClass)stub : null;
    }

    @Override
    @NotNull
    public String getFQN() {
        return MethodImpl.getFQN((PhpClassMember)this);
    }

    @NotNull
    public static String getFQN(@NotNull PhpClassMember method) {
        PhpClass containingClass;
        if (method == null) {
            MethodImpl.$$$reportNull$$$0(12);
        }
        return (containingClass = method.getContainingClass()) != null ? containingClass.getFQN() + "." + method.getName() : "";
    }

    @Override
    @Nullable
    protected PhpType getTypeFromLanguageMap() {
        PhpType typeFromLanguageMap = super.getTypeFromLanguageMap();
        if (typeFromLanguageMap == null) {
            return null;
        }
        PhpClass aClass = this.getContainingClass();
        if (aClass == null) {
            return typeFromLanguageMap;
        }
        String fqn = aClass.getFQN();
        return typeFromLanguageMap.map(ts -> PhpLangUtil.isClassNameSpecial(ts) ? PhpTypeSignatureKey.POLYMORPHIC_CLASS.sign((CharSequence)fqn) : ts);
    }

    @Override
    @NotNull
    public PhpType getLocalType(boolean interactive) {
        PhpType type = MethodImpl.getLocalTypeFromGistOrStub(this);
        if (type != null) {
            PhpType phpType = type;
            if (phpType == null) {
                MethodImpl.$$$reportNull$$$0(13);
            }
            return phpType;
        }
        if (this.getMethodType(false) == Method.MethodType.CONSTRUCTOR) {
            PhpType phpType = new PhpType().add((PsiElement)this.getContainingClass());
            if (phpType == null) {
                MethodImpl.$$$reportNull$$$0(14);
            }
            return phpType;
        }
        type = super.getLocalType(interactive);
        PhpDocComment comment = this.getDocComment();
        PhpDocReturnTag returnTag = comment != null ? comment.getReturnTag() : null;
        PhpReturnType returnType = this.getTypeDeclaration();
        boolean docReturnTypeIsAbsent = returnTag == null || returnTag.getType().isEmpty();
        PhpClass aClass = this.getContainingClass();
        assert (aClass != null);
        boolean shouldAddTypeFromSuperMethod = !type.equals((Object)PhpType.VOID) && !type.filterOutIntermediateTypes().isComplete() && docReturnTypeIsAbsent && PhpTypeInfo.getType((PsiElement)returnType).isEmpty() && (aClass.getSuperFQN() != null || aClass.getInterfaceNames().length != 0);
        String methodSignature = MethodImpl.getMethodSignature(aClass.getFQN(), this.getName());
        if (shouldAddTypeFromSuperMethod) {
            type.add(PhpOptionalCompletionTP.TYPE_KEY.sign((CharSequence)PhpTypeSignatureKey.SUPER_MEMBER.sign((CharSequence)methodSignature)));
        }
        if (docReturnTypeIsAbsent) {
            type.add(ParameterImpl.tryGetDocOfSuperMember(methodSignature, comment != null && comment.hasInheritDocTag() && !type.equals((Object)PhpType.VOID), PhpType.intersects((PhpType)type, (PhpType)PhpType.ARRAY)));
        }
        PhpType out = new PhpType();
        for (String name0 : type.getTypesWithParametrisedParts()) {
            PhpClass containingClass;
            int c;
            String name = PhpType.unpluralize((String)name0, (int)(c = PhpType.getPluralDimension((String)name0)));
            if (PhpDocTypeImpl.isPolymorphicClassReference(name, containingClass = this.getContainingClass())) {
                out.add(new PhpType().add(PhpTypeSignatureKey.POLYMORPHIC_CLASS.sign((CharSequence)containingClass.getFQN())).pluralise(c));
                continue;
            }
            out.add(name0);
        }
        PhpType phpType = out;
        if (phpType == null) {
            MethodImpl.$$$reportNull$$$0(15);
        }
        return phpType;
    }

    @Override
    @NotNull
    protected PhpType computeDeclaredType(PhpType typeFromDeclaration) {
        block12: {
            block11: {
                if (this.isAbstract() || this.getModifier().isPrivate() || this.isStatic()) break block11;
                if (!typeFromDeclaration.getTypes().stream().anyMatch(arg_0 -> ((PhpTypeSignatureKey)PhpTypeSignatureKey.POLYMORPHIC_CLASS).isSigned(arg_0))) break block12;
            }
            PhpType phpType = typeFromDeclaration;
            if (phpType == null) {
                MethodImpl.$$$reportNull$$$0(16);
            }
            return phpType;
        }
        PhpClass containingClass = this.getContainingClass();
        if (containingClass == null) {
            PhpType phpType = typeFromDeclaration;
            if (phpType == null) {
                MethodImpl.$$$reportNull$$$0(17);
            }
            return phpType;
        }
        String containingClassFQN = containingClass.getFQN();
        String currentSelf = PhpTypeSignatureKey.SELF_CLASS.sign((CharSequence)containingClassFQN);
        PhpType typeWithoutCurrentClasses = typeFromDeclaration.filterOut(s -> currentSelf.equalsIgnoreCase((String)s) || PhpLangUtil.equalsClassNames(containingClassFQN, s));
        if (typeWithoutCurrentClasses.size() == typeFromDeclaration.size()) {
            PhpType phpType = typeFromDeclaration;
            if (phpType == null) {
                MethodImpl.$$$reportNull$$$0(18);
            }
            return phpType;
        }
        List returnArguments = StreamEx.of((Collection)this.getControlFlow().getExitPoint().getPredecessors()).select(PhpReturnInstruction.class).map(PhpReturnInstruction::getArgument).toList();
        int polymorphicReturnArgumentsCount = ContainerUtil.count((Iterable)returnArguments, MethodImpl::isPolymorphicReturn);
        if (polymorphicReturnArgumentsCount > 0) {
            PhpType typeWithoutCurrentClass = new PhpType().add(polymorphicReturnArgumentsCount == returnArguments.size() ? typeWithoutCurrentClasses : typeFromDeclaration);
            typeWithoutCurrentClass.add(PhpTypeSignatureKey.POLYMORPHIC_CLASS.sign((CharSequence)containingClassFQN));
            PhpType phpType = typeWithoutCurrentClass;
            if (phpType == null) {
                MethodImpl.$$$reportNull$$$0(19);
            }
            return phpType;
        }
        PhpType phpType = typeFromDeclaration;
        if (phpType == null) {
            MethodImpl.$$$reportNull$$$0(20);
        }
        return phpType;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean isPolymorphicReturn(PsiElement element) {
        if (PhpLangUtil.isThisReference(element)) return true;
        if (!new PhpType().add(element).getTypes().stream().anyMatch(arg_0 -> ((PhpTypeSignatureKey)PhpTypeSignatureKey.POLYMORPHIC_CLASS).isSigned(arg_0))) return false;
        return true;
    }

    @NotNull
    private static String getMethodSignature(String classFQN, String methodName) {
        String string = PhpTypeSignatureKey.METHOD.sign((CharSequence)PhpTypeSignatureKey.CLASS.sign((CharSequence)(classFQN + "." + methodName)));
        if (string == null) {
            MethodImpl.$$$reportNull$$$0(21);
        }
        return string;
    }

    @Override
    public boolean isClosure() {
        return false;
    }

    @Override
    @NotNull
    public Set<CharSequence> getPredefinedVariables() {
        if (!this.isStatic()) {
            Set<CharSequence> set = PhpLangUtil.PREDEFINED_DYNAMIC_FIELDS_SET;
            if (set == null) {
                MethodImpl.$$$reportNull$$$0(22);
            }
            return set;
        }
        Set<CharSequence> set = Collections.emptySet();
        if (set == null) {
            MethodImpl.$$$reportNull$$$0(23);
        }
        return set;
    }

    @Override
    public Collection<String> getDocExceptions() {
        PhpNamedStub stub = (PhpNamedStub)this.getGreenStub();
        if (stub instanceof PhpMethodStub) {
            return ((PhpMethodStub)stub).getDocExceptions();
        }
        return MethodImpl.getDocExceptions(this);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 3, 4, 5, 6, 7, 8, 9, 10, 11, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/psi/elements/impl/MethodImpl";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "phpElementVisitor";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/psi/elements/impl/MethodImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getIcon";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getModifier";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getModifierList";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getAccess";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getMethodType";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocalType";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "computeDeclaredType";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getMethodSignature";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getPredefinedVariables";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setName";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getFQN";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 3, 4, 5, 6, 7, 8, 9, 10, 11, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23 -> new IllegalStateException(string);
        };
    }
}

