/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.psi.elements.impl;

import com.google.common.base.Predicates;
import com.intellij.lang.ASTNode;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.LastComputedIconCache;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SyntheticElement;
import com.intellij.psi.impl.RenameableFakePsiElement;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.ui.IconManager;
import com.intellij.ui.PlatformIcons;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.MultiMap;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.PhpClassHierarchyUtils;
import com.jetbrains.php.PhpIcons;
import com.jetbrains.php.PhpIndex;
import com.jetbrains.php.PhpIndexImpl;
import com.jetbrains.php.PhpPresentationUtil;
import com.jetbrains.php.codeInsight.controlFlow.PhpControlFlow;
import com.jetbrains.php.codeInsight.controlFlow.PhpControlFlowUtil;
import com.jetbrains.php.codeInsight.controlFlow.PhpInstructionProcessor;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpAccessFieldByVariableInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpAccessFieldInObjectContextInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpAccessInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpArrayAccessInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpCallInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpClassDeclarationInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpInstruction;
import com.jetbrains.php.codeInsight.dataFlow.reachingDefinition.PhpDFAUtil;
import com.jetbrains.php.config.PhpProjectConfigurationFacade;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.documentation.phpdoc.PhpDocUtil;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocComment;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocMethod;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocProperty;
import com.jetbrains.php.lang.documentation.phpdoc.psi.impl.PhpDocCommentImpl;
import com.jetbrains.php.lang.documentation.phpdoc.psi.tags.PhpDocTag;
import com.jetbrains.php.lang.inspections.PhpElementIsNotAvailableInCurrentPhpVersionInspection;
import com.jetbrains.php.lang.inspections.PhpUndefinedClassInspection;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.parser.PhpStubElementTypes;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ArrayAccessExpression;
import com.jetbrains.php.lang.psi.elements.AssignmentExpression;
import com.jetbrains.php.lang.psi.elements.ClassReference;
import com.jetbrains.php.lang.psi.elements.ConstantReference;
import com.jetbrains.php.lang.psi.elements.ExtendsList;
import com.jetbrains.php.lang.psi.elements.Field;
import com.jetbrains.php.lang.psi.elements.FieldReference;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.ImplementsList;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.MethodReference;
import com.jetbrains.php.lang.psi.elements.NewExpression;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.lang.psi.elements.ParameterList;
import com.jetbrains.php.lang.psi.elements.PhpAttribute;
import com.jetbrains.php.lang.psi.elements.PhpAttributesOwner;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpClassFieldsList;
import com.jetbrains.php.lang.psi.elements.PhpClassMember;
import com.jetbrains.php.lang.psi.elements.PhpDeprecationAttributeOwner;
import com.jetbrains.php.lang.psi.elements.PhpEnumCase;
import com.jetbrains.php.lang.psi.elements.PhpExpression;
import com.jetbrains.php.lang.psi.elements.PhpFieldType;
import com.jetbrains.php.lang.psi.elements.PhpModifier;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.elements.PhpNamespace;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.PhpReference;
import com.jetbrains.php.lang.psi.elements.PhpTraitUseRule;
import com.jetbrains.php.lang.psi.elements.PhpTypeDeclarationOwner;
import com.jetbrains.php.lang.psi.elements.PhpUse;
import com.jetbrains.php.lang.psi.elements.PhpUseList;
import com.jetbrains.php.lang.psi.elements.impl.FieldImpl;
import com.jetbrains.php.lang.psi.elements.impl.FunctionImpl;
import com.jetbrains.php.lang.psi.elements.impl.MethodImpl;
import com.jetbrains.php.lang.psi.elements.impl.PhpBackedEnumTypeImpl;
import com.jetbrains.php.lang.psi.elements.impl.PhpClassFieldsListImpl;
import com.jetbrains.php.lang.psi.elements.impl.PhpEnumCaseImpl;
import com.jetbrains.php.lang.psi.elements.impl.PhpNamedElementImpl;
import com.jetbrains.php.lang.psi.elements.impl.PhpPromotedFieldParameterImpl;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.resolve.types.PhpTypeAnalyserVisitor;
import com.jetbrains.php.lang.psi.resolve.types.generics.PhpGenericsBaseExtendedWithGenericTypeProvider;
import com.jetbrains.php.lang.psi.resolve.types.generics.PhpGenericsExtendedTypeProvider;
import com.jetbrains.php.lang.psi.stubs.PhpClassStub;
import com.jetbrains.php.lang.psi.stubs.PhpClassStubImpl;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import com.jetbrains.php.phpunit.PhpUnitUtil;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.Icon;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;
import org.jetbrains.annotations.VisibleForTesting;

public final class PhpClassImpl
extends PhpNamedElementImpl<PhpClassStub>
implements PhpClass,
PhpDeprecationAttributeOwner,
PhpTypeDeclarationOwner<PhpBackedEnumTypeImpl> {
    private static final boolean FIELDS_FROM_CONSTRUCTORS = true;
    private static final TokenSet FIELDS_TS = TokenSet.create((IElementType[])new IElementType[]{PhpElementTypes.CLASS_FIELDS, PhpElementTypes.CLASS_CONSTANTS});
    public static final String BACKED_ENUM_FQN = "\\BackedEnum";
    public static final String INT_BACKED_ENUM_FQN = "\\IntBackedEnum";
    public static final String STRING_BACKED_ENUM_FQN = "\\StringBackedEnum";
    public static final String UNIT_ENUM_FQN = "\\UnitEnum";
    private static final TokenSet tsDECLARATION_KEYWORDS = TokenSet.create((IElementType[])new IElementType[]{PhpTokenTypes.kwCLASS, PhpTokenTypes.kwINTERFACE, PhpTokenTypes.kwTRAIT, PhpTokenTypes.kwENUM});
    private static final Function<PhpClass, Icon> CLASS_ICON_EVALUATOR = clazz -> {
        if (clazz.isTrait()) {
            return PhpIcons.TRAIT;
        }
        if (clazz.isInterface()) {
            return PhpIcons.INTERFACE;
        }
        if (clazz.isEnum()) {
            return com.intellij.util.PlatformIcons.ENUM_ICON;
        }
        Ref isTestClassRef = new Ref((Object)false);
        Ref isExceptionClassRef = new Ref((Object)false);
        boolean isDumb = DumbService.getInstance((Project)clazz.getProject()).isDumb();
        if (clazz.isValid() && !isDumb) {
            PhpClassHierarchyUtils.processSuperClasses((PhpClass)clazz, (boolean)true, (boolean)true, aClass -> {
                if (PhpUnitUtil.isRootTestClass(aClass)) {
                    isTestClassRef.set((Object)true);
                } else if (PhpLangUtil.equalsClassNames("Exception", aClass.getNameCS())) {
                    isExceptionClassRef.set((Object)true);
                }
                return (Boolean)isTestClassRef.get() == false && (Boolean)isExceptionClassRef.get() == false;
            });
        }
        if (((Boolean)isTestClassRef.get()).booleanValue()) {
            if (clazz.isFinal()) {
                return PhpIcons.FINAL_TEST_CLASS;
            }
            if (clazz.isAbstract()) {
                return PhpIcons.ABSTRACT_TEST_CLASS;
            }
            return PhpIcons.PHP_TEST_CLASS;
        }
        if (((Boolean)isExceptionClassRef.get()).booleanValue()) {
            if (clazz.isFinal()) {
                return PhpIcons.FINAL_EXCEPTION;
            }
            if (clazz.isAbstract()) {
                return PhpIcons.ABSTRACT_EXCEPTION;
            }
            return PhpIcons.EXCEPTION;
        }
        if (clazz.isAbstract()) {
            return IconManager.getInstance().getPlatformIcon(PlatformIcons.AbstractClass);
        }
        if (clazz.isFinal() || !isDumb && PhpDocUtil.getFinalDocTag((PhpNamedElement)clazz) != null) {
            return PhpIcons.FINAL_CLASS;
        }
        if (clazz.isReadonly()) {
            return PhpIcons.READONLY_CLASS;
        }
        if (clazz.isAnonymous()) {
            return com.intellij.util.PlatformIcons.ANONYMOUS_CLASS_ICON;
        }
        return PhpIcons.CLASS;
    };
    @VisibleForTesting
    public static final Function<PhpClass, Icon> CLASS_ATTRIBUTE_ICON_EVALUATOR = phpClass -> PhpIcons.withAttribute(phpClass, CLASS_ICON_EVALUATOR.apply((PhpClass)phpClass));
    public static final TokenSet FIELDS = TokenSet.create((IElementType[])new IElementType[]{PhpStubElementTypes.CLASS_FIELD, PhpStubElementTypes.CLASS_CONST});
    private static final Predicate<Method> NOT_DOC_METHOD = t -> !(t instanceof PhpDocMethod);
    private static final Comparator<PhpClass> COMPARATOR = (o1, o2) -> {
        if (o1 == o2 || PhpLangUtil.equalsClassNames(o1.getFQN(), o2.getFQN())) {
            return 0;
        }
        PhpIndex index = PhpIndex.getInstance((Project)o1.getProject());
        if (PhpType.findSuper((String)o2.getFQN(), (String)o1.getFQN(), (PhpIndex)index)) {
            return -1;
        }
        if (PhpType.findSuper((String)o1.getFQN(), (String)o2.getFQN(), (PhpIndex)index)) {
            return 1;
        }
        return 0;
    };
    @NotNull
    public static final Condition<PhpNamedElement> NOT_AVAILABLE_BY_LANGUAGE_LEVEL = Conditions.or(PhpElementIsNotAvailableInCurrentPhpVersionInspection::notAvailableBySinceTag, PhpElementIsNotAvailableInCurrentPhpVersionInspection::notAvailableByRemovedTag);
    public static final String PHPUNIT_SETUP_METHOD = "setUp";
    public static final String PHPUNIT_SETUP_BEFORE_CLASS_METHOD = "setUpBeforeClass";

    public PhpClassImpl(ASTNode node) {
        super(node);
    }

    public PhpClassImpl(PhpClassStub stub) {
        super(stub, (IElementType)PhpStubElementTypes.CLASS);
    }

    public Collection<Field> getFields() {
        HashMap<PhpFieldDescriptor, Field> allFields = new HashMap<PhpFieldDescriptor, Field>();
        PhpClassImpl.getFieldsInternal(this, allFields);
        return allFields.values();
    }

    @NotNull
    public @NotNull Collection<@NotNull PhpAttribute> getAttributes() {
        Collection<PhpAttribute> collection = PhpClassImpl.getAttributesStubAware(this);
        if (collection == null) {
            PhpClassImpl.$$$reportNull$$$0(0);
        }
        return collection;
    }

    @Nullable
    public PhpDeprecationAttributeOwner.PhpDeprecationInfo getDeprecationInfo() {
        return FunctionImpl.getDeprecationInfoFromAttribute((PhpAttributesOwner)this);
    }

    private static void getFieldsInternal(PhpClass phpClass, Map<PhpFieldDescriptor, Field> allFields) {
        PhpClassHierarchyUtils.processFields((PhpClass)phpClass, (PhpClass)phpClass, (field, subClass, baseClass) -> {
            @NonNls String name = field.getName();
            if (!StringUtil.isEmpty((String)name)) {
                PhpClass currentContainingClass;
                PhpFieldDescriptor key = new PhpFieldDescriptor(name = StringUtil.toLowerCase((String)name), field.isConstant(), field instanceof PhpDocProperty);
                Field current = (Field)allFields.get(key);
                PhpClass phpClass = currentContainingClass = current == null ? null : current.getContainingClass();
                if (!(current != null && field instanceof MyRenamableFakePsiElement || currentContainingClass != null && !PhpLangUtil.isObject(currentContainingClass) && !currentContainingClass.isTrait())) {
                    allFields.put(key, (Field)field);
                }
            }
            return true;
        }, (boolean)false, (boolean)true);
    }

    public static boolean isDeclaredIfNotExists(PhpClass c) {
        if (c instanceof PhpClassImpl) {
            PhpClassStub stub = (PhpClassStub)((PhpClassImpl)c).getGreenStub();
            if (stub instanceof PhpClassStubImpl) {
                return ((PhpClassStubImpl)stub).isDeclaredIfNotExists();
            }
            PhpClassDeclarationInstruction instruction = PhpControlFlowUtil.getInstruction((PsiElement)c, PhpClassDeclarationInstruction.class);
            if (instruction != null) {
                Ref canBeDefined = Ref.create((Object)false);
                Ref canBeUndefined = Ref.create((Object)false);
                PhpDFAUtil.performReachingDefinitions((PhpInstruction)instruction, (Ref<Boolean>)canBeDefined, (Ref<Boolean>)canBeUndefined, c.getFQN(), PhpUndefinedClassInspection.DF_ANALYZER);
                return (Boolean)canBeDefined.get() == false && (Boolean)canBeUndefined.get() != false;
            }
        }
        return false;
    }

    public Field[] getOwnFields() {
        return this.getOwnFields(true);
    }

    public Field[] getOwnFields(boolean dynamicFieldsOnlyFromConstructor) {
        Collection values = this.getOwnFieldMap().values();
        if (dynamicFieldsOnlyFromConstructor) {
            values = ContainerUtil.filter((Collection)values, f -> !PhpClassImpl.isDynamicFieldNotFromConstructor(f));
        }
        return values.toArray((Field[])Field.ARRAY_FACTORY.create(values.size()));
    }

    private MultiMap<CharSequence, Field> getOwnFieldMap() {
        return (MultiMap)CachedValuesManager.getCachedValue((PsiElement)this, () -> {
            MultiMap res = MultiMap.create();
            res.putAllValues(this.getOwnDeclaredFieldMap());
            HashSet declaredFields = new HashSet(res.keySet());
            for (Map.Entry entry : this.getOwnDynamicFieldMap().entrySet()) {
                for (Field field : (Collection)entry.getValue()) {
                    if (declaredFields.contains(field.getName())) continue;
                    res.putValue((Object)field.getName(), (Object)field);
                }
            }
            return CachedValueProvider.Result.create((Object)res, (Object[])new Object[]{this});
        });
    }

    public MultiMap<CharSequence, Field> getOwnDeclaredFieldMap() {
        return (MultiMap)CachedValuesManager.getCachedValue((PsiElement)this, () -> CachedValueProvider.Result.create(this.getOwnFieldsInternal(), (Object[])new Object[]{this}));
    }

    MultiMap<CharSequence, Field> getOwnDynamicFieldMap() {
        return (MultiMap)CachedValuesManager.getCachedValue((PsiElement)this, () -> CachedValueProvider.Result.create(this.collectDynamicFields(), (Object[])new Object[]{this}));
    }

    @NotNull
    private Stream<PhpDocProperty> docProperties() {
        PhpDocComment docComment = this.getDocComment();
        if (docComment == null) {
            Stream<PhpDocProperty> stream = Stream.empty();
            if (stream == null) {
                PhpClassImpl.$$$reportNull$$$0(1);
            }
            return stream;
        }
        StreamEx streamEx = StreamEx.of(((PhpDocCommentImpl)docComment).getDocTagByClass(PhpDocTag.class)).map(tag -> (PhpDocProperty)PsiTreeUtil.getStubChildOfType((PsiElement)tag, PhpDocProperty.class)).nonNull();
        if (streamEx == null) {
            PhpClassImpl.$$$reportNull$$$0(2);
        }
        return streamEx;
    }

    private MultiMap<CharSequence, Field> getOwnFieldsInternal() {
        Method constructor;
        MultiMap fields = MultiMap.create();
        PhpClassStub stub = (PhpClassStub)this.getGreenStub();
        if (stub == null || stub.hasPropertyTags()) {
            this.docProperties().forEach(phpDocProperty -> {
                String phpDocPropertyName = phpDocProperty.getName();
                if (!phpDocPropertyName.isEmpty()) {
                    fields.putValue((Object)phpDocPropertyName, phpDocProperty);
                }
            });
        }
        if (stub != null) {
            for (PhpClassFieldsList list : (PhpClassFieldsList[])stub.getChildrenByType(FIELDS_TS, PhpClassFieldsList.ARRAY_FACTORY)) {
                for (Field field : list.getFields()) {
                    fields.putValue((Object)field.getName(), (Object)field);
                }
            }
        } else {
            for (PsiElement element : this.findChildrenByType(FIELDS_TS)) {
                for (PsiElement child = element.getFirstChild(); child != null; child = child.getNextSibling()) {
                    if (!(child instanceof Field)) continue;
                    fields.putValue((Object)((Field)child).getName(), (Object)((Field)child));
                }
            }
        }
        if ((constructor = this.getOwnConstructor()) != null) {
            for (Parameter parameter : constructor.getParameters()) {
                if (!(parameter instanceof PhpPromotedFieldParameterImpl)) continue;
                fields.putValue((Object)parameter.getName(), (Object)((PhpPromotedFieldParameterImpl)parameter));
            }
        }
        return fields;
    }

    private MultiMap<CharSequence, Field> collectDynamicFields() {
        MultiMap fields;
        block4: {
            fields = MultiMap.create();
            PhpClassStub stub = (PhpClassStub)this.getGreenStub();
            if (stub != null && !stub.hasConstructorFields()) break block4;
            if (stub != null) {
                for (PhpClassStub.PhpConstructorFieldStubData data : stub.getConstructionFieldsStubData()) {
                    String name = data.getName();
                    fields.putValue((Object)name, (Object)new MyRenamableFakePsiElement(data.getRange(), this, data.isDynamic(), data.getType(), data.getInitPlace(), name));
                }
            } else {
                for (MyRenamableFakePsiElement field : this.getDynamicFields((MultiMap<CharSequence, Field>)fields)) {
                    fields.putValue((Object)field.getName(), (Object)field);
                }
            }
        }
        return fields;
    }

    @NotNull
    public Collection<MyRenamableFakePsiElement> getDynamicFields(MultiMap<CharSequence, Field> fields) {
        ArrayList<MyRenamableFakePsiElement> fakeFields = new ArrayList<MyRenamableFakePsiElement>();
        MultiMap map = (MultiMap)new DynamicFieldsAssignmentsInMethodsProvider(this, fields.keySet()).compute().getValue();
        for (String name : map.keySet()) {
            for (FieldReference expression : map.get((Object)name)) {
                fakeFields.add(new MyASTRenamableFakePsiElement(this, expression));
            }
        }
        ArrayList<MyRenamableFakePsiElement> arrayList = fakeFields;
        if (arrayList == null) {
            PhpClassImpl.$$$reportNull$$$0(3);
        }
        return arrayList;
    }

    public static PhpClassHierarchyUtils.HierarchyMethodProcessor getCollectingMethodProcessor(Map<String, Method> allMethods) {
        return (method, subClass, baseClass) -> {
            @NonNls String methodName = method.getName();
            if (!StringUtil.isEmpty((String)methodName)) {
                PhpClass currentContainingClass;
                Method current = (Method)allMethods.get(methodName = StringUtil.toLowerCase((String)methodName));
                PhpClass phpClass = currentContainingClass = current == null ? null : current.getContainingClass();
                if (currentContainingClass == null || PhpLangUtil.isObject(currentContainingClass) || current.isAbstract() && currentContainingClass.isTrait() && !method.isAbstract()) {
                    allMethods.put(methodName, (Method)method);
                }
            }
            return true;
        };
    }

    public Collection<Method> getMethods() {
        HashMap<String, Method> allMethods = new HashMap<String, Method>();
        PhpClassHierarchyUtils.processMethods((PhpClass)this, (PhpClass)this, (PhpClassHierarchyUtils.HierarchyMethodProcessor)PhpClassImpl.getCollectingMethodProcessor(allMethods), (boolean)false, (boolean)true);
        return allMethods.values();
    }

    public Method[] getOwnMethods() {
        return this.getOwnMethodsMap().values().toArray(Method.EMPTY);
    }

    @NotNull
    private MultiMap<CharSequence, Method> getOwnMethodsMap() {
        MultiMap multiMap = (MultiMap)CachedValuesManager.getCachedValue((PsiElement)this, () -> new CachedValueProvider.Result(this.getOwnMethodsInternal(true), new Object[]{this, PhpProjectConfigurationFacade.LANGUAGE_LEVEL_CHANGED_MODIFICATION_TRACKER}));
        if (multiMap == null) {
            PhpClassImpl.$$$reportNull$$$0(4);
        }
        return multiMap;
    }

    @NotNull
    public MultiMap<CharSequence, Method> getOwnMethodsInternal(boolean filterByLanguageLevelAvailability) {
        PhpDocComment comment;
        MultiMap result = new MultiMap(CollectionFactory.createCharSequenceMap((boolean)false));
        Method[] normalMethods = (Method[])this.getStubOrPsiChildren(TokenSet.create((IElementType[])new IElementType[]{PhpStubElementTypes.CLASS_METHOD}), Method.ARRAY_FACTORY);
        PhpClassStub stub = (PhpClassStub)this.getGreenStub();
        for (Method method : normalMethods) {
            if (method instanceof MethodImpl && filterByLanguageLevelAvailability && !PhpIndexImpl.suitsPhpStormStubsLanguageLevel(this.getProject(), (MethodImpl)method)) continue;
            result.putValue((Object)method.getName(), (Object)method);
        }
        if ((stub == null || stub.hasMethodTags()) && (comment = this.getDocComment()) != null) {
            PhpDocMethod[] tags;
            for (PhpDocMethod method : tags = comment.getMethods()) {
                result.putValue((Object)method.getName(), (Object)method);
            }
        }
        MultiMap multiMap = result;
        if (multiMap == null) {
            PhpClassImpl.$$$reportNull$$$0(5);
        }
        return multiMap;
    }

    public boolean hasMethodTags() {
        PhpDocComment comment = this.getDocComment();
        if (comment == null) {
            return false;
        }
        return comment.getMethods().length > 0;
    }

    public boolean hasPropertyTags() {
        return this.docProperties().findAny().isPresent();
    }

    public boolean hasConstructorFields() {
        for (Field ownField : this.getOwnFieldMap().values()) {
            if (!(ownField instanceof MyRenamableFakePsiElement)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public String getSuperName() {
        String superFQN = this.getSuperFQN();
        if (superFQN != null) {
            int i = superFQN.lastIndexOf(92);
            return i >= 0 ? superFQN.substring(i + 1) : superFQN;
        }
        return null;
    }

    public String getSuperFQN() {
        if (this.isInterface()) {
            return null;
        }
        PhpClassStub stub = (PhpClassStub)this.getGreenStub();
        if (stub != null) {
            return stub.getSuperclass();
        }
        ClassReference superRef = this.getSuperRef();
        return superRef != null ? superRef.getFQN() : null;
    }

    @Nullable
    public ClassReference getSuperRef() {
        ExtendsList list = this.getExtendsList();
        return (ClassReference)ContainerUtil.getFirstItem((List)list.getReferenceElements());
    }

    @Nullable
    public PhpClass getSuperClass() {
        Collection<PhpClass> classes = this.getSuperClasses();
        return classes.size() == 1 ? classes.iterator().next() : (PhpClass)ContainerUtil.getFirstItem(PhpClassImpl.selectBestClasses(classes, this));
    }

    public Collection<PhpClass> getSuperClasses() {
        return PhpClassHierarchyUtils.getSuperClasses((PhpClass)this);
    }

    public boolean hasStaticMembers() {
        HashSet<PhpClassImpl> visited = new HashSet<PhpClassImpl>();
        Collection<PhpClassImpl> phpClass = Collections.singleton(this);
        do {
            if (ContainerUtil.exists(phpClass, PhpClass::hasOwnStaticMembers)) {
                return true;
            }
            visited.addAll(phpClass);
        } while (!(phpClass = (Collection)phpClass.stream().flatMap(c -> c.getSuperClasses().stream()).filter(c -> !PhpLangUtil.isObject(c) && !visited.contains(c)).collect(Collectors.toSet())).isEmpty());
        return false;
    }

    @NotNull
    public static Collection<PhpClass> selectBestClasses(Collection<? extends PhpClass> classes, PhpPsiElement origin) {
        String my = PhpClassImpl.getPath((PsiElement)origin);
        if (my == null) {
            List<PhpClass> list = Collections.emptyList();
            if (list == null) {
                PhpClassImpl.$$$reportNull$$$0(6);
            }
            return list;
        }
        Map map = StreamEx.of(classes).toMap(aClass -> PhpClassImpl.getProximity(aClass, origin, my), aClass -> Collections.singleton(aClass), ContainerUtil::union);
        Optional<Integer> max = map.keySet().stream().max(Comparator.comparingInt(Integer::intValue));
        Collection<Object> collection = max.isPresent() ? (Collection)map.get(max.get()) : Collections.emptyList();
        if (collection == null) {
            PhpClassImpl.$$$reportNull$$$0(7);
        }
        return collection;
    }

    private static int getProximity(PhpClass aClass, PhpPsiElement origin, @NotNull String my) {
        if (my == null) {
            PhpClassImpl.$$$reportNull$$$0(8);
        }
        if (aClass.getContainingFile() == origin.getContainingFile()) {
            return Integer.MAX_VALUE;
        }
        String path = PhpClassImpl.getPath((PsiElement)aClass);
        assert (path != null);
        return StringUtil.commonPrefixLength((CharSequence)my, (CharSequence)path);
    }

    @Nullable
    static String getPath(PsiElement e) {
        PsiFile file = e.getContainingFile();
        if (file == null) {
            return null;
        }
        VirtualFile virtualFile = file.getVirtualFile();
        if (virtualFile == null) {
            return null;
        }
        return virtualFile.getPath();
    }

    @Override
    @NotNull
    @NlsSafe
    public String getNamespaceName() {
        PhpClassStub stub = (PhpClassStub)this.getGreenStub();
        if (stub != null) {
            String string = stub.getNamespaceName();
            if (string == null) {
                PhpClassImpl.$$$reportNull$$$0(9);
            }
            return string;
        }
        String string = super.getNamespaceName();
        if (string == null) {
            PhpClassImpl.$$$reportNull$$$0(10);
        }
        return string;
    }

    public String @NotNull [] getInterfaceNames() {
        List referenceElements;
        PhpClassStub stub = (PhpClassStub)this.getGreenStub();
        if (stub != null) {
            String[] stringArray = stub.getInterfaces();
            if (stringArray == null) {
                PhpClassImpl.$$$reportNull$$$0(11);
            }
            return stringArray;
        }
        List list = referenceElements = !this.isInterface() ? this.getImplementsList().getReferenceElements() : this.getExtendsList().getReferenceElements();
        if (referenceElements.isEmpty()) {
            if (ArrayUtilRt.EMPTY_STRING_ARRAY == null) {
                PhpClassImpl.$$$reportNull$$$0(12);
            }
            return ArrayUtilRt.EMPTY_STRING_ARRAY;
        }
        String[] stringArray = (String[])StreamEx.of((Collection)referenceElements).map(PhpReference::getFQN).nonNull().toArray(String.class);
        if (stringArray == null) {
            PhpClassImpl.$$$reportNull$$$0(13);
        }
        return stringArray;
    }

    public PhpClass[] getImplementedInterfaces() {
        List interfaceList = this.getDirectImplementedInterfaces();
        interfaceList.addAll(this.getImplicitEnumInterfaces());
        return interfaceList.toArray(PhpClass.EMPTY_ARRAY);
    }

    @NotNull
    public Collection<PhpClass> getImplicitEnumInterfaces() {
        if (!this.isEnum()) {
            List<PhpClass> list = Collections.emptyList();
            if (list == null) {
                PhpClassImpl.$$$reportNull$$$0(14);
            }
            return list;
        }
        PhpType backedEnumType = this.getBackedEnumType();
        Collection collection = PhpIndex.getInstance((Project)this.getProject()).getInterfacesByFQN(!backedEnumType.isEmpty() ? BACKED_ENUM_FQN : UNIT_ENUM_FQN);
        if (collection == null) {
            PhpClassImpl.$$$reportNull$$$0(15);
        }
        return collection;
    }

    public boolean hasTraitUses() {
        PhpClassStub stub = (PhpClassStub)this.getGreenStub();
        if (stub != null) {
            return stub.hasTraitUses();
        }
        return (Boolean)CachedValuesManager.getCachedValue((PsiElement)this, () -> new CachedValueProvider.Result((Object)this.useListTargetReferencesFQNs().isNotEmpty(), new Object[]{this}));
    }

    @NotNull
    private JBIterable<String> useListTargetReferencesFQNs() {
        JBIterable jBIterable = this.useListTargetReferences().map(PhpReference::getFQN).filter(Objects::nonNull);
        if (jBIterable == null) {
            PhpClassImpl.$$$reportNull$$$0(16);
        }
        return jBIterable;
    }

    public String @NotNull [] getTraitNames() {
        PhpClassStub stub = (PhpClassStub)this.getGreenStub();
        if (stub != null) {
            String[] stringArray = stub.getTraits();
            if (stringArray == null) {
                PhpClassImpl.$$$reportNull$$$0(17);
            }
            return stringArray;
        }
        Set names = (Set)CachedValuesManager.getCachedValue((PsiElement)this, () -> {
            HashSet res = new HashSet();
            this.useListTargetReferencesFQNs().forEach(res::add);
            return new CachedValueProvider.Result(res, new Object[]{this});
        });
        String[] stringArray = ArrayUtilRt.toStringArray((Collection)names);
        if (stringArray == null) {
            PhpClassImpl.$$$reportNull$$$0(18);
        }
        return stringArray;
    }

    public JBIterable<PhpReference> useListTargetReferences() {
        return this.traitUseLists().flatMap(child -> JBIterable.of((Object[])child.getDeclarations())).map(PhpUse::getTargetReference).filter(Objects::nonNull);
    }

    public PhpClass[] getTraits() {
        ArrayList traits = new ArrayList();
        PhpIndex phpIndex = PhpIndex.getInstance((Project)this.getProject());
        for (String fqn : this.getTraitNames()) {
            traits.addAll(phpIndex.getTraitsByFQN(fqn));
        }
        return traits.toArray(PhpClass.EMPTY_ARRAY);
    }

    public String @NotNull [] getMixinNames() {
        PhpClassStub stub = (PhpClassStub)this.getGreenStub();
        if (stub != null) {
            String[] stringArray = stub.getMixins();
            if (stringArray == null) {
                PhpClassImpl.$$$reportNull$$$0(19);
            }
            return stringArray;
        }
        String[] stringArray = (String[])CachedValuesManager.getCachedValue((PsiElement)this, () -> {
            HashSet names = new HashSet();
            PhpDocComment comment = this.getDocComment();
            if (comment != null) {
                PhpDocTag[] mixinTags;
                for (PhpDocTag tag : mixinTags = comment.getTagElementsByName("@mixin")) {
                    PhpType type = tag.getType();
                    names.addAll(type.getTypes());
                }
            }
            return new CachedValueProvider.Result((Object)ArrayUtilRt.toStringArray(names), new Object[]{this});
        });
        if (stringArray == null) {
            PhpClassImpl.$$$reportNull$$$0(20);
        }
        return stringArray;
    }

    public PhpClass[] getMixins() {
        ArrayList mixins = new ArrayList();
        PhpIndex phpIndex = PhpIndex.getInstance((Project)this.getProject());
        for (String fqn : this.getMixinNames()) {
            mixins.addAll(phpIndex.getAnyByFQN(fqn));
        }
        return mixins.toArray(PhpClass.EMPTY_ARRAY);
    }

    public boolean hasGenericMixins() {
        return ContainerUtil.or((Object[])this.getMixinNames(), PhpGenericsExtendedTypeProvider.KEY::signed);
    }

    public PhpClass[] getMixinsIncludingGeneric(String genericInstantiationType) {
        Map<String, String> genericParameterToRealTypeMapping = PhpClassImpl.createGenericMappingFromInstantiation(this, genericInstantiationType);
        return this.getMixinsIncludingGeneric(genericParameterToRealTypeMapping);
    }

    @Nullable
    public Method getConstructor() {
        return PhpClassImpl.getConstructors(this, new HashSet<PhpClass>()).getAny();
    }

    @Nullable
    public Method getOwnConstructor() {
        return PhpClassImpl.getOwnConstructors(this).getAny();
    }

    @Nullable
    private Method findOwnMethodByName(@Nullable CharSequence name, @NotNull Predicate<? super Method> predicate) {
        if (predicate == null) {
            PhpClassImpl.$$$reportNull$$$0(21);
        }
        return (Method)ContainerUtil.find((Iterable)this.findOwnMethodsByName(name).getMethods(), predicate::test);
    }

    public PhpClass.PhpOverloadedMethods findOwnMethodsByName(@Nullable CharSequence name) {
        return name != null ? PhpClass.PhpOverloadedMethods.from((Collection)this.getOwnMethodsMap().get((Object)name)) : PhpClass.PhpOverloadedMethods.EMPTY;
    }

    @Override
    @Nullable
    public ASTNode getNameNode() {
        return TreeUtil.findSibling((ASTNode)this.getNode().findChildByType(tsDECLARATION_KEYWORDS), (IElementType)PhpTokenTypes.IDENTIFIER);
    }

    public PsiElement setName(@NonNls @NotNull String name) throws IncorrectOperationException {
        ASTNode nameNode;
        if (name == null) {
            PhpClassImpl.$$$reportNull$$$0(22);
        }
        if ((nameNode = this.getNameNode()) != null && !name.equals(this.getName())) {
            ConstantReference constantReference = PhpPsiElementFactory.createConstantReference(this.getProject(), name);
            ASTNode newNameNode = constantReference.getNameNode();
            assert (newNameNode != null);
            nameNode.getTreeParent().replaceChild(nameNode, newNameNode);
        }
        return this;
    }

    @Override
    protected void accept(@NotNull PhpElementVisitor phpElementVisitor) {
        if (phpElementVisitor == null) {
            PhpClassImpl.$$$reportNull$$$0(23);
        }
        phpElementVisitor.visitPhpClass((PhpClass)this);
    }

    @Override
    @NotNull
    public Icon getIcon() {
        Icon prevIcon = LastComputedIconCache.get((UserDataHolder)this, (int)0);
        Icon base = prevIcon != null ? prevIcon : PhpIcons.CLASS;
        Icon icon = IconManager.getInstance().createDeferredIcon(base, (Object)this, clazz -> {
            Icon icon = CLASS_ATTRIBUTE_ICON_EVALUATOR.apply((PhpClass)clazz);
            LastComputedIconCache.put((UserDataHolder)clazz, (Icon)icon, (int)0);
            return icon;
        });
        if (icon == null) {
            PhpClassImpl.$$$reportNull$$$0(24);
        }
        return icon;
    }

    public boolean isAbstract() {
        PhpClassStub stub = (PhpClassStub)this.getGreenStub();
        if (stub != null) {
            return stub.isAbstract();
        }
        return this.isInterface() || PhpClassImpl.getFirstChildSkippingAttributesAndReadonlyKw((PsiElement)this) == PhpTokenTypes.kwABSTRACT;
    }

    public boolean isFinal() {
        PhpClassStub stub = (PhpClassStub)this.getGreenStub();
        if (stub != null) {
            return stub.isFinal();
        }
        IElementType firstChildType = PhpClassImpl.getFirstChildSkippingAttributesAndReadonlyKw((PsiElement)this);
        return firstChildType == PhpTokenTypes.kwFINAL || firstChildType == PhpTokenTypes.kwENUM;
    }

    public boolean isAnonymous() {
        return this.getStub() == null && this.getParent() instanceof NewExpression && this.getNameNode() == null && this.findChildByClass(PsiErrorElement.class) == null;
    }

    public boolean isReadonly() {
        PhpClassStub stub = (PhpClassStub)this.getGreenStub();
        if (stub != null) {
            return stub.isReadonly();
        }
        PsiElement readonlyKeyword = FieldImpl.getReadonlyKeyword((PsiElement)this);
        return readonlyKeyword != null && readonlyKeyword != this.getNameIdentifier();
    }

    public boolean isInterface() {
        PhpClassStub stub = (PhpClassStub)this.getGreenStub();
        if (stub != null) {
            return stub.isInterface();
        }
        return PhpClassFieldsListImpl.getFirstChildNodeSkippingAttributes((PsiElement)this).getElementType() == PhpTokenTypes.kwINTERFACE;
    }

    public boolean isTrait() {
        PhpClassStub stub = (PhpClassStub)this.getGreenStub();
        if (stub != null) {
            return stub.isTrait();
        }
        return PhpClassFieldsListImpl.getFirstChildNodeSkippingAttributes((PsiElement)this).getElementType() == PhpTokenTypes.kwTRAIT;
    }

    public boolean isEnum() {
        PhpClassStub stub = (PhpClassStub)this.getGreenStub();
        if (stub != null) {
            return stub.isEnum();
        }
        return PhpClassFieldsListImpl.getFirstChildNodeSkippingAttributes((PsiElement)this).getElementType() == PhpTokenTypes.kwENUM;
    }

    @NotNull
    public PhpType getBackedEnumType() {
        PhpClassStub stub = (PhpClassStub)this.getGreenStub();
        if (stub != null) {
            PhpType phpType = stub.getBackedEnumType();
            if (phpType == null) {
                PhpClassImpl.$$$reportNull$$$0(25);
            }
            return phpType;
        }
        PhpBackedEnumTypeImpl typeDeclaration = this.getTypeDeclaration();
        PhpType phpType = typeDeclaration != null ? typeDeclaration.getType() : PhpType.EMPTY;
        if (phpType == null) {
            PhpClassImpl.$$$reportNull$$$0(26);
        }
        return phpType;
    }

    @Nullable
    public PhpBackedEnumTypeImpl getTypeDeclaration() {
        return (PhpBackedEnumTypeImpl)PsiTreeUtil.getChildOfType((PsiElement)this, PhpBackedEnumTypeImpl.class);
    }

    public JBIterable<PhpTraitUseRule> traitUseRules() {
        PhpClassStub stub = (PhpClassStub)this.getGreenStub();
        if (stub != null && !stub.hasTraitUses()) {
            return JBIterable.empty();
        }
        return this.traitUseLists().flatMap(useList -> PsiTreeUtil.getStubChildrenOfTypeAsList((PsiElement)useList, PhpTraitUseRule.class));
    }

    @NotNull
    private JBIterable<PhpUseList> traitUseLists() {
        JBIterable jBIterable = JBIterable.from((Iterable)PsiTreeUtil.getStubChildrenOfTypeAsList((PsiElement)this, PhpUseList.class));
        if (jBIterable == null) {
            PhpClassImpl.$$$reportNull$$$0(27);
        }
        return jBIterable;
    }

    public PhpClass[] getSupers() {
        ArrayList<PhpClass> superClasses = new ArrayList<PhpClass>(this.getSuperClasses());
        Collections.addAll(superClasses, this.getImplementedInterfaces());
        Collections.addAll(superClasses, this.getTraits());
        return superClasses.toArray(PhpClass.EMPTY_ARRAY);
    }

    public boolean hasOwnStaticMembers() {
        PhpClassStub stub = (PhpClassStub)this.getGreenStub();
        if (stub != null) {
            return stub.hasOwnStaticMembers();
        }
        for (Method method : this.getOwnMethods()) {
            if (!method.isStatic()) continue;
            return true;
        }
        for (Field field : this.getOwnFieldMap().values()) {
            if (!field.getModifier().isStatic()) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public PhpModifier getModifier() {
        if (this.isAbstract()) {
            PhpModifier phpModifier = PhpModifier.PUBLIC_ABSTRACT_DYNAMIC;
            if (phpModifier == null) {
                PhpClassImpl.$$$reportNull$$$0(28);
            }
            return phpModifier;
        }
        if (this.isFinal()) {
            PhpModifier phpModifier = PhpModifier.PUBLIC_FINAL_DYNAMIC;
            if (phpModifier == null) {
                PhpClassImpl.$$$reportNull$$$0(29);
            }
            return phpModifier;
        }
        PhpModifier phpModifier = PhpModifier.PUBLIC_IMPLEMENTED_DYNAMIC;
        if (phpModifier == null) {
            PhpClassImpl.$$$reportNull$$$0(30);
        }
        return phpModifier;
    }

    @Override
    public ItemPresentation getPresentation() {
        return PhpPresentationUtil.getClassPresentation(this);
    }

    @Override
    public void processDocs(Processor<PhpDocComment> processor2) {
        PhpClassHierarchyUtils.processSuperClasses((PhpClass)this, (boolean)true, (boolean)false, aClass -> processor2.process((Object)aClass.getDocComment()));
    }

    @NotNull
    public ExtendsList getExtendsList() {
        ExtendsList extendsList = (ExtendsList)this.findChildByClass(ExtendsList.class);
        if (extendsList == null) {
            PhpClassImpl.$$$reportNull$$$0(31);
        }
        return extendsList;
    }

    @NotNull
    public ImplementsList getImplementsList() {
        ImplementsList implementsList = (ImplementsList)this.findChildByClass(ImplementsList.class);
        if (implementsList == null) {
            PhpClassImpl.$$$reportNull$$$0(32);
        }
        return implementsList;
    }

    @Override
    @NotNull
    public PhpType getType() {
        if (this.isAnonymous()) {
            PhpType type = new PhpType().add("__anonymous@" + this.getTextOffset());
            type.add(this.getSuperFQN());
            for (String s : this.getInterfaceNames()) {
                type.add(s);
            }
            if (this.findOwnMethodByName("__invoke") != null) {
                type.add(PhpType.CALLABLE);
            }
            PhpType phpType = type.createImmutableType();
            if (phpType == null) {
                PhpClassImpl.$$$reportNull$$$0(33);
            }
            return phpType;
        }
        String fqn = this.getFQN();
        PhpType phpType = new PhpType().add(fqn).createImmutableType();
        if (phpType == null) {
            PhpClassImpl.$$$reportNull$$$0(34);
        }
        return phpType;
    }

    @Override
    public String toString() {
        return "PhpClass: " + this.getName();
    }

    private static boolean isDynamicReference(@NotNull FieldReference ref) {
        PhpExpression classReference;
        if (ref == null) {
            PhpClassImpl.$$$reportNull$$$0(35);
        }
        return (classReference = ref.getClassReference()) != null && ("$this".equals(classReference.getText()) || "parent".equals(classReference.getText()));
    }

    private static PhpClass.PhpDynamicFieldInitPlace getInitPlace(@NotNull FieldReference ref) {
        Method method;
        if (ref == null) {
            PhpClassImpl.$$$reportNull$$$0(36);
        }
        if ((method = PhpPsiUtil.getParentOfClass((PsiElement)ref, Method.class)) == null) {
            return PhpClass.PhpDynamicFieldInitPlace.DYNAMIC;
        }
        if (PhpLangUtil.equalsMethodNames(method.getName(), PHPUNIT_SETUP_METHOD)) {
            return PhpClass.PhpDynamicFieldInitPlace.PHPUNIT_SETUP;
        }
        if (PhpLangUtil.equalsMethodNames(method.getName(), PHPUNIT_SETUP_BEFORE_CLASS_METHOD)) {
            return PhpClass.PhpDynamicFieldInitPlace.PHPUNIT_SETUP_BEFORE_CLASS;
        }
        PhpClass containingClass = method.getContainingClass();
        return containingClass != null && containingClass.getOwnConstructor() == method ? PhpClass.PhpDynamicFieldInitPlace.CONSTRUCTOR : PhpClass.PhpDynamicFieldInitPlace.DYNAMIC;
    }

    @NotNull
    public static Set<PhpNamedElement> tryResolveEnumCases(@NotNull PhpClass klass, String referenceName) {
        Collection<PhpEnumCase> enumCase;
        if (klass == null) {
            PhpClassImpl.$$$reportNull$$$0(37);
        }
        HashSet<PhpEnumCase> hashSet = !(enumCase = PhpClassImpl.findEnumCasesByName(klass, referenceName)).isEmpty() ? new HashSet<PhpEnumCase>(enumCase) : Collections.emptySet();
        if (hashSet == null) {
            PhpClassImpl.$$$reportNull$$$0(38);
        }
        return hashSet;
    }

    @NotNull
    private static @Unmodifiable Collection<PhpEnumCase> findEnumCasesByName(@NotNull PhpClass klass, String referenceName) {
        if (klass == null) {
            PhpClassImpl.$$$reportNull$$$0(39);
        }
        List list = ContainerUtil.filter((Collection)klass.getEnumCases(), t -> t.getName().equals(referenceName));
        if (list == null) {
            PhpClassImpl.$$$reportNull$$$0(40);
        }
        return list;
    }

    @Nullable
    public Method findOwnMethodByName(@Nullable CharSequence name) {
        return this.findOwnMethodByName(name, (Predicate<? super Method>)Predicates.alwaysTrue());
    }

    @Nullable
    public Method findMethodByName(@Nullable CharSequence name) {
        return this.findMethodByName(name, new HashSet<PhpClass>());
    }

    @Nullable
    public Method findMethodByName(@Nullable CharSequence name, Collection<PhpClass> visited) {
        return PhpClassImpl.findMethodsByName(this, name, visited, null).getAny();
    }

    @NotNull
    public Collection<Method> findMethodsByName(@Nullable CharSequence name) {
        Collection<Method> collection = this.findMethodsByName(name, new HashSet<PhpClass>());
        if (collection == null) {
            PhpClassImpl.$$$reportNull$$$0(41);
        }
        return collection;
    }

    @NotNull
    public Collection<Method> findMethodsByName(@Nullable CharSequence name, HashSet<PhpClass> visited) {
        Collection collection = PhpClassImpl.findMethodsByName(this, name, visited, null).getMethods();
        if (collection == null) {
            PhpClassImpl.$$$reportNull$$$0(42);
        }
        return collection;
    }

    @ApiStatus.Internal
    @NotNull
    public static PhpClass.PhpOverloadedMethods getConstructors(PhpClass aClass, Set<PhpClass> visited) {
        while (aClass != null && !PhpLangUtil.isObject(aClass)) {
            PhpClass[] traits;
            if (aClass.isInterface() || aClass.isEnum()) {
                PhpClass.PhpOverloadedMethods phpOverloadedMethods = PhpClass.PhpOverloadedMethods.EMPTY;
                if (phpOverloadedMethods == null) {
                    PhpClassImpl.$$$reportNull$$$0(43);
                }
                return phpOverloadedMethods;
            }
            if (!visited.add(aClass)) {
                PhpClass.PhpOverloadedMethods phpOverloadedMethods = PhpClass.PhpOverloadedMethods.EMPTY;
                if (phpOverloadedMethods == null) {
                    PhpClassImpl.$$$reportNull$$$0(44);
                }
                return phpOverloadedMethods;
            }
            PhpClass.PhpOverloadedMethods own = PhpClassImpl.getOwnConstructors(aClass);
            if (!own.isEmpty()) {
                PhpClass.PhpOverloadedMethods phpOverloadedMethods = own;
                if (phpOverloadedMethods == null) {
                    PhpClassImpl.$$$reportNull$$$0(45);
                }
                return phpOverloadedMethods;
            }
            for (PhpClass trait : traits = aClass.getTraits()) {
                PhpClass.PhpOverloadedMethods constructors = PhpClassImpl.getConstructors(trait, visited);
                if (constructors.isEmpty()) continue;
                PhpClass.PhpOverloadedMethods phpOverloadedMethods = constructors;
                if (phpOverloadedMethods == null) {
                    PhpClassImpl.$$$reportNull$$$0(46);
                }
                return phpOverloadedMethods;
            }
            aClass = aClass.getSuperClass();
        }
        PhpClass.PhpOverloadedMethods phpOverloadedMethods = PhpClass.PhpOverloadedMethods.EMPTY;
        if (phpOverloadedMethods == null) {
            PhpClassImpl.$$$reportNull$$$0(47);
        }
        return phpOverloadedMethods;
    }

    @NotNull
    public static PhpClass.PhpOverloadedMethods getOwnConstructors(PhpClass aClass) {
        if (aClass.isInterface() || aClass.isEnum()) {
            PhpClass.PhpOverloadedMethods phpOverloadedMethods = PhpClass.PhpOverloadedMethods.EMPTY;
            if (phpOverloadedMethods == null) {
                PhpClassImpl.$$$reportNull$$$0(48);
            }
            return phpOverloadedMethods;
        }
        PhpClass.PhpOverloadedMethods c = aClass.findOwnMethodsByName((CharSequence)"__construct").filter(NOT_DOC_METHOD);
        if (c.isEmpty() && "\\".equals(aClass.getNamespaceName())) {
            PhpClass.PhpOverloadedMethods phpOverloadedMethods = aClass.findOwnMethodsByName((CharSequence)aClass.getName()).filter(NOT_DOC_METHOD);
            if (phpOverloadedMethods == null) {
                PhpClassImpl.$$$reportNull$$$0(49);
            }
            return phpOverloadedMethods;
        }
        PhpClass.PhpOverloadedMethods phpOverloadedMethods = c;
        if (phpOverloadedMethods == null) {
            PhpClassImpl.$$$reportNull$$$0(50);
        }
        return phpOverloadedMethods;
    }

    @ApiStatus.Internal
    @NotNull
    public static PhpClass.PhpOverloadedMethods findMethodsByName(@Nullable PhpClass aClass, @Nullable CharSequence name, Collection<PhpClass> visited, @Nullable String genericInstantiationType) {
        if (aClass == null || name == null || !visited.add(aClass)) {
            PhpClass.PhpOverloadedMethods phpOverloadedMethods = PhpClass.PhpOverloadedMethods.EMPTY;
            if (phpOverloadedMethods == null) {
                PhpClassImpl.$$$reportNull$$$0(51);
            }
            return phpOverloadedMethods;
        }
        PhpClass.PhpOverloadedMethods ownMethods = aClass.findOwnMethodsByName(name);
        if (!ownMethods.isEmpty()) {
            PhpClass.PhpOverloadedMethods phpOverloadedMethods = ownMethods;
            if (phpOverloadedMethods == null) {
                PhpClassImpl.$$$reportNull$$$0(52);
            }
            return phpOverloadedMethods;
        }
        PhpClass.PhpOverloadedMethods methodsFromTrait = PhpClassImpl.findMethodInTraits(aClass, name, visited);
        if (!methodsFromTrait.isEmpty()) {
            PhpClass.PhpOverloadedMethods methodFromSuperClass;
            if (methodsFromTrait.isFromMixin() && !(methodFromSuperClass = PhpClassImpl.findMethodInSuperClass(aClass, name, visited)).isEmpty() && !methodFromSuperClass.isFromMixin()) {
                PhpClass.PhpOverloadedMethods phpOverloadedMethods = PhpClass.PhpOverloadedMethods.from((Collection)ContainerUtil.union((Collection)methodFromSuperClass.getMethods(), (Collection)methodsFromTrait.getMethods()));
                if (phpOverloadedMethods == null) {
                    PhpClassImpl.$$$reportNull$$$0(53);
                }
                return phpOverloadedMethods;
            }
            PhpClass.PhpOverloadedMethods phpOverloadedMethods = methodsFromTrait;
            if (phpOverloadedMethods == null) {
                PhpClassImpl.$$$reportNull$$$0(54);
            }
            return phpOverloadedMethods;
        }
        PhpClass.PhpOverloadedMethods methodFromSuperClass = PhpClassImpl.findMethodInSuperClass(aClass, name, visited);
        if (!methodFromSuperClass.isEmpty()) {
            PhpClass.PhpOverloadedMethods phpOverloadedMethods = methodFromSuperClass;
            if (phpOverloadedMethods == null) {
                PhpClassImpl.$$$reportNull$$$0(55);
            }
            return phpOverloadedMethods;
        }
        PhpClass.PhpOverloadedMethods methodFromInterface = PhpClassImpl.findMethodInInterfaces(aClass, name, visited);
        if (!methodFromInterface.isEmpty()) {
            PhpClass.PhpOverloadedMethods phpOverloadedMethods = methodFromInterface;
            if (phpOverloadedMethods == null) {
                PhpClassImpl.$$$reportNull$$$0(56);
            }
            return phpOverloadedMethods;
        }
        if (genericInstantiationType != null && aClass.hasGenericMixins()) {
            PhpClass[] mixins = aClass.getMixinsIncludingGeneric(genericInstantiationType);
            PhpClass.PhpOverloadedMethods phpOverloadedMethods = PhpClass.PhpOverloadedMethods.fromMethods(PhpClassImpl.findMethodInClasses(Arrays.stream(mixins), name, visited).values()).fromMixin(true);
            if (phpOverloadedMethods == null) {
                PhpClassImpl.$$$reportNull$$$0(57);
            }
            return phpOverloadedMethods;
        }
        PhpClass.PhpOverloadedMethods phpOverloadedMethods = PhpClass.PhpOverloadedMethods.fromMethods(PhpClassImpl.findMethodInClasses(Arrays.stream(aClass.getMixins()), name, visited).values()).fromMixin(true);
        if (phpOverloadedMethods == null) {
            PhpClassImpl.$$$reportNull$$$0(58);
        }
        return phpOverloadedMethods;
    }

    @NotNull
    private static Map<PhpClass, PhpClass.PhpOverloadedMethods> findMethodInClasses(Stream<PhpClass> classes, @NotNull CharSequence methodName, Collection<PhpClass> visited) {
        Map<PhpClass, PhpClass.PhpOverloadedMethods> methodsInClasses;
        List<PhpClass> sortedClasses;
        if (methodName == null) {
            PhpClassImpl.$$$reportNull$$$0(59);
        }
        if ((sortedClasses = (methodsInClasses = PhpClassImpl.methodsInClasses(classes, methodName, visited)).keySet().stream().sorted(COMPARATOR).toList()).size() > 1 && COMPARATOR.compare(sortedClasses.get(0), sortedClasses.get(1)) != 0) {
            Map<PhpClass, PhpClass.PhpOverloadedMethods> map = Map.of(sortedClasses.get(0), methodsInClasses.get(sortedClasses.get(0)));
            if (map == null) {
                PhpClassImpl.$$$reportNull$$$0(60);
            }
            return map;
        }
        Map<PhpClass, PhpClass.PhpOverloadedMethods> map = methodsInClasses;
        if (map == null) {
            PhpClassImpl.$$$reportNull$$$0(61);
        }
        return map;
    }

    @NotNull
    private static Map<PhpClass, PhpClass.PhpOverloadedMethods> methodsInClasses(@NotNull Stream<PhpClass> classes, @NotNull CharSequence methodName, Collection<PhpClass> visited) {
        if (classes == null) {
            PhpClassImpl.$$$reportNull$$$0(62);
        }
        if (methodName == null) {
            PhpClassImpl.$$$reportNull$$$0(63);
        }
        Map map = ((StreamEx)StreamEx.of(classes).flatMap(c -> {
            PhpClass.PhpOverloadedMethods method = PhpClassImpl.findMethodsByName(c, methodName, visited, null);
            return method.getMethods().stream().map(m -> Pair.create((Object)method.isFromMixin(), (Object)m));
        }).distinct()).mapToEntry(t -> ((Method)t.getSecond()).getContainingClass(), m -> PhpClass.PhpOverloadedMethods.from(Collections.singleton((Method)m.getSecond())).fromMixin(((Boolean)m.getFirst()).booleanValue())).toMap((o1, o2) -> PhpClass.PhpOverloadedMethods.fromMethods(Set.of(o1, o2)));
        if (map == null) {
            PhpClassImpl.$$$reportNull$$$0(64);
        }
        return map;
    }

    @NotNull
    private static PhpClass.PhpOverloadedMethods findMethodInSuperClass(@NotNull PhpClass aClass, @NotNull CharSequence name, Collection<PhpClass> visited) {
        PhpClass.PhpOverloadedMethods methodsFromBestClass;
        Map<PhpClass, PhpClass.PhpOverloadedMethods> methodsFromSuperClass;
        if (aClass == null) {
            PhpClassImpl.$$$reportNull$$$0(65);
        }
        if (name == null) {
            PhpClassImpl.$$$reportNull$$$0(66);
        }
        if ((methodsFromSuperClass = PhpClassImpl.findMethodInClasses(PhpClassHierarchyUtils.getSuperClasses((PhpClass)aClass).stream(), name, visited)).size() == 1) {
            PhpClass.PhpOverloadedMethods phpOverloadedMethods = (PhpClass.PhpOverloadedMethods)ContainerUtil.getFirstItem(methodsFromSuperClass.values());
            if (phpOverloadedMethods == null) {
                PhpClassImpl.$$$reportNull$$$0(67);
            }
            return phpOverloadedMethods;
        }
        if (methodsFromSuperClass.size() > 1 && !(methodsFromBestClass = PhpClassImpl.chooseMethodFromBestClass(aClass, methodsFromSuperClass)).isEmpty()) {
            PhpClass.PhpOverloadedMethods phpOverloadedMethods = methodsFromBestClass;
            if (phpOverloadedMethods == null) {
                PhpClassImpl.$$$reportNull$$$0(68);
            }
            return phpOverloadedMethods;
        }
        PhpClass.PhpOverloadedMethods phpOverloadedMethods = PhpClass.PhpOverloadedMethods.EMPTY;
        if (phpOverloadedMethods == null) {
            PhpClassImpl.$$$reportNull$$$0(69);
        }
        return phpOverloadedMethods;
    }

    @NotNull
    private static PhpClass.PhpOverloadedMethods chooseMethodFromBestClass(@NotNull PhpClass aClass, Map<PhpClass, PhpClass.PhpOverloadedMethods> methodsFromSuperClass) {
        if (aClass == null) {
            PhpClassImpl.$$$reportNull$$$0(70);
        }
        Collection<PhpClass> bestClasses = PhpClassImpl.selectBestClasses(methodsFromSuperClass.keySet(), (PhpPsiElement)aClass);
        PhpClass.PhpOverloadedMethods phpOverloadedMethods = PhpClass.PhpOverloadedMethods.fromMethods((Collection)ContainerUtil.map(bestClasses, methodsFromSuperClass::get));
        if (phpOverloadedMethods == null) {
            PhpClassImpl.$$$reportNull$$$0(71);
        }
        return phpOverloadedMethods;
    }

    public static boolean isImplicitEnumFQN(@Nullable String classFQN) {
        return PhpLangUtil.equalsClassNames(classFQN, INT_BACKED_ENUM_FQN) || PhpLangUtil.equalsClassNames(classFQN, STRING_BACKED_ENUM_FQN) || PhpLangUtil.equalsClassNames(classFQN, UNIT_ENUM_FQN) || PhpLangUtil.equalsClassNames(classFQN, BACKED_ENUM_FQN);
    }

    @NotNull
    private static PhpClass.PhpOverloadedMethods findMethodInInterfaces(@NotNull PhpClass aClass, @NotNull CharSequence name, Collection<PhpClass> visited) {
        if (aClass == null) {
            PhpClassImpl.$$$reportNull$$$0(72);
        }
        if (name == null) {
            PhpClassImpl.$$$reportNull$$$0(73);
        }
        StreamEx interfaces = StreamEx.of((Collection)aClass.getDirectImplementedInterfaces());
        if (aClass.isEnum()) {
            Collection fqn = aClass.getTypeAwareImplicitEnumInterfaces();
            interfaces = interfaces.append(fqn);
        }
        PhpClass.PhpOverloadedMethods phpOverloadedMethods = PhpClass.PhpOverloadedMethods.fromMethods(PhpClassImpl.findMethodInClasses((Stream<PhpClass>)interfaces, name, visited).values());
        if (phpOverloadedMethods == null) {
            PhpClassImpl.$$$reportNull$$$0(74);
        }
        return phpOverloadedMethods;
    }

    @NotNull
    public Collection<PhpClass> getTypeAwareImplicitEnumInterfaces() {
        if (!this.isEnum()) {
            List<PhpClass> list = Collections.emptyList();
            if (list == null) {
                PhpClassImpl.$$$reportNull$$$0(75);
            }
            return list;
        }
        Collection collection = PhpIndex.getInstance((Project)this.getProject()).getInterfacesByFQN(this.getEnumInterfaceFQN());
        if (collection == null) {
            PhpClassImpl.$$$reportNull$$$0(76);
        }
        return collection;
    }

    @NotNull
    private String getEnumInterfaceFQN() {
        PhpType backedEnumType = this.getBackedEnumType();
        if (PhpType.intersects((PhpType)backedEnumType, (PhpType)PhpType.STRING)) {
            return STRING_BACKED_ENUM_FQN;
        }
        if (PhpType.intersects((PhpType)backedEnumType, (PhpType)PhpType.INT)) {
            return INT_BACKED_ENUM_FQN;
        }
        if (!backedEnumType.isEmpty()) {
            return BACKED_ENUM_FQN;
        }
        return UNIT_ENUM_FQN;
    }

    @NotNull
    private static PhpClass.PhpOverloadedMethods findMethodInTraits(PhpClass aClass, CharSequence methodName, Collection<PhpClass> visited) {
        for (PhpTraitUseRule rule : aClass.traitUseRules()) {
            Method method = rule.getMethod();
            if (method == null || !PhpLangUtil.equalsMethodNames(method.getName(), methodName) || !method.isValid()) continue;
            PhpClass.PhpOverloadedMethods phpOverloadedMethods = PhpClass.PhpOverloadedMethods.from(Collections.singleton(method));
            if (phpOverloadedMethods == null) {
                PhpClassImpl.$$$reportNull$$$0(77);
            }
            return phpOverloadedMethods;
        }
        PhpClass.PhpOverloadedMethods phpOverloadedMethods = PhpClass.PhpOverloadedMethods.fromMethods(PhpClassImpl.findMethodInClasses(Arrays.stream(aClass.getTraits()), methodName, visited).values());
        if (phpOverloadedMethods == null) {
            PhpClassImpl.$$$reportNull$$$0(78);
        }
        return phpOverloadedMethods;
    }

    @Nullable
    public Field findOwnFieldByName(@Nullable CharSequence name, boolean findConstant) {
        return (Field)ContainerUtil.getFirstItem(this.findOwnFieldsByName(name, findConstant, true));
    }

    public Collection<Field> findOwnFieldsByName(@Nullable CharSequence name, boolean findConstant, boolean dynamicFieldsOnlyFromConstructor) {
        Collection<Field> fields = PhpClassImpl.findOwnFieldsByName(name, findConstant, dynamicFieldsOnlyFromConstructor, this.getOwnDeclaredFieldMap());
        if (!fields.isEmpty()) {
            return fields;
        }
        return PhpClassImpl.findOwnFieldsByName(name, findConstant, dynamicFieldsOnlyFromConstructor, this.getOwnDynamicFieldMap());
    }

    public static Collection<Field> findOwnFieldsByName(@Nullable CharSequence name, boolean findConstant, boolean dynamicFieldsOnlyFromConstructor, MultiMap<CharSequence, Field> map) {
        return map.get((Object)name).stream().filter(f -> f.isConstant() == findConstant).filter(f -> !dynamicFieldsOnlyFromConstructor || !PhpClassImpl.isDynamicFieldNotFromConstructor(f)).collect(Collectors.toList());
    }

    private static boolean isDynamicFieldNotFromConstructor(Field field) {
        return field instanceof MyRenamableFakePsiElement && ((MyRenamableFakePsiElement)field).getInitPlace() != PhpClass.PhpDynamicFieldInitPlace.CONSTRUCTOR;
    }

    @Nullable
    public Field findFieldByName(@Nullable CharSequence name, boolean findConstant) {
        return (Field)ContainerUtil.getFirstItem(PhpClassImpl.findFieldsByName(this, name, findConstant, null));
    }

    public static Collection<Field> findFieldsByName(PhpClass base, @Nullable CharSequence name, boolean findConstant, @Nullable String genericInstantiationType) {
        return PhpClassImpl.findFieldsByName(base, name, findConstant, false, genericInstantiationType);
    }

    public static Collection<Field> findFieldsByName(PhpClass base, @Nullable CharSequence name, boolean findConstant, boolean dfaReachable, @Nullable String genericInstantiationType) {
        if (name == null) {
            return Collections.emptyList();
        }
        ArrayList<Field> res = new ArrayList<Field>();
        ArrayList<Field> firstNotAvailableElements = new ArrayList<Field>();
        HashSet<PhpClass> processed = new HashSet<PhpClass>();
        ArrayDeque<PhpClass> processorPool = new ArrayDeque<PhpClass>();
        processorPool.add(base);
        HashSet<PhpClass> classesToSkipSetUpMethod = new HashSet<PhpClass>();
        HashSet<PhpClass> classesToSkipSetUpBeforeClassMethod = new HashSet<PhpClass>();
        while (!processorPool.isEmpty()) {
            PhpClass aClass = (PhpClass)processorPool.pollFirst();
            if (!processed.add(aClass)) continue;
            List ownFields = ContainerUtil.filter(PhpClassImpl.fetchOwnFields(name, findConstant, aClass), f -> PhpClassImpl.isPhpUnitDynamicFieldToSkip(classesToSkipSetUpMethod, classesToSkipSetUpBeforeClassMethod, aClass, f));
            boolean appendNext = true;
            if (!ownFields.isEmpty()) {
                boolean privateSuperFieldInPresenceOfDynamic;
                boolean bl = privateSuperFieldInPresenceOfDynamic = aClass != base && ContainerUtil.exists(res, f -> f instanceof MyRenamableFakePsiElement) && ContainerUtil.exists((Iterable)ownFields, ownField -> ownField.getModifier().isPrivate()) && !aClass.isTrait();
                if (!(privateSuperFieldInPresenceOfDynamic || !dfaReachable && PhpClassImpl.notAvailableByLanguageLevel(ownFields))) {
                    res.addAll(ownFields);
                    if (ContainerUtil.exists((Iterable)ownFields, f -> !(f instanceof MyRenamableFakePsiElement))) {
                        appendNext = false;
                    }
                } else if (PhpClassImpl.notAvailableByLanguageLevel(ownFields) && firstNotAvailableElements.isEmpty()) {
                    firstNotAvailableElements.addAll(ownFields);
                }
            }
            if (!PhpClassImpl.canCallSuperMethod(aClass.findOwnMethodByName((CharSequence)PHPUNIT_SETUP_METHOD))) {
                classesToSkipSetUpMethod.add(aClass);
            }
            if (!PhpClassImpl.canCallSuperMethod(aClass.findOwnMethodByName((CharSequence)PHPUNIT_SETUP_BEFORE_CLASS_METHOD))) {
                classesToSkipSetUpBeforeClassMethod.add(aClass);
            }
            if (!appendNext) continue;
            ArrayDeque tmp = new ArrayDeque();
            PhpClassHierarchyUtils.SUPER_APPENDER_AMBIGUITY_WITH_MIXINS.appendNextElements((Object)aClass, tmp);
            if (genericInstantiationType != null && aClass.hasGenericMixins()) {
                Object[] mixins = aClass.getMixinsIncludingGeneric(genericInstantiationType);
                ContainerUtil.addAll(tmp, (Object[])mixins);
            }
            for (PhpClass nextClass : tmp) {
                if (classesToSkipSetUpMethod.contains(aClass)) {
                    classesToSkipSetUpMethod.add(nextClass);
                }
                if (classesToSkipSetUpBeforeClassMethod.contains(aClass)) {
                    classesToSkipSetUpBeforeClassMethod.add(nextClass);
                }
                processorPool.add(nextClass);
            }
        }
        List withoutDynamic = ContainerUtil.filter(res, f -> !(f instanceof MyRenamableFakePsiElement));
        if (!withoutDynamic.isEmpty()) {
            return withoutDynamic;
        }
        if (res.isEmpty()) {
            return firstNotAvailableElements;
        }
        return res;
    }

    private static boolean canCallSuperMethod(@Nullable Method method) {
        if (method == null) {
            return true;
        }
        final Ref res = new Ref((Object)false);
        PhpControlFlowUtil.processFlow(method.getControlFlow(), new PhpInstructionProcessor(){

            public boolean processPhpCallInstruction(PhpCallInstruction instruction) {
                FunctionReference functionReference = instruction.getFunctionReference();
                if (functionReference instanceof MethodReference) {
                    PhpExpression classReference = ((MethodReference)functionReference).getClassReference();
                    if (classReference != null && PhpLangUtil.isClassNameSpecial(classReference.getName())) {
                        res.set((Object)true);
                        return false;
                    }
                } else if (ContainerUtil.exists((Object[])functionReference.getParameters(), PhpLangUtil::isThisReference)) {
                    res.set((Object)true);
                    return false;
                }
                return super.processPhpCallInstruction(instruction);
            }
        });
        return (Boolean)res.get();
    }

    private static boolean isPhpUnitDynamicFieldToSkip(Collection<PhpClass> classesToSkipSetUpMethod, Collection<PhpClass> classesToSkipSetUpBeforeClassMethod, PhpClass containingClass, Field field) {
        return !(field instanceof MyRenamableFakePsiElement) || (((MyRenamableFakePsiElement)field).getInitPlace() != PhpClass.PhpDynamicFieldInitPlace.PHPUNIT_SETUP || !classesToSkipSetUpMethod.contains(containingClass)) && (((MyRenamableFakePsiElement)field).getInitPlace() != PhpClass.PhpDynamicFieldInitPlace.PHPUNIT_SETUP_BEFORE_CLASS || !classesToSkipSetUpBeforeClassMethod.contains(containingClass));
    }

    private static Collection<Field> fetchOwnFields(@NotNull CharSequence name, boolean findConstant, PhpClass aClass) {
        if (name == null) {
            PhpClassImpl.$$$reportNull$$$0(79);
        }
        return aClass instanceof PhpClassImpl ? ((PhpClassImpl)aClass).findOwnFieldsByName(name, findConstant, false) : PhpClassImpl.findOwnFields(name, findConstant, aClass);
    }

    private static boolean notAvailableByLanguageLevel(Collection<Field> fields) {
        return ContainerUtil.exists(fields, NOT_AVAILABLE_BY_LANGUAGE_LEVEL);
    }

    @NotNull
    private static List<Field> findOwnFields(@NotNull CharSequence name, boolean findConstant, PhpClass aClass) {
        if (name == null) {
            PhpClassImpl.$$$reportNull$$$0(80);
        }
        Field field = aClass.findOwnFieldByName(name, findConstant);
        List list = ContainerUtil.createMaybeSingletonList((Object)field);
        if (list == null) {
            PhpClassImpl.$$$reportNull$$$0(81);
        }
        return list;
    }

    @Nullable
    public static PhpClass getContainingClass(@NotNull PsiElement point) {
        PsiElement owner;
        if (point == null) {
            PhpClassImpl.$$$reportNull$$$0(82);
        }
        if (point instanceof PhpClass) {
            return (PhpClass)point;
        }
        PhpDocComment docComment = PhpPsiUtil.getParentOfClass(point, PhpDocComment.class);
        PsiElement psiElement = owner = docComment != null ? docComment.getOwner() : null;
        if (owner instanceof PhpClass) {
            return (PhpClass)owner;
        }
        PhpClass outerClass = PhpClassImpl.getOuterClass(point);
        if (outerClass != null && outerClass.isAnonymous()) {
            return PsiTreeUtil.isAncestor(PhpPsiUtil.getChildByCondition((PsiElement)outerClass, (Condition<? super PsiElement>)ParameterList.INSTANCEOF), (PsiElement)point, (boolean)false) ? PhpClassImpl.getOuterClass((PsiElement)outerClass) : outerClass;
        }
        Method method = (Method)PhpPsiUtil.getParentByCondition(point, (Condition<? super PsiElement>)Method.INSTANCEOF, (Condition<? super PsiElement>)PhpNamespace.INSTANCEOF);
        if (method != null) {
            return method.getContainingClass();
        }
        return outerClass;
    }

    @Nullable
    private static PhpClass getOuterClass(@NotNull PsiElement point) {
        if (point == null) {
            PhpClassImpl.$$$reportNull$$$0(83);
        }
        return (PhpClass)PhpPsiUtil.getParentByCondition(point, (Condition<? super PsiElement>)PhpClass.INSTANCEOF, (Condition<? super PsiElement>)PhpNamespace.INSTANCEOF);
    }

    @NotNull
    public String getPresentableFQN() {
        String fqn = this.getFQN();
        String string = PhpLangUtil.toPresentableFQN(fqn);
        if (string == null) {
            PhpClassImpl.$$$reportNull$$$0(84);
        }
        return string;
    }

    public Collection<PhpEnumCase> getEnumCases() {
        return Arrays.asList((PhpEnumCase[])this.getStubOrPsiChildren(TokenSet.create((IElementType[])new IElementType[]{PhpStubElementTypes.ENUM_CASE}), (PsiElement[])PhpEnumCaseImpl.EMPTY_ENUM_ARRAY));
    }

    @NotNull
    public static MultiMap<String, FieldReference> getConstructorAssignmentsPerField(@NotNull PhpClass phpClass) {
        if (phpClass == null) {
            PhpClassImpl.$$$reportNull$$$0(85);
        }
        MultiMap<String, FieldReference> multiMap = PhpClassImpl.getAssignmentsPerField(phpClass, new ConstructorFieldsAssignmentsInMethodsCachedValueProvider(phpClass));
        if (multiMap == null) {
            PhpClassImpl.$$$reportNull$$$0(86);
        }
        return multiMap;
    }

    private static MultiMap<String, FieldReference> getAssignmentsPerField(@NotNull PhpClass phpClass, FieldsAssignmentsInMethodsCachedValueProvider provider) {
        if (phpClass == null) {
            PhpClassImpl.$$$reportNull$$$0(87);
        }
        return (MultiMap)CachedValuesManager.getCachedValue((PsiElement)phpClass, (CachedValueProvider)provider);
    }

    @NotNull
    public static MultiMap<String, AssignmentExpression> getPhpUnitSetUpAssignmentsPerField(@NotNull PhpClass phpClass) {
        if (phpClass == null) {
            PhpClassImpl.$$$reportNull$$$0(88);
        }
        MultiMap<String, FieldReference> fields = PhpClassImpl.getAssignmentsPerField(phpClass, new PhpUnitFieldsAssignmentsInMethodsCachedValueProvider(phpClass));
        MultiMap res = new MultiMap();
        for (Map.Entry e : fields.entrySet()) {
            res.put((Object)((String)e.getKey()), (Collection)ContainerUtil.map((Collection)((Collection)e.getValue()), v -> PhpPsiUtil.getParentOfClass((PsiElement)v, AssignmentExpression.class)));
        }
        MultiMap multiMap = res;
        if (multiMap == null) {
            PhpClassImpl.$$$reportNull$$$0(89);
        }
        return multiMap;
    }

    @NotNull
    private static IElementType getFirstChildSkippingAttributesAndReadonlyKw(@NotNull PsiElement element) {
        if (element == null) {
            PhpClassImpl.$$$reportNull$$$0(90);
        }
        IElementType iElementType = PhpClassFieldsListImpl.getFirstNonWhitespaceChildSkippingCondition(element, node -> {
            IElementType type = node.getElementType();
            return type == PhpElementTypes.ATTRIBUTES_LIST || FieldImpl.isReadonlyKeyword(node);
        }).getElementType();
        if (iElementType == null) {
            PhpClassImpl.$$$reportNull$$$0(91);
        }
        return iElementType;
    }

    public Map<String, Set<@NotNull String>> getAliasedTraitMethods() {
        return StreamEx.of((Stream)this.traitUseRules().toStream()).mapToEntry(e -> StringUtil.toLowerCase((String)e.getAlias()), e -> {
            MethodReference methodReference;
            String name;
            PhpPsiElement patt0$temp = e.getFirstPsiChild();
            if (patt0$temp instanceof MethodReference && (name = (methodReference = (MethodReference)patt0$temp).getName()) != null) {
                return Collections.singleton(StringUtil.toLowerCase((String)name));
            }
            return Collections.emptySet();
        }).nonNullKeys().filterValues(e -> !e.isEmpty()).toMap(ContainerUtil::union);
    }

    @NotNull
    public static Map<String, String> createGenericMappingFromInstantiation(PhpNamedElement element, String genericInstantiationType) {
        List genericParts = PhpType.getParametrizedParts((String)genericInstantiationType);
        List<String> templates = PhpGenericsBaseExtendedWithGenericTypeProvider.getTemplates(element).stream().toList();
        HashMap<String, String> mapping = new HashMap<String, String>();
        for (int i = 0; i < Math.min(templates.size(), genericParts.size()); ++i) {
            mapping.put(templates.get(i), (String)genericParts.get(i));
        }
        HashMap<String, String> hashMap = mapping;
        if (hashMap == null) {
            PhpClassImpl.$$$reportNull$$$0(92);
        }
        return hashMap;
    }

    public PhpClass[] getMixinsIncludingGeneric(Map<String, String> genericParameterToRealTypeMapping) {
        ArrayList mixins = new ArrayList();
        PhpIndex phpIndex = PhpIndex.getInstance((Project)this.getProject());
        for (String fqn : this.getMixinNames()) {
            String name;
            String actualClass;
            Collection found = phpIndex.getAnyByFQN(fqn);
            if (!found.isEmpty()) {
                mixins.addAll(found);
                continue;
            }
            if (!PhpGenericsExtendedTypeProvider.KEY.signed(fqn) || (actualClass = (String)genericParameterToRealTypeMapping.getOrDefault(name = StringUtil.trimEnd((String)PhpGenericsExtendedTypeProvider.unsign(fqn), (String)"."), null)) == null) continue;
            found = phpIndex.getAnyByFQN(actualClass);
            mixins.addAll(found);
        }
        return mixins.toArray(PhpClass.EMPTY_ARRAY);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 8, 21, 22, 23, 35, 36, 37, 39, 59, 62, 63, 65, 66, 70, 72, 73, 79, 80, 82, 83, 85, 87, 88, 90 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/psi/elements/impl/PhpClassImpl";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "my";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "predicate";
                break;
            }
            case 22: 
            case 66: 
            case 73: 
            case 79: 
            case 80: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "phpElementVisitor";
                break;
            }
            case 35: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 37: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "klass";
                break;
            }
            case 59: 
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodName";
                break;
            }
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classes";
                break;
            }
            case 65: 
            case 70: 
            case 72: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 82: 
            case 83: {
                objectArray2 = objectArray3;
                objectArray3[0] = "point";
                break;
            }
            case 85: 
            case 87: 
            case 88: {
                objectArray2 = objectArray3;
                objectArray3[0] = "phpClass";
                break;
            }
            case 90: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getAttributes";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "docProperties";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDynamicFields";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getOwnMethodsMap";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getOwnMethodsInternal";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "selectBestClasses";
                break;
            }
            case 8: 
            case 21: 
            case 22: 
            case 23: 
            case 35: 
            case 36: 
            case 37: 
            case 39: 
            case 59: 
            case 62: 
            case 63: 
            case 65: 
            case 66: 
            case 70: 
            case 72: 
            case 73: 
            case 79: 
            case 80: 
            case 82: 
            case 83: 
            case 85: 
            case 87: 
            case 88: 
            case 90: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/psi/elements/impl/PhpClassImpl";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getNamespaceName";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getInterfaceNames";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getImplicitEnumInterfaces";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "useListTargetReferencesFQNs";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getTraitNames";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getMixinNames";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getIcon";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getBackedEnumType";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "traitUseLists";
                break;
            }
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getModifier";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtendsList";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "getImplementsList";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "getType";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "tryResolveEnumCases";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "findEnumCasesByName";
                break;
            }
            case 41: 
            case 42: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: {
                objectArray = objectArray2;
                objectArray2[1] = "findMethodsByName";
                break;
            }
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: {
                objectArray = objectArray2;
                objectArray2[1] = "getConstructors";
                break;
            }
            case 48: 
            case 49: 
            case 50: {
                objectArray = objectArray2;
                objectArray2[1] = "getOwnConstructors";
                break;
            }
            case 60: 
            case 61: {
                objectArray = objectArray2;
                objectArray2[1] = "findMethodInClasses";
                break;
            }
            case 64: {
                objectArray = objectArray2;
                objectArray2[1] = "methodsInClasses";
                break;
            }
            case 67: 
            case 68: 
            case 69: {
                objectArray = objectArray2;
                objectArray2[1] = "findMethodInSuperClass";
                break;
            }
            case 71: {
                objectArray = objectArray2;
                objectArray2[1] = "chooseMethodFromBestClass";
                break;
            }
            case 74: {
                objectArray = objectArray2;
                objectArray2[1] = "findMethodInInterfaces";
                break;
            }
            case 75: 
            case 76: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeAwareImplicitEnumInterfaces";
                break;
            }
            case 77: 
            case 78: {
                objectArray = objectArray2;
                objectArray2[1] = "findMethodInTraits";
                break;
            }
            case 81: {
                objectArray = objectArray2;
                objectArray2[1] = "findOwnFields";
                break;
            }
            case 84: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableFQN";
                break;
            }
            case 86: {
                objectArray = objectArray2;
                objectArray2[1] = "getConstructorAssignmentsPerField";
                break;
            }
            case 89: {
                objectArray = objectArray2;
                objectArray2[1] = "getPhpUnitSetUpAssignmentsPerField";
                break;
            }
            case 91: {
                objectArray = objectArray2;
                objectArray2[1] = "getFirstChildSkippingAttributesAndReadonlyKw";
                break;
            }
            case 92: {
                objectArray = objectArray2;
                objectArray2[1] = "createGenericMappingFromInstantiation";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getProximity";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "findOwnMethodByName";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "setName";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "isDynamicReference";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "getInitPlace";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "tryResolveEnumCases";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "findEnumCasesByName";
                break;
            }
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "findMethodInClasses";
                break;
            }
            case 62: 
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "methodsInClasses";
                break;
            }
            case 65: 
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "findMethodInSuperClass";
                break;
            }
            case 70: {
                objectArray = objectArray;
                objectArray[2] = "chooseMethodFromBestClass";
                break;
            }
            case 72: 
            case 73: {
                objectArray = objectArray;
                objectArray[2] = "findMethodInInterfaces";
                break;
            }
            case 79: {
                objectArray = objectArray;
                objectArray[2] = "fetchOwnFields";
                break;
            }
            case 80: {
                objectArray = objectArray;
                objectArray[2] = "findOwnFields";
                break;
            }
            case 82: {
                objectArray = objectArray;
                objectArray[2] = "getContainingClass";
                break;
            }
            case 83: {
                objectArray = objectArray;
                objectArray[2] = "getOuterClass";
                break;
            }
            case 85: {
                objectArray = objectArray;
                objectArray[2] = "getConstructorAssignmentsPerField";
                break;
            }
            case 87: {
                objectArray = objectArray;
                objectArray[2] = "getAssignmentsPerField";
                break;
            }
            case 88: {
                objectArray = objectArray;
                objectArray[2] = "getPhpUnitSetUpAssignmentsPerField";
                break;
            }
            case 90: {
                objectArray = objectArray;
                objectArray[2] = "getFirstChildSkippingAttributesAndReadonlyKw";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 8, 21, 22, 23, 35, 36, 37, 39, 59, 62, 63, 65, 66, 70, 72, 73, 79, 80, 82, 83, 85, 87, 88, 90 -> new IllegalArgumentException(string);
        };
    }

    public static class MyRenamableFakePsiElement
    extends RenameableFakePsiElement
    implements Field,
    SyntheticElement {
        private final TextRange myRange;
        private final PhpType myType;
        protected final boolean myDynamic;
        protected final PhpClass.PhpDynamicFieldInitPlace myInitPlace;
        protected final String myName;

        protected MyRenamableFakePsiElement(TextRange range, PhpClass containingClass, boolean dynamic, @NotNull PhpType type, PhpClass.PhpDynamicFieldInitPlace initPlace, String name) {
            if (type == null) {
                MyRenamableFakePsiElement.$$$reportNull$$$0(0);
            }
            super((PsiElement)containingClass);
            this.myRange = range;
            this.myType = type;
            this.myDynamic = dynamic;
            this.myInitPlace = initPlace;
            this.myName = name;
        }

        @NotNull
        public PsiElement findSameElementInCopy(@NotNull PsiFile copy) {
            if (copy == null) {
                MyRenamableFakePsiElement.$$$reportNull$$$0(1);
            }
            PhpClass copyClass = (PhpClass)PsiTreeUtil.findSameElementInCopy((PsiElement)this.getContainingClass(), (PsiFile)copy);
            return new MyRenamableFakePsiElement(this.myRange, copyClass, this.myDynamic, this.myType, this.myInitPlace, this.myName);
        }

        public boolean isValid() {
            return super.getParent().isValid() && super.isValid();
        }

        @Nullable
        private FieldReference findFieldReference() {
            PsiElement elementAt;
            for (elementAt = this.getContainingFile().findElementAt(this.myRange.getStartOffset()); elementAt != null && !this.myRange.equals((Object)elementAt.getTextRange()); elementAt = elementAt.getParent()) {
            }
            return (FieldReference)ObjectUtils.tryCast((Object)elementAt, FieldReference.class);
        }

        public String getTypeName() {
            return PhpBundle.message("constructor.field", new Object[0]);
        }

        public Icon getIcon() {
            return PhpIcons.FIELD;
        }

        @NotNull
        public String getFQN() {
            String string = this.getContainingClass().getFQN() + "->" + this.getName();
            if (string == null) {
                MyRenamableFakePsiElement.$$$reportNull$$$0(2);
            }
            return string;
        }

        @NotNull
        public String getNamespaceName() {
            String string = this.getContainingClass().getNamespaceName();
            if (string == null) {
                MyRenamableFakePsiElement.$$$reportNull$$$0(3);
            }
            return string;
        }

        public boolean isDeprecated() {
            return false;
        }

        public boolean isInternal() {
            return false;
        }

        public PsiElement getParent() {
            return this.findFieldReference();
        }

        public ASTNode getNameNode() {
            FieldReference reference = this.findFieldReference();
            return reference != null ? reference.getNameNode() : null;
        }

        @NotNull
        public String getName() {
            String string = this.myName;
            if (string == null) {
                MyRenamableFakePsiElement.$$$reportNull$$$0(4);
            }
            return string;
        }

        @Nullable
        public TextRange getTextRange() {
            return this.myRange;
        }

        @NotNull
        public CharSequence getNameCS() {
            String string = this.getName();
            if (string == null) {
                MyRenamableFakePsiElement.$$$reportNull$$$0(5);
            }
            return string;
        }

        public PhpDocComment getDocComment() {
            return null;
        }

        public void processDocs(Processor<PhpDocComment> processor2) {
            PhpClassHierarchyUtils.processSuperMembers((PhpClassMember)this, (method, subClass, baseClass) -> !processor2.process((Object)method.getDocComment()));
        }

        @NotNull
        public PhpModifier getModifier() {
            PhpModifier phpModifier = this.myDynamic ? PhpModifier.PUBLIC_IMPLEMENTED_DYNAMIC : PhpModifier.PUBLIC_IMPLEMENTED_STATIC;
            if (phpModifier == null) {
                MyRenamableFakePsiElement.$$$reportNull$$$0(6);
            }
            return phpModifier;
        }

        public boolean isReadonly() {
            return false;
        }

        @NotNull
        public PhpClass getContainingClass() {
            PhpClass phpClass = (PhpClass)super.getParent();
            if (phpClass == null) {
                MyRenamableFakePsiElement.$$$reportNull$$$0(7);
            }
            return phpClass;
        }

        public boolean isConstant() {
            return false;
        }

        public PsiElement getDefaultValue() {
            return null;
        }

        public String getDefaultValuePresentation() {
            return null;
        }

        @Nullable
        public PhpClassFieldsList getParentList() {
            return null;
        }

        public boolean isWriteAccess() {
            return true;
        }

        public PhpPsiElement getFirstPsiChild() {
            return null;
        }

        public PhpPsiElement getNextPsiSibling() {
            return null;
        }

        public PhpPsiElement getPrevPsiSibling() {
            return null;
        }

        @NotNull
        public PhpType getType() {
            PhpType phpType = this.myType;
            if (phpType == null) {
                MyRenamableFakePsiElement.$$$reportNull$$$0(8);
            }
            return phpType;
        }

        public PsiElement getNameIdentifier() {
            ASTNode node = this.getNameNode();
            return node != null ? node.getPsi() : null;
        }

        public String toString() {
            return "FakeConstructorField " + this.getName();
        }

        @Nullable
        public PhpFieldType getTypeDeclaration() {
            return null;
        }

        @NotNull
        public @NotNull Collection<@NotNull PhpAttribute> getAttributes() {
            List<PhpAttribute> list = Collections.emptyList();
            if (list == null) {
                MyRenamableFakePsiElement.$$$reportNull$$$0(9);
            }
            return list;
        }

        @NotNull
        public PsiElement getNavigationElement() {
            FieldReference fieldReference = this.findFieldReference();
            if (fieldReference == null) {
                MyRenamableFakePsiElement.$$$reportNull$$$0(10);
            }
            return fieldReference;
        }

        public boolean isDynamic() {
            return this.myDynamic;
        }

        public PhpClass.PhpDynamicFieldInitPlace getInitPlace() {
            return this.myInitPlace;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3, 4, 5, 6, 7, 8, 9, 10 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "copy";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/psi/elements/impl/PhpClassImpl$MyRenamableFakePsiElement";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/psi/elements/impl/PhpClassImpl$MyRenamableFakePsiElement";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFQN";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getNamespaceName";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getNameCS";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getModifier";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getContainingClass";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getType";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAttributes";
                    break;
                }
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getNavigationElement";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "findSameElementInCopy";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3, 4, 5, 6, 7, 8, 9, 10 -> new IllegalStateException(string);
            };
        }
    }

    private static class DynamicFieldsAssignmentsInMethodsProvider
    extends FieldsAssignmentsInMethodsCachedValueProvider {
        private final Set<CharSequence> myRealFields;

        private DynamicFieldsAssignmentsInMethodsProvider(PhpClass myClass, Set<CharSequence> realFields) {
            super(myClass);
            this.myRealFields = realFields;
        }

        @Override
        @NotNull
        protected Collection<CharSequence> collectAssignedFieldsNames(PhpControlFlow flow) {
            Collection collection = ContainerUtil.subtract(super.collectAssignedFieldsNames(flow), this.myRealFields);
            if (collection == null) {
                DynamicFieldsAssignmentsInMethodsProvider.$$$reportNull$$$0(0);
            }
            return collection;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/php/lang/psi/elements/impl/PhpClassImpl$DynamicFieldsAssignmentsInMethodsProvider", "collectAssignedFieldsNames"));
        }
    }

    public static class MyASTRenamableFakePsiElement
    extends MyRenamableFakePsiElement {
        @NotNull
        private final FieldReference myOriginalRef;

        public MyASTRenamableFakePsiElement(PhpClass containingClass, @NotNull FieldReference ref) {
            if (ref == null) {
                MyASTRenamableFakePsiElement.$$$reportNull$$$0(0);
            }
            super(ref.getTextRange(), containingClass, PhpClassImpl.isDynamicReference(ref), PhpType.EMPTY, PhpClassImpl.getInitPlace(ref), ref.getName());
            this.myOriginalRef = ref;
        }

        @Override
        @NotNull
        public PhpType getType() {
            return MyASTRenamableFakePsiElement.getType(this.myOriginalRef);
        }

        @NotNull
        private static PhpType getType(@NotNull FieldReference ref) {
            if (ref == null) {
                MyASTRenamableFakePsiElement.$$$reportNull$$$0(1);
            }
            PhpTypeAnalyserVisitor visitor = new PhpTypeAnalyserVisitor();
            visitor.addTypeFromExpression((PhpExpression)ref);
            PhpType phpType = visitor.getType().removeParametrisedParts();
            if (phpType == null) {
                MyASTRenamableFakePsiElement.$$$reportNull$$$0(2);
            }
            return phpType;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ref";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/psi/elements/impl/PhpClassImpl$MyASTRenamableFakePsiElement";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/psi/elements/impl/PhpClassImpl$MyASTRenamableFakePsiElement";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getType";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "getType";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    }

    private static class ConstructorFieldsAssignmentsInMethodsCachedValueProvider
    extends FieldsAssignmentsInMethodsCachedValueProvider {
        private ConstructorFieldsAssignmentsInMethodsCachedValueProvider(@NotNull PhpClass phpClass) {
            if (phpClass == null) {
                ConstructorFieldsAssignmentsInMethodsCachedValueProvider.$$$reportNull$$$0(0);
            }
            super(phpClass);
        }

        @Override
        protected Collection<Method> getMethods() {
            Method constructor = this.myClass.getOwnConstructor();
            return constructor != null ? Collections.singleton(constructor) : Collections.emptyList();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "phpClass", "com/jetbrains/php/lang/psi/elements/impl/PhpClassImpl$ConstructorFieldsAssignmentsInMethodsCachedValueProvider", "<init>"));
        }
    }

    private static class FieldsAssignmentsInMethodsCachedValueProvider
    implements CachedValueProvider<MultiMap<String, FieldReference>> {
        protected final PhpClass myClass;

        FieldsAssignmentsInMethodsCachedValueProvider(PhpClass aClass) {
            this.myClass = aClass;
        }

        @NotNull
        public CachedValueProvider.Result<MultiMap<String, FieldReference>> compute() {
            MultiMap accessMap = new MultiMap();
            MultiMap instructionsMap = new MultiMap();
            HashSet fieldNamesSetInConstructor = new HashSet();
            for (Method method : this.getMethods()) {
                if (method == null) continue;
                PhpControlFlow flow = method.getControlFlow();
                for (CharSequence name : this.collectAssignedFieldsNames(flow)) {
                    if (fieldNamesSetInConstructor.contains(name.toString())) continue;
                    this.putLastWrittenInstructions((MultiMap<String, FieldReference>)accessMap, (MultiMap<String, PhpAccessInstruction>)instructionsMap, flow, name);
                }
                if (method.getMethodType(false) != Method.MethodType.CONSTRUCTOR) continue;
                fieldNamesSetInConstructor.addAll(accessMap.keySet());
            }
            return new CachedValueProvider.Result((Object)accessMap, new Object[]{this.myClass});
        }

        @NotNull
        protected Collection<CharSequence> collectAssignedFieldsNames(PhpControlFlow flow) {
            final HashSet<CharSequence> res = new HashSet<CharSequence>();
            PhpControlFlowUtil.processFlow(flow, new PhpFieldAccessProcessor(this, this.myClass){

                @Override
                protected boolean processFieldAccessInstruction(PhpAccessInstruction instruction, FieldReference reference) {
                    String name = reference.getName();
                    if (StringUtil.isNotEmpty((String)name)) {
                        res.add(name);
                    }
                    return true;
                }
            });
            HashSet<CharSequence> hashSet = res;
            if (hashSet == null) {
                FieldsAssignmentsInMethodsCachedValueProvider.$$$reportNull$$$0(0);
            }
            return hashSet;
        }

        private void putLastWrittenInstructions(final MultiMap<String, FieldReference> accessMap, final MultiMap<String, PhpAccessInstruction> instructionsMap, PhpControlFlow flow, final CharSequence dynamicFieldName) {
            PhpControlFlowUtil.processPredecessorsIgnoreInitialBackEdges((PhpInstruction)flow.getExitPoint(), false, new PhpFieldAccessProcessor(this, this.myClass){

                @Override
                protected boolean processFieldAccessInstruction(PhpAccessInstruction instruction, FieldReference reference) {
                    String name = reference.getName();
                    if (StringUtil.isNotEmpty((String)name) && PhpLangUtil.equalsFieldNames(dynamicFieldName, name)) {
                        accessMap.putValue((Object)name, (Object)reference);
                        instructionsMap.putValue((Object)name, (Object)instruction);
                        return false;
                    }
                    return true;
                }
            });
        }

        protected Collection<Method> getMethods() {
            return ContainerUtil.sorted(Arrays.asList(this.myClass.getOwnMethods()), Comparator.comparingInt(value -> value.getMethodType(false) == Method.MethodType.CONSTRUCTOR ? -1 : 1));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/php/lang/psi/elements/impl/PhpClassImpl$FieldsAssignmentsInMethodsCachedValueProvider", "collectAssignedFieldsNames"));
        }
    }

    private static class PhpUnitFieldsAssignmentsInMethodsCachedValueProvider
    extends FieldsAssignmentsInMethodsCachedValueProvider {
        PhpUnitFieldsAssignmentsInMethodsCachedValueProvider(PhpClass aClass) {
            super(aClass);
        }

        @Override
        protected Collection<Method> getMethods() {
            SmartList res = new SmartList();
            ContainerUtil.addIfNotNull((Collection)res, (Object)this.myClass.findOwnMethodByName((CharSequence)PhpClassImpl.PHPUNIT_SETUP_METHOD));
            ContainerUtil.addIfNotNull((Collection)res, (Object)this.myClass.findOwnMethodByName((CharSequence)PhpClassImpl.PHPUNIT_SETUP_BEFORE_CLASS_METHOD));
            return res;
        }
    }

    private static final class PhpFieldDescriptor {
        @NotNull
        private final String myName;
        private final boolean myIsConstant;
        private final boolean myIsDocProperty;

        private PhpFieldDescriptor(@NotNull String name, boolean isConstant, boolean isDocProperty) {
            if (name == null) {
                PhpFieldDescriptor.$$$reportNull$$$0(0);
            }
            this.myName = name;
            this.myIsConstant = isConstant;
            this.myIsDocProperty = isDocProperty;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PhpFieldDescriptor that = (PhpFieldDescriptor)o;
            if (this.myIsConstant != that.myIsConstant) {
                return false;
            }
            if (this.myIsDocProperty != that.myIsDocProperty) {
                return false;
            }
            return this.myName.equals(that.myName);
        }

        public int hashCode() {
            int result = this.myName.hashCode();
            result = 31 * result + (this.myIsConstant ? 1 : 0);
            result = 31 * result + (this.myIsDocProperty ? 1 : 0);
            return result;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/jetbrains/php/lang/psi/elements/impl/PhpClassImpl$PhpFieldDescriptor", "<init>"));
        }
    }

    static abstract class PhpFieldAccessProcessor
    extends PhpInstructionProcessor {
        private final PhpClass myClass;

        protected PhpFieldAccessProcessor(PhpClass aClass) {
            this.myClass = aClass;
        }

        public boolean processAccessFieldInObjectContextInstruction(PhpAccessFieldInObjectContextInstruction instruction) {
            return this.processFieldAccessInstruction((PhpAccessInstruction)instruction, (PsiElement)instruction.getAnchor());
        }

        public boolean processAccessFieldByVariableInstruction(PhpAccessFieldByVariableInstruction instruction) {
            return this.processFieldAccessInstruction((PhpAccessInstruction)instruction, (PsiElement)instruction.getAnchor());
        }

        public boolean processArrayAccessInstruction(PhpArrayAccessInstruction instruction) {
            PhpPsiElement value = instruction.getAnchor();
            while (value instanceof ArrayAccessExpression) {
                value = ((ArrayAccessExpression)value).getValue();
            }
            return this.processFieldAccessInstruction((PhpAccessInstruction)instruction, (PsiElement)value);
        }

        private boolean processFieldAccessInstruction(PhpAccessInstruction instruction, @Nullable PsiElement anchor) {
            FieldReference reference = (FieldReference)ObjectUtils.tryCast((Object)anchor, FieldReference.class);
            if (reference == null) {
                return true;
            }
            if (!instruction.getAccess().isWrite()) {
                return true;
            }
            AssignmentExpression expr = PhpPsiUtil.getParentOfClass((PsiElement)reference, AssignmentExpression.class);
            if (expr == null) {
                return true;
            }
            try {
                PhpExpression classReference = reference.getClassReference();
                if (classReference != null && ("$this".equals(classReference.getText()) || "self".equals(classReference.getText()) && !PhpLangUtil.canBeResolvedInSubclasses((PsiElement)classReference)) && reference.getNameNode() != null) {
                    return this.processFieldAccessInstruction(instruction, reference);
                }
                return true;
            }
            catch (ProcessCanceledException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException("expr = " + expr.getText() + " for " + this.myClass.getText(), e);
            }
        }

        protected abstract boolean processFieldAccessInstruction(PhpAccessInstruction var1, FieldReference var2);
    }
}

