/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.psi.elements.impl;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.ObjectUtils;
import com.jetbrains.php.lang.documentation.phpdoc.parser.tags.PhpDocTagParser;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.PhpExpression;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.impl.PhpTypedElementImpl;
import com.jetbrains.php.lang.psi.resolve.types.PhpArrayFunctionsProcessorParameterTypeProvider;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.stubs.PhpTypedStub;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpExpressionImpl
extends PhpTypedElementImpl
implements PhpExpression,
PhpElementTypes {
    public static final String CALLABLE_PARAMS_TYPES_SEPARATOR = String.valueOf('\u1913');

    public PhpExpressionImpl(ASTNode node) {
        super(node);
    }

    protected PhpExpressionImpl(PhpTypedStub stub, @NotNull IElementType nodeType) {
        if (nodeType == null) {
            PhpExpressionImpl.$$$reportNull$$$0(0);
        }
        super(stub, nodeType);
    }

    @Nullable
    public PhpPsiElement getValue() {
        PhpPsiElement child = this.getFirstPsiChild();
        if (child == null) {
            return null;
        }
        IElementType type = child.getNode().getElementType();
        return type != PhpElementTypes.HASH_ARRAY_ELEMENT && type != PhpElementTypes.ARRAY_VALUE ? child : null;
    }

    @Override
    protected void accept(@NotNull PhpElementVisitor phpElementVisitor) {
        if (phpElementVisitor == null) {
            PhpExpressionImpl.$$$reportNull$$$0(1);
        }
        phpElementVisitor.visitPhpExpression((PhpExpression)this);
    }

    @Override
    @NotNull
    public PhpType getType() {
        if (this.getNode().getElementType() == NUMBER) {
            if (this.getNumberType().equals("\\float")) {
                PhpType phpType = PhpType.FLOAT;
                if (phpType == null) {
                    PhpExpressionImpl.$$$reportNull$$$0(2);
                }
                return phpType;
            }
            String text = PhpPsiUtil.getLiteralText((PsiElement)this);
            if (PhpDocTagParser.isIntRangeBound((String)text)) {
                PhpType phpType = PhpType.createParametrized((String)"\\int", (String[])new String[]{text, text});
                if (phpType == null) {
                    PhpExpressionImpl.$$$reportNull$$$0(3);
                }
                return phpType;
            }
            PhpType phpType = PhpType.INT;
            if (phpType == null) {
                PhpExpressionImpl.$$$reportNull$$$0(4);
            }
            return phpType;
        }
        if (this.getNode().getElementType() == CLOSURE) {
            List types;
            Function function = (Function)ObjectUtils.tryCast((Object)this.getFirstPsiChild(), Function.class);
            if (function != null && !(types = (List)StreamEx.of((Object[])function.getParameters()).map(p -> PhpExpressionImpl.serializeAdvancedClosureParameter(p.getName(), PhpExpressionImpl.serializeCallableTypes(p.getDeclaredType()))).append((Object)PhpExpressionImpl.serializeCallableTypes(PhpExpressionImpl.getFunctionType(function))).collect(Collectors.toList())).isEmpty()) {
                PhpType phpType = PhpType.from((String[])new String[]{PhpType.createParametrizedType((String)"\\Closure", (Collection)types)});
                if (phpType == null) {
                    PhpExpressionImpl.$$$reportNull$$$0(5);
                }
                return phpType;
            }
            PhpType phpType = PhpType.CLOSURE;
            if (phpType == null) {
                PhpExpressionImpl.$$$reportNull$$$0(6);
            }
            return phpType;
        }
        PhpType phpType = super.getType();
        if (phpType == null) {
            PhpExpressionImpl.$$$reportNull$$$0(7);
        }
        return phpType;
    }

    @NotNull
    private static String serializeCallableTypes(PhpType p) {
        String string = StringUtil.join((Collection)p.getTypesWithParametrisedParts(), (String)CALLABLE_PARAMS_TYPES_SEPARATOR);
        if (string == null) {
            PhpExpressionImpl.$$$reportNull$$$0(8);
        }
        return string;
    }

    @NotNull
    private static PhpType getFunctionType(Function function) {
        PhpType type = function.getType().filterOut(PhpArrayFunctionsProcessorParameterTypeProvider.KEY::signed);
        if (type.size() == 1) {
            PhpType phpType = type;
            if (phpType == null) {
                PhpExpressionImpl.$$$reportNull$$$0(9);
            }
            return phpType;
        }
        if (type.filterUnknown().size() == 1) {
            PhpType phpType = type.filterUnknown();
            if (phpType == null) {
                PhpExpressionImpl.$$$reportNull$$$0(10);
            }
            return phpType;
        }
        PhpType phpType = type;
        if (phpType == null) {
            PhpExpressionImpl.$$$reportNull$$$0(11);
        }
        return phpType;
    }

    @Override
    public String toString() {
        return PhpExpressionImpl.toStringWithValue((PsiElement)this, this.getText());
    }

    @NotNull
    public String getNumberType() {
        IElementType type = this.findChildByType(PhpTokenTypes.tsNUMBERS).getNode().getElementType();
        return PhpTokenTypes.FLOAT_LITERAL.equals(type) ? "\\float" : "\\int";
    }

    @NotNull
    public static String serializeAdvancedClosureParameter(String name, String types) {
        String string = "#" + CALLABLE_PARAMS_TYPES_SEPARATOR + name + CALLABLE_PARAMS_TYPES_SEPARATOR + types;
        if (string == null) {
            PhpExpressionImpl.$$$reportNull$$$0(12);
        }
        return string;
    }

    @NotNull
    public static Pair<String, PhpType> getTypeFromSerializedClosureParameter(String serializedType) {
        int nameEnd;
        String name = "";
        if (serializedType.startsWith("#" + CALLABLE_PARAMS_TYPES_SEPARATOR) && (nameEnd = serializedType.indexOf(CALLABLE_PARAMS_TYPES_SEPARATOR, 2)) >= 0) {
            name = serializedType.substring(2, nameEnd);
            serializedType = serializedType.substring(nameEnd + 1);
        }
        PhpType type = new PhpType();
        StringUtil.split((String)serializedType, (String)CALLABLE_PARAMS_TYPES_SEPARATOR).forEach(arg_0 -> ((PhpType)type).add(arg_0));
        Pair pair = Pair.create((Object)name, (Object)type);
        if (pair == null) {
            PhpExpressionImpl.$$$reportNull$$$0(13);
        }
        return pair;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodeType";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "phpElementVisitor";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/psi/elements/impl/PhpExpressionImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/psi/elements/impl/PhpExpressionImpl";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getType";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "serializeCallableTypes";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getFunctionType";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "serializeAdvancedClosureParameter";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeFromSerializedClosureParameter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13 -> new IllegalStateException(string);
        };
    }
}

