/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.psi.resolve.types;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.resolve.types.PhpCharBasedTypeKey;
import com.jetbrains.php.lang.psi.resolve.types.PhpCharTypeKey;
import com.jetbrains.php.lang.psi.resolve.types.PhpParameterBasedTypeProvider;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.resolve.types.PhpTypeProvider4;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpArithmeticDeferredTypeProvider
implements PhpTypeProvider4 {
    private static final PhpCharBasedTypeKey KEY = new PhpCharTypeKey('\u2207');
    @NotNull
    private static final PhpType INT_STRING = PhpType.or((PhpType)PhpType.INT, (PhpType)PhpType.STRING);

    public char getKey() {
        return KEY.getKey();
    }

    @Nullable
    public PhpType getType(PsiElement element) {
        return null;
    }

    @Nullable
    public PhpType complete(String expression, Project project) {
        List<String> signatures = PhpParameterBasedTypeProvider.extractSignatures(expression, 2);
        List operandTypes = ContainerUtil.map(signatures, s -> PhpArithmeticDeferredTypeProvider.computeOperandType(project, s));
        if (ContainerUtil.all((Collection)operandTypes, arg_0 -> ((PhpType)PhpType.STRING).equals(arg_0))) {
            return PhpType.STRING;
        }
        if (ContainerUtil.exists((Iterable)operandTypes, operand -> !operand.isAmbiguous() && !PhpType.intersects((PhpType)operand, (PhpType)PhpType.STRING))) {
            return PhpType.INT;
        }
        if (ContainerUtil.all((Collection)operandTypes, operand -> operand.isAmbiguous())) {
            return PhpType.INT;
        }
        return INT_STRING;
    }

    private static PhpType computeOperandType(Project project, String s) {
        PhpType left = new PhpType();
        PhpParameterBasedTypeProvider.extractSignatures(s, 0).forEach(arg_0 -> ((PhpType)left).add(arg_0));
        return left.global(project);
    }

    public Collection<? extends PhpNamedElement> getBySignature(String expression, Set<String> visited, int depth, Project project) {
        return null;
    }

    @NotNull
    public static PhpType encodeBitwiseOperandTypesType(PhpType ... types) {
        String wrappedTypes = PhpParameterBasedTypeProvider.wrapTypes(ContainerUtil.map((Object[])types, t -> PhpParameterBasedTypeProvider.wrapTypes(t.getTypes())));
        PhpType phpType = new PhpType().add(KEY.sign(wrappedTypes));
        if (phpType == null) {
            PhpArithmeticDeferredTypeProvider.$$$reportNull$$$0(0);
        }
        return phpType;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/php/lang/psi/resolve/types/PhpArithmeticDeferredTypeProvider", "encodeBitwiseOperandTypesType"));
    }
}

