/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.psi.resolve.types;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.lang.documentation.phpdoc.PhpDocUtil;
import com.jetbrains.php.lang.documentation.phpdoc.lexer.PhpDocTokenTypes;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocComment;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocType;
import com.jetbrains.php.lang.documentation.phpdoc.psi.tags.PhpDocTag;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpClassMember;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.resolve.types.PhpCharBasedTypeKey;
import com.jetbrains.php.lang.psi.resolve.types.PhpCharTypeKey;
import com.jetbrains.php.lang.psi.resolve.types.PhpDocPrefixProvider;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.resolve.types.PhpTypeProvider4;
import com.jetbrains.php.lang.psi.resolve.types.generics.PhpGenericsExtendedTypeProvider;
import com.jetbrains.php.lang.psi.stubs.indexes.PhpDocTypeAliasesIndex;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpDocTagAliasTypeProvider
implements PhpTypeProvider4 {
    public static final PhpCharBasedTypeKey KEY = new PhpCharTypeKey('\u1792');
    public static final String TYPE_TAG_POSTFIX = "type";
    public static final String IMPORT_TYPE_TAG_POSTFIX = "import-type";

    public char getKey() {
        return KEY.getKey();
    }

    @Nullable
    public PhpType getType(PsiElement element) {
        if (element instanceof PhpDocType) {
            PhpType type = new PhpType();
            for (PhpDocTag tag : PhpDocTagAliasTypeProvider.resolveTypeAliases((PhpDocType)element)) {
                List<PhpDocType> docType = PhpPsiUtil.getChildren((PsiElement)tag, (Condition<? super PsiElement>)((Condition)PhpDocType.class::isInstance));
                if (tag.getName().endsWith("-import-type")) {
                    PsiElement aliasName = PhpPsiUtil.getChildOfType((PsiElement)tag, PhpDocTokenTypes.DOC_IDENTIFIER);
                    PhpDocType fromType = (PhpDocType)ContainerUtil.getOnlyItem(docType);
                    if (aliasName == null || fromType == null) continue;
                    type.add(KEY.sign(fromType.getFQN() + "." + aliasName.getText()));
                    continue;
                }
                docType.forEach(arg_0 -> ((PhpType)type).add(arg_0));
            }
            return type;
        }
        return null;
    }

    public static Collection<PhpDocTag> resolveTypeAliases(PhpDocType phpDocType) {
        PhpNamedElement closestDeclarationForDoc;
        String name = phpDocType.getName();
        if (name == null || phpDocType.getText().indexOf(92) >= 0) {
            return Collections.emptyList();
        }
        PhpDocComment docComment = PhpPsiUtil.getParentOfClass((PsiElement)phpDocType, PhpDocComment.class);
        if (docComment == null) {
            return Collections.emptyList();
        }
        PsiElement docCommentOwner = (PsiElement)ObjectUtils.notNull((Object)docComment.getOwner(), (Object)docComment);
        while ((closestDeclarationForDoc = PhpDocTagAliasTypeProvider.getClosestDeclarationForDoc(docCommentOwner)) != null) {
            Collection<PhpDocTag> types = PhpDocTagAliasTypeProvider.resolveLocalTypeFromTypeAlias(name, closestDeclarationForDoc.getDocComment());
            if (!types.isEmpty()) {
                return types;
            }
            docCommentOwner = docCommentOwner.getParent();
        }
        return Collections.emptyList();
    }

    @Nullable
    private static PhpNamedElement getClosestDeclarationForDoc(@NotNull PsiElement owner) {
        if (owner == null) {
            PhpDocTagAliasTypeProvider.$$$reportNull$$$0(0);
        }
        return (PhpNamedElement)PhpPsiUtil.getParentByCondition(owner, false, (Condition<? super PsiElement>)((Condition)e -> e instanceof PhpClassMember || e instanceof Function || e instanceof PhpClass));
    }

    @NotNull
    private static Collection<PhpDocTag> resolveLocalTypeFromTypeAlias(String name, @Nullable PhpDocComment docComment) {
        if (docComment == null || !PhpDocTagAliasTypeProvider.canContainTagAlias(docComment)) {
            List<PhpDocTag> list = Collections.emptyList();
            if (list == null) {
                PhpDocTagAliasTypeProvider.$$$reportNull$$$0(1);
            }
            return list;
        }
        HashSet<PhpDocTag> res = new HashSet<PhpDocTag>();
        for (PhpDocPrefixProvider provider : PhpDocPrefixProvider.EP_NAME.getExtensionList()) {
            PhpDocUtil.processTagElementsByNames(docComment, tag -> {
                PsiElement identifier = PhpDocTagAliasTypeProvider.getAliasIdentifier(tag);
                if (identifier != null && identifier.textMatches((CharSequence)name)) {
                    res.add((PhpDocTag)tag);
                }
            }, provider.getPrefix() + TYPE_TAG_POSTFIX, provider.getPrefix() + IMPORT_TYPE_TAG_POSTFIX);
        }
        HashSet<PhpDocTag> hashSet = res;
        if (hashSet == null) {
            PhpDocTagAliasTypeProvider.$$$reportNull$$$0(2);
        }
        return hashSet;
    }

    private static boolean canContainTagAlias(@NotNull PhpDocComment docComment) {
        if (docComment == null) {
            PhpDocTagAliasTypeProvider.$$$reportNull$$$0(3);
        }
        return (Boolean)CachedValuesManager.getCachedValue((PsiElement)docComment, () -> {
            List providers = PhpDocPrefixProvider.EP_NAME.getExtensionList();
            String text = docComment.getText();
            boolean r = ContainerUtil.exists((Iterable)providers, p -> text.contains(p.getPrefix() + TYPE_TAG_POSTFIX) || text.contains(p.getPrefix() + IMPORT_TYPE_TAG_POSTFIX));
            return CachedValueProvider.Result.createSingleDependency((Object)r, (Object)docComment);
        });
    }

    @Nullable
    public static PsiElement getAliasIdentifier(PhpDocTag tag) {
        PsiElement identifier = PhpPsiUtil.getChildOfType((PsiElement)tag, PhpDocTokenTypes.DOC_IDENTIFIER);
        if (PhpDocPrefixProvider.EP_NAME.getExtensionList().stream().anyMatch(p -> tag.getName().equals(p.getPrefix() + IMPORT_TYPE_TAG_POSTFIX))) {
            return PhpGenericsExtendedTypeProvider.getAliasIdentifierFromImportedType(tag);
        }
        return identifier;
    }

    @Nullable
    public PhpType complete(String expression, Project project) {
        int dimension = PhpType.getPluralDimension((String)expression);
        expression = PhpType.unpluralize((String)expression, (int)dimension);
        String fromClassFQN = PhpDocTagAliasTypeProvider.classFqnFromSignature(expression);
        String typeName = PhpDocTagAliasTypeProvider.typeNameFromSignature(expression);
        return fromClassFQN != null && typeName != null ? PhpDocTypeAliasesIndex.getTypeByAliasName(project, fromClassFQN, typeName).pluralise(dimension) : null;
    }

    private static int getClassFqnTypeSeparatorIndex(@NotNull String signature) {
        int separatorIndex;
        if (signature == null) {
            PhpDocTagAliasTypeProvider.$$$reportNull$$$0(4);
        }
        return (separatorIndex = signature.lastIndexOf(46)) >= 3 && separatorIndex < signature.length() - 2 ? separatorIndex : -1;
    }

    @ApiStatus.Internal
    @Nullable
    public static String classFqnFromSignature(@NotNull String signature) {
        int separatorIndex;
        if (signature == null) {
            PhpDocTagAliasTypeProvider.$$$reportNull$$$0(5);
        }
        return (separatorIndex = PhpDocTagAliasTypeProvider.getClassFqnTypeSeparatorIndex(signature)) >= 0 ? signature.substring(2, separatorIndex) : null;
    }

    @ApiStatus.Internal
    @Nullable
    public static String typeNameFromSignature(@NotNull String signature) {
        int separatorIndex;
        if (signature == null) {
            PhpDocTagAliasTypeProvider.$$$reportNull$$$0(6);
        }
        return (separatorIndex = PhpDocTagAliasTypeProvider.getClassFqnTypeSeparatorIndex(signature)) >= 0 ? signature.substring(separatorIndex + 1) : null;
    }

    public Collection<? extends PhpNamedElement> getBySignature(String expression, Set<String> visited, int depth, Project project) {
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/psi/resolve/types/PhpDocTagAliasTypeProvider";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "docComment";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "signature";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/psi/resolve/types/PhpDocTagAliasTypeProvider";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveLocalTypeFromTypeAlias";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getClosestDeclarationForDoc";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "canContainTagAlias";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getClassFqnTypeSeparatorIndex";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "classFqnFromSignature";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "typeNameFromSignature";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2 -> new IllegalStateException(string);
        };
    }
}

