/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.psi.resolve.types;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpIndex;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.MethodReference;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.lang.psi.elements.PhpAttribute;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.elements.PhpReference;
import com.jetbrains.php.lang.psi.elements.impl.FunctionImpl;
import com.jetbrains.php.lang.psi.elements.impl.PhpReferenceImpl;
import com.jetbrains.php.lang.psi.resolve.types.PhpCharBasedTypeKey;
import com.jetbrains.php.lang.psi.resolve.types.PhpCharTypeKey;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.resolve.types.PhpTypeProvider4;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpReturnTypeContractTP
implements PhpTypeProvider4 {
    public static final Set<@NotNull String> FUNCTION_NAMES = Set.of("microtime", "gettimeofday", "fscanf", "sscanf");
    public static final PhpCharBasedTypeKey KEY = new PhpCharTypeKey('\u7401');
    private static final String ARGUMENTS_DELIMITER = ".";
    private static final String TRUE = "true";
    private static final String FALSE = "false";
    private static final String EXISTS = "exists";
    private static final String NOT_EXISTS = "notExists";
    private static final String NULL = "null";
    public static final String ATTRIBUTE_FQN = "\\JetBrains\\PhpStorm\\Internal\\ReturnTypeContract";

    public char getKey() {
        return KEY.getKey();
    }

    @Nullable
    public PhpType getType(PsiElement element) {
        if (element instanceof FunctionReference && !(element instanceof MethodReference)) {
            String name = ((FunctionReference)element).getName();
            if (ApplicationManager.getApplication().isUnitTestMode() || name != null && FUNCTION_NAMES.contains(name)) {
                if (!PhpReferenceImpl.allowGlobal((PhpReference)((FunctionReference)element))) {
                    return null;
                }
                String arguments = StringUtil.join((Object[])((FunctionReference)element).getParameters(), PhpReturnTypeContractTP::getConstantValue, (String)ARGUMENTS_DELIMITER);
                return new PhpType().add(KEY.sign(((FunctionReference)element).getFQN() + ARGUMENTS_DELIMITER + arguments));
            }
        }
        return null;
    }

    private static String getConstantValue(PsiElement argument) {
        if (PhpLangUtil.isTrue(argument)) {
            return TRUE;
        }
        if (PhpLangUtil.isFalse(argument)) {
            return FALSE;
        }
        return NULL;
    }

    @Nullable
    public PhpType complete(String expression, Project project) {
        String subject = expression.substring(2);
        int firstDelimiter = subject.indexOf(ARGUMENTS_DELIMITER);
        List arguments = StringUtil.split((String)subject.substring(firstDelimiter + 1), (String)ARGUMENTS_DELIMITER);
        PhpType res = new PhpType();
        for (Function function : PhpIndex.getInstance((Project)project).getFunctionsByFQN(subject.substring(0, firstDelimiter))) {
            if (!PhpLangUtil.isGlobalNamespaceFQN(function.getNamespaceName())) {
                return null;
            }
            Parameter[] parameters = function.getParameters();
            int length = parameters.length;
            for (int i = 0; i < length; ++i) {
                PhpAttribute contractAttribute = (PhpAttribute)ContainerUtil.getFirstItem((Collection)parameters[i].getAttributes(ATTRIBUTE_FQN));
                if (contractAttribute == null) continue;
                String actualArgumentValue = PhpReturnTypeContractTP.findArgumentByName(contractAttribute, FALSE) != null ? (i < arguments.size() ? (String)arguments.get(i) : FALSE) : (i < arguments.size() ? EXISTS : NOT_EXISTS);
                res.add(PhpReturnTypeContractTP.getType((FunctionImpl)function, contractAttribute, actualArgumentValue));
            }
        }
        return res;
    }

    private static PhpType getType(FunctionImpl function, PhpAttribute contractAttribute, String actualArgumentValue) {
        PhpType res = new PhpType();
        PhpAttribute.PhpAttributeArgument returnTypeArgument = PhpReturnTypeContractTP.findArgumentByName(contractAttribute, actualArgumentValue);
        if (returnTypeArgument != null) {
            StringUtil.split((String)StringUtil.unquoteString((String)returnTypeArgument.getArgument().getValue()), (String)"|").forEach(arg_0 -> ((PhpType)res).add(arg_0));
        } else {
            res.add(function.getLocalType(false));
        }
        return res;
    }

    @Nullable
    private static PhpAttribute.PhpAttributeArgument findArgumentByName(PhpAttribute contractAttribute, String name) {
        return (PhpAttribute.PhpAttributeArgument)ContainerUtil.find((Iterable)contractAttribute.getArguments(), arg -> arg.getName().equals(name));
    }

    public Collection<? extends PhpNamedElement> getBySignature(String expression, Set<String> visited, int depth, Project project) {
        return Collections.emptyList();
    }
}

