/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.psi.resolve.types;

import com.google.common.collect.FluentIterable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.jetbrains.php.PhpIndex;
import com.jetbrains.php.PhpIndexImpl;
import com.jetbrains.php.codeInsight.PhpScopeHolder;
import com.jetbrains.php.codeInsight.controlFlow.PhpControlFlowUtil;
import com.jetbrains.php.codeInsight.controlFlow.PhpInstructionProcessor;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpAccessFieldByVariableInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpAccessFieldInObjectContextInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpAccessVariableInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpArrayAccessInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpExitPointInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpInstruction;
import com.jetbrains.php.codeInsight.typeInference.PhpArrayAccessTypeAnalyzer;
import com.jetbrains.php.codeInsight.typeInference.PhpFieldReferenceArrayAccessTypeAnalyzer;
import com.jetbrains.php.codeInsight.typeInference.PhpFieldReferenceByVariableTypeAnalyzer;
import com.jetbrains.php.codeInsight.typeInference.PhpFieldReferenceInObjectContextTypeAnalyzer;
import com.jetbrains.php.codeInsight.typeInference.PhpTypeAnalyzerProcessor;
import com.jetbrains.php.codeInsight.typeInference.PhpVariableArrayAccessTypeAnalyzer;
import com.jetbrains.php.codeInsight.typeInference.PhpVariableDocDeclaredTypeAnalyzerProcessor;
import com.jetbrains.php.codeInsight.typeInference.PhpVariableInferredTypeAnalyzerProcessor;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.annotator.PhpAnnotatorVisitor;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocComment;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocType;
import com.jetbrains.php.lang.documentation.phpdoc.psi.impl.PhpDocMethodTagImpl;
import com.jetbrains.php.lang.documentation.phpdoc.psi.impl.PhpDocTypeImpl;
import com.jetbrains.php.lang.documentation.phpdoc.psi.tags.PhpDocParamTag;
import com.jetbrains.php.lang.documentation.phpdoc.psi.tags.PhpDocTag;
import com.jetbrains.php.lang.intentions.PhpReplaceIfWithTernaryIntention;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ArrayAccessExpression;
import com.jetbrains.php.lang.psi.elements.ArrayCreationExpression;
import com.jetbrains.php.lang.psi.elements.ArrayHashElement;
import com.jetbrains.php.lang.psi.elements.ArrayIndex;
import com.jetbrains.php.lang.psi.elements.AssignmentExpression;
import com.jetbrains.php.lang.psi.elements.BinaryExpression;
import com.jetbrains.php.lang.psi.elements.Catch;
import com.jetbrains.php.lang.psi.elements.ClassConstantReference;
import com.jetbrains.php.lang.psi.elements.ClassReference;
import com.jetbrains.php.lang.psi.elements.Constant;
import com.jetbrains.php.lang.psi.elements.ConstantReference;
import com.jetbrains.php.lang.psi.elements.Field;
import com.jetbrains.php.lang.psi.elements.FieldReference;
import com.jetbrains.php.lang.psi.elements.ForeachStatement;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.Global;
import com.jetbrains.php.lang.psi.elements.MemberReference;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.MethodReference;
import com.jetbrains.php.lang.psi.elements.MultiassignmentExpression;
import com.jetbrains.php.lang.psi.elements.NewExpression;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.lang.psi.elements.ParenthesizedExpression;
import com.jetbrains.php.lang.psi.elements.PhpCallableFunction;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpEnumCase;
import com.jetbrains.php.lang.psi.elements.PhpExpression;
import com.jetbrains.php.lang.psi.elements.PhpMatchArm;
import com.jetbrains.php.lang.psi.elements.PhpMatchExpression;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.PhpReference;
import com.jetbrains.php.lang.psi.elements.PhpReturn;
import com.jetbrains.php.lang.psi.elements.PhpReturnType;
import com.jetbrains.php.lang.psi.elements.PhpTypedElement;
import com.jetbrains.php.lang.psi.elements.PhpUseList;
import com.jetbrains.php.lang.psi.elements.SelfAssignmentExpression;
import com.jetbrains.php.lang.psi.elements.TernaryExpression;
import com.jetbrains.php.lang.psi.elements.UnaryExpression;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.lang.psi.elements.impl.ArrayCreationExpressionImpl;
import com.jetbrains.php.lang.psi.elements.impl.ParameterImpl;
import com.jetbrains.php.lang.psi.elements.impl.PhpClassImpl;
import com.jetbrains.php.lang.psi.elements.impl.PhpMatchExpressionImpl;
import com.jetbrains.php.lang.psi.resolve.types.PhpArithmeticDeferredTypeProvider;
import com.jetbrains.php.lang.psi.resolve.types.PhpExcludeTypeTP;
import com.jetbrains.php.lang.psi.resolve.types.PhpGeneraliseIntRangeTypeProvider;
import com.jetbrains.php.lang.psi.resolve.types.PhpOptionalCompletionTP;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.resolve.types.PhpTypeProvider4;
import com.jetbrains.php.lang.psi.resolve.types.PhpTypeSignatureKey;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpTypeAnalyserVisitor
extends PhpElementVisitor
implements PhpElementTypes {
    public static final boolean INFER_FROM_CONSTRUCTOR = true;
    public static final int MAX_ARRAY_VALUES = Registry.intValue((String)"php.type.inference.max.array.values", (int)100);
    private static final Logger LOG = Logger.getInstance(PhpTypeAnalyserVisitor.class);
    @NotNull
    private PhpType type = new PhpType();
    private boolean myFilterOutMixed;
    private boolean mySelfAssignmentToInt;

    public void addType(@Nullable PsiElement element) {
        this.type.add(element);
    }

    public void addType(@Nullable String signature) {
        this.type.add(signature);
    }

    public void addType(@NotNull PhpType phpType) {
        if (phpType == null) {
            PhpTypeAnalyserVisitor.$$$reportNull$$$0(0);
        }
        if (!phpType.isEmpty()) {
            this.type.add(phpType);
        }
    }

    public void addType(@NotNull Collection<String> types) {
        if (types == null) {
            PhpTypeAnalyserVisitor.$$$reportNull$$$0(1);
        }
        for (String s : types) {
            this.type.add(s);
        }
    }

    public boolean addTypeFromExpression(@NotNull PhpExpression curAnchor) {
        PsiElement parent;
        if (curAnchor == null) {
            PhpTypeAnalyserVisitor.$$$reportNull$$$0(2);
        }
        if (curAnchor instanceof Variable) {
            Variable assignedVariable;
            AssignmentExpression assignment;
            Function function;
            Variable variable = (Variable)curAnchor;
            PsiElement parent2 = variable.getParent();
            if (parent2 instanceof Catch) {
                PhpType phpType = new PhpType().add(PhpType.EXCEPTION);
                ((Catch)parent2).getExceptionTypes().forEach(arg_0 -> ((PhpType)phpType).add(arg_0));
                this.addType(phpType);
                return true;
            }
            if (parent2 instanceof Global) {
                this.addType(new PhpType().add(variable.getSignature()));
                return true;
            }
            if (parent2 instanceof PhpUseList && PhpReplaceIfWithTernaryIntention.isPassedByReference((PsiElement)variable) && (function = (Function)ObjectUtils.tryCast((Object)parent2.getParent(), Function.class)) != null && function.isClosure() && (assignment = PhpPsiUtil.getParentOfClass((PsiElement)function, AssignmentExpression.class)) != null && (assignedVariable = (Variable)ObjectUtils.tryCast((Object)assignment.getVariable(), Variable.class)) != null && PhpLangUtil.equalsVariableNames(assignedVariable.getName(), variable.getName()) && PsiTreeUtil.isAncestor((PsiElement)assignment.getValue(), (PsiElement)function, (boolean)false)) {
                this.addType(new PhpType().add(assignedVariable.getType()));
                return true;
            }
        }
        if (PhpPsiUtil.isOfType(parent = curAnchor.getParent(), ARRAY_VALUE)) {
            PsiElement grandParent = parent.getParent();
            PsiElement psiElement = parent = grandParent instanceof ArrayCreationExpression ? grandParent.getParent() : grandParent;
        }
        if (parent instanceof MultiassignmentExpression) {
            PhpPsiElement valueExpression = ((MultiassignmentExpression)parent).getValue();
            if (PhpPsiUtil.isOfType((PsiElement)valueExpression, EXPRESSION)) {
                PhpPsiElement value = valueExpression.getFirstPsiChild();
                if (value instanceof ArrayCreationExpression) {
                    int pos = PhpTypeAnalyserVisitor.findPos(curAnchor.getParent());
                    FluentIterable children = ArrayCreationExpressionImpl.children((ArrayCreationExpression)value).limit(pos + 1);
                    List arrayValues = ContainerUtil.map((Iterable)children, e -> e instanceof ArrayHashElement ? ((ArrayHashElement)e).getValue() : e.getFirstPsiChild());
                    if (!arrayValues.isEmpty() && pos < arrayValues.size()) {
                        this.addType((PsiElement)arrayValues.get(pos));
                        return true;
                    }
                }
                if (value instanceof PhpTypedElement) {
                    this.addType(((PhpTypedElement)value).getType().elementType());
                    return true;
                }
            }
        } else if (parent instanceof SelfAssignmentExpression) {
            SelfAssignmentExpression selfAssignmentExpression = (SelfAssignmentExpression)parent;
            PhpPsiElement variable = selfAssignmentExpression.getVariable();
            if (variable == curAnchor) {
                PsiElement operation = selfAssignmentExpression.getOperation();
                if (operation != null && PhpPsiUtil.isOfType(operation, PhpTokenTypes.opCONCAT_ASGN)) {
                    this.addType(PhpType.STRING);
                    return true;
                }
                PhpPsiElement value = selfAssignmentExpression.getValue();
                if (value instanceof PhpTypedElement) {
                    PhpType type = ((PhpTypedElement)value).getType();
                    if (!PhpPsiUtil.isOfType(operation, PhpTokenTypes.opCOALESCE_ASGN)) {
                        type = type.filterFalse();
                    }
                    this.addType(type);
                    if (PhpPsiUtil.isOfType(operation, PhpTokenTypes.tsMATH_ASGN_OPS) && type.equals((Object)PhpType.INT)) {
                        this.mySelfAssignmentToInt = true;
                        return false;
                    }
                    return !PhpPsiUtil.isOfType(operation, PhpTokenTypes.tsBIT_ASGN_OPS) && !ContainerUtil.exists((Iterable)type.getTypes(), t -> PhpType.isArray((String)t) || PhpType.isPluralType((String)t));
                }
            }
        } else if (parent instanceof AssignmentExpression) {
            PhpPsiElement value;
            AssignmentExpression assignmentExpression = (AssignmentExpression)parent;
            if (assignmentExpression.getVariable() == curAnchor && (value = assignmentExpression.getValue()) instanceof PhpTypedElement) {
                this.addType(((PhpTypedElement)value).getType());
                return true;
            }
        } else if (parent instanceof ArrayAccessExpression && this.extractTypeFromArrayAccessExpression((ArrayAccessExpression)parent)) {
            return false;
        }
        return false;
    }

    protected boolean extractTypeFromArrayAccessExpression(ArrayAccessExpression arrayAccessExpression) {
        ArrayIndex arrayIndex = arrayAccessExpression.getIndex();
        if (arrayIndex != null && arrayIndex.getFirstPsiChild() == null) {
            this.addType(PhpType.ARRAY);
            return true;
        }
        return false;
    }

    public Collection<? extends PhpTypeProvider4> getTypeProviders(@NotNull PsiElement psi) {
        if (psi == null) {
            PhpTypeAnalyserVisitor.$$$reportNull$$$0(3);
        }
        return ((PhpIndexImpl)PhpIndex.getInstance((Project)psi.getProject())).getTypeProviders();
    }

    @NotNull
    private static PhpType getDocTypeFromAnonymousDoc(PhpReturn returnStatement) {
        PhpDocComment docComment = PhpPsiUtil.getDocCommentFor((PhpPsiElement)returnStatement);
        PhpDocParamTag tag = docComment != null ? docComment.getVarTag() : null;
        PhpType phpType = tag != null && StringUtil.isEmpty((String)tag.getVarName()) ? tag.getType() : PhpType.EMPTY;
        if (phpType == null) {
            PhpTypeAnalyserVisitor.$$$reportNull$$$0(4);
        }
        return phpType;
    }

    @NotNull
    public PhpType getTypeFromAST(@NotNull PsiElement psi) {
        PhpType typeFromAnonymousDoc;
        if (psi == null) {
            PhpTypeAnalyserVisitor.$$$reportNull$$$0(5);
        }
        if ((typeFromAnonymousDoc = this.tryGetTypeFromAnonymousReturnDoc(psi)) != null) {
            PhpType phpType = typeFromAnonymousDoc;
            if (phpType == null) {
                PhpTypeAnalyserVisitor.$$$reportNull$$$0(6);
            }
            return phpType;
        }
        psi.accept((PsiElementVisitor)this);
        PhpType phpType = this.getType();
        if (phpType == null) {
            PhpTypeAnalyserVisitor.$$$reportNull$$$0(7);
        }
        return phpType;
    }

    @Nullable
    private PhpType tryGetTypeFromAnonymousReturnDoc(PsiElement psi) {
        PhpType typeFromAnonymousDoc;
        PsiElement parent;
        if (psi instanceof PhpExpression && (parent = psi.getParent()) instanceof PhpReturn && ((PhpReturn)parent).getArgument() == psi && !(typeFromAnonymousDoc = PhpTypeAnalyserVisitor.getDocTypeFromAnonymousDoc((PhpReturn)parent)).isEmpty()) {
            this.myFilterOutMixed = true;
            return PhpType.from((PhpType[])new PhpType[]{typeFromAnonymousDoc});
        }
        return null;
    }

    private static int findPos(PsiElement element) {
        int i = 0;
        while ((element = PhpPsiUtil.getPrevSiblingByCondition(element, (Condition<? super PsiElement>)((Condition)e -> PhpPsiUtil.isOfType(e, PhpTokenTypes.opCOMMA)))) != null) {
            ++i;
        }
        return i;
    }

    public boolean filterOutMixed() {
        return this.myFilterOutMixed;
    }

    @Nullable
    private static PhpType inferType(@NotNull PhpPsiElement curAnchor) {
        ArrayAccessExpression arrayAccessExpression;
        ArrayIndex arrayIndex;
        PsiElement grandParent;
        PsiElement parent;
        if (curAnchor == null) {
            PhpTypeAnalyserVisitor.$$$reportNull$$$0(8);
        }
        if (curAnchor instanceof Variable) {
            Variable assignedVariable;
            AssignmentExpression assignment;
            Function function;
            Variable variable = (Variable)curAnchor;
            PsiElement parent2 = variable.getParent();
            if (parent2 instanceof Catch) {
                PhpType phpType = new PhpType().add(PhpType.EXCEPTION);
                ((Catch)parent2).getExceptionTypes().forEach(arg_0 -> ((PhpType)phpType).add(arg_0));
                return phpType;
            }
            if (parent2 instanceof Global) {
                return new PhpType().add(variable.getSignature());
            }
            if (parent2 instanceof PhpUseList && PhpReplaceIfWithTernaryIntention.isPassedByReference((PsiElement)variable) && (function = (Function)ObjectUtils.tryCast((Object)parent2.getParent(), Function.class)) != null && function.isClosure() && (assignment = PhpPsiUtil.getParentOfClass((PsiElement)function, AssignmentExpression.class)) != null && (assignedVariable = (Variable)ObjectUtils.tryCast((Object)assignment.getVariable(), Variable.class)) != null && PhpLangUtil.equalsVariableNames(assignedVariable.getName(), variable.getName()) && PsiTreeUtil.isAncestor((PsiElement)assignment.getValue(), (PsiElement)function, (boolean)false)) {
                return new PhpType().add(assignedVariable.getType());
            }
        }
        if (PhpPsiUtil.isOfType(parent = curAnchor.getParent(), ARRAY_VALUE) && (grandParent = parent.getParent()) instanceof ArrayCreationExpression) {
            parent = grandParent.getParent();
        }
        if (parent instanceof MultiassignmentExpression) {
            PhpPsiElement value;
            PhpPsiElement valueExpression = ((MultiassignmentExpression)parent).getValue();
            if (PhpPsiUtil.isOfType((PsiElement)valueExpression, EXPRESSION) && (value = valueExpression.getFirstPsiChild()) instanceof PhpTypedElement) {
                return ((PhpTypedElement)value).getType().elementType();
            }
        } else if (parent instanceof SelfAssignmentExpression) {
            SelfAssignmentExpression selfAssignmentExpression = (SelfAssignmentExpression)parent;
            PhpPsiElement variable = selfAssignmentExpression.getVariable();
            if (variable == curAnchor) {
                PsiElement operation = selfAssignmentExpression.getOperation();
                if (operation != null && PhpPsiUtil.isOfType(operation, PhpTokenTypes.opCONCAT_ASGN)) {
                    return PhpType.STRING;
                }
                PhpPsiElement value = selfAssignmentExpression.getValue();
                if (value instanceof PhpTypedElement) {
                    return ((PhpTypedElement)value).getType();
                }
            }
        } else if (parent instanceof AssignmentExpression) {
            PhpPsiElement value;
            AssignmentExpression assignmentExpression = (AssignmentExpression)parent;
            if (assignmentExpression.getVariable() == curAnchor && (value = assignmentExpression.getValue()) instanceof PhpTypedElement) {
                return ((PhpTypedElement)value).getType();
            }
        } else if (parent instanceof ArrayAccessExpression && (arrayIndex = (arrayAccessExpression = (ArrayAccessExpression)parent).getIndex()) != null && arrayIndex.getFirstPsiChild() == null) {
            return PhpType.ARRAY;
        }
        return null;
    }

    @NotNull
    public PhpType getType() {
        PhpType phpType = this.type;
        if (phpType == null) {
            PhpTypeAnalyserVisitor.$$$reportNull$$$0(9);
        }
        return phpType;
    }

    protected void visitPhpReference(PhpReference ref) {
        PhpType localType = ref.resolveLocalType();
        if (!localType.isEmpty()) {
            this.addType(localType);
        } else {
            this.addSignatureTypes(ref);
        }
    }

    private void addSignatureTypes(PhpReference ref) {
        for (String s : ref.getSignatureParts()) {
            this.addType(s);
        }
    }

    public void visitPhpUnaryExpression(UnaryExpression expression) {
        IElementType o = expression.getOperation().getNode().getElementType();
        if (PhpPsiUtil.isOfType((PsiElement)expression, PhpElementTypes.INFIX_EXPRESSION)) {
            if (o != PhpTokenTypes.opPLUS && o != PhpTokenTypes.opMINUS) {
                if (o == PhpTokenTypes.opBIT_NOT) {
                    PhpType type = new PhpType().add((PsiElement)expression.getValue());
                    if (type.equals((Object)PhpType.STRING)) {
                        this.addType(PhpType.STRING);
                    } else if (PhpTypeAnalyserVisitor.isUnresolvedWithoutString(type)) {
                        this.addType(PhpType.INT);
                    } else {
                        this.addType(PhpArithmeticDeferredTypeProvider.encodeBitwiseOperandTypesType(type));
                    }
                } else {
                    this.addType(PhpType.BOOLEAN);
                }
            }
        } else if (PhpTokenTypes.tsCAST_OPS.contains(o)) {
            this.addType(PhpTypeAnalyserVisitor.getCastOperationType(o));
        } else if (o == PhpTokenTypes.opNOT) {
            this.addType(PhpType.BOOLEAN);
        } else if (!PhpPsiUtil.isOfType((PsiElement)expression, PhpElementTypes.INFIX_WRITE_EXPRESSION)) {
            this.addType((PsiElement)expression.getValue());
        }
    }

    public static PhpType getCastOperationType(IElementType o) {
        if (o == PhpTokenTypes.opINTEGER_CAST) {
            return PhpType.INT;
        }
        if (o == PhpTokenTypes.opFLOAT_CAST) {
            return PhpType.FLOAT;
        }
        if (o == PhpTokenTypes.opBOOLEAN_CAST) {
            return PhpType.BOOLEAN;
        }
        if (o == PhpTokenTypes.opSTRING_CAST) {
            return PhpType.STRING;
        }
        if (o == PhpTokenTypes.opARRAY_CAST) {
            return PhpType.ARRAY;
        }
        if (o == PhpTokenTypes.opOBJECT_CAST) {
            return PhpType.OBJECT;
        }
        if (o == PhpTokenTypes.opUNSET_CAST) {
            return PhpType.UNSET;
        }
        return PhpType.EMPTY;
    }

    private static boolean isUnresolvedWithoutString(@NotNull PhpType type) {
        if (type == null) {
            PhpTypeAnalyserVisitor.$$$reportNull$$$0(10);
        }
        return !type.hasUnresolved() && !PhpType.intersects((PhpType)PhpType.STRING, (PhpType)type);
    }

    public void visitPhpVariable(Variable variable) {
        PhpType docType = variable.getDocType();
        this.addType(docType);
        if (!docType.isEmpty()) {
            this.myFilterOutMixed = true;
            return;
        }
        this.addInferredType(variable, new PhpVariableDocDeclaredTypeAnalyzerProcessor(variable));
    }

    public void addInferredType(Variable variable, PhpTypeAnalyzerProcessor variableDeclaredTypeAnalyzer) {
        PhpScopeHolder scopeHolder;
        CharSequence variableName;
        if (PhpLangUtil.isThisReference((PsiElement)variable)) {
            this.addType(PhpTypeAnalyserVisitor.getBoundClassType(variable));
        }
        if (StringUtil.isEmpty((CharSequence)(variableName = variable.getNameCS()))) {
            return;
        }
        PhpAccessVariableInstruction instruction = PhpControlFlowUtil.getAccessInstruction((PhpPsiElement)variable, PhpAccessVariableInstruction.class);
        PhpType inferredDocType = PhpTypeAnalyserVisitor.inferDocType(variableDeclaredTypeAnalyzer, instruction);
        this.addType(inferredDocType);
        if (inferredDocType.isNotExtendablePrimitiveType()) {
            return;
        }
        PsiElement parent = variable.getParent();
        if (parent instanceof ForeachStatement && (((ForeachStatement)parent).getKey() == variable || ((ForeachStatement)parent).getValue() == variable)) {
            return;
        }
        boolean finish = this.addTypeFromExpression((PhpExpression)variable);
        if (!finish && (scopeHolder = PhpPsiUtil.getScopeHolder((PsiElement)variable)) != null && instruction != null) {
            PhpType inferredType = this.inferVariableType(variable, variableName, (PhpInstruction)instruction, scopeHolder);
            this.addType(!inferredDocType.isEmpty() ? inferredType.filterMixed() : inferredType);
        }
    }

    @NotNull
    private static PhpType getBoundClassType(Variable point) {
        PhpType boundType = PhpTypeAnalyserVisitor.getClosureReboundType((PhpPsiElement)point);
        if (boundType != null) {
            PhpType phpType = boundType;
            if (phpType == null) {
                PhpTypeAnalyserVisitor.$$$reportNull$$$0(11);
            }
            return phpType;
        }
        PhpClass containingClass = PhpClassImpl.getContainingClass((PsiElement)point);
        if (containingClass != null && !containingClass.isTrait()) {
            PhpType classType = PhpType.from((PsiElement[])new PsiElement[]{containingClass});
            if (containingClass.isAnonymous()) {
                PhpType phpType = classType;
                if (phpType == null) {
                    PhpTypeAnalyserVisitor.$$$reportNull$$$0(12);
                }
                return phpType;
            }
            PhpType phpType = PhpType.or((PhpType)classType.map(arg_0 -> ((PhpTypeSignatureKey)PhpTypeSignatureKey.POLYMORPHIC_CLASS).sign(arg_0)), (PhpType)classType);
            if (phpType == null) {
                PhpTypeAnalyserVisitor.$$$reportNull$$$0(13);
            }
            return phpType;
        }
        PhpType phpType = PhpType.EMPTY;
        if (phpType == null) {
            PhpTypeAnalyserVisitor.$$$reportNull$$$0(14);
        }
        return phpType;
    }

    @Nullable
    public static PhpType getClosureReboundType(@Nullable PhpPsiElement point) {
        PhpType boundType;
        Function containingFunction = (Function)PhpPsiUtil.getParentByCondition((PsiElement)point, (Condition<? super PsiElement>)((Condition)Function.class::isInstance), (Condition<? super PsiElement>)((Condition)PhpClass.class::isInstance));
        if (containingFunction != null && containingFunction.isClosure() && !(boundType = PhpAnnotatorVisitor.getClosureBoundType(containingFunction, false)).isEmpty()) {
            return boundType;
        }
        return null;
    }

    @NotNull
    private static PhpType inferDocType(PhpTypeAnalyzerProcessor variableDeclaredTypeAnalyzer, @Nullable PhpAccessVariableInstruction instruction) {
        if (instruction != null && variableDeclaredTypeAnalyzer instanceof PhpVariableDocDeclaredTypeAnalyzerProcessor && !((PhpVariableDocDeclaredTypeAnalyzerProcessor)variableDeclaredTypeAnalyzer).scopeContainsDocType(instruction.getAnchor(), instruction.getVariableName())) {
            PhpType phpType = PhpType.EMPTY;
            if (phpType == null) {
                PhpTypeAnalyserVisitor.$$$reportNull$$$0(15);
            }
            return phpType;
        }
        if (instruction == null) {
            PhpType phpType = PhpType.EMPTY;
            if (phpType == null) {
                PhpTypeAnalyserVisitor.$$$reportNull$$$0(16);
            }
            return phpType;
        }
        PhpControlFlowUtil.processPredecessorsIgnoreInitialBackEdges((PhpInstruction)instruction, true, variableDeclaredTypeAnalyzer);
        PhpType phpType = variableDeclaredTypeAnalyzer.getType();
        if (phpType == null) {
            PhpTypeAnalyserVisitor.$$$reportNull$$$0(17);
        }
        return phpType;
    }

    @NotNull
    protected PhpType inferVariableType(Variable variable, CharSequence variableName, PhpInstruction instruction, PhpScopeHolder scopeHolder) {
        List lastVariableWrites;
        PhpVariableInferredTypeAnalyzerProcessor processor2 = new PhpVariableInferredTypeAnalyzerProcessor(variable, variableName, scopeHolder, instruction);
        PhpType type = PhpVariableInferredTypeAnalyzerProcessor.inferTypeDfaBasedTypeStateAware(variable, variableName, scopeHolder, instruction, processor2);
        if (PhpVariableInferredTypeAnalyzerProcessor.isCoalesceSelfAssignmentVariable((PsiElement)variable)) {
            type = type.filterNull();
        }
        if (this.mySelfAssignmentToInt && !processor2.isAmbiguous()) {
            if (type.equals((Object)PhpType.FLOAT)) {
                this.type = this.type.filterOut("\\int"::equalsIgnoreCase);
                PhpType phpType = type;
                if (phpType == null) {
                    PhpTypeAnalyserVisitor.$$$reportNull$$$0(18);
                }
                return phpType;
            }
            PhpType phpType = type.filterOut(t -> !"\\float".equalsIgnoreCase((String)t));
            if (phpType == null) {
                PhpTypeAnalyserVisitor.$$$reportNull$$$0(19);
            }
            return phpType;
        }
        if (processor2.isStaticDeclaration() && !(lastVariableWrites = ContainerUtil.filter(this.getLastVariableWrites(scopeHolder, variableName), v -> v != variable)).isEmpty()) {
            PhpType phpType = new PhpType().add(type);
            lastVariableWrites.forEach(arg_0 -> ((PhpType)phpType).add(arg_0));
            PhpType phpType2 = phpType;
            if (phpType2 == null) {
                PhpTypeAnalyserVisitor.$$$reportNull$$$0(20);
            }
            return phpType2;
        }
        PhpType phpType = type;
        if (phpType == null) {
            PhpTypeAnalyserVisitor.$$$reportNull$$$0(21);
        }
        return phpType;
    }

    private Collection<PsiElement> getLastVariableWrites(PhpScopeHolder scopeHolder, final CharSequence variableName) {
        final HashSet<PsiElement> res = new HashSet<PsiElement>();
        PhpControlFlowUtil.processPredecessors((PhpInstruction)scopeHolder.getControlFlow().getExitPoint(), false, new PhpInstructionProcessor(this){

            public boolean processAccessVariableInstruction(PhpAccessVariableInstruction instruction) {
                if (PhpLangUtil.equalsVariableNames(instruction.getVariableName(), variableName) && instruction.getAccess().isWrite()) {
                    res.add(instruction.getAnchor());
                    return false;
                }
                return super.processAccessVariableInstruction(instruction);
            }
        });
        return res;
    }

    public void visitPhpAssignmentExpression(AssignmentExpression expr) {
        this.addType((PsiElement)expr.getValue());
    }

    public void visitPhpSelfAssignmentExpression(SelfAssignmentExpression expression) {
        PsiElement operation = expression.getOperation();
        if (PhpPsiUtil.isOfType(operation, PhpTokenTypes.opCONCAT_ASGN)) {
            this.addType(PhpType.STRING);
        } else {
            this.visitPhpAssignmentExpression((AssignmentExpression)expression);
        }
    }

    public void visitPhpMultiassignmentExpression(MultiassignmentExpression multiassignmentExpression) {
        this.visitPhpAssignmentExpression((AssignmentExpression)multiassignmentExpression);
    }

    public void visitPhpConstant(Constant constant) {
        PsiElement value = constant.getValue();
        if (!(value == null || value instanceof ConstantReference && StringUtil.equalsIgnoreCase((CharSequence)((ConstantReference)value).getName(), (CharSequence)constant.getName()))) {
            this.addType(value);
        }
    }

    public void visitPhpArrayCreationExpression(ArrayCreationExpression expression) {
        PhpType onlyType;
        HashSet<Collection<String>> typesWithParametrisedParts = new HashSet<Collection<String>>();
        HashSet<Collection<String>> types = new HashSet<Collection<String>>();
        PhpType keyType = new PhpType();
        int analyzedChildren = 0;
        for (PhpPsiElement child : ArrayCreationExpressionImpl.children(expression).limit(MAX_ARRAY_VALUES)) {
            PhpTypedElement element;
            if (++analyzedChildren >= MAX_ARRAY_VALUES) {
                keyType.add(PhpType.MIXED);
                typesWithParametrisedParts.add(PhpType.MIXED.getTypes());
                types.add(PhpType.MIXED.getTypes());
                if (!LOG.isTraceEnabled()) break;
                LOG.trace("max array values reached for expression at " + expression.getTextOffset() + " in " + expression.getContainingFile().getName());
                break;
            }
            if (child instanceof ArrayHashElement) {
                element = (PhpTypedElement)ObjectUtils.tryCast((Object)((ArrayHashElement)child).getValue(), PhpTypedElement.class);
                PhpPsiElement key = ((ArrayHashElement)child).getKey();
                if (PhpLangUtil.isScalar((PsiElement)key)) {
                    keyType.add(PhpType.from((PsiElement[])new PsiElement[]{key}).removeParametrisedParts());
                } else {
                    keyType.add(PhpType.MIXED);
                }
            } else {
                element = (PhpTypedElement)ObjectUtils.tryCast((Object)child.getFirstPsiChild(), PhpTypedElement.class);
                keyType.add(PhpType.INT);
            }
            if (element == null) {
                this.addType(PhpType.ARRAY);
                return;
            }
            if (types.size() > 1 || typesWithParametrisedParts.size() > 1) continue;
            PhpType type = types.isEmpty() || PhpTypeAnalyserVisitor.getOnlyValueType(typesWithParametrisedParts, types) != null ? element.getType() : PhpType.MIXED;
            typesWithParametrisedParts.add(type.getTypesWithParametrisedParts());
            types.add(type.getTypes());
        }
        if ((onlyType = PhpTypeAnalyserVisitor.getOnlyValueType(typesWithParametrisedParts, types)) != null) {
            this.addType(PhpTypeAnalyserVisitor.getArrayKeyType(keyType, onlyType, onlyType.pluralise()));
        } else {
            this.addType(PhpTypeAnalyserVisitor.getArrayKeyType(keyType, PhpType.MIXED, PhpType.ARRAY));
        }
    }

    @Nullable
    private static PhpType getOnlyValueType(Set<Collection<String>> typesWithParametrisedParts, Set<Collection<String>> types) {
        PhpType onlyType = PhpTypeAnalyserVisitor.getOnlyType(typesWithParametrisedParts);
        return onlyType != null ? onlyType : PhpTypeAnalyserVisitor.getOnlyType(types);
    }

    private static PhpType getArrayKeyType(PhpType keyType, PhpType valueType, PhpType pluralisedValueType) {
        if (keyType.size() == 1 && !PhpType.MIXED.equals((Object)keyType)) {
            return valueType.map(value -> PhpType.createParametrizedType((String)"array", (String[])new String[]{(String)ContainerUtil.getFirstItem((Collection)keyType.getTypes()), value}));
        }
        return pluralisedValueType;
    }

    private static PhpType getOnlyType(Collection<Collection<String>> types) {
        PhpType elementTypePluralised;
        Collection onlyType = (Collection)ContainerUtil.getOnlyItem(types);
        if (onlyType != null && !(elementTypePluralised = PhpType.fromStrings((Collection)onlyType).filterUnknown()).isEmpty()) {
            return elementTypePluralised.createImmutableType();
        }
        return null;
    }

    public void visitPhpArrayAccessExpression(ArrayAccessExpression expression) {
        PhpPsiElement reference = expression.getValue();
        ArrayIndex index = expression.getIndex();
        if (index != null) {
            PhpArrayAccessTypeAnalyzer processor2;
            PhpPsiElement key = index.getValue();
            boolean finish = this.addTypeFromExpression((PhpExpression)expression);
            if (finish) {
                return;
            }
            PhpArrayAccessInstruction instruction = PhpControlFlowUtil.getAccessInstruction((PhpPsiElement)expression, PhpArrayAccessInstruction.class);
            if (instruction != null && (processor2 = PhpTypeAnalyserVisitor.createProcessor((PsiElement)reference, (PsiElement)key)) != null) {
                PhpControlFlowUtil.processPredecessorsIgnoreBackEdges((PhpInstruction)instruction, false, processor2);
                PhpType phpType = processor2.getType();
                if (!phpType.isEmpty()) {
                    this.addType(phpType);
                    if (processor2.foundExactArrayIndexType()) {
                        return;
                    }
                } else {
                    AssignmentExpression assignmentExpression = (AssignmentExpression)ObjectUtils.tryCast((Object)expression.getParent(), AssignmentExpression.class);
                    if (assignmentExpression != null && assignmentExpression.getVariable() == expression) {
                        this.addType(PhpType.MIXED);
                    }
                }
            }
        }
        if (index != null) {
            PhpPsiElement value = expression.getValue();
            if (value instanceof PhpTypedElement) {
                PhpType elementType = ((PhpTypedElement)value).getType().elementType();
                for (String s : elementType.getTypesWithParametrisedParts()) {
                    if (("$this".equals(s) || "static".equals(s)) && reference instanceof MemberReference) {
                        this.addType((PsiElement)((MemberReference)reference).getClassReference());
                        continue;
                    }
                    this.addType(s);
                }
            }
        } else {
            this.addType(PhpType.ARRAY);
        }
    }

    @Nullable
    public static PhpArrayAccessTypeAnalyzer createProcessor(PsiElement arrayValue, @Nullable PsiElement key) {
        if (arrayValue instanceof Variable && StringUtil.isNotEmpty((String)((Variable)arrayValue).getName())) {
            return new PhpVariableArrayAccessTypeAnalyzer(((Variable)arrayValue).getName(), key);
        }
        if (arrayValue instanceof FieldReference) {
            PhpExpression classReference = ((FieldReference)arrayValue).getClassReference();
            String name = ((FieldReference)arrayValue).getName();
            if (classReference instanceof Variable || classReference instanceof ClassReference && PhpLangUtil.isSelfReference((ClassReference)classReference)) {
                return new PhpFieldReferenceArrayAccessTypeAnalyzer((PsiElement)classReference, name, key);
            }
        }
        return null;
    }

    public void visitPhpExpression(PhpExpression expression) {
    }

    public void visitPhpParenthesizedExpression(ParenthesizedExpression expression) {
        this.addType((PsiElement)expression.extract());
    }

    public void visitPhpBinaryExpression(BinaryExpression expression) {
        IElementType o = expression.getOperationType();
        if (o == PhpTokenTypes.opCONCAT) {
            this.addType(PhpType.STRING);
        }
        if (PhpTokenTypes.opSHIFT_RIGHT == o || PhpTokenTypes.opSHIFT_LEFT == o) {
            this.addType(PhpType.INT);
        } else if (PhpTokenTypes.tsBIT_BINARY_OPS.contains(o)) {
            PhpType left = new PhpType().add(expression.getLeftOperand());
            PhpType right = new PhpType().add(expression.getRightOperand());
            if (left.equals((Object)PhpType.STRING) && right.equals((Object)PhpType.STRING)) {
                this.addType(PhpType.STRING);
            } else if (PhpTypeAnalyserVisitor.isUnresolvedWithoutString(left) || PhpTypeAnalyserVisitor.isUnresolvedWithoutString(right)) {
                this.addType(PhpType.INT);
            } else {
                this.addType(PhpArithmeticDeferredTypeProvider.encodeBitwiseOperandTypesType(left, right));
            }
        } else if (PhpTokenTypes.tsLOGICAL_OPS.contains(o) || PhpTokenTypes.tsCOMPARE_OPS.contains(o)) {
            if (o == PhpTokenTypes.opSPACESHIP) {
                this.addType(PhpType.INT);
            } else {
                this.addType(PhpType.BOOLEAN);
            }
        } else if (o == PhpTokenTypes.opREM || PhpTokenTypes.tsBIT_OPS.contains(o)) {
            this.addType(PhpType.INT);
        } else if (PhpTokenTypes.tsMATH_OPS.contains(o)) {
            PsiElement rightOperand = expression.getRightOperand();
            PsiElement leftOperand = expression.getLeftOperand();
            if (PhpPsiUtil.isOfType(rightOperand, PhpElementTypes.NUMBER) && PhpType.intersects((PhpType)PhpType.FLOAT, (PhpType)((PhpTypedElement)rightOperand).getType()) || PhpPsiUtil.isOfType(leftOperand, PhpElementTypes.NUMBER) && PhpType.intersects((PhpType)PhpType.FLOAT, (PhpType)((PhpTypedElement)leftOperand).getType()) || rightOperand != null && PhpType.FLOAT.equals((Object)((PhpTypedElement)rightOperand).getType()) || leftOperand != null && PhpType.FLOAT.equals((Object)((PhpTypedElement)leftOperand).getType())) {
                this.addType(PhpType.FLOAT);
                return;
            }
        }
        if (o == PhpTokenTypes.opDIV || o == PhpTokenTypes.opMUL) {
            this.addType(PhpType.INT);
            this.addType(PhpType.FLOAT);
        }
        if (this.type.isEmpty()) {
            PhpTypedElement rightOperand;
            PhpTypedElement leftOperand = (PhpTypedElement)ObjectUtils.tryCast((Object)expression.getLeftOperand(), PhpTypedElement.class);
            if (leftOperand != null) {
                PhpType leftOperandType = leftOperand.getType();
                if (o == PhpTokenTypes.opCOALESCE) {
                    this.addType(leftOperandType.filterNull());
                } else {
                    this.addType(leftOperandType.filterFalse().map(PhpGeneraliseIntRangeTypeProvider::signUnresolved).getTypesWithParametrisedParts());
                }
            }
            if ((rightOperand = (PhpTypedElement)ObjectUtils.tryCast((Object)expression.getRightOperand(), PhpTypedElement.class)) != null) {
                PhpType rightOperandType = rightOperand.getType();
                if (o == PhpTokenTypes.opCOALESCE) {
                    this.addType(rightOperandType);
                } else {
                    this.addType(rightOperandType.filterFalse().map(PhpGeneraliseIntRangeTypeProvider::signUnresolved).getTypesWithParametrisedParts());
                }
            }
        }
    }

    public void visitPhpTernaryExpression(TernaryExpression expression) {
        this.type = new PhpType();
        PhpType trueType = new PhpType().add((PsiElement)expression.getTrueVariant());
        PhpType falseType = new PhpType().add((PsiElement)expression.getFalseVariant());
        this.type.add(expression.isShort() ? trueType.filterNull() : trueType);
        this.type.add(falseType);
        if (trueType.isEmpty() != falseType.isEmpty()) {
            this.type.add(PhpType.MIXED);
        }
    }

    public void visitPhpParameter(Parameter parameter) {
        this.addType(parameter.getLocalType());
    }

    public void visitPhpNewExpression(NewExpression value) {
        ClassReference reference = value.getClassReference();
        if (reference != null) {
            Set types;
            String classStringType;
            PhpType resolvedType = reference.resolveLocalType().filterScalarPrimitives();
            if (!resolvedType.isEmpty()) {
                this.addType(resolvedType.filter(PhpType.CLASS_STRING));
            }
            if ((classStringType = (String)ContainerUtil.find((Iterable)(types = resolvedType.getTypesWithParametrisedParts()), t -> t.contains("class-string"))) != null) {
                PhpType.getParametrizedParts((String)classStringType).forEach(this::addType);
            }
            if (ContainerUtil.all((Collection)resolvedType.getTypes(), PhpExcludeTypeTP.KEY::signed)) {
                this.addType(PhpType.MIXED);
            }
        } else {
            PhpPsiElement child = value.getFirstPsiChild();
            if (child instanceof PhpClass) {
                this.addType((PsiElement)child);
            }
        }
    }

    public void visitPhpFunction(Function function) {
        this.addType(function.getLocalType(false));
    }

    public void visitPhpMethod(Method method) {
        this.addType(method.getLocalType(false));
    }

    public void visitPhpField(Field field) {
        PhpType declaredType = field.getDeclaredType();
        PhpType docType = field.getDocType();
        if (field.isConstant()) {
            this.addType(docType);
            this.addType(PhpTypeAnalyserVisitor.getTypeWithoutOverridingGenericArrays(this.type, declaredType));
            this.addType(field.getDefaultValue());
            return;
        }
        PhpClass phpClass = field.getContainingClass();
        boolean parametrisedInt = PhpTypeAnalyserVisitor.isParametrisedInt(docType);
        if (phpClass != null) {
            MultiMap<String, FieldReference> accessMap = PhpClassImpl.getConstructorAssignmentsPerField(phpClass);
            for (FieldReference fieldReference : accessMap.get((Object)field.getName())) {
                if (fieldReference == null) continue;
                this.addInferredType(fieldReference);
            }
            this.addType(ParameterImpl.removeParametrisedIntType(this.getType()));
            if (parametrisedInt) {
                this.type = this.getType().filter(PhpType.INT);
            }
            if (!this.type.isEmpty() && PhpTypeAnalyserVisitor.fieldAssignmentAlwaysReachable(field, false)) {
                this.addType(PhpTypeAnalyserVisitor.getTypeWithoutOverridingGenericArrays(this.type, declaredType));
                this.addType(docType);
                return;
            }
        }
        PhpType typeFromDeclarations = new PhpType().add(declaredType).add(docType);
        PhpType mergedType = parametrisedInt && declaredType.equals((Object)PhpType.INT) ? docType : PhpTypeAnalyserVisitor.filterFalseFromDefaultValueTypeIfNeeded(typeFromDeclarations, field.getDefaultValue()).add(declaredType);
        this.addType(PhpTypeAnalyserVisitor.getTypeWithoutOverridingGenericArrays(docType, mergedType));
        this.addType(docType);
    }

    @NotNull
    private static PhpType filterFalseFromDefaultValueTypeIfNeeded(PhpType declaredType, @Nullable PsiElement defaultValue) {
        PhpType defaultValueType = new PhpType().add(defaultValue);
        if (defaultValueType.equals((Object)PhpType.INT) && PhpTypeAnalyserVisitor.isParametrisedInt(declaredType)) {
            return new PhpType();
        }
        if (declaredType.equals((Object)PhpType.TRUE) || declaredType.equals((Object)PhpType.FALSE) || declaredType.equals((Object)PhpType.NULL)) {
            PhpType phpType = declaredType;
            if (phpType == null) {
                PhpTypeAnalyserVisitor.$$$reportNull$$$0(22);
            }
            return phpType;
        }
        PhpType phpType = PhpType.intersects((PhpType)declaredType, (PhpType)PhpType.or((PhpType)PhpType.FALSE, (PhpType)PhpType.TRUE)) ? defaultValueType : ParameterImpl.generaliseDefaultValueType(defaultValueType);
        if (phpType == null) {
            PhpTypeAnalyserVisitor.$$$reportNull$$$0(23);
        }
        return phpType;
    }

    public static boolean isParametrisedInt(PhpType declaredType) {
        return PhpTypeAnalyserVisitor.getShortNameToParametrisedTypes(declaredType).containsKey("\\int");
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public static Map<String, String> getShortNameToParametrisedTypes(PhpType type) {
        if (type.isAmbiguous()) {
            return Collections.emptyMap();
        }
        @NlsSafe Set types = type.getTypesWithParametrisedParts();
        HashMap<String, String> res = new HashMap<String, String>();
        for (String t : types) {
            if (!PhpType.hasParameterizedPart((String)t) || types.contains(PhpType.removeParametrisedType((String)t))) continue;
            res.put(PhpType.removeParametrisedType((String)t), t);
        }
        return res;
    }

    private static PhpType getTypeWithoutOverridingGenericArrays(PhpType toSearchPlurals, PhpType toAddWithoutOverridingArrays) {
        if (ContainerUtil.exists((Iterable)toSearchPlurals.getTypesWithParametrisedParts(), t -> PhpType.isPluralType((String)t) || PhpType.isArray((String)t))) {
            return toAddWithoutOverridingArrays.getTypesWithParametrisedParts().stream().filter(Predicate.not("\\array"::equalsIgnoreCase)).map(xva$0 -> PhpType.from((String[])new String[]{xva$0})).reduce(new PhpType(), PhpType::or);
        }
        return toAddWithoutOverridingArrays;
    }

    public static boolean fieldAssignmentAlwaysReachable(final @NotNull Field field, final boolean haltOnReadAccesses) {
        if (field == null) {
            PhpTypeAnalyserVisitor.$$$reportNull$$$0(24);
        }
        if (!field.getModifier().isPrivate()) {
            return false;
        }
        PhpClass phpClass = field.getContainingClass();
        if (phpClass == null) {
            return false;
        }
        Method constructor = phpClass.getOwnConstructor();
        if (constructor == null) {
            return false;
        }
        final Ref canBeUndefined = new Ref((Object)Boolean.FALSE);
        PhpControlFlowUtil.processSuccessors((PhpInstruction)constructor.getControlFlow().getEntryPoint(), false, new PhpInstructionProcessor(){

            public boolean processAccessFieldByVariableInstruction(PhpAccessFieldByVariableInstruction instruction) {
                FieldReference anchor = instruction.getFieldReference();
                if (anchor != null && PhpTypeAnalyserVisitor.isReferenceTo(anchor, field)) {
                    if (instruction.getAccess().isWrite()) {
                        return false;
                    }
                    if (haltOnReadAccesses) {
                        canBeUndefined.set((Object)true);
                        return false;
                    }
                }
                return super.processAccessFieldByVariableInstruction(instruction);
            }

            public boolean processExitPointInstruction(PhpExitPointInstruction instruction) {
                canBeUndefined.set((Object)true);
                return super.processExitPointInstruction(instruction);
            }
        });
        return canBeUndefined.get() == Boolean.FALSE;
    }

    private static boolean isReferenceTo(FieldReference anchor, @NotNull Field field) {
        if (field == null) {
            PhpTypeAnalyserVisitor.$$$reportNull$$$0(25);
        }
        return anchor.resolveLocal().contains(field);
    }

    public void visitPhpClassReference(ClassReference ref) {
        this.visitPhpReference((PhpReference)ref);
    }

    public void visitPhpReturnType(PhpReturnType returnType) {
        this.addType(returnType.getType());
    }

    public void visitPhpMethodReference(MethodReference ref) {
        this.visitPhpReference((PhpReference)ref);
        this.type = PhpTypeAnalyserVisitor.replaceVoidWithNull(this.type);
        if (ref.hasNullSafeDereference()) {
            this.addType(PhpType.NULL);
        }
    }

    public void visitPhpClassConstantReference(ClassConstantReference ref) {
        this.visitPhpReference((PhpReference)ref);
    }

    public void visitPhpFieldReference(FieldReference fieldReference) {
        if (fieldReference.hasNullSafeDereference()) {
            this.addType(PhpType.NULL);
        }
        Collection elements = fieldReference.resolveLocal();
        if (this.addInferredType(fieldReference)) {
            if (ContainerUtil.all((Collection)elements, PhpClassImpl.MyASTRenamableFakePsiElement.class::isInstance)) {
                for (String s : fieldReference.getSignatureParts()) {
                    this.addType(PhpOptionalCompletionTP.TYPE_KEY.sign((CharSequence)s));
                }
            }
            for (PhpNamedElement element : elements) {
                this.addType(element.getDocType());
                this.addType(PhpTypeAnalyserVisitor.getTypeWithoutOverridingGenericArrays(this.getType(), element.getDeclaredType()));
            }
            return;
        }
        this.visitPhpReference((PhpReference)fieldReference);
        if (ContainerUtil.exists((Iterable)elements, PhpTypeAnalyserVisitor::isDynamicField)) {
            this.addSignatureTypes((PhpReference)fieldReference);
        }
    }

    private static boolean isDynamicField(PhpNamedElement e) {
        return e instanceof PhpClassImpl.MyASTRenamableFakePsiElement && ((PhpClassImpl.MyASTRenamableFakePsiElement)e).getInitPlace() == PhpClass.PhpDynamicFieldInitPlace.DYNAMIC;
    }

    public boolean addInferredType(FieldReference fieldReference) {
        CharSequence fieldName = fieldReference.getNameCS();
        if (!StringUtil.isEmpty((CharSequence)fieldName)) {
            boolean finish = this.addTypeFromExpression((PhpExpression)fieldReference);
            if (finish) {
                return true;
            }
            PhpExpression reference = fieldReference.getClassReference();
            if (reference instanceof ClassReference) {
                PhpAccessFieldInObjectContextInstruction instruction;
                if (PhpLangUtil.isSelfReference((ClassReference)reference) && (instruction = PhpControlFlowUtil.getAccessInstruction((PhpPsiElement)fieldReference, PhpAccessFieldInObjectContextInstruction.class)) != null) {
                    PhpFieldReferenceInObjectContextTypeAnalyzer processor2 = new PhpFieldReferenceInObjectContextTypeAnalyzer(fieldName);
                    PhpControlFlowUtil.processPredecessorsIgnoreBackEdges((PhpInstruction)instruction, false, processor2);
                    PhpType phpType = processor2.getType();
                    if (!phpType.isEmpty()) {
                        this.addType(phpType);
                    }
                }
            } else if (reference != null) {
                CharSequence variableName = reference instanceof Variable ? ((Variable)reference).getNameCS() : null;
                PhpAccessFieldByVariableInstruction instruction = PhpControlFlowUtil.getAccessInstruction((PhpPsiElement)fieldReference, PhpAccessFieldByVariableInstruction.class);
                if (instruction != null) {
                    PhpFieldReferenceByVariableTypeAnalyzer processor3 = new PhpFieldReferenceByVariableTypeAnalyzer(instruction, fieldName, variableName);
                    PhpControlFlowUtil.processPredecessorsIgnoreBackEdges((PhpInstruction)instruction, false, processor3);
                    PhpType phpType = processor3.getType();
                    if (!phpType.isEmpty()) {
                        boolean ambiguousResult = processor3.isAmbiguousResult();
                        if (ambiguousResult) {
                            phpType = PhpTypeAnalyserVisitor.generaliseIntRange(phpType);
                        }
                        this.addType(phpType);
                        return !ambiguousResult;
                    }
                }
            }
        }
        return false;
    }

    public static PhpType generaliseIntRange(PhpType phpType) {
        return PhpTypeAnalyserVisitor.isIntWithPossibleRangeType(phpType) ? PhpType.or((PhpType)PhpType.INT, (PhpType)phpType) : phpType;
    }

    private static boolean isIntWithPossibleRangeType(PhpType phpType) {
        return PhpType.intersects((PhpType)phpType, (PhpType)PhpType.INT);
    }

    public void visitPhpConstantReference(ConstantReference ref) {
        this.visitPhpReference((PhpReference)ref);
    }

    public void visitPhpFunctionCall(FunctionReference ref) {
        this.visitPhpReference((PhpReference)ref);
        this.type = PhpTypeAnalyserVisitor.replaceVoidWithNull(this.type);
    }

    public void visitPhpCallableFunction(PhpCallableFunction ref) {
        this.visitPhpReference((PhpReference)ref);
    }

    public void visitPhpDocType(PhpDocType type) {
        this.addType(PhpDocTypeImpl.getType((PhpReference)type, type.getText()));
    }

    public void visitPhpMatchExpression(PhpMatchExpression matchExpression) {
        for (PhpMatchArm arm : ((PhpMatchExpressionImpl)matchExpression).getAllMatchArms()) {
            PhpExpression bodyExpression = arm.getBodyExpression();
            if (bodyExpression == null) continue;
            this.addType(bodyExpression.getType());
        }
    }

    public void visitPhpEnumCase(PhpEnumCase enumCase) {
        this.addType((PsiElement)enumCase.getContainingClass());
    }

    public void visitPhpDocTag(PhpDocTag tag) {
        if (tag instanceof PhpDocMethodTagImpl) {
            this.addType(((PhpDocMethodTagImpl)tag).getTypeFromAst());
        }
    }

    @NotNull
    public static PhpType replaceVoidWithNull(PhpType type) {
        PhpType phpType = type.map(t -> "\\void".equals(t) ? "\\null" : t);
        if (phpType == null) {
            PhpTypeAnalyserVisitor.$$$reportNull$$$0(26);
        }
        return phpType;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 6, 7, 9, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 26 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "phpType";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "types";
                break;
            }
            case 2: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "curAnchor";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psi";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/psi/resolve/types/PhpTypeAnalyserVisitor";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 24: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/psi/resolve/types/PhpTypeAnalyserVisitor";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getDocTypeFromAnonymousDoc";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeFromAST";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getType";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getBoundClassType";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "inferDocType";
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "inferVariableType";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "filterFalseFromDefaultValueTypeIfNeeded";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "replaceVoidWithNull";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addType";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "addTypeFromExpression";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getTypeProviders";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 26: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getTypeFromAST";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "inferType";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isUnresolvedWithoutString";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "fieldAssignmentAlwaysReachable";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "isReferenceTo";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 6, 7, 9, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 26 -> new IllegalStateException(string);
        };
    }
}

