/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.psi.resolve.types;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.psi.elements.AssignmentExpression;
import com.jetbrains.php.lang.psi.elements.ClassConstantReference;
import com.jetbrains.php.lang.psi.elements.ClassReference;
import com.jetbrains.php.lang.psi.elements.MethodReference;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpExpression;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.StringLiteralExpression;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.lang.psi.elements.impl.PhpClassImpl;
import com.jetbrains.php.lang.psi.resolve.types.PhpCharBasedTypeKey;
import com.jetbrains.php.lang.psi.resolve.types.PhpCharTypeKey;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.resolve.types.PhpTypeProvider4;
import com.jetbrains.php.lang.psi.resolve.types.PhpUnitFiledInitializedInSetUpMethodsTP;
import com.jetbrains.php.lang.psi.resolve.types.PhpUnitMockBuilderProxyTP;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpUnitMockBuilderTP
implements PhpTypeProvider4 {
    private static final Collection<String> MOCK_INIT_METHODS = CollectionFactory.createCaseInsensitiveStringSet(Arrays.asList("getMock", "getMockForAbstractClass", "getMockForTrait"));
    private static final Collection<String> MOCK_INIT_METHODS_WITH_META_METHODS = CollectionFactory.createCaseInsensitiveStringSet(Arrays.asList("createMock", "createStub", "createConfiguredMock", "createPartialMock", "createTestProxy", "getMockForAbstractClass"));
    private static final PhpCharBasedTypeKey MOCK_TYPE_KEY = new PhpCharTypeKey('m');
    public static final String MOCK_BUILDER_METHOD_NAME = "getMockBuilder";

    public char getKey() {
        return MOCK_TYPE_KEY.getKey();
    }

    @Nullable
    public PhpType getType(PsiElement element) {
        MethodReference methodReference;
        AssignmentExpression assignmentExpression;
        PsiElement psiElement;
        if (element instanceof Variable && (psiElement = element.getParent()) instanceof AssignmentExpression && (assignmentExpression = (AssignmentExpression)psiElement).getVariable() == element && (psiElement = assignmentExpression.getValue()) instanceof MethodReference && (MOCK_INIT_METHODS.contains((methodReference = (MethodReference)psiElement).getName()) || MOCK_INIT_METHODS_WITH_META_METHODS.contains(methodReference.getName()))) {
            return PhpType.from((PsiElement[])new PsiElement[]{assignmentExpression.getValue()});
        }
        if (element instanceof MethodReference) {
            PhpType classReferenceType;
            List buildTypes;
            PhpExpression classReference = ((MethodReference)element).getClassReference();
            if (classReference == null) {
                return null;
            }
            if (PhpLangUtil.isThisReference((PsiElement)classReference) && PhpLangUtil.equalsMethodNames(((MethodReference)element).getName(), MOCK_BUILDER_METHOD_NAME)) {
                PhpClass containingClass;
                String parameterSignature = PhpUnitMockBuilderTP.getParameterSignature(((MethodReference)element).getParameter(0));
                if (parameterSignature != null && (containingClass = PhpClassImpl.getContainingClass(element)) != null) {
                    return new PhpType().add(PhpUnitMockBuilderProxyTP.BUILDER_TYPE_KEY.sign(containingClass.getFQN() + "." + parameterSignature));
                }
            } else if (PhpUnitMockBuilderTP.mayReferenceToBuilderDeclaration((PsiElement)classReference, new HashSet<PsiElement>()) && !(buildTypes = ContainerUtil.filter((Collection)(classReferenceType = classReference.getType()).getTypes(), PhpUnitMockBuilderTP::isBuilderType)).isEmpty()) {
                if (MOCK_INIT_METHODS.contains(((MethodReference)element).getName())) {
                    PhpType result = new PhpType();
                    for (String s : buildTypes) {
                        result.add(MOCK_TYPE_KEY.sign(s.substring(2)));
                    }
                    return result;
                }
                return PhpType.fromStrings((Collection)buildTypes);
            }
        }
        return null;
    }

    private static boolean mayReferenceToBuilderDeclaration(PsiElement reference, @NotNull Collection<PsiElement> visited) {
        if (visited == null) {
            PhpUnitMockBuilderTP.$$$reportNull$$$0(0);
        }
        if (reference == null || !visited.add(reference)) {
            return false;
        }
        if (reference instanceof MethodReference) {
            return PhpUnitMockBuilderTP.mayReferenceToBuilderDeclaration((PsiElement)((MethodReference)reference).getClassReference(), visited);
        }
        if (reference instanceof Variable) {
            if (PhpLangUtil.isThisReference(reference)) {
                return true;
            }
            Collection elements = ((Variable)reference).resolveLocal();
            if (!elements.isEmpty()) {
                return elements.stream().allMatch(e -> PhpUnitMockBuilderTP.isBuilderDeclaration(e, visited));
            }
        }
        return false;
    }

    private static boolean isBuilderDeclaration(PhpNamedElement e, Collection<PsiElement> visited) {
        AssignmentExpression expression = (AssignmentExpression)ObjectUtils.tryCast((Object)e.getParent(), AssignmentExpression.class);
        if (expression == null) {
            return false;
        }
        PhpPsiElement value = expression.getValue();
        if (value instanceof MethodReference) {
            PhpExpression cr = ((MethodReference)value).getClassReference();
            if (PhpLangUtil.isThisReference((PsiElement)cr)) {
                return ((MethodReference)value).getType().getTypes().stream().anyMatch(PhpUnitMockBuilderTP::isBuilderType);
            }
            if (cr instanceof Variable) {
                return PhpUnitMockBuilderTP.mayReferenceToBuilderDeclaration((PsiElement)cr, visited);
            }
        }
        return false;
    }

    public static boolean isBuilderType(String typeString) {
        return typeString.startsWith("#") && PhpUnitMockBuilderProxyTP.BUILDER_TYPE_KEY.is(typeString.charAt(1));
    }

    @Nullable
    public PhpType complete(String expression, Project project) {
        int i = expression.indexOf(46);
        if (i == -1) {
            return null;
        }
        String containingClass = expression.substring(2, i);
        String argumentSignature = expression.substring(i + 1);
        if (PhpUnitFiledInitializedInSetUpMethodsTP.isPhpUnitClass(project, containingClass)) {
            return new PhpType().add(argumentSignature + "&\\PHPUnit\\Framework\\MockObject\\MockObject");
        }
        return null;
    }

    public Collection<? extends PhpNamedElement> getBySignature(String expression, Set<String> visited, int depth, Project project) {
        return null;
    }

    @Nullable
    public static String getParameterSignature(@Nullable PsiElement parameter) {
        ClassReference reference;
        if (parameter instanceof StringLiteralExpression) {
            return PhpLangUtil.toFQN(((StringLiteralExpression)parameter).getContents());
        }
        if (parameter instanceof ClassConstantReference && StringUtil.equals((CharSequence)"class", (CharSequence)((ClassConstantReference)parameter).getNameCS()) && (reference = (ClassReference)((ClassConstantReference)parameter).getClassReference()) != null) {
            return reference.getFQN();
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visited", "com/jetbrains/php/lang/psi/resolve/types/PhpUnitMockBuilderTP", "mayReferenceToBuilderDeclaration"));
    }
}

