/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.psi.resolve.types.generics;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpWorkaroundUtil;
import com.jetbrains.php.lang.documentation.phpdoc.lexer.PhpDocTokenTypes;
import com.jetbrains.php.lang.documentation.phpdoc.parser.PhpDocElementTypes;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocComment;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocType;
import com.jetbrains.php.lang.documentation.phpdoc.psi.impl.PhpDocTypeImpl;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.elements.PhpReference;
import com.jetbrains.php.lang.psi.resolve.types.PhpCharBasedTypeKey;
import com.jetbrains.php.lang.psi.resolve.types.PhpCharTypeKey;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.resolve.types.PhpTypeProvider4;
import com.jetbrains.php.lang.psi.resolve.types.generics.PhpGenericsBaseExtendedWithGenericTypeProvider;
import com.jetbrains.php.lang.psi.resolve.types.generics.PhpGenericsTemplatesCustomDocTagValueStubProvider;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpGenericDocTypeProvider
implements PhpTypeProvider4 {
    public static final PhpCharBasedTypeKey KEY = new PhpCharTypeKey('\u1891');
    @NotNull
    private final PhpType myIntIndices = PhpType.INT.map(KEY::sign);

    public char getKey() {
        return KEY.getKey();
    }

    @Nullable
    public PhpType getType(PsiElement element) {
        if (element instanceof PhpDocTypeImpl) {
            String name = PhpWorkaroundUtil.getGenericDocTypeName((PhpDocType)element);
            if (name != null && name.equals("list")) {
                return this.myIntIndices;
            }
            if (PhpDocTypeImpl.isFloatArrayShapeType(element.getText())) {
                return PhpType.FLOAT_INT;
            }
            if (name != null && name.equals("class-string")) {
                PhpDocComment docComment = PhpPsiUtil.getParentOfClass(element, PhpDocComment.class);
                if (docComment != null) {
                    Collection<String> collection;
                    PsiElement owner = docComment.getOwner();
                    if (owner instanceof PhpNamedElement) {
                        PhpNamedElement namedElement = (PhpNamedElement)owner;
                        collection = PhpGenericsBaseExtendedWithGenericTypeProvider.getTemplates(namedElement);
                    } else {
                        collection = Collections.emptyList();
                    }
                    List<String> templates = collection;
                    List<String> templateFQNs = PhpGenericsTemplatesCustomDocTagValueStubProvider.getTemplateFQNs(element, templates, e -> (PhpReference)ObjectUtils.tryCast((Object)e, PhpDocType.class));
                    return PhpType.from((String[])new String[]{PhpType.createParametrizedType((String)"\\class-string", templateFQNs)});
                }
                return PhpType.CLASS_STRING;
            }
            boolean isGenericArray = PhpWorkaroundUtil.isGenericArray((PhpDocType)element);
            PsiElement attributeList = PhpPsiUtil.getChildOfType(element, (IElementType)PhpDocElementTypes.phpDocAttributeList);
            if (attributeList == null || !PhpPsiUtil.isOfType(attributeList.getFirstChild(), PhpDocTokenTypes.DOC_LAB)) {
                return null;
            }
            List types = ContainerUtil.map((Object[])attributeList.getChildren(), c -> (String)ContainerUtil.getFirstItem((Collection)PhpType.from((PsiElement[])new PsiElement[]{c}).getTypesWithParametrisedParts()));
            if (types.isEmpty() || types.contains(null)) {
                return null;
            }
            if (isGenericArray) {
                PhpType keyType = new PhpType();
                PsiElement separator = PhpWorkaroundUtil.getTypesSeparatorElement(element, PhpDocTokenTypes.DOC_LAB, PhpDocTokenTypes.DOC_RAB, PhpDocTokenTypes.DOC_COMMA);
                if (separator != null) {
                    for (PsiElement child = attributeList.getFirstChild(); child != null && child != separator; child = child.getNextSibling()) {
                        if (!(child instanceof PhpDocType)) continue;
                        keyType.add(child);
                    }
                }
                if (!"iterable".equalsIgnoreCase(((PhpDocType)element).getName())) {
                    keyType = keyType.filterOut(t -> !PhpType.NUMERIC.getTypes().contains(t) && !t.startsWith("\\class-string") && !PhpType.isUnresolved((String)t));
                }
                return keyType.map(KEY::sign);
            }
            if (name == null || !name.contains("-")) {
                return ((PhpDocTypeImpl)element).inferNativeType().map(s -> PhpType.unpluralize((String)s) + "<" + StringUtil.join((Collection)types, (String)",") + ">");
            }
        }
        return null;
    }

    @Nullable
    public PhpType complete(String expression, Project project) {
        return null;
    }

    public Collection<? extends PhpNamedElement> getBySignature(String expression, Set<String> visited, int depth, Project project) {
        return null;
    }
}

