/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.psi.stubs;

import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.stubs.IndexSink;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubIndexKey;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.io.StringRef;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpDeprecationAttributeOwner;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.stubs.PhpClassStub;
import com.jetbrains.php.lang.psi.stubs.PhpClassStubImpl;
import com.jetbrains.php.lang.psi.stubs.PhpStubElementType;
import com.jetbrains.php.lang.psi.stubs.PhpStubSerializer;
import com.jetbrains.php.lang.psi.stubs.indexes.PhpClassIndex;
import com.jetbrains.php.lang.psi.stubs.indexes.PhpInheritanceIndex;
import com.jetbrains.php.lang.psi.stubs.indexes.PhpInterfaceIndex;
import com.jetbrains.php.lang.psi.stubs.indexes.PhpTraitFqnIndex;
import com.jetbrains.php.lang.psi.stubs.indexes.PhpTraitIndex;
import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001c\u0010\u0006\u001a\u00020\u00072\b\b\u0001\u0010\b\u001a\u00020\u00032\b\b\u0001\u0010\t\u001a\u00020\nH\u0016J\u001e\u0010\u000b\u001a\u00020\u00032\b\b\u0001\u0010\t\u001a\u00020\f2\n\u0010\r\u001a\u0006\u0012\u0002\b\u00030\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\u001c\u0010\u0011\u001a\u00020\u00072\b\b\u0001\u0010\b\u001a\u00020\u00032\b\b\u0001\u0010\u0012\u001a\u00020\u0013H\u0016\u00a8\u0006\u0014"}, d2={"Lcom/jetbrains/php/lang/psi/stubs/PhpClassStubSerializer;", "Lcom/jetbrains/php/lang/psi/stubs/PhpStubSerializer;", "Lcom/jetbrains/php/lang/psi/elements/PhpClass;", "Lcom/jetbrains/php/lang/psi/stubs/PhpClassStub;", "<init>", "()V", "serialize", "", "stub", "dataStream", "Lcom/intellij/psi/stubs/StubOutputStream;", "deserialize", "Lcom/intellij/psi/stubs/StubInputStream;", "parentStub", "Lcom/intellij/psi/stubs/StubElement;", "getElementType", "Lcom/intellij/psi/tree/IElementType;", "indexStub", "sink", "Lcom/intellij/psi/stubs/IndexSink;", "intellij.php.impl"})
public final class PhpClassStubSerializer
extends PhpStubSerializer<PhpClass, PhpClassStub> {
    public void serialize(@NotNull PhpClassStub stub, @NotNull StubOutputStream dataStream) {
        Intrinsics.checkNotNullParameter((Object)stub, (String)"stub");
        Intrinsics.checkNotNullParameter((Object)dataStream, (String)"dataStream");
        dataStream.writeName(stub.getName());
        dataStream.writeName(stub.getNamespaceName());
        dataStream.writeShort((int)stub.getFlags());
        dataStream.writeName(stub.getSuperclass());
        String[] stringArray = stub.getInterfaces();
        Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"getInterfaces(...)");
        this.writeStringArray(dataStream, stringArray);
        String[] stringArray2 = stub.getTraits();
        Intrinsics.checkNotNullExpressionValue((Object)stringArray2, (String)"getTraits(...)");
        this.writeStringArray(dataStream, stringArray2);
        String[] stringArray3 = stub.getMixins();
        Intrinsics.checkNotNullExpressionValue((Object)stringArray3, (String)"getMixins(...)");
        this.writeStringArray(dataStream, stringArray3);
        dataStream.writeName(stub.getDeprecatedSinceVersion());
        PhpClassStub.PhpConstructorFieldStubData[] data = stub.getConstructionFieldsStubData();
        dataStream.writeInt(data.length);
        Intrinsics.checkNotNull((Object)data);
        for (PhpClassStub.PhpConstructorFieldStubData datum : data) {
            dataStream.writeInt(datum.getRange().getStartOffset());
            dataStream.writeInt(datum.getRange().getEndOffset());
            dataStream.writeName(datum.getName());
            PhpType phpType = datum.getType();
            Intrinsics.checkNotNullExpressionValue((Object)phpType, (String)"getType(...)");
            this.writePhpType(dataStream, phpType);
            dataStream.writeBoolean(datum.isDynamic());
            dataStream.writeInt(datum.getInitPlace().ordinal());
        }
        PhpDeprecationAttributeOwner.PhpDeprecationInfo.write((PhpDeprecationAttributeOwner.PhpDeprecationInfo)stub.getDeprecationInfo(), (StubOutputStream)dataStream);
        PhpType phpType = stub.getBackedEnumType();
        Intrinsics.checkNotNullExpressionValue((Object)phpType, (String)"getBackedEnumType(...)");
        this.writePhpType(dataStream, phpType);
    }

    @NotNull
    public PhpClassStub deserialize(@NotNull StubInputStream dataStream, @NotNull StubElement<?> parentStub) {
        Intrinsics.checkNotNullParameter((Object)dataStream, (String)"dataStream");
        Intrinsics.checkNotNullParameter(parentStub, (String)"parentStub");
        StringRef name = dataStream.readName();
        StringRef namespace = dataStream.readName();
        short flags = dataStream.readShort();
        String superclass = dataStream.readNameString();
        String[] interfaces = this.readStringArray(dataStream);
        String[] traits = this.readStringArray(dataStream);
        String[] mixins = this.readStringArray(dataStream);
        StringRef deprecatedSinceRef = dataStream.readName();
        int constructorFieldStubDataSize = dataStream.readInt();
        PhpClassStub.PhpConstructorFieldStubData[] data = constructorFieldStubDataSize == 0 ? new PhpClassStub.PhpConstructorFieldStubData[]{} : new PhpClassStub.PhpConstructorFieldStubData[constructorFieldStubDataSize];
        for (int i = 0; i < constructorFieldStubDataSize; ++i) {
            int startOffset = dataStream.readInt();
            int endOffset = dataStream.readInt();
            String dataName = dataStream.readNameString();
            PhpType type = this.readPhpType(dataStream);
            boolean isDynamic = dataStream.readBoolean();
            PhpClass.PhpDynamicFieldInitPlace initPlace = (PhpClass.PhpDynamicFieldInitPlace)EntriesMappings.entries$0.get(dataStream.readInt());
            data[i] = new PhpClassStub.PhpConstructorFieldStubData(dataName, type, TextRange.create((int)startOffset, (int)endOffset), isDynamic, initPlace);
        }
        PhpDeprecationAttributeOwner.PhpDeprecationInfo deprecationInfo = PhpDeprecationAttributeOwner.PhpDeprecationInfo.read((StubInputStream)dataStream);
        PhpType backedEnumType = this.readPhpType(dataStream);
        return new PhpClassStubImpl(parentStub, this.getElementType(), name, namespace, flags, superclass, interfaces, traits, mixins, deprecatedSinceRef, data, deprecationInfo, backedEnumType);
    }

    @Override
    @NotNull
    public IElementType getElementType() {
        PhpStubElementType phpStubElementType = PhpElementTypes.CLASS;
        Intrinsics.checkNotNullExpressionValue((Object)phpStubElementType, (String)"CLASS");
        return (IElementType)phpStubElementType;
    }

    @Override
    public void indexStub(@NotNull PhpClassStub stub, @NotNull IndexSink sink) {
        Intrinsics.checkNotNullParameter((Object)stub, (String)"stub");
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        String shortName = stub.getName();
        if (shortName != null) {
            StubIndexKey<String, PhpClass> indexKey = stub.isInterface() ? PhpInterfaceIndex.KEY : (stub.isTrait() ? PhpTraitIndex.KEY : PhpClassIndex.KEY);
            sink.occurrence(indexKey, (Object)StringUtil.toLowerCase((String)shortName));
        }
        String string = stub.getSuperclass();
        if (string != null) {
            String it = string;
            boolean bl = false;
            sink.occurrence(PhpInheritanceIndex.KEY, (Object)StringUtil.toLowerCase((String)it));
        }
        String[] stringArray = stub.getInterfaces();
        Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"getInterfaces(...)");
        for (String superName : stringArray) {
            sink.occurrence(PhpInheritanceIndex.KEY, (Object)StringUtil.toLowerCase((String)superName));
        }
        if (stub.isTrait() && shortName != null) {
            sink.occurrence(PhpTraitFqnIndex.KEY, (Object)PhpLangUtil.concat(stub.getNamespaceName(), shortName));
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class EntriesMappings {
        public static final /* synthetic */ EnumEntries<PhpClass.PhpDynamicFieldInitPlace> entries$0;

        static {
            entries$0 = EnumEntriesKt.enumEntries((Enum[])((Enum[])PhpClass.PhpDynamicFieldInitPlace.values()));
        }
    }
}

