/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.psi.stubs;

import com.intellij.psi.stubs.IndexSink;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.io.StringRef;
import com.jetbrains.php.lang.psi.elements.Field;
import com.jetbrains.php.lang.psi.elements.PhpDeprecationAttributeOwner;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.stubs.PhpFieldStub;
import com.jetbrains.php.lang.psi.stubs.PhpFieldStubImpl;
import com.jetbrains.php.lang.psi.stubs.PhpLanguageTypeMap;
import com.jetbrains.php.lang.psi.stubs.PhpStubSerializer;
import com.jetbrains.php.lang.psi.stubs.indexes.PhpClassConstantIndex;
import com.jetbrains.php.lang.psi.stubs.indexes.PhpFieldIndex;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u001e\u0010\u000f\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0005H\u0016J\u0018\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\u0016H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0017"}, d2={"Lcom/jetbrains/php/lang/psi/stubs/PhpFieldStubSerializer;", "Lcom/jetbrains/php/lang/psi/stubs/PhpStubSerializer;", "Lcom/jetbrains/php/lang/psi/elements/Field;", "Lcom/jetbrains/php/lang/psi/stubs/PhpFieldStub;", "type", "Lcom/intellij/psi/tree/IElementType;", "<init>", "(Lcom/intellij/psi/tree/IElementType;)V", "getType", "()Lcom/intellij/psi/tree/IElementType;", "serialize", "", "stub", "dataStream", "Lcom/intellij/psi/stubs/StubOutputStream;", "deserialize", "Lcom/intellij/psi/stubs/StubInputStream;", "parentStub", "Lcom/intellij/psi/stubs/StubElement;", "getElementType", "indexStub", "sink", "Lcom/intellij/psi/stubs/IndexSink;", "intellij.php.impl"})
public final class PhpFieldStubSerializer
extends PhpStubSerializer<Field, PhpFieldStub> {
    @NotNull
    private final IElementType type;

    public PhpFieldStubSerializer(@NotNull IElementType type) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        this.type = type;
    }

    @NotNull
    public final IElementType getType() {
        return this.type;
    }

    public void serialize(@NotNull PhpFieldStub stub, @NotNull StubOutputStream dataStream) {
        Intrinsics.checkNotNullParameter((Object)stub, (String)"stub");
        Intrinsics.checkNotNullParameter((Object)dataStream, (String)"dataStream");
        dataStream.writeName(stub.getName());
        dataStream.writeName(stub.getDefaultValuePresentation());
        dataStream.writeShort((int)stub.getFlags());
        PhpType phpType = stub.getDeclaredType();
        Intrinsics.checkNotNullExpressionValue((Object)phpType, (String)"getDeclaredType(...)");
        this.writePhpType(dataStream, phpType);
        dataStream.writeName(stub.getDeprecatedSinceVersion());
        PhpDeprecationAttributeOwner.PhpDeprecationInfo.write((PhpDeprecationAttributeOwner.PhpDeprecationInfo)stub.getDeprecationInfo(), (StubOutputStream)dataStream);
        this.writeLanguageTypeMap(stub.getLanguageTypeMap(), dataStream);
    }

    @NotNull
    public PhpFieldStub deserialize(@NotNull StubInputStream dataStream, @Nullable StubElement<?> parentStub) {
        Intrinsics.checkNotNullParameter((Object)dataStream, (String)"dataStream");
        StringRef name = dataStream.readName();
        StringRef defaultValuePresentation = dataStream.readName();
        short flags = dataStream.readShort();
        PhpType declaredType = this.readPhpType(dataStream);
        StringRef deprecatedSinceRef = dataStream.readName();
        PhpDeprecationAttributeOwner.PhpDeprecationInfo info = PhpDeprecationAttributeOwner.PhpDeprecationInfo.read((StubInputStream)dataStream);
        PhpLanguageTypeMap map = this.readLanguageTypeMap(dataStream);
        return new PhpFieldStubImpl(parentStub, this.type, name, defaultValuePresentation, flags, deprecatedSinceRef, declaredType, info, map);
    }

    @Override
    @NotNull
    public IElementType getElementType() {
        return this.type;
    }

    @Override
    public void indexStub(@NotNull PhpFieldStub stub, @NotNull IndexSink sink) {
        Intrinsics.checkNotNullParameter((Object)stub, (String)"stub");
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        String string = stub.getName();
        if (string == null) {
            return;
        }
        String shortName = string;
        sink.occurrence(stub.isConstant() ? PhpClassConstantIndex.KEY : PhpFieldIndex.KEY, (Object)shortName);
    }
}

