/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.psi.stubs;

import com.intellij.psi.PsiElement;
import com.intellij.psi.stubs.IndexSink;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import com.intellij.psi.stubs.StubSerializer;
import com.intellij.psi.tree.IElementType;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.stubs.PhpLanguageTypeMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0004\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u0002*\u000e\b\u0001\u0010\u0003*\b\u0012\u0004\u0012\u0002H\u00010\u00042\b\u0012\u0004\u0012\u0002H\u00030\u0005B\u0007\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH&J\u001d\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00028\u00012\u0006\u0010\u000f\u001a\u00020\u0010H\u0016\u00a2\u0006\u0002\u0010\u0011J\u001a\u0010\u0012\u001a\u00020\r2\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0004J\u0012\u0010\u0017\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u0018H\u0004J\u0018\u0010\u0019\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u001bH\u0004J\u0010\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u0015\u001a\u00020\u0018H\u0004J!\u0010\u001d\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u00162\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\t0\u001f\u00a2\u0006\u0002\u0010 J\u0019\u0010!\u001a\b\u0012\u0004\u0012\u00020\t0\u001f2\u0006\u0010\u0015\u001a\u00020\u0018\u00a2\u0006\u0002\u0010\"\u00a8\u0006#"}, d2={"Lcom/jetbrains/php/lang/psi/stubs/PhpStubSerializer;", "S", "Lcom/intellij/psi/PsiElement;", "T", "Lcom/intellij/psi/stubs/StubElement;", "Lcom/intellij/psi/stubs/StubSerializer;", "<init>", "()V", "getExternalId", "", "getElementType", "Lcom/intellij/psi/tree/IElementType;", "indexStub", "", "stub", "sink", "Lcom/intellij/psi/stubs/IndexSink;", "(Lcom/intellij/psi/stubs/StubElement;Lcom/intellij/psi/stubs/IndexSink;)V", "writeLanguageTypeMap", "map", "Lcom/jetbrains/php/lang/psi/stubs/PhpLanguageTypeMap;", "dataStream", "Lcom/intellij/psi/stubs/StubOutputStream;", "readLanguageTypeMap", "Lcom/intellij/psi/stubs/StubInputStream;", "writePhpType", "type", "Lcom/jetbrains/php/lang/psi/resolve/types/PhpType;", "readPhpType", "writeStringArray", "names", "", "(Lcom/intellij/psi/stubs/StubOutputStream;[Ljava/lang/String;)V", "readStringArray", "(Lcom/intellij/psi/stubs/StubInputStream;)[Ljava/lang/String;", "intellij.php.impl"})
public abstract class PhpStubSerializer<S extends PsiElement, T extends StubElement<S>>
implements StubSerializer<T> {
    @NotNull
    public String getExternalId() {
        return "php." + this.getElementType();
    }

    @NotNull
    public abstract IElementType getElementType();

    public void indexStub(@NotNull T stub, @NotNull IndexSink sink) {
        Intrinsics.checkNotNullParameter(stub, (String)"stub");
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
    }

    protected final void writeLanguageTypeMap(@Nullable PhpLanguageTypeMap map, @NotNull StubOutputStream dataStream) {
        Intrinsics.checkNotNullParameter((Object)dataStream, (String)"dataStream");
        if (map == null) {
            dataStream.writeBoolean(false);
        } else {
            dataStream.writeBoolean(true);
            Map map2 = map.getLanguageTypeMap();
            Intrinsics.checkNotNullExpressionValue((Object)map2, (String)"getLanguageTypeMap(...)");
            Map languageTypeMap = map2;
            dataStream.writeInt(languageTypeMap.size());
            for (Map.Entry entry : languageTypeMap.entrySet()) {
                String key = (String)entry.getKey();
                PhpType value = (PhpType)entry.getValue();
                dataStream.writeName(key);
                Intrinsics.checkNotNull((Object)value);
                this.writePhpType(dataStream, value);
            }
            PhpType phpType = map.getDefaultType();
            Intrinsics.checkNotNullExpressionValue((Object)phpType, (String)"getDefaultType(...)");
            this.writePhpType(dataStream, phpType);
        }
    }

    @Nullable
    protected final PhpLanguageTypeMap readLanguageTypeMap(@NotNull StubInputStream dataStream) {
        Intrinsics.checkNotNullParameter((Object)dataStream, (String)"dataStream");
        if (!dataStream.readBoolean()) {
            return null;
        }
        int size = dataStream.readInt();
        Map languageTypeMap = new LinkedHashMap();
        for (int i = 0; i < size; ++i) {
            int it = i;
            boolean bl = false;
            String key = dataStream.readNameString();
            PhpType value = this.readPhpType(dataStream);
            if (key == null) continue;
            languageTypeMap.put(key, value);
        }
        PhpType defaultType = this.readPhpType(dataStream);
        return new PhpLanguageTypeMap(languageTypeMap, defaultType);
    }

    protected final void writePhpType(@NotNull StubOutputStream dataStream, @NotNull PhpType type) {
        Intrinsics.checkNotNullParameter((Object)dataStream, (String)"dataStream");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Set set = type.getTypesWithParametrisedParts();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"getTypesWithParametrisedParts(...)");
        Set types = set;
        dataStream.writeVarInt(types.size());
        for (String typeName : types) {
            dataStream.writeName(typeName);
        }
    }

    @NotNull
    protected final PhpType readPhpType(@NotNull StubInputStream dataStream) {
        Intrinsics.checkNotNullParameter((Object)dataStream, (String)"dataStream");
        PhpType phpType = new PhpType();
        int typeCount = dataStream.readVarInt();
        for (int i = 0; i < typeCount; ++i) {
            int it = i;
            boolean bl = false;
            String typeName = dataStream.readNameString();
            if (typeName == null) continue;
            phpType.add(typeName);
        }
        return phpType;
    }

    public final void writeStringArray(@NotNull StubOutputStream dataStream, @NotNull String[] names) {
        Intrinsics.checkNotNullParameter((Object)dataStream, (String)"dataStream");
        Intrinsics.checkNotNullParameter((Object)names, (String)"names");
        int size = RangesKt.coerceAtMost((int)names.length, (int)127);
        dataStream.writeByte(size);
        for (int i = 0; i < size; ++i) {
            dataStream.writeName(names[i]);
        }
    }

    @NotNull
    public final String[] readStringArray(@NotNull StubInputStream dataStream) {
        Intrinsics.checkNotNullParameter((Object)dataStream, (String)"dataStream");
        int supersNumber = dataStream.readByte();
        String[] stringArray = new String[supersNumber];
        for (int i = 0; i < supersNumber; ++i) {
            int n = i;
            String string = dataStream.readNameString();
            if (string == null) {
                string = "";
            }
            stringArray[n] = string;
        }
        return stringArray;
    }
}

