/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.psi.stubs.indexes;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexExtension;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.ID;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.EnumeratorStringDescriptor;
import com.intellij.util.io.KeyDescriptor;
import com.jetbrains.php.lang.classAlias.PhpClassAliasProvider;
import com.jetbrains.php.lang.classAlias.PhpClassAliasUtil;
import com.jetbrains.php.lang.psi.PhpFile;
import com.jetbrains.php.lang.psi.stubs.indexes.PhpClassAliasNameIndex;
import com.jetbrains.php.lang.psi.stubs.indexes.PhpConstantNameIndex;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class PhpClassAliasToClassIndex
extends FileBasedIndexExtension<String, DeclarationLocation> {
    public static final ID<String, DeclarationLocation> KEY = ID.create((String)"php.class.alias.to.class");
    private static final DataExternalizer<DeclarationLocation> LOCATION_DATA_EXTERNALIZER = new DataExternalizer<DeclarationLocation>(){

        public void save(@NotNull DataOutput out, DeclarationLocation location) throws IOException {
            if (out == null) {
                1.$$$reportNull$$$0(0);
            }
            out.writeInt(location.offset);
            out.writeUTF(location.originalFqn);
        }

        public DeclarationLocation read(@NotNull DataInput in) throws IOException {
            if (in == null) {
                1.$$$reportNull$$$0(1);
            }
            return new DeclarationLocation(in.readInt(), in.readUTF());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "out";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "in";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/php/lang/psi/stubs/indexes/PhpClassAliasToClassIndex$1";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "save";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "read";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    };

    @NotNull
    public ID<String, DeclarationLocation> getName() {
        ID<String, DeclarationLocation> iD = KEY;
        if (iD == null) {
            PhpClassAliasToClassIndex.$$$reportNull$$$0(0);
        }
        return iD;
    }

    public int getVersion() {
        return PhpClassAliasUtil.getVersion() + 1;
    }

    @NotNull
    public DataIndexer<String, DeclarationLocation, FileContent> getIndexer() {
        DataIndexer dataIndexer = input -> {
            List<PhpClassAliasProvider> providers = PhpClassAliasNameIndex.getRelevantProviders(input);
            if (!providers.isEmpty()) {
                HashMap map = new HashMap();
                PsiFile file = input.getPsiFile();
                if (file instanceof PhpFile) {
                    PhpClassAliasUtil.processClassAliasDeclarations((PsiElement)file, providers, (reference, result) -> {
                        int offset = reference.getTextRange().getStartOffset();
                        map.put(StringUtil.toLowerCase((String)result.getAliasFqn()), new DeclarationLocation(offset, result.getOriginalFqn()));
                    });
                    return map;
                }
            }
            return Collections.emptyMap();
        };
        if (dataIndexer == null) {
            PhpClassAliasToClassIndex.$$$reportNull$$$0(1);
        }
        return dataIndexer;
    }

    @NotNull
    public KeyDescriptor<String> getKeyDescriptor() {
        EnumeratorStringDescriptor enumeratorStringDescriptor = EnumeratorStringDescriptor.INSTANCE;
        if (enumeratorStringDescriptor == null) {
            PhpClassAliasToClassIndex.$$$reportNull$$$0(2);
        }
        return enumeratorStringDescriptor;
    }

    @NotNull
    public DataExternalizer<DeclarationLocation> getValueExternalizer() {
        DataExternalizer<DeclarationLocation> dataExternalizer = LOCATION_DATA_EXTERNALIZER;
        if (dataExternalizer == null) {
            PhpClassAliasToClassIndex.$$$reportNull$$$0(3);
        }
        return dataExternalizer;
    }

    @NotNull
    public FileBasedIndex.InputFilter getInputFilter() {
        FileBasedIndex.InputFilter inputFilter = PhpConstantNameIndex.PHP_INPUT_FILTER;
        if (inputFilter == null) {
            PhpClassAliasToClassIndex.$$$reportNull$$$0(4);
        }
        return inputFilter;
    }

    public boolean dependsOnFileContent() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/jetbrains/php/lang/psi/stubs/indexes/PhpClassAliasToClassIndex";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndexer";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeyDescriptor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getValueExternalizer";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getInputFilter";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    public static final class DeclarationLocation {
        public final int offset;
        public final String originalFqn;

        private DeclarationLocation(int offset, @NotNull String originalFqn) {
            if (originalFqn == null) {
                DeclarationLocation.$$$reportNull$$$0(0);
            }
            this.offset = offset;
            this.originalFqn = originalFqn;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof DeclarationLocation)) {
                return false;
            }
            DeclarationLocation location = (DeclarationLocation)o;
            if (this.offset != location.offset) {
                return false;
            }
            return this.originalFqn.equals(location.originalFqn);
        }

        public int hashCode() {
            int result = this.offset;
            result = 31 * result + this.originalFqn.hashCode();
            return result;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "originalFqn", "com/jetbrains/php/lang/psi/stubs/indexes/PhpClassAliasToClassIndex$DeclarationLocation", "<init>"));
        }
    }
}

