/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.psi.stubs.indexes;

import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.util.indexing.ID;
import com.intellij.util.io.DataExternalizer;
import com.jetbrains.php.lang.inspections.deadcode.PhpUnusedDeclarationPresentation;
import com.jetbrains.php.lang.psi.PhpFile;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.elements.impl.PhpClassImpl;
import com.jetbrains.php.lang.psi.stubs.indexes.PhpFlatCollectionIndexBase;
import com.jetbrains.php.lang.psi.stubs.indexes.StringSetDataExternalizer;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Stream;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public final class PhpDocTagNameIndex
extends PhpFlatCollectionIndexBase<Set<String>> {
    @NonNls
    public static final ID<Boolean, Set<String>> KEY = ID.create((String)"php.doctag.user.name");

    @Override
    protected Set<String> collectValues(@NotNull PhpFile file) {
        if (file == null) {
            PhpDocTagNameIndex.$$$reportNull$$$0(0);
        }
        HashSet<String> userTagNames = new HashSet<String>();
        StreamEx.of(PhpDocTagNameIndex.methodsAndFields(file)).append(file.getTopLevelDefs().values()).flatMap(namedElement -> PhpUnusedDeclarationPresentation.getCustomDocTags(namedElement).stream()).forEach(userTagNames::add);
        return userTagNames;
    }

    @NotNull
    private static Stream<PhpNamedElement> methodsAndFields(@NotNull PhpFile file) {
        if (file == null) {
            PhpDocTagNameIndex.$$$reportNull$$$0(1);
        }
        StreamEx streamEx = StreamEx.of(PhpPsiUtil.findClasses(file, (Condition<? super PhpClass>)Conditions.alwaysTrue())).select(PhpClassImpl.class).flatMap(aClass -> PhpDocTagNameIndex.getClassMethodsAndFields(aClass));
        if (streamEx == null) {
            PhpDocTagNameIndex.$$$reportNull$$$0(2);
        }
        return streamEx;
    }

    @NotNull
    public ID<Boolean, Set<String>> getName() {
        ID<Boolean, Set<String>> iD = KEY;
        if (iD == null) {
            PhpDocTagNameIndex.$$$reportNull$$$0(3);
        }
        return iD;
    }

    @NotNull
    public DataExternalizer<Set<String>> getValueExternalizer() {
        StringSetDataExternalizer stringSetDataExternalizer = StringSetDataExternalizer.INSTANCE;
        if (stringSetDataExternalizer == null) {
            PhpDocTagNameIndex.$$$reportNull$$$0(4);
        }
        return stringSetDataExternalizer;
    }

    private static Stream<PhpNamedElement> getClassMethodsAndFields(PhpClassImpl myClass) {
        return Stream.concat(myClass.getOwnMethodsInternal(false).values().stream(), Arrays.stream(myClass.getOwnFields()));
    }

    @Override
    public int getVersion() {
        return 6;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/psi/stubs/indexes/PhpDocTagNameIndex";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/psi/stubs/indexes/PhpDocTagNameIndex";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "methodsAndFields";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getValueExternalizer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "collectValues";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "methodsAndFields";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4 -> new IllegalStateException(string);
        };
    }
}

