/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.psi.stubs.indexes;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexExtension;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.ID;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.EnumeratorStringDescriptor;
import com.intellij.util.io.KeyDescriptor;
import com.jetbrains.php.codeInsight.controlFlow.PhpControlFlow;
import com.jetbrains.php.codeInsight.controlFlow.PhpControlFlowUtil;
import com.jetbrains.php.codeInsight.controlFlow.PhpInstructionProcessor;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpAccessVariableInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpArrayAccessInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpInstruction;
import com.jetbrains.php.codeInsight.typeInference.PhpDfaDelegateBasedTypeState;
import com.jetbrains.php.lang.inspections.parameterCountMismatch.PhpFuncGetArgUsageProvider;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.lang.psi.stubs.indexes.PhpCollectionExternalizer;
import com.jetbrains.php.lang.psi.stubs.indexes.PhpConstantNameIndex;
import com.jetbrains.php.lang.psi.stubs.indexes.expectedArguments.PhpExpectedFunctionArgument;
import com.jetbrains.php.lang.psi.stubs.indexes.expectedArguments.PhpExpectedFunctionArgumentsIndex;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;

public final class PhpUsedParametersArrayKeysIndex
extends FileBasedIndexExtension<String, Collection<PhpExpectedFunctionArgument>> {
    @NotNull
    public static final ID<String, Collection<PhpExpectedFunctionArgument>> KEY = ID.create((String)"php.used.parameters.array.keys");
    public static final PhpCollectionExternalizer<PhpExpectedFunctionArgument> VALUE_EXTERNALIZER = new PhpCollectionExternalizer<PhpExpectedFunctionArgument>(PhpExpectedFunctionArgumentsIndex.EXTERNALIZER, HashSet::new);

    @NotNull
    public ID<String, Collection<PhpExpectedFunctionArgument>> getName() {
        ID<String, Collection<PhpExpectedFunctionArgument>> iD = KEY;
        if (iD == null) {
            PhpUsedParametersArrayKeysIndex.$$$reportNull$$$0(0);
        }
        return iD;
    }

    @NotNull
    public DataIndexer<String, Collection<PhpExpectedFunctionArgument>, FileContent> getIndexer() {
        return new DataIndexer<String, Collection<PhpExpectedFunctionArgument>, FileContent>(this){

            @NotNull
            public Map<String, Collection<PhpExpectedFunctionArgument>> map(@NotNull FileContent inputData) {
                if (inputData == null) {
                    1.$$$reportNull$$$0(0);
                }
                Map map = PhpFuncGetArgUsageProvider.findTopLevelFunctions(inputData.getPsiFile()).flatMapToEntry(PhpUsedParametersArrayKeysIndex::parametersWithUsedArrayKeys).toMap(ContainerUtil::union);
                if (map == null) {
                    1.$$$reportNull$$$0(1);
                }
                return map;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 1 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "inputData";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/jetbrains/php/lang/psi/stubs/indexes/PhpUsedParametersArrayKeysIndex$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/jetbrains/php/lang/psi/stubs/indexes/PhpUsedParametersArrayKeysIndex$1";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "map";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "map";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 1 -> new IllegalStateException(string);
                };
            }
        };
    }

    private static Map<String, Collection<PhpExpectedFunctionArgument>> parametersWithUsedArrayKeys(Function f) {
        PhpControlFlow flow = f.getControlFlow();
        return StreamEx.of(PhpUsedParametersArrayKeysIndex.collectParametersWithUsedArrayKeysCandidates(f)).mapToEntry(p -> PhpUsedParametersArrayKeysIndex.signParameterName(f, p), p -> PhpUsedParametersArrayKeysIndex.getUsedArrayKeys(flow, p)).filterValues(keys -> !keys.isEmpty()).toMap();
    }

    @NotNull
    private static String signParameterName(Function f, CharSequence p) {
        String string = f.getFQN() + "." + String.valueOf(p);
        if (string == null) {
            PhpUsedParametersArrayKeysIndex.$$$reportNull$$$0(1);
        }
        return string;
    }

    private static Collection<CharSequence> collectParametersWithUsedArrayKeysCandidates(Function f) {
        final HashSet<CharSequence> res = new HashSet<CharSequence>();
        final List parameterNames = ContainerUtil.map((Object[])f.getParameters(), Parameter::getName);
        PhpControlFlowUtil.processFlow(f.getControlFlow(), new PhpInstructionProcessor(){

            public boolean processArrayAccessInstruction(PhpArrayAccessInstruction instruction) {
                CharSequence variableName = instruction.getVariableName();
                if (variableName != null && parameterNames.contains(variableName) && !instruction.getAccess().isWrite()) {
                    res.add(variableName);
                }
                return super.processArrayAccessInstruction(instruction);
            }
        });
        return res;
    }

    private static Collection<PhpExpectedFunctionArgument> getUsedArrayKeys(PhpControlFlow flow, final CharSequence parameterName) {
        final HashSet<PhpExpectedFunctionArgument> keys = new HashSet<PhpExpectedFunctionArgument>();
        final HashSet writtenKeys = new HashSet();
        PhpControlFlowUtil.processSuccessors((PhpInstruction)flow.getEntryPoint(), false, new PhpInstructionProcessor(){

            public boolean processAccessVariableInstruction(PhpAccessVariableInstruction instruction) {
                if (instruction.getVariableName().equals(parameterName) && instruction.getAccess().isWrite()) {
                    return false;
                }
                return super.processAccessVariableInstruction(instruction);
            }

            public boolean processArrayAccessInstruction(PhpArrayAccessInstruction instruction) {
                CharSequence variableName = instruction.getVariableName();
                PsiElement key = instruction.getKey();
                if (key != null && parameterName.equals(variableName) && PhpDfaDelegateBasedTypeState.PhpPrimitiveTypeCheckByComparison.isStringWithoutInterpolations(key)) {
                    PhpExpectedFunctionArgument argument = PhpExpectedFunctionArgumentsIndex.getExpectedArgument(key, 0, 0, null, false);
                    if (!instruction.getAccess().isWrite() && !writtenKeys.contains(argument)) {
                        keys.add(argument);
                    } else {
                        writtenKeys.add(argument);
                    }
                }
                return super.processArrayAccessInstruction(instruction);
            }
        });
        return keys;
    }

    @NotNull
    public KeyDescriptor<String> getKeyDescriptor() {
        EnumeratorStringDescriptor enumeratorStringDescriptor = EnumeratorStringDescriptor.INSTANCE;
        if (enumeratorStringDescriptor == null) {
            PhpUsedParametersArrayKeysIndex.$$$reportNull$$$0(2);
        }
        return enumeratorStringDescriptor;
    }

    @NotNull
    public DataExternalizer<Collection<PhpExpectedFunctionArgument>> getValueExternalizer() {
        PhpCollectionExternalizer<PhpExpectedFunctionArgument> phpCollectionExternalizer = VALUE_EXTERNALIZER;
        if (phpCollectionExternalizer == null) {
            PhpUsedParametersArrayKeysIndex.$$$reportNull$$$0(3);
        }
        return phpCollectionExternalizer;
    }

    public int getVersion() {
        return 1;
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
    @NotNull FileBasedIndex.InputFilter getInputFilter() {
        FileBasedIndex.InputFilter inputFilter = PhpConstantNameIndex.PHP_INPUT_FILTER;
        if (inputFilter == null) {
            PhpUsedParametersArrayKeysIndex.$$$reportNull$$$0(4);
        }
        return inputFilter;
    }

    public boolean dependsOnFileContent() {
        return true;
    }

    public static Collection<PhpExpectedFunctionArgument> getUsedEntries(Parameter parameter, Function function) {
        String signature = PhpUsedParametersArrayKeysIndex.signParameterName(function, parameter.getName());
        HashSet<PhpExpectedFunctionArgument> res = new HashSet<PhpExpectedFunctionArgument>();
        FileBasedIndex.getInstance().processValues(KEY, (Object)signature, null, (file, value) -> {
            res.addAll((Collection<PhpExpectedFunctionArgument>)value);
            return true;
        }, GlobalSearchScope.allScope((Project)parameter.getProject()));
        return res;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/jetbrains/php/lang/psi/stubs/indexes/PhpUsedParametersArrayKeysIndex";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "signParameterName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeyDescriptor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getValueExternalizer";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getInputFilter";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

