/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.phar;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileCopyEvent;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileMoveEvent;
import com.intellij.openapi.vfs.VirtualFilePropertyEvent;
import com.intellij.openapi.vfs.impl.BulkVirtualFileListenerAdapter;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileDeleteEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.platform.backend.workspace.VirtualFileUrls;
import com.intellij.platform.backend.workspace.WorkspaceModel;
import com.intellij.platform.workspace.storage.EntitySource;
import com.intellij.platform.workspace.storage.EntityStorage;
import com.intellij.platform.workspace.storage.EntityStorageKt;
import com.intellij.platform.workspace.storage.ImmutableEntityStorage;
import com.intellij.platform.workspace.storage.MutableEntityStorage;
import com.intellij.platform.workspace.storage.WorkspaceEntity;
import com.intellij.platform.workspace.storage.url.VirtualFileUrl;
import com.intellij.platform.workspace.storage.url.VirtualFileUrlManager;
import com.intellij.psi.search.FileTypeIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xmlb.annotations.XCollection;
import com.jetbrains.php.config.library.PhpAdditionalLibraryManager;
import com.jetbrains.php.phar.PharEntitySource;
import com.jetbrains.php.phar.PharFileSystem;
import com.jetbrains.php.phar.PharFileType;
import com.jetbrains.php.phar.PharRootsEntity;
import com.jetbrains.php.phar.PharRootsEntityBuilder;
import com.jetbrains.php.phar.PharRootsEntityModifications;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

@Service(value={Service.Level.PROJECT})
@com.intellij.openapi.components.State(name="ExcludedPharFiles", storages={@Storage(value="$WORKSPACE_FILE$")})
public final class PharLibraryManager
extends PhpAdditionalLibraryManager
implements PersistentStateComponent<State> {
    private static final Logger LOG = Logger.getInstance(PharLibraryManager.class);
    @NlsSafe
    public static final String PHAR_LIBRARY_NAME = "PHARS";
    private static final EntitySource PHAR_ENTITY_SOURCE = new PharEntitySource();
    private static final boolean useWorkspaceEntities = Registry.is((String)"php.use.workspace.entities.for.phars");
    private final Object EXCLUSION_WRITE_LOCK;
    private volatile Set<VirtualFile> myExcludedFiles;

    public static PharLibraryManager getInstance(@NotNull Project project) {
        if (project == null) {
            PharLibraryManager.$$$reportNull$$$0(0);
        }
        return (PharLibraryManager)project.getService(PharLibraryManager.class);
    }

    private PharLibraryManager(@NotNull Project project, @NotNull CoroutineScope scope) {
        if (project == null) {
            PharLibraryManager.$$$reportNull$$$0(1);
        }
        if (scope == null) {
            PharLibraryManager.$$$reportNull$$$0(2);
        }
        super(project, scope, LOG);
        this.EXCLUSION_WRITE_LOCK = new Object();
        this.myExcludedFiles = new HashSet<VirtualFile>();
    }

    public Collection<VirtualFile> getPharsForAdditionalLibraryContributor() {
        if (useWorkspaceEntities) {
            return Collections.emptyList();
        }
        List<VirtualFile> phars = this.getRoots();
        LOG.trace("myPhars " + String.valueOf(phars));
        if (this.myExcludedFiles.isEmpty()) {
            return phars;
        }
        phars = new ArrayList<VirtualFile>(phars);
        phars.removeAll(this.myExcludedFiles);
        return phars;
    }

    @Override
    public void projectOpened() {
        this.myProject.getMessageBus().connect((Disposable)this).subscribe(VirtualFileManager.VFS_CHANGES, (Object)new BulkVirtualFileListenerAdapter((VirtualFileListener)new MyLocalVirtualFileListener()));
        this.myProject.getMessageBus().connect((Disposable)this).subscribe(VirtualFileManager.VFS_CHANGES, (Object)new PharFileDeletedListener());
        super.projectOpened();
        PharLibraryManager.deleteOldStyleLibrary(this.myProject, PHAR_LIBRARY_NAME);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void loadInitialRoots(List<VirtualFile> roots) {
        if (!useWorkspaceEntities) {
            return;
        }
        PharRootsEntity entity = PharLibraryManager.getPharRootsEntity((EntityStorage)WorkspaceModel.getInstance((Project)this.myProject).getCurrentSnapshot());
        if (entity == null) {
            return;
        }
        entity.getRoots().forEach(root -> {
            VirtualFile file = VirtualFileUrls.getVirtualFile((VirtualFileUrl)root);
            if (file != null && file.isValid() && PharFileType.isPhar(file)) {
                roots.add(file);
            }
        });
        HashSet<VirtualFile> excludedRoots = new HashSet<VirtualFile>();
        entity.getExcludedRoots().forEach(root -> {
            VirtualFile file = VirtualFileUrls.getVirtualFile((VirtualFileUrl)root);
            if (file != null && file.isValid() && PharFileType.isPhar(file)) {
                excludedRoots.add(file);
            }
        });
        Object object = this.EXCLUSION_WRITE_LOCK;
        synchronized (object) {
            this.myExcludedFiles = excludedRoots;
        }
    }

    @Nullable
    private static PharRootsEntity getPharRootsEntity(EntityStorage storage) {
        Sequence entities = storage.entities(PharRootsEntity.class);
        return (PharRootsEntity)SequencesKt.firstOrNull((Sequence)entities);
    }

    @Override
    @NotNull
    protected @Unmodifiable Collection<VirtualFile> collectRoots() {
        Collection collection = (Collection)ReadAction.nonBlocking(() -> {
            Collection files = FileTypeIndex.getFiles((FileType)PharFileType.INSTANCE, (GlobalSearchScope)GlobalSearchScope.allScope((Project)this.myProject));
            PharFileSystem pharFileSystem = PharFileSystem.getInstance();
            return ContainerUtil.filter((Collection)files, f -> f.getFileSystem() != pharFileSystem);
        }).inSmartMode(this.myProject).expireWith((Disposable)this).executeSynchronously();
        if (collection == null) {
            PharLibraryManager.$$$reportNull$$$0(3);
        }
        return collection;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void addPatchedRoots(@NotNull Collection<? extends VirtualFile> rootsToAdd, @NotNull List<? super VirtualFile> newRoots) {
        if (rootsToAdd == null) {
            PharLibraryManager.$$$reportNull$$$0(4);
        }
        if (newRoots == null) {
            PharLibraryManager.$$$reportNull$$$0(5);
        }
        PharFileSystem pharFileSystem = PharFileSystem.getInstance();
        for (VirtualFile virtualFile : rootsToAdd) {
            void var5_5;
            if (virtualFile.getFileSystem() != pharFileSystem) {
                VirtualFile virtualFile2 = pharFileSystem.refreshAndFindFileByPath(virtualFile.getPath());
            }
            if (var5_5 == null) continue;
            LOG.trace("Added " + var5_5.getPath());
            newRoots.add((VirtualFile)var5_5);
        }
    }

    @Override
    protected void notifyPlatformLibraryRootsChanged(@NotNull List<VirtualFile> newRoots, @NotNull Collection<VirtualFile> oldRoots) {
        if (newRoots == null) {
            PharLibraryManager.$$$reportNull$$$0(6);
        }
        if (oldRoots == null) {
            PharLibraryManager.$$$reportNull$$$0(7);
        }
        if (useWorkspaceEntities) {
            this.saveRootsToWorkspaceModel(newRoots);
        } else {
            super.notifyPlatformLibraryRootsChanged(newRoots, oldRoots);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveRootsToWorkspaceModel(@NotNull List<VirtualFile> newRoots) {
        ArrayList<VirtualFile> excludedFiles;
        if (newRoots == null) {
            PharLibraryManager.$$$reportNull$$$0(8);
        }
        WorkspaceModel workspaceModel = WorkspaceModel.getInstance((Project)this.myProject);
        ImmutableEntityStorage entityStorage = workspaceModel.getCurrentSnapshot();
        List entities = SequencesKt.toList((Sequence)entityStorage.entities(PharRootsEntity.class));
        if (newRoots.isEmpty() && entities.isEmpty()) {
            return;
        }
        PharRootsEntity entity = (PharRootsEntity)CollectionsKt.firstOrNull((List)entities);
        VirtualFileUrlManager fileUrlManager = workspaceModel.getVirtualFileUrlManager();
        List fileUrls = ContainerUtil.map(newRoots, root -> fileUrlManager.getOrCreateFromUrl(root.getUrl()));
        Object object = this.EXCLUSION_WRITE_LOCK;
        synchronized (object) {
            excludedFiles = new ArrayList<VirtualFile>(this.myExcludedFiles);
        }
        List excludedUrls = ContainerUtil.map(excludedFiles, root -> fileUrlManager.getOrCreateFromUrl(root.getUrl()));
        if (!newRoots.isEmpty() && entity != null && entities.size() == 1 && entity.getRoots().equals(fileUrls) && entity.getExcludedRoots().equals(excludedUrls)) {
            return;
        }
        MutableEntityStorage preliminaryBuilder = EntityStorageKt.toBuilder((ImmutableEntityStorage)entityStorage);
        if (newRoots.isEmpty()) {
            for (PharRootsEntity rootsEntity : entities) {
                preliminaryBuilder.removeEntity((WorkspaceEntity)rootsEntity);
            }
        } else if (entity == null) {
            preliminaryBuilder.addEntity((WorkspaceEntity.Builder)PharRootsEntityModifications.createPharRootsEntity(fileUrls, excludedUrls, PHAR_ENTITY_SOURCE));
        } else {
            preliminaryBuilder.modifyEntity(PharRootsEntityBuilder.class, (WorkspaceEntity)entity, pharRootsEntity -> {
                pharRootsEntity.setRoots(fileUrls);
                pharRootsEntity.setExcludedRoots(excludedUrls);
                return Unit.INSTANCE;
            });
            for (int i = 1; i < entities.size(); ++i) {
                preliminaryBuilder.removeEntity((WorkspaceEntity)entities.get(i));
            }
        }
        PharLibraryManager.modifyWorkspaceModel(this.myProject, "Updating PHARs", (Function1<? super MutableEntityStorage, Unit>)((Function1)storage -> {
            storage.applyChangesFrom(preliminaryBuilder);
            return Unit.INSTANCE;
        }));
    }

    @Nullable
    private static VirtualFile getFile(VirtualFileEvent event, Project project) {
        if (project == null || project.isDisposed()) {
            return null;
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        VirtualFile file = event.getFile();
        if (!PharFileType.isPhar(file)) {
            return null;
        }
        file = PharFileSystem.getInstance().refreshAndFindFileByPath(file.getPath());
        return file;
    }

    public boolean isExcluded(@NotNull VirtualFile pharFile) {
        if (pharFile == null) {
            PharLibraryManager.$$$reportNull$$$0(9);
        }
        return this.myExcludedFiles.contains(pharFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setExcluded(VirtualFile @NotNull [] pharFiles, boolean excluded) {
        if (pharFiles == null) {
            PharLibraryManager.$$$reportNull$$$0(10);
        }
        if (LOG.isTraceEnabled()) {
            StringBuilder stringBuilder = new StringBuilder("SetExcluded ").append(excluded).append('\n');
            for (VirtualFile file : pharFiles) {
                stringBuilder.append(file.getPath()).append('\n');
            }
            LOG.trace(stringBuilder.toString());
        }
        List<VirtualFile> oldRoots = this.getRoots();
        VirtualFile[] virtualFileArray = this.EXCLUSION_WRITE_LOCK;
        synchronized (this.EXCLUSION_WRITE_LOCK) {
            HashSet<VirtualFile> excludedFiles = new HashSet<VirtualFile>(this.myExcludedFiles);
            if (excluded) {
                ContainerUtil.addAll(excludedFiles, (Object[])pharFiles);
            } else {
                ContainerUtil.removeAll(excludedFiles, (Object[])pharFiles);
            }
            this.myExcludedFiles = excludedFiles;
            // ** MonitorExit[var4_4] (shouldn't be in output)
            List<VirtualFile> newRoots = this.getRoots();
            if (useWorkspaceEntities) {
                this.saveRootsToWorkspaceModel(newRoots);
            } else {
                PharLibraryManager.fireLibraryChanged(this.myProject, this.getPresentableLibraryName(), newRoots, oldRoots);
            }
            return;
        }
    }

    @Override
    @Nls
    @NotNull
    protected String getPresentableLibraryName() {
        return PHAR_LIBRARY_NAME;
    }

    public State getState() {
        return new State(this.myExcludedFiles);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadState(@NotNull State state) {
        if (state == null) {
            PharLibraryManager.$$$reportNull$$$0(11);
        }
        HashSet<VirtualFile> excludedFiles = new HashSet<VirtualFile>();
        PharFileSystem pharFileSystem = PharFileSystem.getInstance();
        for (String path : state.getPaths()) {
            VirtualFile excludedPhar = pharFileSystem.findFileByPath(path);
            if (excludedPhar == null) continue;
            excludedFiles.add(excludedPhar);
        }
        Object object = this.EXCLUSION_WRITE_LOCK;
        synchronized (object) {
            this.myExcludedFiles = excludedFiles;
        }
        if (LOG.isTraceEnabled()) {
            StringBuilder stringBuilder = new StringBuilder("Loaded state ").append('\n');
            for (VirtualFile file : this.myExcludedFiles) {
                stringBuilder.append(file.getPath()).append('\n');
            }
            LOG.trace(stringBuilder.toString());
        }
    }

    private void saveBothPharAndExcludedPaths(VirtualFile realPharFile, boolean removeInvalidFiles) {
        this.modifyLibraries(realPharFile, removeInvalidFiles);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/phar/PharLibraryManager";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootsToAdd";
                break;
            }
            case 5: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newRoots";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldRoots";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pharFile";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pharFiles";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/phar/PharLibraryManager";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "collectRoots";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addPatchedRoots";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "notifyPlatformLibraryRootsChanged";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "saveRootsToWorkspaceModel";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isExcluded";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "setExcluded";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }

    private class MyLocalVirtualFileListener
    implements VirtualFileListener {
        private MyLocalVirtualFileListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void propertyChanged(@NotNull VirtualFilePropertyEvent event) {
            if (event == null) {
                MyLocalVirtualFileListener.$$$reportNull$$$0(0);
            }
            if (!"name".equals(event.getPropertyName())) {
                return;
            }
            VirtualFile file = event.getFile();
            if (!PharFileType.isPhar(file)) {
                return;
            }
            LOG.trace("Property changed on " + file.getPath());
            VirtualFile realPharFile = PharFileSystem.getInstance().refreshAndFindFileByPath(file.getPath());
            if (realPharFile == null) {
                LOG.warn("Failed to find phar file on '" + file.getPath() + "'");
                return;
            }
            Object object = PharLibraryManager.this.EXCLUSION_WRITE_LOCK;
            synchronized (object) {
                for (VirtualFile excludedFile : PharLibraryManager.this.myExcludedFiles) {
                    if (!MyLocalVirtualFileListener.matches(excludedFile, file.getParent(), (String)event.getOldValue())) continue;
                    LOG.trace("Should exclude");
                    HashSet<VirtualFile> excludedFiles = new HashSet<VirtualFile>(PharLibraryManager.this.myExcludedFiles);
                    excludedFiles.add(realPharFile);
                    PharLibraryManager.this.myExcludedFiles = excludedFiles;
                    break;
                }
            }
            PharLibraryManager.this.saveBothPharAndExcludedPaths(realPharFile, false);
        }

        public void fileCreated(@NotNull VirtualFileEvent event) {
            VirtualFile file;
            if (event == null) {
                MyLocalVirtualFileListener.$$$reportNull$$$0(1);
            }
            if ((file = PharLibraryManager.getFile(event, PharLibraryManager.this.myProject)) == null) {
                return;
            }
            LOG.trace("FileCreated " + file.getPath());
            PharLibraryManager.this.saveBothPharAndExcludedPaths(file, false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void fileMoved(@NotNull VirtualFileMoveEvent event) {
            VirtualFile file;
            if (event == null) {
                MyLocalVirtualFileListener.$$$reportNull$$$0(2);
            }
            if (!PharFileType.isPhar(file = event.getFile())) {
                return;
            }
            VirtualFile realPharFile = PharFileSystem.getInstance().refreshAndFindFileByPath(file.getPath());
            if (realPharFile == null) {
                LOG.warn("Failed to find phar file on '" + file.getPath() + "'");
                return;
            }
            LOG.trace("FileMoved " + realPharFile.getPath());
            Object object = PharLibraryManager.this.EXCLUSION_WRITE_LOCK;
            synchronized (object) {
                LOG.trace("OldParent path " + event.getOldParent().getPath());
                for (VirtualFile excludedFile : PharLibraryManager.this.myExcludedFiles) {
                    if (!MyLocalVirtualFileListener.matches(excludedFile, event.getOldParent(), file.getName())) continue;
                    LOG.trace("Should exclude");
                    HashSet<VirtualFile> excludedFiles = new HashSet<VirtualFile>(PharLibraryManager.this.myExcludedFiles);
                    excludedFiles.add(realPharFile);
                    PharLibraryManager.this.myExcludedFiles = excludedFiles;
                    break;
                }
            }
            PharLibraryManager.this.saveBothPharAndExcludedPaths(file, false);
        }

        private static boolean matches(VirtualFile pharFile, VirtualFile localParent, @NotNull String name) {
            if (name == null) {
                MyLocalVirtualFileListener.$$$reportNull$$$0(3);
            }
            if (!name.equals(pharFile.getName())) {
                return false;
            }
            String path = pharFile.getPath();
            String parentPath = PathUtil.getParentPath((String)path);
            VirtualFile localPharParent = LocalFileSystem.getInstance().refreshAndFindFileByPath(parentPath);
            boolean equals = localParent.equals(localPharParent);
            if (LOG.isTraceEnabled()) {
                LOG.trace("Matches phar " + pharFile.getPath() + ", local parent " + localParent.getPath() + ", name " + name + " " + equals);
            }
            return equals;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void fileCopied(@NotNull VirtualFileCopyEvent event) {
            VirtualFile file;
            if (event == null) {
                MyLocalVirtualFileListener.$$$reportNull$$$0(4);
            }
            if (!PharFileType.isPhar(file = event.getFile())) {
                return;
            }
            LOG.trace("FileCopied " + file.getPath());
            PharFileSystem pharFileSystem = PharFileSystem.getInstance();
            VirtualFile realPharFile = pharFileSystem.refreshAndFindFileByPath(file.getPath());
            if (realPharFile == null) {
                LOG.warn("Failed to find phar file on '" + file.getPath() + "'");
                return;
            }
            VirtualFile realOriginalPhar = pharFileSystem.refreshAndFindFileByPath(event.getOriginalFile().getPath());
            if (realOriginalPhar != null) {
                Object object = PharLibraryManager.this.EXCLUSION_WRITE_LOCK;
                synchronized (object) {
                    if (PharLibraryManager.this.myExcludedFiles.contains(realOriginalPhar)) {
                        LOG.trace("Should exclude");
                        HashSet<VirtualFile> excludedFiles = new HashSet<VirtualFile>(PharLibraryManager.this.myExcludedFiles);
                        excludedFiles.add(realOriginalPhar);
                        PharLibraryManager.this.myExcludedFiles = excludedFiles;
                    }
                }
            }
            PharLibraryManager.this.saveBothPharAndExcludedPaths(realPharFile, false);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/php/phar/PharLibraryManager$MyLocalVirtualFileListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "propertyChanged";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "fileCreated";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "fileMoved";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "matches";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "fileCopied";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class PharFileDeletedListener
    implements VirtualFileListener,
    BulkFileListener {
        private PharFileDeletedListener() {
        }

        public void after(@NotNull @NotNull List<? extends @NotNull VFileEvent> events) {
            if (events == null) {
                PharFileDeletedListener.$$$reportNull$$$0(0);
            }
            for (VFileEvent vFileEvent : events) {
                if (!(vFileEvent instanceof VFileDeleteEvent)) continue;
                this.onFileDelete(((VFileDeleteEvent)vFileEvent).getFile());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void onFileDelete(@NotNull VirtualFile realPharFile) {
            if (realPharFile == null) {
                PharFileDeletedListener.$$$reportNull$$$0(1);
            }
            if (!realPharFile.getFileSystem().getProtocol().equals("phar")) {
                return;
            }
            LOG.trace("FileDeleted in phar " + realPharFile.getPath());
            Object object = PharLibraryManager.this.EXCLUSION_WRITE_LOCK;
            synchronized (object) {
                HashSet<VirtualFile> excludedFiles = new HashSet<VirtualFile>(PharLibraryManager.this.myExcludedFiles);
                excludedFiles.remove(realPharFile);
                PharLibraryManager.this.myExcludedFiles = excludedFiles;
            }
            PharLibraryManager.this.saveBothPharAndExcludedPaths(null, true);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "events";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "realPharFile";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/php/phar/PharLibraryManager$PharFileDeletedListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "after";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "onFileDelete";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class State {
        private List<String> myPaths = new ArrayList<String>();

        public State() {
        }

        public State(Collection<? extends VirtualFile> files) {
            for (VirtualFile virtualFile : files) {
                this.myPaths.add(virtualFile.getPath());
            }
        }

        @XCollection(propertyElementName="excludedPaths", elementName="path")
        public List<String> getPaths() {
            return this.myPaths;
        }

        public void setPaths(List<String> paths) {
            this.myPaths = paths;
        }
    }
}

