/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.phpunit.codeGeneration;

import com.intellij.DynamicBundle;
import com.intellij.ide.projectView.impl.ProjectRootsUtil;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ContentFolder;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ModuleRootModel;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.SourceFolder;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.refactoring.classMembers.MemberInfoBase;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.SimpleListCellRenderer;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PlatformIcons;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.PhpIndex;
import com.jetbrains.php.actions.PhpBaseNewClassDialog;
import com.jetbrains.php.actions.PhpNewFileDialog;
import com.jetbrains.php.completion.PhpCompletionUtil;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpClassMember;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.phpunit.codeGeneration.PhpTestCreator;
import com.jetbrains.php.phpunit.codeGeneration.PhpTestDirectoryByPsrProvider;
import com.jetbrains.php.refactoring.PhpMemberInfo;
import com.jetbrains.php.refactoring.ui.PhpMemberSelectionPanel;
import com.jetbrains.php.roots.PhpDirectoryByPsrProvider;
import com.jetbrains.php.roots.PhpNamespaceCompositeProvider;
import com.jetbrains.php.roots.PhpNamespaceProvider;
import com.jetbrains.php.roots.ui.PhpPsrDirectoryComboBox;
import com.jetbrains.php.testFramework.PhpTestCreateInfo;
import com.jetbrains.php.testFramework.PhpTestFrameworkType;
import com.jetbrains.php.ui.PhpUiUtil;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.function.Function;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.event.DocumentEvent;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpNewTestDialog
extends PhpBaseNewClassDialog {
    private static final String DEFAULT_LIBRARY_NAME_PROPERTY = PhpNewTestDialog.class.getName() + ".defaultLibrary";
    private JPanel myMainPanel;
    private EditorTextField myNameTextField;
    private EditorTextField myNamespaceTextField;
    private EditorTextField myTestTargetTextField;
    private JBLabel myNamespaceCompletionHintLabel;
    private JBLabel myTestTargetCompletionHintLabel;
    protected PhpPsrDirectoryComboBox myDirectoryCombobox;
    private JBLabel myEditDirectoryHintLabel;
    private JPanel myLibrariesComboWrapper;
    private JBLabel myLibrariesLabel;
    private JBLabel myLibrariesUpDownHint;
    private JPanel myMethodsTableWrapper;
    private ComboBox<String> myTestTargetFileCombo;
    private JPanel myTestTargetPanel;
    private JBCheckBox myShowInheritedMembersCheckBox;
    private final PhpMemberSelectionPanel myMethodsPanel;
    private final ComboBox<PhpTestCreateInfo> myLibrariesCombo;
    private boolean myTestTargetTextChanged;
    @Nullable
    private final String mySelectedElementName;
    private boolean myLibraryChanged;
    private boolean myTestMethodSelectedOnInit;
    public boolean mySuggestionFieldsWasChangedUnderFocus;
    public boolean myTestTargetTextChangedUnderFocus;
    public boolean myMethodsTableWasChangedUnderFocus;
    public boolean myShowInheritedMembersChangedUnderFocus;

    public PhpNewTestDialog(final @NotNull Project project, @Nullable PsiDirectory directory, final @Nullable PsiFile file, @Nullable PhpTestCreateInfo defaultTestCreateInfo, final @Nullable PhpNamedElement selectedElement) {
        if (project == null) {
            PhpNewTestDialog.$$$reportNull$$$0(0);
        }
        super(project, directory);
        this.$$$setupUI$$$();
        this.myMethodsPanel = new PhpMemberSelectionPanel(null, Collections.emptyList(), null);
        this.myLibrariesCombo = new ComboBox(new DefaultComboBoxModel());
        this.initTestLibraryCombo(project, defaultTestCreateInfo);
        this.init(this.myMainPanel, this.myNameTextField, null, this.myNamespaceCompletionHintLabel, null, this.myDirectoryCombobox, this.myEditDirectoryHintLabel);
        PhpCompletionUtil.installNamespaceCompletion(this.myNamespaceTextField, this.getNamespace(), this.getDisposable());
        final Component component = this.myDirectoryCombobox.getComboBox().getEditor().getEditorComponent();
        if (component instanceof JTextField) {
            this.myDirectoryCombobox.getComboBox().addItemListener(e -> {
                if (!component.isFocusOwner()) {
                    return;
                }
                this.addUpdateRequest(() -> {
                    if (this.mySuggestionFieldsWasChangedUnderFocus || this.getSelectedTargetClass(project) == null) {
                        return;
                    }
                    this.updateTestNameAndNamespaces(project, this.myTestTargetTextField.getText());
                });
            });
            ((JTextField)component).getDocument().addDocumentListener((javax.swing.event.DocumentListener)new DocumentAdapter(){

                protected void textChanged(@NotNull DocumentEvent e) {
                    if (e == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (!component.isFocusOwner()) {
                        return;
                    }
                    PhpNewTestDialog.this.addUpdateRequest(() -> {
                        PhpNewTestDialog.this.mySuggestionFieldsWasChangedUnderFocus = true;
                    });
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/jetbrains/php/phpunit/codeGeneration/PhpNewTestDialog$1", "textChanged"));
                }
            });
        }
        this.myTestTargetTextField.addDocumentListener(new DocumentListener(){

            public void documentChanged(@NotNull com.intellij.openapi.editor.event.DocumentEvent e) {
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                PhpNewTestDialog.this.addUpdateRequest(() -> {
                    String text = PhpNewTestDialog.this.myTestTargetTextField.getText();
                    if (!StringUtil.isEmpty((String)text) && !StringUtil.endsWith((CharSequence)text, (CharSequence)"\\")) {
                        if (ApplicationManager.getApplication().isUnitTestMode()) {
                            this.updateUi(PhpIndex.getInstance((Project)PhpNewTestDialog.this.getProject()).getAnyByFQN(text));
                            return;
                        }
                        ReadAction.nonBlocking(() -> PhpIndex.getInstance((Project)PhpNewTestDialog.this.getProject()).getAnyByFQN(text)).finishOnUiThread(ModalityState.current(), classes -> this.updateUi((Collection<PhpClass>)classes)).coalesceBy(new Object[]{this}).submit((Executor)AppExecutorUtil.getAppExecutorService());
                    }
                });
            }

            private void updateUi(Collection<PhpClass> classes) {
                if (!classes.isEmpty()) {
                    PhpNewTestDialog.this.updateSuggestions(PhpNewTestDialog.this.getTargetClassNamespace());
                }
                PhpNewTestDialog.this.myTestTargetFileCombo.removeAllItems();
                for (PhpClass aClass : classes) {
                    PhpNewTestDialog.this.myTestTargetFileCombo.addItem((Object)PhpNewTestDialog.getFilePath(aClass.getContainingFile()));
                }
                if (!PhpNewTestDialog.this.myTestTargetTextChanged && file != null) {
                    PhpNewTestDialog.this.myTestTargetFileCombo.setSelectedItem((Object)PhpNewTestDialog.getFilePath(file));
                }
                PhpNewTestDialog.this.myTestTargetFileCombo.setEnabled(classes.size() > 1);
                PhpNewTestDialog.this.reloadMemberSelectionPanel(project, selectedElement);
                PhpNewTestDialog.this.myTestTargetTextChanged = true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/jetbrains/php/phpunit/codeGeneration/PhpNewTestDialog$2", "documentChanged"));
            }
        });
        PhpCompletionUtil.installClassCompletion(this.myTestTargetTextField, null, this.getDisposable(), (Condition<? super PhpClass>)((Condition)clazz -> this.getSelectedTestCreateInfo().canCreateTestFor((PhpClass)clazz)), new String[0]);
        this.myTestTargetCompletionHintLabel.setText(PhpBundle.message("0.completion.shortcut", "class reference", PhpUiUtil.getShortcutTextByActionName("CodeCompletion")));
        this.addUpdateRequest(() -> {
            PhpClass targetElement = PhpNewTestDialog.getTargetClass(file, (PsiElement)selectedElement);
            if (targetElement != null) {
                String fqn = targetElement.getFQN();
                this.myTestTargetTextField.setText(PhpLangUtil.toName(fqn));
                this.updateTestName(targetElement.getName());
                return;
            }
            this.updateTestName("");
            Editor editor = this.myNameTextField.getEditor();
            if (editor != null) {
                editor.getCaretModel().moveToOffset(0);
            }
        });
        this.myTestTargetPanel.setVisible(selectedElement == null);
        this.myTestTargetFileCombo.addItemListener(e -> this.reloadMemberSelectionPanel(project, selectedElement));
        this.myMethodsTableWrapper.add(this.myMethodsPanel);
        this.myShowInheritedMembersCheckBox.addActionListener(e -> this.reloadMemberSelectionPanel(project, selectedElement));
        this.mySelectedElementName = PhpNewTestDialog.getElementName(selectedElement);
        this.initChangeDetectors();
        this.init();
    }

    @Override
    protected void initChangeDetectors() {
        super.initChangeDetectors();
        this.myTestTargetTextField.addDocumentListener(new DocumentListener(){

            public void documentChanged(@NotNull com.intellij.openapi.editor.event.DocumentEvent event) {
                if (event == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (!PhpNewTestDialog.this.myTestTargetTextField.isFocusOwner()) {
                    return;
                }
                PhpNewTestDialog.this.myTestTargetTextChangedUnderFocus = true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/jetbrains/php/phpunit/codeGeneration/PhpNewTestDialog$3", "documentChanged"));
            }
        });
        this.myNamespaceTextField.addDocumentListener(new DocumentListener(){

            public void documentChanged(@NotNull com.intellij.openapi.editor.event.DocumentEvent event) {
                if (event == null) {
                    4.$$$reportNull$$$0(0);
                }
                if (!PhpNewTestDialog.this.myNamespaceTextField.isFocusOwner()) {
                    return;
                }
                PhpNewTestDialog.this.myNamespaceTextChangedUnderFocus = true;
                PhpNewTestDialog.this.mySuggestionFieldsWasChangedUnderFocus = true;
                PhpNewTestDialog.this.addUpdateRequest(() -> PhpNewTestDialog.this.myDirectoryCombobox.updateDirectories(PhpNewTestDialog.this.getNamespace()), 10);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/jetbrains/php/phpunit/codeGeneration/PhpNewTestDialog$4", "documentChanged"));
            }
        });
        this.myMethodsPanel.getTable().addMemberInfoChangeListener(e -> {
            if (!UIUtil.isFocusAncestor((Component)this.myMethodsPanel)) {
                return;
            }
            this.myMethodsTableWasChangedUnderFocus = true;
        });
        this.myShowInheritedMembersCheckBox.addItemListener(e -> {
            if (!this.myShowInheritedMembersCheckBox.isFocusOwner()) {
                return;
            }
            this.myShowInheritedMembersChangedUnderFocus = true;
        });
    }

    public boolean isLibraryChanged() {
        return this.myLibraryChanged;
    }

    @Nullable
    private static String getElementName(@Nullable PhpNamedElement selectedElement) {
        if (selectedElement == null) {
            return null;
        }
        if (selectedElement instanceof Method) {
            PhpClass containingClass = ((Method)selectedElement).getContainingClass();
            return containingClass != null ? containingClass.getName() : null;
        }
        return selectedElement.getName();
    }

    @Nullable
    private static PhpClass getTargetClass(@Nullable PsiFile file, @Nullable PsiElement selectedElement) {
        if (selectedElement instanceof PhpClass) {
            return (PhpClass)selectedElement;
        }
        if (selectedElement instanceof Method) {
            return ((Method)selectedElement).getContainingClass();
        }
        return PhpTestCreator.findClass(file);
    }

    private void reloadMemberSelectionPanel(@NotNull Project project, @Nullable PhpNamedElement selectedMethod) {
        if (project == null) {
            PhpNewTestDialog.$$$reportNull$$$0(1);
        }
        Set<PhpClassMember> selectedMembers = this.getSelectedClassMembers();
        List<PhpMemberInfo> classMembersInfos = this.getClassMembersInfo(project, this.isInheritedMembersOptionSelected());
        classMembersInfos.forEach(info -> info.setChecked(selectedMembers.contains(info.getMember())));
        this.checkMethodSelectedOnInit(selectedMethod, classMembersInfos);
        this.myMethodsPanel.getTable().setMemberInfos(classMembersInfos);
    }

    private void checkMethodSelectedOnInit(@Nullable PhpNamedElement methodSelectedOnInit, @NotNull List<PhpMemberInfo> classMembersInfos) {
        PhpMemberInfo memberInfoForInit;
        if (classMembersInfos == null) {
            PhpNewTestDialog.$$$reportNull$$$0(2);
        }
        if (!this.myTestMethodSelectedOnInit && methodSelectedOnInit instanceof Method && (memberInfoForInit = (PhpMemberInfo)ContainerUtil.find(classMembersInfos, info -> info.getMember() == methodSelectedOnInit)) != null) {
            memberInfoForInit.setChecked(true);
            this.myTestMethodSelectedOnInit = true;
        }
    }

    public boolean isInheritedMembersOptionSelected() {
        return this.myShowInheritedMembersCheckBox.isSelected();
    }

    @Nullable
    private String getDefaultLibraryName() {
        return PropertiesComponent.getInstance((Project)this.myProject).getValue(DEFAULT_LIBRARY_NAME_PROPERTY);
    }

    private void initTestLibraryCombo(@NotNull Project project, @Nullable PhpTestCreateInfo defaultTestCreateInfo) {
        if (project == null) {
            PhpNewTestDialog.$$$reportNull$$$0(3);
        }
        String defaultLibraryName = defaultTestCreateInfo != null ? defaultTestCreateInfo.getName() : this.getDefaultLibraryName();
        for (PhpTestFrameworkType type : PhpTestFrameworkType.getTestFrameworkTypes()) {
            for (PhpTestCreateInfo createInfo : type.getDescriptor().getTestCreateInfos()) {
                this.myLibrariesCombo.addItem((Object)createInfo);
                if (!StringUtil.equals((CharSequence)createInfo.getName(), (CharSequence)defaultLibraryName)) continue;
                this.myLibrariesCombo.setSelectedItem((Object)createInfo);
            }
        }
        this.myLibrariesCombo.setRenderer((ListCellRenderer)SimpleListCellRenderer.create((label, value, index) -> {
            if (value != null) {
                label.setText(value.getName());
                label.setIcon(value.getIcon());
            }
        }));
        this.myLibrariesCombo.addItemListener(e -> {
            if (this.myDirectory != null) {
                this.myDirectoryCombobox.selectDirectory(this.myDirectory.getVirtualFile().getPath());
            }
            this.updateSuggestions(this.getTargetClassNamespace());
            this.myLibraryChanged = !StringUtil.equals((CharSequence)this.getSelectedTestCreateInfo().getName(), (CharSequence)defaultLibraryName);
        });
        this.registerLibrariesUpDownShortcut();
        this.myLibrariesComboWrapper.add((Component)this.myLibrariesCombo);
        this.myLibrariesLabel.setLabelFor(this.myLibrariesCombo);
    }

    private void registerLibrariesUpDownShortcut() {
        this.myLibrariesUpDownHint.setIcon(PlatformIcons.UP_DOWN_ARROWS);
        this.myLibrariesUpDownHint.setToolTipText(PhpBundle.message("actions.new.test.class.dialog.arrows.libraries.hint", new Object[0]));
        KeyboardShortcut up = new KeyboardShortcut(KeyStroke.getKeyStroke(38, 0), null);
        KeyboardShortcut down = new KeyboardShortcut(KeyStroke.getKeyStroke(40, 0), null);
        PhpNewFileDialog.getCbArrowAction(this.myLibrariesCombo).registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(new Shortcut[]{up, down}), (JComponent)this.myNameTextField);
    }

    protected void updateSuggestions(@NotNull String namespace) {
        if (namespace == null) {
            PhpNewTestDialog.$$$reportNull$$$0(4);
        }
        if (this.mySuggestionFieldsWasChangedUnderFocus) {
            return;
        }
        this.myDirectoryCombobox.updateDirectories(namespace, (VirtualFile)ObjectUtils.notNull((Object)this.getSelectedTargetDirectory(this.myProject), (Object)this.myDirectoryCombobox.getBaseDirectory()));
        this.updateTestNameAndNamespaces(this.myProject, this.myTestTargetTextField.getText());
    }

    @Override
    protected void updateNamespacesSuggestions(@NotNull List<String> namespaces) {
        if (namespaces == null) {
            PhpNewTestDialog.$$$reportNull$$$0(5);
        }
        String namespace = namespaces.isEmpty() ? "" : (String)ContainerUtil.getFirstItem(namespaces);
        this.myNamespaceTextField.setText(namespace);
    }

    protected void updateTestNameAndNamespaces(@NotNull Project project, @NotNull String testName) {
        if (project == null) {
            PhpNewTestDialog.$$$reportNull$$$0(6);
        }
        if (testName == null) {
            PhpNewTestDialog.$$$reportNull$$$0(7);
        }
        this.updateNamespacesSuggestions(this.getTestNamespaces(project));
        this.updateTestName(testName);
    }

    private void updateTestName(@NotNull String testName) {
        if (testName == null) {
            PhpNewTestDialog.$$$reportNull$$$0(8);
        }
        this.myNameTextField.setText(this.getSelectedTestCreateInfo().getDefaultTestName(PhpLangUtil.toShortName(testName)));
    }

    @NotNull
    private List<String> getTestNamespaces(@NotNull Project project) {
        if (project == null) {
            PhpNewTestDialog.$$$reportNull$$$0(9);
        }
        PhpTestCreateInfo selectedTestCreateInfo = this.getSelectedTestCreateInfo();
        List<String> suggestedNamespaces = this.myDirectory != null ? PhpNamespaceCompositeProvider.INSTANCE.suggestNamespaces(this.myDirectory) : PhpNamespaceProvider.GLOBAL_NAMESPACE;
        String testDirectoryPath = this.myDirectoryCombobox.getSelectedPath();
        if (FileUtil.pathsEqual((String)testDirectoryPath, (String)project.getBasePath())) {
            List<String> list = suggestedNamespaces;
            if (list == null) {
                PhpNewTestDialog.$$$reportNull$$$0(10);
            }
            return list;
        }
        VirtualFile testDirectory = LocalFileSystem.getInstance().findFileByPath(testDirectoryPath);
        VirtualFile selectedExistingFile = (VirtualFile)ObjectUtils.coalesce((Object)testDirectory, (Object)this.myDirectoryCombobox.getExistingParent(), (Object)project.getBaseDir());
        SourceFolder testSourceFolder = PhpNewTestDialog.getSourceFolder(project, selectedExistingFile);
        VirtualFile selectedRoot = ProjectFileIndex.getInstance((Project)project).getSourceRootForFile(selectedExistingFile);
        if (selectedRoot == null || testSourceFolder == null || !testSourceFolder.isTestSource()) {
            List<String> list = suggestedNamespaces;
            if (list == null) {
                PhpNewTestDialog.$$$reportNull$$$0(11);
            }
            return list;
        }
        List list = ((StreamEx)StreamEx.of(suggestedNamespaces).map(namespace -> selectedTestCreateInfo.getTestNamespace(project, selectedRoot, PhpNewTestDialog.getNamespaceWithTestPrefix(project, PhpDirectoryByPsrProvider.getFolderPrefix(testSourceFolder), this.myDirectory, namespace), (String)namespace, testDirectoryPath)).nonNull().distinct()).toList();
        if (list == null) {
            PhpNewTestDialog.$$$reportNull$$$0(12);
        }
        return list;
    }

    @Override
    protected boolean isFileNameAutoUpdate() {
        return false;
    }

    protected void init() {
        super.init();
        this.setTitle(this.mySelectedElementName != null ? PhpBundle.message("actions.new.test.class.dialog.title.named", this.mySelectedElementName) : PhpBundle.message("actions.new.test.class.dialog.title", new Object[0]));
    }

    @Nullable
    protected String getDimensionServiceKey() {
        return "com.jetbrains.php.test.PhpNewTestDialog";
    }

    @Override
    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.mySelectedElementName != null ? this.myNameTextField : this.myTestTargetTextField;
    }

    @NotNull
    public PhpTestCreateInfo getSelectedTestCreateInfo() {
        Object result = this.myLibrariesCombo.getSelectedItem();
        assert (result instanceof PhpTestCreateInfo);
        PhpTestCreateInfo phpTestCreateInfo = (PhpTestCreateInfo)result;
        if (phpTestCreateInfo == null) {
            PhpNewTestDialog.$$$reportNull$$$0(13);
        }
        return phpTestCreateInfo;
    }

    @Override
    @NotNull
    public String getTemplateName() {
        String string = this.getSelectedTestCreateInfo().getTemplateName();
        if (string == null) {
            PhpNewTestDialog.$$$reportNull$$$0(14);
        }
        return string;
    }

    @Override
    @NotNull
    public String getNamespace() {
        String string = PhpLangUtil.toName(this.myNamespaceTextField.getText());
        if (string == null) {
            PhpNewTestDialog.$$$reportNull$$$0(15);
        }
        return string;
    }

    @Override
    @NotNull
    public String getFileName() {
        String string = this.getName();
        if (string == null) {
            PhpNewTestDialog.$$$reportNull$$$0(16);
        }
        return string;
    }

    @Override
    @NotNull
    public Properties getProperties(@NotNull PsiDirectory directory) {
        String namespace;
        if (directory == null) {
            PhpNewTestDialog.$$$reportNull$$$0(17);
        }
        Properties properties = super.getProperties(directory);
        String fqn = PhpLangUtil.toName(this.myTestTargetTextField.getText());
        String testedName = PhpLangUtil.toShortName(fqn);
        if (StringUtil.isNotEmpty((String)testedName)) {
            properties.setProperty("TESTED_NAME", testedName);
        }
        if (!PhpLangUtil.isGlobalNamespaceName(namespace = PhpLangUtil.getParentQualifiedName(fqn))) {
            properties.setProperty("TESTED_NAMESPACE", namespace);
        }
        Properties properties2 = properties;
        if (properties2 == null) {
            PhpNewTestDialog.$$$reportNull$$$0(18);
        }
        return properties2;
    }

    protected void createUIComponents() {
        this.myNamespaceTextField = new EditorTextField("", this.getProject(), (FileType)FileTypes.PLAIN_TEXT);
        this.myTestTargetTextField = new EditorTextField("", this.getProject(), (FileType)FileTypes.PLAIN_TEXT);
        this.myDirectoryCombobox = new PhpPsrDirectoryComboBox(this.getProject(), this.getTestDirectoryProvider()){

            @Override
            public void init(@NotNull VirtualFile baseDir, @NotNull String namespace) {
                if (baseDir == null) {
                    5.$$$reportNull$$$0(0);
                }
                if (namespace == null) {
                    5.$$$reportNull$$$0(1);
                }
                super.init(baseDir, namespace);
                ProjectFileIndex index = ProjectRootManager.getInstance((Project)PhpNewTestDialog.this.myProject).getFileIndex();
                if (index.isInSourceContent(baseDir)) {
                    this.setDirectoriesFilter((Condition<VirtualFile>)((Condition)file -> index.isInTestSourceContent(file) || FileUtil.pathsEqual((String)file.getPath(), (String)PhpNewTestDialog.this.myProject.getBasePath())));
                }
                PhpNewTestDialog.this.updateSuggestions(PhpNewTestDialog.this.getNamespace());
            }

            @Override
            protected void chooseFile(@NotNull VirtualFile file) {
                if (file == null) {
                    5.$$$reportNull$$$0(2);
                }
                super.chooseFile(file);
                PhpNewTestDialog.this.myDirectoryTextChangedUnderFocus = true;
                if (PhpNewTestDialog.this.mySuggestionFieldsWasChangedUnderFocus) {
                    return;
                }
                PhpNewTestDialog.this.updateTestNameAndNamespaces(PhpNewTestDialog.this.myProject, PhpNewTestDialog.this.myTestTargetTextField.getText());
            }

            @Override
            @NotNull
            public VirtualFile getBaseDirectory() {
                VirtualFile virtualFile = (VirtualFile)ObjectUtils.notNull((Object)PhpNewTestDialog.this.myDirectoryCombobox.getExistingParent(), (Object)super.getBaseDirectory());
                if (virtualFile == null) {
                    5.$$$reportNull$$$0(3);
                }
                return virtualFile;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 3 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "baseDir";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "namespace";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "file";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/jetbrains/php/phpunit/codeGeneration/PhpNewTestDialog$5";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/jetbrains/php/phpunit/codeGeneration/PhpNewTestDialog$5";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getBaseDirectory";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "init";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "chooseFile";
                        break;
                    }
                    case 3: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 3 -> new IllegalStateException(string);
                };
            }
        };
    }

    @Nullable
    protected String getHelpId() {
        return "reference.php.reference.testing.create.new.phpunit.test";
    }

    protected void doOKAction() {
        this.saveDefaultLibraryName();
        super.doOKAction();
    }

    private void saveDefaultLibraryName() {
        PropertiesComponent.getInstance((Project)this.myProject).setValue(DEFAULT_LIBRARY_NAME_PROPERTY, this.getSelectedTestCreateInfo().getName());
    }

    @Nullable
    public PhpClass getSelectedTargetClass(@NotNull Project project) {
        Collection classes;
        if (project == null) {
            PhpNewTestDialog.$$$reportNull$$$0(19);
        }
        if ((classes = PhpIndex.getInstance((Project)project).getAnyByFQN(PhpLangUtil.toFQN(this.myTestTargetTextField.getText()))).isEmpty()) {
            return null;
        }
        if (classes.size() == 1) {
            return (PhpClass)ContainerUtil.getFirstItem((Collection)classes);
        }
        return (PhpClass)ContainerUtil.find((Iterable)classes, clazz -> StringUtil.equals((CharSequence)PhpNewTestDialog.getFilePath(clazz.getContainingFile()), (CharSequence)((String)this.myTestTargetFileCombo.getSelectedItem())));
    }

    @Nullable
    public VirtualFile getSelectedTargetDirectory(@NotNull Project project) {
        PhpClass targetClass;
        VirtualFile targetFile;
        if (project == null) {
            PhpNewTestDialog.$$$reportNull$$$0(20);
        }
        return (targetFile = PsiUtilCore.getVirtualFile((PsiElement)(targetClass = this.getSelectedTargetClass(project)))) != null ? targetFile.getParent() : null;
    }

    @NotNull
    public String getTargetClassNamespace() {
        String string = PhpLangUtil.toName(PhpLangUtil.getParentQualifiedName(this.myTestTargetTextField.getText()));
        if (string == null) {
            PhpNewTestDialog.$$$reportNull$$$0(21);
        }
        return string;
    }

    @NotNull
    public String getTargetClassFqn() {
        String string = PhpLangUtil.toFQN(this.myTestTargetTextField.getText());
        if (string == null) {
            PhpNewTestDialog.$$$reportNull$$$0(22);
        }
        return string;
    }

    @NotNull
    @Nls
    private static String getFilePath(PsiFile file) {
        String string = file.getVirtualFile().getPresentableUrl();
        if (string == null) {
            PhpNewTestDialog.$$$reportNull$$$0(23);
        }
        return string;
    }

    @NotNull
    private List<PhpMemberInfo> getClassMembersInfo(@NotNull Project project, boolean includeInherited) {
        PhpClass targetClass;
        if (project == null) {
            PhpNewTestDialog.$$$reportNull$$$0(24);
        }
        if ((targetClass = this.getSelectedTargetClass(project)) == null) {
            List<PhpMemberInfo> list = Collections.emptyList();
            if (list == null) {
                PhpNewTestDialog.$$$reportNull$$$0(25);
            }
            return list;
        }
        List list = ((StreamEx)PhpNewTestDialog.getPublicMethods(targetClass, includeInherited).map(PhpMemberInfo::new).sorted(PhpNewTestDialog.ownMethodsFirst(targetClass.getContainingFile()).thenComparing(Function.identity()))).toList();
        if (list == null) {
            PhpNewTestDialog.$$$reportNull$$$0(26);
        }
        return list;
    }

    @NotNull
    private static Comparator<PhpMemberInfo> ownMethodsFirst(@NotNull PsiFile targetContainingFile) {
        if (targetContainingFile == null) {
            PhpNewTestDialog.$$$reportNull$$$0(27);
        }
        Comparator comparator = (o1, o2) -> {
            PsiFile containingFile2;
            PsiFile containingFile1 = ((PhpClassMember)o1.getMember()).getContainingFile();
            if (containingFile1 != (containingFile2 = ((PhpClassMember)o2.getMember()).getContainingFile())) {
                if (containingFile1 == targetContainingFile) {
                    return -1;
                }
                if (containingFile2 == targetContainingFile) {
                    return 1;
                }
            }
            return 0;
        };
        if (comparator == null) {
            PhpNewTestDialog.$$$reportNull$$$0(28);
        }
        return comparator;
    }

    @NotNull
    private static StreamEx<Method> getPublicMethods(@NotNull PhpClass targetClass, boolean includeInherited) {
        if (targetClass == null) {
            PhpNewTestDialog.$$$reportNull$$$0(29);
        }
        StreamEx streamEx = (StreamEx)(includeInherited ? StreamEx.of((Collection)targetClass.getMethods()) : StreamEx.of((Object[])targetClass.getOwnMethods())).filter(method -> method.getAccess().isPublic());
        if (streamEx == null) {
            PhpNewTestDialog.$$$reportNull$$$0(30);
        }
        return streamEx;
    }

    @NotNull
    public Set<PhpClassMember> getSelectedClassMembers() {
        Set set = StreamEx.of((Collection)this.myMethodsPanel.getTable().getSelectedMemberInfos()).map(MemberInfoBase::getMember).toSet();
        if (set == null) {
            PhpNewTestDialog.$$$reportNull$$$0(31);
        }
        return set;
    }

    @NotNull
    protected PhpDirectoryByPsrProvider getTestDirectoryProvider() {
        return new PhpTestDirectoryByPsrProvider(this.myDirectory){

            @Override
            @NotNull
            protected PhpTestCreateInfo getTestCreateInfo() {
                PhpTestCreateInfo phpTestCreateInfo = PhpNewTestDialog.this.getSelectedTestCreateInfo();
                if (phpTestCreateInfo == null) {
                    6.$$$reportNull$$$0(0);
                }
                return phpTestCreateInfo;
            }

            @Override
            @Nullable
            protected VirtualFile getTargetDirectory(@NotNull Project project) {
                if (project == null) {
                    6.$$$reportNull$$$0(1);
                }
                return PhpNewTestDialog.this.getSelectedTargetDirectory(project);
            }

            @Override
            protected String getClassNamespace() {
                return PhpNewTestDialog.this.getTargetClassNamespace();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 2;
                    case 1 -> 3;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/jetbrains/php/phpunit/codeGeneration/PhpNewTestDialog$6";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "project";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getTestCreateInfo";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/jetbrains/php/phpunit/codeGeneration/PhpNewTestDialog$6";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "getTargetDirectory";
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalStateException(string);
                    case 1 -> new IllegalArgumentException(string);
                };
            }
        };
    }

    @NotNull
    public static StreamEx<SourceFolder> getSourceFolders(@NotNull Project project) {
        if (project == null) {
            PhpNewTestDialog.$$$reportNull$$$0(32);
        }
        StreamEx streamEx = StreamEx.of((Object[])ModuleManager.getInstance((Project)project).getModules()).map(ModuleRootManager::getInstance).flatArray(ModuleRootModel::getContentEntries).flatArray(ContentEntry::getSourceFolders);
        if (streamEx == null) {
            PhpNewTestDialog.$$$reportNull$$$0(33);
        }
        return streamEx;
    }

    @NotNull
    public static Set<String> getExistedSourceRootPaths(@NotNull Project project) {
        if (project == null) {
            PhpNewTestDialog.$$$reportNull$$$0(34);
        }
        Set set = PhpNewTestDialog.getSourceFolders(project).map(ContentFolder::getFile).nonNull().map(VirtualFile::getPath).toSet();
        if (set == null) {
            PhpNewTestDialog.$$$reportNull$$$0(35);
        }
        return set;
    }

    @NotNull
    public static String getNamespaceWithTestPrefix(@NotNull Project project, @NotNull String toPrefix, @Nullable PsiDirectory fromDirectory, @NotNull String namespace) {
        VirtualFile fromFile;
        if (project == null) {
            PhpNewTestDialog.$$$reportNull$$$0(36);
        }
        if (toPrefix == null) {
            PhpNewTestDialog.$$$reportNull$$$0(37);
        }
        if (namespace == null) {
            PhpNewTestDialog.$$$reportNull$$$0(38);
        }
        VirtualFile virtualFile = fromFile = fromDirectory != null ? fromDirectory.getVirtualFile() : null;
        if (!toPrefix.isEmpty() && PhpDirectoryByPsrProvider.containsPrefix(toPrefix, namespace) || fromFile == null) {
            String string = namespace;
            if (string == null) {
                PhpNewTestDialog.$$$reportNull$$$0(39);
            }
            return string;
        }
        if (namespace.isEmpty()) {
            String string = toPrefix;
            if (string == null) {
                PhpNewTestDialog.$$$reportNull$$$0(40);
            }
            return string;
        }
        SourceFolder fromSourceFolder = PhpNewTestDialog.getSourceFolder(project, fromFile);
        if (fromSourceFolder == null) {
            String string = PhpLangUtil.toName(PhpLangUtil.concat(toPrefix, namespace));
            if (string == null) {
                PhpNewTestDialog.$$$reportNull$$$0(41);
            }
            return string;
        }
        String namespaceWithoutPrefix = PhpDirectoryByPsrProvider.cutPrefix(namespace, PhpDirectoryByPsrProvider.getFolderPrefix(fromSourceFolder));
        String string = PhpLangUtil.toName(PhpLangUtil.concat(toPrefix, namespaceWithoutPrefix));
        if (string == null) {
            PhpNewTestDialog.$$$reportNull$$$0(42);
        }
        return string;
    }

    @Nullable
    public static SourceFolder getSourceFolder(@NotNull Project project, @NotNull VirtualFile file) {
        VirtualFile fromSourceRoot;
        if (project == null) {
            PhpNewTestDialog.$$$reportNull$$$0(43);
        }
        if (file == null) {
            PhpNewTestDialog.$$$reportNull$$$0(44);
        }
        if ((fromSourceRoot = ProjectFileIndex.getInstance((Project)project).getSourceRootForFile(file)) == null) {
            return null;
        }
        return ProjectRootsUtil.getModuleSourceRoot((VirtualFile)fromSourceRoot, (Project)project);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 10, 11, 12, 13, 14, 15, 16, 18, 21, 22, 23, 25, 26, 28, 30, 31, 33, 35, 39, 40, 41, 42 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classMembersInfos";
                break;
            }
            case 4: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namespace";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namespaces";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testName";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 21: 
            case 22: 
            case 23: 
            case 25: 
            case 26: 
            case 28: 
            case 30: 
            case 31: 
            case 33: 
            case 35: 
            case 39: 
            case 40: 
            case 41: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/phpunit/codeGeneration/PhpNewTestDialog";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directory";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetContainingFile";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetClass";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toPrefix";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/phpunit/codeGeneration/PhpNewTestDialog";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getTestNamespaces";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedTestCreateInfo";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getTemplateName";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getNamespace";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileName";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getProperties";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargetClassNamespace";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargetClassFqn";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilePath";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassMembersInfo";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "ownMethodsFirst";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getPublicMethods";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedClassMembers";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "getSourceFolders";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "getExistedSourceRootPaths";
                break;
            }
            case 39: 
            case 40: 
            case 41: 
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "getNamespaceWithTestPrefix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "reloadMemberSelectionPanel";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "checkMethodSelectedOnInit";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "initTestLibraryCombo";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "updateSuggestions";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "updateNamespacesSuggestions";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "updateTestNameAndNamespaces";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "updateTestName";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getTestNamespaces";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 21: 
            case 22: 
            case 23: 
            case 25: 
            case 26: 
            case 28: 
            case 30: 
            case 31: 
            case 33: 
            case 35: 
            case 39: 
            case 40: 
            case 41: 
            case 42: {
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getProperties";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getSelectedTargetClass";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getSelectedTargetDirectory";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getClassMembersInfo";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "ownMethodsFirst";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getPublicMethods";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getSourceFolders";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "getExistedSourceRootPaths";
                break;
            }
            case 36: 
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "getNamespaceWithTestPrefix";
                break;
            }
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "getSourceFolder";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 10, 11, 12, 13, 14, 15, 16, 18, 21, 22, 23, 25, 26, 28, 30, 31, 33, 35, 39, 40, 41, 42 -> new IllegalStateException(string);
        };
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBLabel jBLabel;
        JPanel jPanel;
        ComboBox comboBox;
        JBLabel jBLabel2;
        JPanel jPanel2;
        JBCheckBox jBCheckBox;
        JBLabel jBLabel3;
        JBLabel jBLabel4;
        JPanel jPanel3;
        JBLabel jBLabel5;
        EditorTextField editorTextField;
        JPanel jPanel4;
        this.createUIComponents();
        this.myMainPanel = jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(4, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        Spacer spacer = new Spacer();
        jPanel4.add((Component)spacer, new GridConstraints(3, 0, 1, 3, 0, 2, 1, 6, null, null, null));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(7, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel5.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel4.add((Component)jPanel5, new GridConstraints(2, 0, 1, 3, 0, 3, 3, 3, null, null, null, 0, true));
        jPanel5.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder(null, (String)DynamicBundle.getBundle((String)"messages/PhpBundle", PhpNewTestDialog.class).getString("actions.new.test.class.dialog.border.title.test.class"), (int)0, (int)0, null, null));
        this.myNameTextField = editorTextField = new EditorTextField();
        jPanel5.add((Component)editorTextField, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 0, null, null, null));
        JBLabel jBLabel6 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel6, DynamicBundle.getBundle((String)"messages/PhpBundle", PhpNewTestDialog.class).getString("actions.new.test.class.dialog.label.name"));
        jPanel5.add((Component)jBLabel6, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myLibrariesUpDownHint = jBLabel5 = new JBLabel();
        jPanel5.add((Component)jBLabel5, new GridConstraints(0, 2, 1, 1, 0, 0, 0, 0, null, null, null));
        this.myMethodsTableWrapper = jPanel3 = new JPanel();
        jPanel3.setLayout(new CardLayout(0, 0));
        jPanel5.add((Component)jPanel3, new GridConstraints(5, 0, 1, 3, 0, 3, 3, 3, null, null, null));
        JBLabel jBLabel7 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel7, DynamicBundle.getBundle((String)"messages/PhpBundle", PhpNewTestDialog.class).getString("actions.new.test.class.dialog.label.namespace"));
        jPanel5.add((Component)jBLabel7, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, new Dimension(100, 14), null));
        this.myNamespaceCompletionHintLabel = jBLabel4 = new JBLabel();
        jBLabel4.setComponentStyle(UIUtil.ComponentStyle.MINI);
        jPanel5.add((Component)jBLabel4, new GridConstraints(4, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        EditorTextField editorTextField2 = this.myNamespaceTextField;
        jPanel5.add((Component)editorTextField2, new GridConstraints(3, 1, 1, 2, 0, 1, 6, 0, null, null, null));
        JBLabel jBLabel8 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel8, DynamicBundle.getBundle((String)"messages/PhpBundle", PhpNewTestDialog.class).getString("actions.new.test.class.dialog.label.directory"));
        jPanel5.add((Component)jBLabel8, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        PhpPsrDirectoryComboBox phpPsrDirectoryComboBox = this.myDirectoryCombobox;
        jPanel5.add((Component)((Object)phpPsrDirectoryComboBox), new GridConstraints(1, 1, 1, 2, 0, 1, 6, 0, null, null, null));
        this.myEditDirectoryHintLabel = jBLabel3 = new JBLabel();
        jBLabel3.setComponentStyle(UIUtil.ComponentStyle.MINI);
        jPanel5.add((Component)jBLabel3, new GridConstraints(2, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myShowInheritedMembersCheckBox = jBCheckBox = new JBCheckBox();
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox, DynamicBundle.getBundle((String)"messages/PhpBundle", PhpNewTestDialog.class).getString("actions.new.test.class.dialog.select.methods.show.inherited.methods"));
        jPanel5.add((Component)jBCheckBox, new GridConstraints(6, 0, 1, 3, 8, 0, 0, 0, null, null, null));
        this.myTestTargetPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(3, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel4.add((Component)jPanel2, new GridConstraints(1, 0, 1, 3, 0, 3, 3, 3, null, null, null, 0, true));
        jPanel2.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder(null, (String)DynamicBundle.getBundle((String)"messages/PhpBundle", PhpNewTestDialog.class).getString("actions.new.test.class.dialog.border.title.class.to.test"), (int)0, (int)0, null, null));
        EditorTextField editorTextField3 = this.myTestTargetTextField;
        editorTextField3.setToolTipText(DynamicBundle.getBundle((String)"messages/PhpBundle", PhpNewTestDialog.class).getString("php.unit.optional"));
        jPanel2.add((Component)editorTextField3, new GridConstraints(0, 1, 1, 2, 0, 1, 6, 0, null, null, null));
        JBLabel jBLabel9 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel9, DynamicBundle.getBundle((String)"messages/PhpBundle", PhpNewTestDialog.class).getString("actions.new.test.class.dialog.label.fqn"));
        jPanel2.add((Component)jBLabel9, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, new Dimension(160, -1), null));
        this.myTestTargetCompletionHintLabel = jBLabel2 = new JBLabel();
        jBLabel2.setComponentStyle(UIUtil.ComponentStyle.MINI);
        jBLabel2.setFontColor(UIUtil.FontColor.NORMAL);
        jBLabel2.setText("");
        jPanel2.add((Component)jBLabel2, new GridConstraints(1, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        JBLabel jBLabel10 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel10, DynamicBundle.getBundle((String)"messages/PhpBundle", PhpNewTestDialog.class).getString("actions.new.test.class.dialog.border.title.target.class.file.path"));
        jPanel2.add((Component)jBLabel10, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myTestTargetFileCombo = comboBox = new ComboBox();
        jPanel2.add((Component)comboBox, new GridConstraints(2, 1, 1, 2, 0, 1, 2, 0, null, null, null));
        this.myLibrariesComboWrapper = jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(0, 5, 5));
        jPanel4.add((Component)jPanel, new GridConstraints(0, 0, 1, 3, 0, 3, 3, 3, null, null, null, 0, true));
        this.myLibrariesLabel = jBLabel = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel, DynamicBundle.getBundle((String)"messages/PhpBundle", PhpNewTestDialog.class).getString("php.unit.label.test.file.template"));
        Component component = jPanel.add((Component)jBLabel);
        Spacer spacer2 = new Spacer();
        Component component2 = jPanel.add((Component)spacer2);
        Spacer spacer3 = new Spacer();
        Component component3 = jPanel.add((Component)spacer3);
        jBLabel6.setLabelFor((Component)editorTextField);
        jBLabel7.setLabelFor((Component)editorTextField2);
        jBLabel9.setLabelFor((Component)editorTextField3);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

