/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.phpunit.codeGeneration;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.psi.PsiFile;
import com.intellij.testIntegration.TestCreator;
import com.jetbrains.php.lang.psi.PhpFile;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.phpunit.PhpUnitUtil;
import com.jetbrains.php.phpunit.codeGeneration.PhpNewTestAction;
import org.jetbrains.annotations.Nullable;

public final class PhpTestCreator
implements TestCreator {
    public boolean isAvailable(Project project, Editor editor, PsiFile file) {
        if (file instanceof PhpFile) {
            PhpClass aClass = PhpTestCreator.findClass(file);
            return aClass != null;
        }
        return false;
    }

    @Nullable
    public static PhpClass findClass(@Nullable PsiFile file) {
        PhpClass aClass;
        if (file instanceof PhpFile && (aClass = PhpPsiUtil.findClass((PhpFile)file, (Condition<? super PhpClass>)Conditions.alwaysTrue())) != null && !PhpUnitUtil.isTestClass(aClass)) {
            return aClass;
        }
        return null;
    }

    public void createTest(Project project, Editor editor, PsiFile file) {
        new PhpNewTestAction().invoke(project, file.getParent(), file, null, editor);
    }
}

