/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.profiler.ui;

import com.intellij.DynamicBundle;
import com.intellij.execution.ui.RunnerLayoutUi;
import com.intellij.execution.ui.layout.PlaceInGrid;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.UiDataProvider;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.fileEditor.impl.EditorWindow;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.ui.ColoredTableCellRenderer;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.TableSpeedSearch;
import com.intellij.ui.TreeTableSpeedSearch;
import com.intellij.ui.components.JBTabbedPane;
import com.intellij.ui.content.Content;
import com.intellij.ui.table.TableView;
import com.intellij.ui.treeStructure.treetable.TreeTable;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.Alarm;
import com.intellij.util.EventDispatcher;
import com.intellij.util.containers.Convertor;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.ListTableModel;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.config.servers.PhpServer;
import com.jetbrains.php.profiler.ProfilerModelWrapper;
import com.jetbrains.php.profiler.ProfilerSnapshotFileEditor;
import com.jetbrains.php.profiler.ProfilerUtil;
import com.jetbrains.php.profiler.model.ProfilerModel;
import com.jetbrains.php.profiler.ui.ProfilerSimpleLazyNode;
import com.jetbrains.php.profiler.ui.ProfilerTimeMeasurementComboBox;
import com.jetbrains.php.profiler.ui.ProfilerTimeMeasurementUnit;
import com.jetbrains.php.profiler.ui.ProfilerTreeNode;
import com.jetbrains.php.profiler.ui.ProfilerTreeNodeColumnInfo;
import com.jetbrains.php.profiler.ui.ProfilerTreeTableModel;
import com.jetbrains.php.profiler.ui.ProfilerTreeTableView;
import com.jetbrains.php.profiler.ui.ProfilerViewFacade;
import com.jetbrains.php.profiler.ui.TreeTableColumnInfo;
import com.jetbrains.php.profiler.xdebug.XdebugAnalyzeProfilerSnapshotAction;
import com.jetbrains.php.ui.PhpServerComboBox;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.EventListener;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProfilerView
extends ProfilerSnapshotFileEditor
implements ProfilerViewFacade {
    private static final Convertor<TreePath, String> TREE_SPEED_SEARCH_CONVERTOR = new Convertor<TreePath, String>(){

        public String convert(TreePath o) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)o.getLastPathComponent();
            if (node != null) {
                return (String)TABLE_SPEED_SEARCH_CONVERTOR.convert(node.getUserObject());
            }
            return "";
        }
    };
    private static final Convertor<Object, String> TABLE_SPEED_SEARCH_CONVERTOR = o -> {
        if (o instanceof ProfilerModel.Callable) {
            return ((ProfilerModel.Callable)o).getSearchKey();
        }
        return "";
    };
    private static final Comparator<ProfilerModel.Callable> TABLE_CALLABLE_SEARCH_KEY_COMPARATOR = (o1, o2) -> {
        String o1key = o1.getSearchKey();
        String o2key = o2.getSearchKey();
        return o1key.compareTo(o2key);
    };
    private static final Comparator<ProfilerModel.Callable> CALLABLE_FILE_PATH_COMPARATOR = (o1, o2) -> StringUtil.compare((String)ProfilerUtil.getFilePath(o1), (String)ProfilerUtil.getFilePath(o2), (boolean)false);
    private static final String SUMMARY_CONTENT = "SummaryContent";
    private static final String EXECUTION_STATISTICS_CONTENT = "ExecutionStatisticsContent";
    private static final String CALL_TREE_CONTENT = "CallTreeContent";
    private static final String CALLEES_TREE_CONTENT = "CalleesContent";
    private static final String CALLERS_TREE_CONTENT = "CallersContent";
    private JPanel myMainPanel;
    private JTabbedPane myGlobalViewsTabbedPane;
    private JTabbedPane myLocalViewsTabbedPane;
    private JPanel myExecutionStatisticsPanel;
    private JPanel myCallTreePanel;
    private JPanel myCalleesPanel;
    private JPanel myCallersPanel;
    private PhpServerComboBox myServerComboBox;
    private ProfilerTimeMeasurementComboBox myProfilerTimeMeasurementComboBox;
    private JButton myRefreshButton;
    private final Alarm myAlarm;
    private final EventDispatcher<CallableSelectedListener> myDispatcher;
    private RunnerLayoutUi myUi;
    private SummaryView mySummaryView;
    private ExecutionStatisticView myExecutionStatisticsView;
    private CallTreeView myCallTreeView;
    private CalleesTreeView myCalleesTreeView;
    private CallersTreeView myCallersTreeView;
    private ProfilerModelWrapper myModelWrapper;

    public ProfilerView(final @NotNull Project project, final @NotNull VirtualFile file, final @NotNull ProfilerModelWrapper modelWrapper) {
        if (project == null) {
            ProfilerView.$$$reportNull$$$0(0);
        }
        if (file == null) {
            ProfilerView.$$$reportNull$$$0(1);
        }
        if (modelWrapper == null) {
            ProfilerView.$$$reportNull$$$0(2);
        }
        super(project, file);
        this.$$$setupUI$$$();
        this.myAlarm = new Alarm();
        this.myDispatcher = EventDispatcher.create(CallableSelectedListener.class);
        this.create(project, modelWrapper);
        this.myProfilerTimeMeasurementComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProfilerView.this.repaintViews();
            }
        });
        this.myRefreshButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Set<VirtualFile> virtualFiles = modelWrapper.getModel().getVirtualFiles();
                VirtualFile[] virtualFilesArray = virtualFiles.toArray(VirtualFile.EMPTY_ARRAY);
                VfsUtil.markDirty((boolean)true, (boolean)true, (VirtualFile[])virtualFilesArray);
                LocalFileSystem.getInstance().refreshFiles(virtualFiles, true, true, () -> {
                    FileEditorManagerEx fileEditorManager = FileEditorManagerEx.getInstanceEx((Project)project);
                    EditorWindow editorWindow = fileEditorManager.getCurrentWindow();
                    editorWindow.closeFile(file);
                    XdebugAnalyzeProfilerSnapshotAction.processFiles(project, virtualFilesArray);
                });
            }
        });
        this.buildContents();
        this.buildUi();
        this.installPopups();
    }

    public void create(@NotNull Project project, @NotNull ProfilerModelWrapper modelWrapper) {
        if (project == null) {
            ProfilerView.$$$reportNull$$$0(3);
        }
        if (modelWrapper == null) {
            ProfilerView.$$$reportNull$$$0(4);
        }
        this.myModelWrapper = modelWrapper;
        this.myUi = RunnerLayoutUi.Factory.getInstance((Project)project).create("", "", "", (Disposable)this);
        this.mySummaryView = new SummaryView();
        this.myExecutionStatisticsView = new ExecutionStatisticView(this);
        this.myCallTreeView = new CallTreeView(this);
        this.myCalleesTreeView = new CalleesTreeView(this);
        this.myCallersTreeView = new CallersTreeView(this);
        this.myDispatcher.addListener((EventListener)this.myCalleesTreeView, (Disposable)this);
        this.myDispatcher.addListener((EventListener)this.myCallersTreeView, (Disposable)this);
        this.myExecutionStatisticsView.getSelectionModel().addListSelectionListener(new MyListSelectionListener((JTable)((Object)this.myExecutionStatisticsView)));
        this.myCallTreeView.getSelectionModel().addListSelectionListener(new MyListSelectionListener((JTable)((Object)this.myCallTreeView)));
    }

    private void repaintViews() {
        this.myExecutionStatisticsView.repaint();
        this.myCallTreeView.repaint();
        this.myCalleesTreeView.repaint();
        this.myCallersTreeView.repaint();
    }

    private void buildContents() {
        Content summaryContent = this.myUi.createContent(SUMMARY_CONTENT, (JComponent)this.mySummaryView, PhpBundle.message("summary", new Object[0]), null, null);
        summaryContent.setCloseable(false);
        summaryContent.setPinned(true);
        this.myUi.addContent(summaryContent, 1, PlaceInGrid.center, false);
        Content executionStatisticsContent = this.myUi.createContent(EXECUTION_STATISTICS_CONTENT, (JComponent)ScrollPaneFactory.createScrollPane((Component)((Object)this.myExecutionStatisticsView)), PhpBundle.message("execution.statistics", new Object[0]), null, null);
        executionStatisticsContent.setCloseable(false);
        executionStatisticsContent.setPinned(true);
        this.myUi.addContent(executionStatisticsContent, 0, PlaceInGrid.left, false);
        Content callTreeContent = this.myUi.createContent(CALL_TREE_CONTENT, (JComponent)ScrollPaneFactory.createScrollPane((Component)((Object)this.myCallTreeView)), PhpBundle.message("call.tree", new Object[0]), null, null);
        callTreeContent.setCloseable(false);
        callTreeContent.setPinned(true);
        this.myUi.addContent(callTreeContent, 0, PlaceInGrid.left, false);
        Content calleesTreeContent = this.myUi.createContent(CALLEES_TREE_CONTENT, (JComponent)ScrollPaneFactory.createScrollPane((Component)((Object)this.myCalleesTreeView)), PhpBundle.message("callees", new Object[0]), null, null);
        calleesTreeContent.setCloseable(false);
        calleesTreeContent.setPinned(true);
        this.myUi.addContent(calleesTreeContent, 0, PlaceInGrid.bottom, false);
        Content callersTreeContent = this.myUi.createContent(CALLERS_TREE_CONTENT, (JComponent)ScrollPaneFactory.createScrollPane((Component)((Object)this.myCallersTreeView)), PhpBundle.message("callers", new Object[0]), null, null);
        callersTreeContent.setCloseable(false);
        callersTreeContent.setPinned(true);
        this.myUi.addContent(callersTreeContent, 0, PlaceInGrid.bottom, false);
    }

    private void buildUi() {
        this.myServerComboBox.reset(this.getProject());
        this.myExecutionStatisticsPanel.add((Component)ScrollPaneFactory.createScrollPane((Component)((Object)this.myExecutionStatisticsView)), "Center");
        this.myCallTreePanel.add((Component)ScrollPaneFactory.createScrollPane((Component)((Object)this.myCallTreeView)), "Center");
        this.myCalleesPanel.add((Component)ScrollPaneFactory.createScrollPane((Component)((Object)this.myCalleesTreeView)), "Center");
        this.myCallersPanel.add((Component)ScrollPaneFactory.createScrollPane((Component)((Object)this.myCallersTreeView)), "Center");
    }

    private void installPopups() {
        PopupHandler.installPopupMenu((JComponent)((Object)this.myExecutionStatisticsView), (String)"ProfilerPopupActions", (String)"ExecutionStatisticsViewPopup");
        PopupHandler.installPopupMenu((JComponent)((Object)this.myCallTreeView), (String)"ProfilerPopupActions", (String)"CallTreeViewPopup");
        PopupHandler.installPopupMenu((JComponent)((Object)this.myCalleesTreeView), (String)"ProfilerPopupActions", (String)"CalleesTreeViewPopup");
        PopupHandler.installPopupMenu((JComponent)((Object)this.myCallersTreeView), (String)"ProfilerPopupActions", (String)"CallersTreeViewPopup");
    }

    public void onCallableSelected(@Nullable ProfilerModel.Callable callable) {
        this.myAlarm.cancelAllRequests();
        this.myAlarm.addRequest(() -> ((CallableSelectedListener)this.myDispatcher.getMulticaster()).onCallableSelected(callable), 200, ModalityState.current());
    }

    @NotNull
    public JComponent getComponent() {
        JPanel jPanel = this.myMainPanel;
        if (jPanel == null) {
            ProfilerView.$$$reportNull$$$0(5);
        }
        return jPanel;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myExecutionStatisticsView;
    }

    @Override
    @NotNull
    public ProfilerModelWrapper getModelWrapper() {
        ProfilerModelWrapper profilerModelWrapper = this.myModelWrapper;
        if (profilerModelWrapper == null) {
            ProfilerView.$$$reportNull$$$0(6);
        }
        return profilerModelWrapper;
    }

    @Override
    public PhpServer getServer() {
        return this.myServerComboBox.getSelectedServer();
    }

    @Override
    @NotNull
    public ProfilerTimeMeasurementUnit getTimeMeasurementUnit() {
        ProfilerTimeMeasurementUnit profilerTimeMeasurementUnit = this.myProfilerTimeMeasurementComboBox.getTimeMeasurementUnit();
        if (profilerTimeMeasurementUnit == null) {
            ProfilerView.$$$reportNull$$$0(7);
        }
        return profilerTimeMeasurementUnit;
    }

    @Nullable
    public static PsiElement findElement(@NotNull ProfilerViewFacade viewFacade, @Nullable ProfilerModel.Callable callable) {
        if (viewFacade == null) {
            ProfilerView.$$$reportNull$$$0(8);
        }
        if (callable == null) {
            return null;
        }
        Project project = viewFacade.getProject();
        return callable.findElement(project, ProfilerUtil.createFileLocator(viewFacade));
    }

    @Nullable
    private static ProfilerModel.Callable getSelectedCallable(@NotNull JTable table) {
        int selectedRow;
        if (table == null) {
            ProfilerView.$$$reportNull$$$0(9);
        }
        if ((selectedRow = table.getSelectedRow()) > -1) {
            Object valueAt = table.getModel().getValueAt(table.convertRowIndexToModel(selectedRow), 0);
            if (valueAt instanceof ProfilerModel.Callable) {
                return (ProfilerModel.Callable)valueAt;
            }
            if (valueAt instanceof CallTreeNode) {
                return ((CallTreeNode)valueAt).getCallee();
            }
            if (valueAt instanceof CalleeTreeNode) {
                return ((CalleeTreeNode)valueAt).getCallee();
            }
            if (valueAt instanceof CallerTreeNode) {
                return ((CallerTreeNode)valueAt).getCaller();
            }
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 6, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modelWrapper";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/profiler/ui/ProfilerView";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "viewFacade";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "table";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/profiler/ui/ProfilerView";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getModelWrapper";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getTimeMeasurementUnit";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "findElement";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getSelectedCallable";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 6, 7 -> new IllegalStateException(string);
        };
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JButton jButton;
        ProfilerTimeMeasurementComboBox profilerTimeMeasurementComboBox;
        PhpServerComboBox phpServerComboBox;
        JPanel jPanel;
        JPanel jPanel2;
        JPanel jPanel3;
        JPanel jPanel4;
        JPanel jPanel5;
        this.myMainPanel = jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JSplitPane jSplitPane = new JSplitPane();
        jSplitPane.setContinuousLayout(true);
        jSplitPane.setDoubleBuffered(true);
        jSplitPane.setOneTouchExpandable(false);
        jSplitPane.setOrientation(0);
        jSplitPane.setResizeWeight(0.5);
        jPanel5.add((Component)jSplitPane, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 7, null, new Dimension(200, 200), null));
        jSplitPane.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(), null, 0, 0, null, null));
        JBTabbedPane jBTabbedPane = new JBTabbedPane();
        this.myGlobalViewsTabbedPane = jBTabbedPane;
        jSplitPane.setLeftComponent((Component)jBTabbedPane);
        this.myExecutionStatisticsPanel = jPanel4 = new JPanel();
        jPanel4.setLayout(new BorderLayout(0, 0));
        jBTabbedPane.addTab(DynamicBundle.getBundle((String)"messages/PhpBundle", ProfilerView.class).getString("profiler.view.execution.statistics.title"), null, jPanel4, null);
        this.myCallTreePanel = jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout(0, 0));
        jBTabbedPane.addTab(DynamicBundle.getBundle((String)"messages/PhpBundle", ProfilerView.class).getString("profiler.view.call.tree.title"), null, jPanel3, null);
        JBTabbedPane jBTabbedPane2 = new JBTabbedPane();
        this.myLocalViewsTabbedPane = jBTabbedPane2;
        jSplitPane.setRightComponent((Component)jBTabbedPane2);
        this.myCalleesPanel = jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(0, 0));
        jBTabbedPane2.addTab(DynamicBundle.getBundle((String)"messages/PhpBundle", ProfilerView.class).getString("profiler.view.callees.title"), null, jPanel2, null);
        this.myCallersPanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jBTabbedPane2.addTab(DynamicBundle.getBundle((String)"messages/PhpBundle", ProfilerView.class).getString("profiler.view.callers.title"), null, jPanel, null);
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout((LayoutManager)new GridLayoutManager(1, 4, new Insets(10, 10, 0, 0), -1, -1, false, false));
        jPanel5.add((Component)jPanel6, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel6.add((Component)jPanel7, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myServerComboBox = phpServerComboBox = new PhpServerComboBox();
        jPanel7.add((Component)((Object)phpServerComboBox), new GridConstraints(0, 1, 1, 1, 0, 0, 3, 3, null, null, null));
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, DynamicBundle.getBundle((String)"messages/PhpBundle", ProfilerView.class).getString("RunConfigurationEditor.server"));
        jPanel7.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel6.add((Component)spacer, new GridConstraints(0, 3, 1, 1, 0, 1, 6, 1, null, null, null));
        JPanel jPanel8 = new JPanel();
        jPanel8.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel6.add((Component)jPanel8, new GridConstraints(0, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        JLabel jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, DynamicBundle.getBundle((String)"messages/PhpBundle", ProfilerView.class).getString("profiler.label.time"));
        jPanel8.add((Component)jLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myProfilerTimeMeasurementComboBox = profilerTimeMeasurementComboBox = new ProfilerTimeMeasurementComboBox();
        jPanel8.add((Component)((Object)profilerTimeMeasurementComboBox), new GridConstraints(0, 1, 1, 1, 0, 0, 3, 3, null, null, null));
        JPanel jPanel9 = new JPanel();
        jPanel9.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel6.add((Component)jPanel9, new GridConstraints(0, 2, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myRefreshButton = jButton = new JButton();
        this.$$$loadButtonText$$$(jButton, DynamicBundle.getBundle((String)"messages/PhpBundle", ProfilerView.class).getString("profiler.button.refresh"));
        jPanel9.add((Component)jButton, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        jLabel.setLabelFor((Component)((Object)phpServerComboBox));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    private static interface CallableSelectedListener
    extends EventListener {
        public void onCallableSelected(@Nullable ProfilerModel.Callable var1);
    }

    public static class SummaryView
    extends JComponent {
    }

    public static class ExecutionStatisticView
    extends TableView<ProfilerModel.Callable>
    implements UiDataProvider {
        @NotNull
        ProfilerViewFacade myProfilerViewFacade;

        public ExecutionStatisticView(@NotNull ProfilerViewFacade profilerViewFacade) {
            if (profilerViewFacade == null) {
                ExecutionStatisticView.$$$reportNull$$$0(0);
            }
            super(new ListTableModel(new ColumnInfo[]{new CallableTableColumnInfo(), new SummaryTimeTableColumnInfo(profilerViewFacade), new SummaryOwnTimeTableColumnInfo(profilerViewFacade), new SummaryInvocationCountTableColumnInfo(profilerViewFacade.getModelWrapper())}, new ArrayList<ProfilerModel.Callable>(profilerViewFacade.getModelWrapper().getModel().getCallables()), 0));
            this.myProfilerViewFacade = profilerViewFacade;
            this.getSelectionModel().setSelectionMode(0);
            this.setDefaultRenderer(ProfilerModel.Callable.class, (TableCellRenderer)((Object)new MyTableCellRenderer()));
            TableSpeedSearch.installOn((JTable)((Object)this), TABLE_SPEED_SEARCH_CONVERTOR);
        }

        public void uiDataSnapshot(@NotNull DataSink sink) {
            if (sink == null) {
                ExecutionStatisticView.$$$reportNull$$$0(1);
            }
            ProfilerModel.Callable callable = ProfilerView.getSelectedCallable((JTable)((Object)this));
            sink.lazy(CommonDataKeys.PSI_ELEMENT, () -> ProfilerView.findElement(this.myProfilerViewFacade, callable));
        }

        public void updateColumnSizes() {
            JTableHeader header = this.getTableHeader();
            TableCellRenderer defaultRenderer = header == null ? null : header.getDefaultRenderer();
            ColumnInfo[] columns = this.getListTableModel().getColumnInfos();
            for (int i = 0; i < columns.length; ++i) {
                TableColumn column = this.getColumnModel().getColumn(i);
                Component headerComponent = defaultRenderer == null ? null : defaultRenderer.getTableCellRendererComponent((JTable)((Object)this), column.getHeaderValue(), false, false, 0, 0);
                Dimension headerSize = headerComponent == null ? new Dimension(0, 0) : headerComponent.getPreferredSize();
                ColumnInfo columnInfo = columns[i];
                int width = columnInfo.getWidth((JTable)((Object)this));
                if (width <= -1) continue;
                int actualWidth = Math.max(width, headerSize.width) + 20;
                column.setMaxWidth(actualWidth);
                column.setPreferredWidth(actualWidth);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "profilerViewFacade";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sink";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/php/profiler/ui/ProfilerView$ExecutionStatisticView";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "uiDataSnapshot";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class CallTreeView
    extends ProfilerTreeTableView
    implements UiDataProvider {
        @NotNull
        private final ColoredTableCellRenderer myColoredTableCellRenderer;
        @NotNull
        protected final ProfilerViewFacade myProfilerViewFacade;

        public CallTreeView(@NotNull ProfilerViewFacade profilerViewFacade) {
            if (profilerViewFacade == null) {
                CallTreeView.$$$reportNull$$$0(0);
            }
            this(new CalleesTreeTableModel(profilerViewFacade, new CallerTreeNode(profilerViewFacade.getModelWrapper())), profilerViewFacade);
        }

        protected CallTreeView(@NotNull CalleesTreeTableModel treeTableModel, final @NotNull ProfilerViewFacade profilerViewFacade) {
            if (treeTableModel == null) {
                CallTreeView.$$$reportNull$$$0(1);
            }
            if (profilerViewFacade == null) {
                CallTreeView.$$$reportNull$$$0(2);
            }
            super(treeTableModel);
            this.myProfilerViewFacade = profilerViewFacade;
            this.myColoredTableCellRenderer = new ColoredTableCellRenderer(){

                protected void customizeCellRenderer(@NotNull JTable table, Object value, boolean selected, boolean hasFocus, int row, int column) {
                    if (table == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    int modelColumn = table.convertColumnIndexToModel(column);
                    if (value instanceof CallTreeNode) {
                        CallTreeNode callTreeNode = (CallTreeNode)value;
                        ProfilerModel.Call call = callTreeNode.getCall();
                        ProfilerModel.Callable callee = callTreeNode.getCallee();
                        switch (modelColumn) {
                            case 1: {
                                if (!(callee instanceof ProfilerModel.SourceCallable)) break;
                                String filePath = ((ProfilerModel.SourceCallable)callee).getSourcePosition().getFilePath();
                                this.append(filePath, SimpleTextAttributes.GRAY_ATTRIBUTES);
                                break;
                            }
                            case 2: {
                                long summaryInvocationCount = myProfilerViewFacade.getModelWrapper().getSummaryInvocationCount();
                                ProfilerUtil.renderRelation(call.getInvocationCount(), summaryInvocationCount, (SimpleColoredComponent)this);
                                break;
                            }
                            case 3: {
                                long summaryTime = myProfilerViewFacade.getModelWrapper().getSummaryTime();
                                ProfilerUtil.renderRelation(call.getTime(), summaryTime, profilerViewFacade.getTimeMeasurementUnit(), (SimpleColoredComponent)this);
                            }
                        }
                    } else if (value instanceof CallerTreeNode) {
                        CallerTreeNode callerTreeNode = (CallerTreeNode)value;
                        ProfilerModel.Callable caller = callerTreeNode.getCaller();
                        switch (modelColumn) {
                            case 1: {
                                if (!(caller instanceof ProfilerModel.SourceCallable)) break;
                                String filePath = ((ProfilerModel.SourceCallable)caller).getSourcePosition().getFilePath();
                                this.append(filePath, SimpleTextAttributes.GRAY_ATTRIBUTES);
                                break;
                            }
                            case 2: {
                                if (caller == null) break;
                                long callerSummaryInvocationCount = myProfilerViewFacade.getModelWrapper().getSummaryInvocationCount(caller);
                                long summaryInvocationCount = myProfilerViewFacade.getModelWrapper().getSummaryInvocationCount();
                                ProfilerUtil.renderRelation(callerSummaryInvocationCount, summaryInvocationCount, (SimpleColoredComponent)this);
                                break;
                            }
                            case 3: {
                                long callerSummaryTime = myProfilerViewFacade.getModelWrapper().getSummaryTime(caller);
                                long summaryTime = myProfilerViewFacade.getModelWrapper().getSummaryTime();
                                ProfilerUtil.renderRelation(callerSummaryTime, summaryTime, profilerViewFacade.getTimeMeasurementUnit(), (SimpleColoredComponent)this);
                            }
                        }
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/jetbrains/php/profiler/ui/ProfilerView$CallTreeView$1", "customizeCellRenderer"));
                }
            };
            this.onModelUpdated();
            TreeTableSpeedSearch.installOn((TreeTable)this, TREE_SPEED_SEARCH_CONVERTOR);
        }

        @Override
        protected void onModelUpdated() {
            this.getTree().setShowsRootHandles(false);
            this.getTree().setRootVisible(true);
            this.setTreeCellRenderer((TreeCellRenderer)((Object)new MyTreeCellRenderer()));
            this.setSelectionMode(0);
        }

        public void uiDataSnapshot(@NotNull DataSink sink) {
            if (sink == null) {
                CallTreeView.$$$reportNull$$$0(3);
            }
            ProfilerModel.Callable callable = ProfilerView.getSelectedCallable((JTable)((Object)this));
            sink.lazy(CommonDataKeys.PSI_ELEMENT, () -> ProfilerView.findElement(this.myProfilerViewFacade, callable));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "profilerViewFacade";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "treeTableModel";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sink";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/php/profiler/ui/ProfilerView$CallTreeView";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "uiDataSnapshot";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class CalleesTreeView
    extends CallTreeView
    implements CallableSelectedListener {
        public CalleesTreeView(@NotNull ProfilerViewFacade profilerViewFacade) {
            if (profilerViewFacade == null) {
                CalleesTreeView.$$$reportNull$$$0(0);
            }
            super(profilerViewFacade);
        }

        @Override
        public void onCallableSelected(@Nullable ProfilerModel.Callable callable) {
            this.setModel(new CalleesTreeTableModel(this.myProfilerViewFacade, new CallerTreeNode(this.myProfilerViewFacade.getModelWrapper(), callable)));
            this.onModelUpdated();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "profilerViewFacade", "com/jetbrains/php/profiler/ui/ProfilerView$CalleesTreeView", "<init>"));
        }
    }

    public static class CallersTreeView
    extends ProfilerTreeTableView
    implements CallableSelectedListener,
    UiDataProvider {
        @NotNull
        final ProfilerViewFacade myProfilerViewFacade;

        public CallersTreeView(@NotNull ProfilerViewFacade profilerViewFacade) {
            if (profilerViewFacade == null) {
                CallersTreeView.$$$reportNull$$$0(0);
            }
            super(new CallersTreeTableModel(new CalleeTreeNode(profilerViewFacade.getModelWrapper(), null)));
            this.myProfilerViewFacade = profilerViewFacade;
            TreeTableSpeedSearch.installOn((TreeTable)this, TREE_SPEED_SEARCH_CONVERTOR);
        }

        @Override
        protected void onModelUpdated() {
            this.getTree().setShowsRootHandles(false);
            this.getTree().setRootVisible(true);
            this.setTreeCellRenderer((TreeCellRenderer)((Object)new MyTreeCellRenderer()));
            this.setSelectionMode(0);
        }

        @Override
        public void onCallableSelected(@Nullable ProfilerModel.Callable callable) {
            this.setModel(new CallersTreeTableModel(new CalleeTreeNode(this.myProfilerViewFacade.getModelWrapper(), callable)));
            this.onModelUpdated();
        }

        public void uiDataSnapshot(@NotNull DataSink sink) {
            if (sink == null) {
                CallersTreeView.$$$reportNull$$$0(1);
            }
            ProfilerModel.Callable callable = ProfilerView.getSelectedCallable((JTable)((Object)this));
            sink.lazy(CommonDataKeys.PSI_ELEMENT, () -> ProfilerView.findElement(this.myProfilerViewFacade, callable));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "profilerViewFacade";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sink";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/php/profiler/ui/ProfilerView$CallersTreeView";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "uiDataSnapshot";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private final class MyListSelectionListener
    implements ListSelectionListener {
        @NotNull
        private final JTable myTable;

        private MyListSelectionListener(JTable table) {
            if (table == null) {
                MyListSelectionListener.$$$reportNull$$$0(0);
            }
            this.myTable = table;
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (!e.getValueIsAdjusting()) {
                ProfilerView.this.onCallableSelected(ProfilerView.getSelectedCallable(this.myTable));
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/jetbrains/php/profiler/ui/ProfilerView$MyListSelectionListener", "<init>"));
        }
    }

    private static final class CallTreeNode
    extends ProfilerSimpleLazyNode<ProfilerModel.Callable> {
        @NotNull
        private final ProfilerModelWrapper myModel;
        @NotNull
        private final ProfilerModel.Call myCall;

        CallTreeNode(@NotNull ProfilerModelWrapper model, @NotNull ProfilerModel.Callable callee, @NotNull ProfilerModel.Call call) {
            if (model == null) {
                CallTreeNode.$$$reportNull$$$0(0);
            }
            if (callee == null) {
                CallTreeNode.$$$reportNull$$$0(1);
            }
            if (call == null) {
                CallTreeNode.$$$reportNull$$$0(2);
            }
            super(callee);
            this.myCall = call;
            this.myModel = model;
        }

        @Override
        protected void appendChildren(@NotNull Collection<MutableTreeNode> children) {
            if (children == null) {
                CallTreeNode.$$$reportNull$$$0(3);
            }
            for (Map.Entry<ProfilerModel.Callable, ProfilerModel.Call> entry : this.myModel.getModel().getCallees((ProfilerModel.Callable)this.getObject()).entrySet()) {
                children.add(new CallTreeNode(this.myModel, entry.getKey(), entry.getValue()));
            }
        }

        @NotNull
        public ProfilerModel.Callable getCallee() {
            ProfilerModel.Callable callable = (ProfilerModel.Callable)this.getObject();
            if (callable == null) {
                CallTreeNode.$$$reportNull$$$0(4);
            }
            return callable;
        }

        @NotNull
        public ProfilerModel.Call getCall() {
            ProfilerModel.Call call = this.myCall;
            if (call == null) {
                CallTreeNode.$$$reportNull$$$0(5);
            }
            return call;
        }

        @Override
        public Object getUserObject() {
            return this.getCallee();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 4, 5 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "model";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "callee";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "call";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "children";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/profiler/ui/ProfilerView$CallTreeNode";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/profiler/ui/ProfilerView$CallTreeNode";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCallee";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCall";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "appendChildren";
                    break;
                }
                case 4: 
                case 5: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 4, 5 -> new IllegalStateException(string);
            };
        }
    }

    private static final class CalleeTreeNode
    extends ProfilerSimpleLazyNode<ProfilerModel.Callable> {
        @NotNull
        private final ProfilerModelWrapper myModel;

        CalleeTreeNode(@NotNull ProfilerModelWrapper model, @Nullable ProfilerModel.Callable callee) {
            if (model == null) {
                CalleeTreeNode.$$$reportNull$$$0(0);
            }
            super(callee);
            this.myModel = model;
        }

        @Override
        protected void appendChildren(@NotNull Collection<MutableTreeNode> children) {
            ProfilerModel.Callable callee;
            if (children == null) {
                CalleeTreeNode.$$$reportNull$$$0(1);
            }
            if ((callee = this.getCallee()) != null) {
                Set<ProfilerModel.Callable> callers = this.myModel.getModel().getCallers(callee);
                for (ProfilerModel.Callable caller : callers) {
                    children.add(new CalleeTreeNode(this.myModel, caller));
                }
            }
        }

        @Nullable
        public ProfilerModel.Callable getCallee() {
            return (ProfilerModel.Callable)this.getObject();
        }

        @Override
        @Nullable
        public Object getUserObject() {
            return this.getCallee();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "model";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "children";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/php/profiler/ui/ProfilerView$CalleeTreeNode";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "appendChildren";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class CallerTreeNode
    extends ProfilerSimpleLazyNode<ProfilerModel.Callable> {
        @NotNull
        private final ProfilerModelWrapper myModel;

        CallerTreeNode(@NotNull ProfilerModelWrapper model) {
            if (model == null) {
                CallerTreeNode.$$$reportNull$$$0(0);
            }
            this(model, null);
        }

        CallerTreeNode(@NotNull ProfilerModelWrapper model, @Nullable ProfilerModel.Callable caller) {
            if (model == null) {
                CallerTreeNode.$$$reportNull$$$0(1);
            }
            super(caller);
            this.myModel = model;
        }

        @Override
        protected void appendChildren(@NotNull Collection<MutableTreeNode> children) {
            if (children == null) {
                CallerTreeNode.$$$reportNull$$$0(2);
            }
            for (Map.Entry<ProfilerModel.Callable, ProfilerModel.Call> entry : this.myModel.getModel().getCallees(this.getCaller()).entrySet()) {
                children.add(new CallTreeNode(this.myModel, entry.getKey(), entry.getValue()));
            }
        }

        @Nullable
        public ProfilerModel.Callable getCaller() {
            return (ProfilerModel.Callable)this.getObject();
        }

        @Override
        @Nullable
        public Object getUserObject() {
            return this.getCaller();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "model";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "children";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/php/profiler/ui/ProfilerView$CallerTreeNode";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "appendChildren";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class MyTreeCellRenderer
    extends ColoredTreeCellRenderer {
        private MyTreeCellRenderer() {
        }

        public void customizeCellRenderer(@NotNull JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            if (tree == null) {
                MyTreeCellRenderer.$$$reportNull$$$0(0);
            }
            if (value instanceof DefaultMutableTreeNode) {
                Object userObject = ((DefaultMutableTreeNode)value).getUserObject();
                if (userObject instanceof ProfilerModel.Callable) {
                    ((ProfilerModel.Callable)userObject).computePresentation((SimpleColoredComponent)this);
                } else {
                    this.append(PhpBundle.message("all.scripts", new Object[0]), SimpleTextAttributes.REGULAR_ATTRIBUTES);
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/jetbrains/php/profiler/ui/ProfilerView$MyTreeCellRenderer", "customizeCellRenderer"));
        }
    }

    private static final class MyTableCellRenderer
    extends ColoredTableCellRenderer {
        private MyTableCellRenderer() {
        }

        protected void customizeCellRenderer(@NotNull JTable table, Object value, boolean selected, boolean hasFocus, int row, int column) {
            if (table == null) {
                MyTableCellRenderer.$$$reportNull$$$0(0);
            }
            if (value instanceof ProfilerModel.Callable) {
                ((ProfilerModel.Callable)value).computePresentation((SimpleColoredComponent)this);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/jetbrains/php/profiler/ui/ProfilerView$MyTableCellRenderer", "customizeCellRenderer"));
        }
    }

    private static final class CallersTreeTableModel
    extends ProfilerTreeTableModel {
        private CallersTreeTableModel(TreeNode root) {
            super(root, new ColumnInfo[]{new CallableTreeTableColumnInfo()});
        }
    }

    private static final class SummaryTimeTreeTableColumnInfo
    extends ProfilerTreeNodeColumnInfo<ProfilerModel.Callable> {
        @NotNull
        private final ProfilerViewFacade myProfilerViewFacade;
        private final ColoredTableCellRenderer myRenderer;
        @NotNull
        private final SummaryTimeTableColumnInfo myColumnInfo;

        private SummaryTimeTreeTableColumnInfo(final @NotNull ProfilerViewFacade profilerViewFacade) {
            if (profilerViewFacade == null) {
                SummaryTimeTreeTableColumnInfo.$$$reportNull$$$0(0);
            }
            super(PhpBundle.message("profiler.column.time.title", new Object[0]));
            this.myColumnInfo = new SummaryTimeTableColumnInfo(profilerViewFacade);
            this.myProfilerViewFacade = profilerViewFacade;
            this.myRenderer = new ColoredTableCellRenderer(){

                protected void customizeCellRenderer(@NotNull JTable table, Object value, boolean selected, boolean hasFocus, int row, int column) {
                    ProfilerModel.Callable caller;
                    if (table == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (value instanceof CallTreeNode) {
                        ProfilerModel.Call call = ((CallTreeNode)value).getCall();
                        long summaryTime = myProfilerViewFacade.getModelWrapper().getSummaryTime();
                        ProfilerUtil.renderRelation(call.getTime(), summaryTime, profilerViewFacade.getTimeMeasurementUnit(), (SimpleColoredComponent)this);
                    } else if (value instanceof CallerTreeNode && (caller = ((CallerTreeNode)value).getCaller()) != null) {
                        long callerSummaryTime = myProfilerViewFacade.getModelWrapper().getSummaryTime(caller);
                        long summaryTime = myProfilerViewFacade.getModelWrapper().getSummaryTime();
                        ProfilerUtil.renderRelation(callerSummaryTime, summaryTime, profilerViewFacade.getTimeMeasurementUnit(), (SimpleColoredComponent)this);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/jetbrains/php/profiler/ui/ProfilerView$SummaryTimeTreeTableColumnInfo$1", "customizeCellRenderer"));
                }
            };
        }

        public TableCellRenderer getRenderer(@NotNull ProfilerTreeNode<ProfilerModel.Callable> treeNode) {
            if (treeNode == null) {
                SummaryTimeTreeTableColumnInfo.$$$reportNull$$$0(1);
            }
            return this.myRenderer;
        }

        public int getWidth(JTable table) {
            return this.myColumnInfo.getWidth(table);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "profilerViewFacade";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "treeNode";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/php/profiler/ui/ProfilerView$SummaryTimeTreeTableColumnInfo";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getRenderer";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class SummaryInvocationCountTreeTableColumnInfo
    extends ProfilerTreeNodeColumnInfo<ProfilerModel.Callable> {
        @NotNull
        private final ProfilerViewFacade myProfilerViewFacade;
        private final ColoredTableCellRenderer myRenderer;
        @NotNull
        private final SummaryInvocationCountTableColumnInfo myColumnInfo;

        private SummaryInvocationCountTreeTableColumnInfo(@NotNull ProfilerViewFacade profilerViewFacade) {
            if (profilerViewFacade == null) {
                SummaryInvocationCountTreeTableColumnInfo.$$$reportNull$$$0(0);
            }
            super(PhpBundle.message("profiler.column.invocation.count.title", new Object[0]));
            this.myProfilerViewFacade = profilerViewFacade;
            this.myColumnInfo = new SummaryInvocationCountTableColumnInfo(profilerViewFacade.getModelWrapper());
            this.myRenderer = new ColoredTableCellRenderer(){

                protected void customizeCellRenderer(@NotNull JTable table, Object value, boolean selected, boolean hasFocus, int row, int column) {
                    if (table == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (value instanceof CallTreeNode) {
                        ProfilerModel.Call call = ((CallTreeNode)value).getCall();
                        long summaryInvocationCount = myProfilerViewFacade.getModelWrapper().getSummaryInvocationCount();
                        ProfilerUtil.renderRelation(call.getInvocationCount(), summaryInvocationCount, (SimpleColoredComponent)this);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/jetbrains/php/profiler/ui/ProfilerView$SummaryInvocationCountTreeTableColumnInfo$1", "customizeCellRenderer"));
                }
            };
        }

        public TableCellRenderer getRenderer(@NotNull ProfilerTreeNode<ProfilerModel.Callable> treeNode) {
            if (treeNode == null) {
                SummaryInvocationCountTreeTableColumnInfo.$$$reportNull$$$0(1);
            }
            return this.myRenderer;
        }

        public int getWidth(JTable table) {
            return this.myColumnInfo.getWidth(table);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "profilerViewFacade";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "treeNode";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/php/profiler/ui/ProfilerView$SummaryInvocationCountTreeTableColumnInfo";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getRenderer";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class CallableTreeTableColumnInfo
    extends TreeTableColumnInfo<ProfilerModel.Callable> {
        private CallableTreeTableColumnInfo() {
            super(PhpBundle.message("profiler.column.invocation.callable", new Object[0]));
        }

        @Override
        public Comparator<ProfilerModel.Callable> getAspectComparator() {
            return TABLE_CALLABLE_SEARCH_KEY_COMPARATOR;
        }
    }

    private static final class CalleesTreeTableModel
    extends ProfilerTreeTableModel {
        @NotNull
        ProfilerModelWrapper myModel;

        private CalleesTreeTableModel(@NotNull ProfilerViewFacade profilerViewFacade, TreeNode root) {
            if (profilerViewFacade == null) {
                CalleesTreeTableModel.$$$reportNull$$$0(0);
            }
            super(root, new ColumnInfo[]{new CallableTreeTableColumnInfo(), new SummaryTimeTreeTableColumnInfo(profilerViewFacade), new SummaryInvocationCountTreeTableColumnInfo(profilerViewFacade)});
            this.myModel = profilerViewFacade.getModelWrapper();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "profilerViewFacade", "com/jetbrains/php/profiler/ui/ProfilerView$CalleesTreeTableModel", "<init>"));
        }
    }

    private static class SummaryTimeTableColumnInfo
    extends ColumnInfo<ProfilerModel.Callable, ProfilerModel.Callable> {
        @NotNull
        private final ProfilerModelWrapper myModel;
        @NotNull
        private final Comparator<ProfilerModel.Callable> myComparator;
        @NotNull
        private final ColoredTableCellRenderer myRenderer;

        SummaryTimeTableColumnInfo(final @NotNull ProfilerViewFacade viewFacade) {
            ProfilerModelWrapper model;
            if (viewFacade == null) {
                SummaryTimeTableColumnInfo.$$$reportNull$$$0(0);
            }
            super(PhpBundle.message("profiler.column.time.title", new Object[0]));
            this.myModel = model = viewFacade.getModelWrapper();
            this.myComparator = (o1, o2) -> (int)Math.signum(model.getSummaryTime((ProfilerModel.Callable)o1) - model.getSummaryTime((ProfilerModel.Callable)o2));
            this.myRenderer = new ColoredTableCellRenderer(){

                protected void customizeCellRenderer(@NotNull JTable table, Object value, boolean selected, boolean hasFocus, int row, int column) {
                    if (table == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (value instanceof ProfilerModel.Callable) {
                        ProfilerUtil.renderRelation(model.getSummaryTime((ProfilerModel.Callable)value), model.getSummaryTime(), viewFacade.getTimeMeasurementUnit(), (SimpleColoredComponent)this);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/jetbrains/php/profiler/ui/ProfilerView$SummaryTimeTableColumnInfo$1", "customizeCellRenderer"));
                }
            };
        }

        public ProfilerModel.Callable valueOf(ProfilerModel.Callable callable) {
            return callable;
        }

        public Comparator<ProfilerModel.Callable> getComparator() {
            return this.myComparator;
        }

        public TableCellRenderer getRenderer(ProfilerModel.Callable callable) {
            return this.myRenderer;
        }

        public int getWidth(JTable table) {
            ProfilerModel.Callable maxSummaryTime = this.myModel.getMaxSummaryTime();
            SimpleColoredComponent component = (SimpleColoredComponent)this.myRenderer.getTableCellRendererComponent(table, (Object)maxSummaryTime, false, false, 0, 0);
            return (int)component.getPreferredSize().getWidth();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "viewFacade", "com/jetbrains/php/profiler/ui/ProfilerView$SummaryTimeTableColumnInfo", "<init>"));
        }
    }

    private static class SummaryOwnTimeTableColumnInfo
    extends ColumnInfo<ProfilerModel.Callable, ProfilerModel.Callable> {
        @NotNull
        private final ProfilerModelWrapper myModel;
        @NotNull
        private final ColoredTableCellRenderer myRenderer;

        SummaryOwnTimeTableColumnInfo(final @NotNull ProfilerViewFacade viewFacade) {
            ProfilerModelWrapper model;
            if (viewFacade == null) {
                SummaryOwnTimeTableColumnInfo.$$$reportNull$$$0(0);
            }
            super(PhpBundle.message("profiler.column.own.time.title", new Object[0]));
            this.myModel = model = viewFacade.getModelWrapper();
            this.myRenderer = new ColoredTableCellRenderer(){

                protected void customizeCellRenderer(@NotNull JTable table, Object value, boolean selected, boolean hasFocus, int row, int column) {
                    if (table == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (value instanceof ProfilerModel.Callable) {
                        ProfilerUtil.renderRelation(model.getSummaryOwnTime((ProfilerModel.Callable)value), model.getSummaryTime(), viewFacade.getTimeMeasurementUnit(), (SimpleColoredComponent)this);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/jetbrains/php/profiler/ui/ProfilerView$SummaryOwnTimeTableColumnInfo$1", "customizeCellRenderer"));
                }
            };
        }

        public ProfilerModel.Callable valueOf(ProfilerModel.Callable entry) {
            return entry;
        }

        public Comparator<ProfilerModel.Callable> getComparator() {
            return Comparator.comparingLong(this.myModel::getSummaryOwnTime);
        }

        public TableCellRenderer getRenderer(ProfilerModel.Callable callable) {
            return this.myRenderer;
        }

        public int getWidth(JTable table) {
            ProfilerModel.Callable maxSummaryOwnTime = this.myModel.getMaxSummaryOwnTime();
            SimpleColoredComponent component = (SimpleColoredComponent)this.myRenderer.getTableCellRendererComponent(table, (Object)maxSummaryOwnTime, false, false, 0, 0);
            return (int)component.getPreferredSize().getWidth();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "viewFacade", "com/jetbrains/php/profiler/ui/ProfilerView$SummaryOwnTimeTableColumnInfo", "<init>"));
        }
    }

    private static class SummaryInvocationCountTableColumnInfo
    extends ColumnInfo<ProfilerModel.Callable, ProfilerModel.Callable> {
        @NotNull
        private final ProfilerModelWrapper myModel;
        @NotNull
        private final ColoredTableCellRenderer myRenderer;

        SummaryInvocationCountTableColumnInfo(@NotNull ProfilerModelWrapper model) {
            if (model == null) {
                SummaryInvocationCountTableColumnInfo.$$$reportNull$$$0(0);
            }
            super(PhpBundle.message("profiler.column.invocation.count.title", new Object[0]));
            this.myModel = model;
            this.myRenderer = new ColoredTableCellRenderer(){

                protected void customizeCellRenderer(@NotNull JTable table, Object value, boolean selected, boolean hasFocus, int row, int column) {
                    if (table == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (value instanceof ProfilerModel.Callable) {
                        long time = myModel.getSummaryInvocationCount((ProfilerModel.Callable)value);
                        ProfilerUtil.renderRelation(time, myModel.getSummaryInvocationCount(), (SimpleColoredComponent)this);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/jetbrains/php/profiler/ui/ProfilerView$SummaryInvocationCountTableColumnInfo$1", "customizeCellRenderer"));
                }
            };
        }

        public ProfilerModel.Callable valueOf(ProfilerModel.Callable entry) {
            return entry;
        }

        public Comparator<ProfilerModel.Callable> getComparator() {
            return (o1, o2) -> (int)(this.myModel.getSummaryInvocationCount((ProfilerModel.Callable)o1) - this.myModel.getSummaryInvocationCount((ProfilerModel.Callable)o2));
        }

        public TableCellRenderer getRenderer(ProfilerModel.Callable callable) {
            return this.myRenderer;
        }

        public int getWidth(JTable table) {
            ProfilerModel.Callable maxSummaryInvocationCount = this.myModel.getMaxSummaryInvocationCount();
            SimpleColoredComponent component = (SimpleColoredComponent)this.myRenderer.getTableCellRendererComponent(table, (Object)maxSummaryInvocationCount, false, false, 0, 0);
            return (int)component.getPreferredSize().getWidth();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/jetbrains/php/profiler/ui/ProfilerView$SummaryInvocationCountTableColumnInfo", "<init>"));
        }
    }

    private static class ScriptTableColumnInfo
    extends ColumnInfo<ProfilerModel.Callable, ProfilerModel.Callable> {
        private static final ColoredTableCellRenderer RENDERER = new ColoredTableCellRenderer(){

            protected void customizeCellRenderer(@NotNull JTable table, Object value, boolean selected, boolean hasFocus, int row, int column) {
                if (table == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (value instanceof ProfilerModel.SourceCallable) {
                    String filePath = ((ProfilerModel.SourceCallable)value).getSourcePosition().getFilePath();
                    this.append(filePath, SimpleTextAttributes.GRAY_ATTRIBUTES);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/jetbrains/php/profiler/ui/ProfilerView$ScriptTableColumnInfo$1", "customizeCellRenderer"));
            }
        };

        ScriptTableColumnInfo() {
            super(PhpBundle.message("profiler.column.script", new Object[0]));
        }

        public ProfilerModel.Callable valueOf(ProfilerModel.Callable entry) {
            return entry;
        }

        public Class getColumnClass() {
            return ProfilerModel.Callable.class;
        }

        public Comparator<ProfilerModel.Callable> getComparator() {
            return CALLABLE_FILE_PATH_COMPARATOR;
        }

        public TableCellRenderer getRenderer(ProfilerModel.Callable callable) {
            return RENDERER;
        }

        public String getPreferredStringValue() {
            return "ScriptScriptScript";
        }

        public String getMaxStringValue() {
            return "ScriptScriptScriptScript";
        }
    }

    private static class CallableTableColumnInfo
    extends ColumnInfo<ProfilerModel.Callable, ProfilerModel.Callable> {
        CallableTableColumnInfo() {
            super(PhpBundle.message("profiler.column.invocation.callable", new Object[0]));
        }

        public ProfilerModel.Callable valueOf(ProfilerModel.Callable entry) {
            return entry;
        }

        public Class getColumnClass() {
            return ProfilerModel.Callable.class;
        }

        public Comparator<ProfilerModel.Callable> getComparator() {
            return TABLE_CALLABLE_SEARCH_KEY_COMPARATOR;
        }
    }
}

