/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.psalm.lang;

import com.intellij.lang.parameterInfo.CreateParameterInfoContext;
import com.intellij.lang.parameterInfo.ParameterInfoContext;
import com.intellij.lang.parameterInfo.ParameterInfoHandler;
import com.intellij.lang.parameterInfo.ParameterInfoHandlerWithTabActionSupport;
import com.intellij.lang.parameterInfo.ParameterInfoUIContext;
import com.intellij.lang.parameterInfo.UpdateParameterInfoContext;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.IntPair;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.lang.PhpParameterInfoHandler;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.Statement;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.psalm.lang.inspections.PsalmAdvanceCallableParamsInspection;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class PsalmAdvancedClosureParameterInfoHandler
implements ParameterInfoHandlerWithTabActionSupport<FunctionReference, List<Pair<String, PhpType>>, PhpPsiElement> {
    private String text;

    @Nullable
    public FunctionReference findElementForParameterInfo(@NotNull CreateParameterInfoContext context) {
        List<Pair<String, PhpType>> types;
        FunctionReference reference;
        if (context == null) {
            PsalmAdvancedClosureParameterInfoHandler.$$$reportNull$$$0(0);
        }
        if ((reference = (FunctionReference)ObjectUtils.tryCast((Object)PhpParameterInfoHandler.findAnchorForParameterInfo((ParameterInfoContext)context), FunctionReference.class)) != null && StringUtil.isEmpty((String)reference.getName()) && !(types = PsalmAdvanceCallableParamsInspection.getAdvancedCallableParametersTypes(reference)).isEmpty()) {
            context.setItemsToShow(new Object[]{types});
            return reference;
        }
        return null;
    }

    public void showParameterInfo(@NotNull FunctionReference element, @NotNull CreateParameterInfoContext context) {
        if (element == null) {
            PsalmAdvancedClosureParameterInfoHandler.$$$reportNull$$$0(1);
        }
        if (context == null) {
            PsalmAdvancedClosureParameterInfoHandler.$$$reportNull$$$0(2);
        }
        context.showHint((PsiElement)element, element.getTextRange().getStartOffset(), (ParameterInfoHandler)this);
    }

    @Nullable
    public FunctionReference findElementForUpdatingParameterInfo(@NotNull UpdateParameterInfoContext context) {
        if (context == null) {
            PsalmAdvancedClosureParameterInfoHandler.$$$reportNull$$$0(3);
        }
        return (FunctionReference)ObjectUtils.tryCast((Object)PhpParameterInfoHandler.findAnchorForParameterInfo((ParameterInfoContext)context), FunctionReference.class);
    }

    public void updateParameterInfo(@NotNull FunctionReference reference, @NotNull UpdateParameterInfoContext context) {
        if (reference == null) {
            PsalmAdvancedClosureParameterInfoHandler.$$$reportNull$$$0(4);
        }
        if (context == null) {
            PsalmAdvancedClosureParameterInfoHandler.$$$reportNull$$$0(5);
        }
        context.setCurrentParameter(PhpParameterInfoHandler.getCurrentParameterIndex((PhpPsiElement)reference, PhpParameterInfoHandler.getCurrentOffset(context), this.getActualParameterDelimiterType()));
    }

    public void updateUI(List<Pair<String, PhpType>> p, @NotNull ParameterInfoUIContext context) {
        if (context == null) {
            PsalmAdvancedClosureParameterInfoHandler.$$$reportNull$$$0(6);
        }
        if (p == null) {
            context.setUIComponentEnabled(false);
            return;
        }
        int currentParameter = context.getCurrentParameterIndex();
        if (currentParameter < 0) {
            currentParameter = 0;
        }
        StringBuilder buffer = new StringBuilder();
        IntPair highlightRange = PhpParameterInfoHandler.appendParameterInfo(context, buffer, new IntPair(-1, -1), currentParameter, p, PsalmAdvancedClosureParameterInfoHandler::getPresentation);
        this.text = buffer.toString();
        context.setupUIComponentPresentation(this.text, highlightRange.first, highlightRange.second, false, false, false, context.getDefaultParameterColor());
    }

    private static String getPresentation(Pair<String, PhpType> p) {
        String name = (String)p.getFirst();
        return name.isEmpty() ? ((PhpType)p.getSecond()).toString() : name + ": " + ((PhpType)p.getSecond()).toString();
    }

    public PhpPsiElement @NotNull [] getActualParameters(@NotNull FunctionReference o) {
        if (o == null) {
            PsalmAdvancedClosureParameterInfoHandler.$$$reportNull$$$0(7);
        }
        PsiElement[] parameters = o.getParameters();
        PhpPsiElement[] phpPsiElementArray = (PhpPsiElement[])Arrays.copyOf(parameters, parameters.length, PhpPsiElement[].class);
        if (phpPsiElementArray == null) {
            PsalmAdvancedClosureParameterInfoHandler.$$$reportNull$$$0(8);
        }
        return phpPsiElementArray;
    }

    @NotNull
    public IElementType getActualParameterDelimiterType() {
        IElementType iElementType = PhpTokenTypes.opCOMMA;
        if (iElementType == null) {
            PsalmAdvancedClosureParameterInfoHandler.$$$reportNull$$$0(9);
        }
        return iElementType;
    }

    @NotNull
    public IElementType getActualParametersRBraceType() {
        IElementType iElementType = PhpTokenTypes.chRPAREN;
        if (iElementType == null) {
            PsalmAdvancedClosureParameterInfoHandler.$$$reportNull$$$0(10);
        }
        return iElementType;
    }

    @NotNull
    public Set<Class<?>> getArgumentListAllowedParentClasses() {
        HashSet hashSet = ContainerUtil.newHashSet((Object[])new Class[]{PhpPsiElement.class});
        if (hashSet == null) {
            PsalmAdvancedClosureParameterInfoHandler.$$$reportNull$$$0(11);
        }
        return hashSet;
    }

    @NotNull
    public Set<? extends Class<?>> getArgListStopSearchClasses() {
        HashSet hashSet = ContainerUtil.newHashSet((Object[])new Class[]{Statement.class});
        if (hashSet == null) {
            PsalmAdvancedClosureParameterInfoHandler.$$$reportNull$$$0(12);
        }
        return hashSet;
    }

    @NotNull
    public Class<FunctionReference> getArgumentListClass() {
        return FunctionReference.class;
    }

    @TestOnly
    public String getText() {
        return this.text;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 8, 9, 10, 11, 12 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/psalm/lang/PsalmAdvancedClosureParameterInfoHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/psalm/lang/PsalmAdvancedClosureParameterInfoHandler";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getActualParameters";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getActualParameterDelimiterType";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getActualParametersRBraceType";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getArgumentListAllowedParentClasses";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getArgListStopSearchClasses";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findElementForParameterInfo";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "showParameterInfo";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findElementForUpdatingParameterInfo";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "updateParameterInfo";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "updateUI";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getActualParameters";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 8, 9, 10, 11, 12 -> new IllegalStateException(string);
        };
    }
}

