/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.refactoring.changeSignature;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.refactoring.ConflictsDialogBase;
import com.intellij.refactoring.changeSignature.ChangeInfo;
import com.intellij.refactoring.changeSignature.ChangeSignatureProcessorBase;
import com.intellij.refactoring.changeSignature.ChangeSignatureUsageProcessor;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewDescriptor;
import com.intellij.util.containers.MultiMap;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.parser.PhpStubElementTypes;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.lang.psi.elements.PhpReturnType;
import com.jetbrains.php.refactoring.PhpFunctionCodeGenerator;
import com.jetbrains.php.refactoring.changeSignature.PhpChangeInfo;
import com.jetbrains.php.refactoring.changeSignature.PhpChangeSignatureUsageProcessor;
import com.jetbrains.php.refactoring.changeSignature.PhpChangeSignatureUsageViewDescriptor;
import com.jetbrains.php.refactoring.changeSignature.PhpMethodDescriptor;
import com.jetbrains.php.refactoring.changeSignature.PhpParameterInfo;
import java.util.Arrays;
import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpChangeSignatureProcessor
extends ChangeSignatureProcessorBase {
    public PhpChangeSignatureProcessor(@NotNull Project project, @NotNull PhpMethodDescriptor method, @Nullable String newVisibility, @NotNull String newName, @Nullable String newReturnType, PhpParameterInfo @NotNull [] parameterInfo, @Nullable Set<Function> methodsToPropagateParameters, boolean initializeParameters, boolean updatePhpDoc) {
        if (project == null) {
            PhpChangeSignatureProcessor.$$$reportNull$$$0(0);
        }
        if (method == null) {
            PhpChangeSignatureProcessor.$$$reportNull$$$0(1);
        }
        if (newName == null) {
            PhpChangeSignatureProcessor.$$$reportNull$$$0(2);
        }
        if (parameterInfo == null) {
            PhpChangeSignatureProcessor.$$$reportNull$$$0(3);
        }
        this(project, PhpChangeSignatureProcessor.generateChangeInfo(method, newVisibility, newName, newReturnType, parameterInfo, methodsToPropagateParameters, initializeParameters, updatePhpDoc));
    }

    public PhpChangeSignatureProcessor(@NotNull Project project, @NotNull PhpChangeInfo changeInfo) {
        if (project == null) {
            PhpChangeSignatureProcessor.$$$reportNull$$$0(4);
        }
        if (changeInfo == null) {
            PhpChangeSignatureProcessor.$$$reportNull$$$0(5);
        }
        super(project, (ChangeInfo)changeInfo);
    }

    public static PhpChangeInfo generateChangeInfo(@NotNull PhpMethodDescriptor method, @Nullable String newVisibility, @NotNull String newName, @Nullable String newReturnTypeText, PhpParameterInfo @NotNull [] parameterInfo, @Nullable Set<Function> methodsToPropagateParameters, boolean initializeParameters, boolean updatePhpDoc) {
        if (method == null) {
            PhpChangeSignatureProcessor.$$$reportNull$$$0(6);
        }
        if (newName == null) {
            PhpChangeSignatureProcessor.$$$reportNull$$$0(7);
        }
        if (parameterInfo == null) {
            PhpChangeSignatureProcessor.$$$reportNull$$$0(8);
        }
        return new PhpChangeInfo(method, parameterInfo, newVisibility, newName, newReturnTypeText, methodsToPropagateParameters, initializeParameters, updatePhpDoc);
    }

    public static PsiElement appendParameterToParameterList(@NotNull Function function, @NotNull Parameter parameter) {
        if (function == null) {
            PhpChangeSignatureProcessor.$$$reportNull$$$0(9);
        }
        if (parameter == null) {
            PhpChangeSignatureProcessor.$$$reportNull$$$0(10);
        }
        PsiElement parameterList = PhpPsiUtil.getChildOfType((PsiElement)function, PhpElementTypes.PARAMETER_LIST);
        assert (parameterList != null);
        PsiElement lastChild = parameterList.getLastChild();
        if (lastChild == null) {
            return parameterList.add((PsiElement)parameter);
        }
        return parameterList.addAfter((PsiElement)parameter, parameterList.addAfter(PhpPsiElementFactory.createComma(parameterList.getProject()), lastChild));
    }

    @Nullable
    private static Parameter addParameterAfter(@NotNull Function function, @NotNull Parameter parameter, @NotNull Parameter parameterToInsertAfter) {
        if (function == null) {
            PhpChangeSignatureProcessor.$$$reportNull$$$0(11);
        }
        if (parameter == null) {
            PhpChangeSignatureProcessor.$$$reportNull$$$0(12);
        }
        if (parameterToInsertAfter == null) {
            PhpChangeSignatureProcessor.$$$reportNull$$$0(13);
        }
        PsiElement parameterList = PhpPsiUtil.getChildOfType((PsiElement)function, PhpElementTypes.PARAMETER_LIST);
        assert (parameterList != null);
        return (Parameter)parameterList.addAfter((PsiElement)parameter, parameterList.addAfter(PhpPsiElementFactory.createComma(parameterList.getProject()), (PsiElement)parameterToInsertAfter));
    }

    @Nullable
    private static Parameter addParameterBefore(@NotNull Function function, @NotNull Parameter parameter, @NotNull Parameter parameterToInsertBefore) {
        if (function == null) {
            PhpChangeSignatureProcessor.$$$reportNull$$$0(14);
        }
        if (parameter == null) {
            PhpChangeSignatureProcessor.$$$reportNull$$$0(15);
        }
        if (parameterToInsertBefore == null) {
            PhpChangeSignatureProcessor.$$$reportNull$$$0(16);
        }
        PsiElement parameterList = PhpPsiUtil.getChildOfType((PsiElement)function, PhpElementTypes.PARAMETER_LIST);
        assert (parameterList != null);
        return (Parameter)parameterList.addBefore((PsiElement)parameter, parameterList.addBefore(PhpPsiElementFactory.createComma(parameterList.getProject()), (PsiElement)parameterToInsertBefore));
    }

    public static void addReturnType(Function f, @NotNull String returnType) {
        if (returnType == null) {
            PhpChangeSignatureProcessor.$$$reportNull$$$0(17);
        }
        PhpReturnType newType = PhpPsiElementFactory.createReturnType(f.getProject(), returnType);
        PhpChangeSignatureProcessor.addReturnType(f, newType);
    }

    public static void addReturnType(@NotNull Function f, @NotNull PhpReturnType newType) {
        if (f == null) {
            PhpChangeSignatureProcessor.$$$reportNull$$$0(18);
        }
        if (newType == null) {
            PhpChangeSignatureProcessor.$$$reportNull$$$0(19);
        }
        PsiElement rParen = PhpPsiUtil.getChildOfType((PsiElement)f, PhpTokenTypes.chRPAREN);
        PsiElement useList = PhpPsiUtil.getChildOfType((PsiElement)f, (IElementType)PhpStubElementTypes.USE_LIST);
        PsiElement elementToInsertAfter = useList != null ? useList : rParen;
        f.addAfter((PsiElement)newType, elementToInsertAfter);
        f.addAfter(PhpPsiElementFactory.createColon(f.getProject()), elementToInsertAfter);
    }

    @NotNull
    protected UsageViewDescriptor createUsageViewDescriptor(UsageInfo @NotNull [] usages) {
        if (usages == null) {
            PhpChangeSignatureProcessor.$$$reportNull$$$0(20);
        }
        return new PhpChangeSignatureUsageViewDescriptor(usages);
    }

    protected boolean preprocessUsages(@NotNull Ref<UsageInfo[]> refUsages) {
        if (refUsages == null) {
            PhpChangeSignatureProcessor.$$$reportNull$$$0(21);
        }
        for (ChangeSignatureUsageProcessor usageProcessor : (ChangeSignatureUsageProcessor[])ChangeSignatureUsageProcessor.EP_NAME.getExtensions()) {
            ConflictsDialogBase dialog;
            MultiMap conflicts = usageProcessor.findConflicts(this.myChangeInfo, refUsages);
            if (conflicts.size() == 0 || (dialog = this.prepareConflictsDialog(conflicts, (UsageInfo[])refUsages.get())).showAndGet()) continue;
            if (dialog.isShowConflicts()) {
                this.prepareSuccessful();
            }
            return false;
        }
        return super.preprocessUsages(refUsages);
    }

    public static void addParameterToFunctionSignature(@NotNull Project project, @NotNull Function function, @NotNull Collection<PhpParameterInfo> newParameterInfos) {
        if (project == null) {
            PhpChangeSignatureProcessor.$$$reportNull$$$0(22);
        }
        if (function == null) {
            PhpChangeSignatureProcessor.$$$reportNull$$$0(23);
        }
        if (newParameterInfos == null) {
            PhpChangeSignatureProcessor.$$$reportNull$$$0(24);
        }
        Parameter parameterToInsertAfter = PhpChangeSignatureProcessor.findParameterToInsertAfter(function);
        for (PhpParameterInfo parameterInfo : newParameterInfos) {
            Parameter complexParameter = PhpPsiElementFactory.createComplexParameter(project, PhpFunctionCodeGenerator.generateParameter(parameterInfo));
            if (parameterToInsertAfter != null) {
                parameterToInsertAfter = PhpChangeSignatureProcessor.addParameterAfter(function, complexParameter, parameterToInsertAfter);
                continue;
            }
            if (function.getParameters().length == 0) {
                parameterToInsertAfter = (Parameter)PhpChangeSignatureProcessor.appendParameterToParameterList(function, complexParameter);
                continue;
            }
            Optional<Parameter> parameterToInsertBefore = Arrays.stream(function.getParameters()).filter(parameter -> parameter.isVariadic() || parameter.getDefaultValue() != null).findFirst();
            if (!parameterToInsertBefore.isPresent()) continue;
            parameterToInsertAfter = PhpChangeSignatureProcessor.addParameterBefore(function, complexParameter, parameterToInsertBefore.get());
        }
        PhpChangeSignatureUsageProcessor.fixPhpDoc(function, false);
    }

    @Nullable
    public static Parameter findParameterToInsertAfter(@NotNull Function function) {
        if (function == null) {
            PhpChangeSignatureProcessor.$$$reportNull$$$0(25);
        }
        Parameter anchor = null;
        for (Parameter it : function.getParameters()) {
            if (it.getDefaultValue() != null || it.isVariadic()) break;
            anchor = it;
        }
        return anchor;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 2: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 3: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameterInfo";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changeInfo";
                break;
            }
            case 9: 
            case 11: 
            case 14: 
            case 23: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 10: 
            case 12: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameterToInsertAfter";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameterToInsertBefore";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "returnType";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "f";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newType";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usages";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refUsages";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newParameterInfos";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/refactoring/changeSignature/PhpChangeSignatureProcessor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "generateChangeInfo";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "appendParameterToParameterList";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "addParameterAfter";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[2] = "addParameterBefore";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[2] = "addReturnType";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[2] = "createUsageViewDescriptor";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[2] = "preprocessUsages";
                break;
            }
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[2] = "addParameterToFunctionSignature";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[2] = "findParameterToInsertAfter";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

