/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.refactoring.codesmells;

import com.jetbrains.php.refactoring.codesmells.Dependency;
import com.jetbrains.php.refactoring.codesmells.DependencyMap;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

public class DependencyGraph<T> {
    private final Collection<T> myNotVisitedNodes;
    private final DependencyMap<T, T> myAdjacencyList;
    private List<Set<T>> myComponents;

    public List<Set<T>> getComponents() {
        return this.myComponents;
    }

    public DependencyGraph(Collection<T> nodes, DependencyMap<T, T> list) {
        this.myNotVisitedNodes = nodes;
        this.myAdjacencyList = list;
        this.calculateGraphComponents();
    }

    @Nullable
    public Set<T> getContainingGraphComponent(T node) {
        for (Set<T> component : this.myComponents) {
            if (!component.contains(node)) continue;
            return component;
        }
        return null;
    }

    public void calculateGraphComponents() {
        this.myComponents = new ArrayList<Set<T>>();
        while (!this.myNotVisitedNodes.isEmpty()) {
            ArrayDeque stack = new ArrayDeque();
            stack.add(this.myNotVisitedNodes.iterator().next());
            HashSet component = new HashSet();
            while (!stack.isEmpty()) {
                Object member = stack.poll();
                component.add(member);
                if (!this.myNotVisitedNodes.contains(member)) continue;
                this.myNotVisitedNodes.remove(member);
                Dependency dependencies = this.myAdjacencyList.dependencyMap.get(member);
                if (dependencies == null) continue;
                for (Object classMember : dependencies.usedEntries.keySet()) {
                    if (!this.myNotVisitedNodes.contains(classMember)) continue;
                    stack.add(classMember);
                }
            }
            this.myComponents.add(component);
        }
    }
}

