/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.refactoring.extract.extractInterface;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocType;
import com.jetbrains.php.lang.documentation.phpdoc.psi.tags.PhpDocTag;
import com.jetbrains.php.lang.psi.elements.Catch;
import com.jetbrains.php.lang.psi.elements.ClassReference;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public class PhpExtractInterfaceUsageSearcher {
    private final Project myProject;
    private final PhpClass myClass;

    public PhpExtractInterfaceUsageSearcher(@NotNull Project project, @NotNull PhpClass aClass) {
        if (project == null) {
            PhpExtractInterfaceUsageSearcher.$$$reportNull$$$0(0);
        }
        if (aClass == null) {
            PhpExtractInterfaceUsageSearcher.$$$reportNull$$$0(1);
        }
        this.myProject = project;
        this.myClass = aClass;
    }

    public UsageInfo[] findUsages() {
        GlobalSearchScope scope = GlobalSearchScope.projectScope((Project)this.myProject);
        return this.findUsages((SearchScope)scope);
    }

    public UsageInfo[] findUsages(@NotNull SearchScope searchScope) {
        if (searchScope == null) {
            PhpExtractInterfaceUsageSearcher.$$$reportNull$$$0(2);
        }
        ReferencesSearch.SearchParameters searchParameters = new ReferencesSearch.SearchParameters((PsiElement)this.myClass, searchScope, false);
        final ArrayList usageInfos = new ArrayList();
        CommonProcessors.FindProcessor<PsiReference> finder = new CommonProcessors.FindProcessor<PsiReference>(this){

            protected boolean accept(PsiReference reference) {
                PsiElement parent;
                if (reference instanceof PhpDocType) {
                    PsiElement parent2 = ((PhpDocType)reference).getParent();
                    if (parent2 instanceof PhpDocTag) {
                        usageInfos.add(new UsageInfo(reference));
                    }
                } else if (reference instanceof ClassReference && (1.isReferenceToReplace(parent = ((ClassReference)reference).getParent()) || 1.isReferenceToReplace(parent.getParent()))) {
                    usageInfos.add(new UsageInfo(reference));
                }
                return false;
            }

            private static boolean isReferenceToReplace(@NotNull PsiElement parent) {
                if (parent == null) {
                    1.$$$reportNull$$$0(0);
                }
                return parent instanceof Parameter || parent instanceof Catch || parent instanceof PhpDocType || PhpExtractInterfaceUsageSearcher.isFunctionReturnType(parent);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/jetbrains/php/refactoring/extract/extractInterface/PhpExtractInterfaceUsageSearcher$1", "isReferenceToReplace"));
            }
        };
        ReferencesSearch.search((ReferencesSearch.SearchParameters)searchParameters).forEach((Processor)finder);
        return usageInfos.toArray(UsageInfo.EMPTY_ARRAY);
    }

    private static boolean isFunctionReturnType(@NotNull PsiElement parent) {
        if (parent == null) {
            PhpExtractInterfaceUsageSearcher.$$$reportNull$$$0(3);
        }
        return parent instanceof Function;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchScope";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/refactoring/extract/extractInterface/PhpExtractInterfaceUsageSearcher";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "findUsages";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isFunctionReturnType";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

