/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.refactoring.extractClass;

import com.intellij.internal.statistic.eventLog.events.EventField;
import com.intellij.internal.statistic.eventLog.events.EventPair;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.refactoring.classMembers.MemberInfoChange;
import com.intellij.refactoring.classMembers.MemberInfoModel;
import com.intellij.refactoring.ui.AbstractMemberSelectionTable;
import com.intellij.refactoring.ui.MemberSelectionPanelBase;
import com.intellij.refactoring.ui.RefactoringDialog;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.components.JBTextField;
import com.intellij.ui.dsl.builder.Align;
import com.intellij.ui.dsl.builder.AlignX;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.ButtonKt;
import com.intellij.ui.dsl.builder.Cell;
import com.intellij.ui.dsl.builder.LabelPosition;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.util.ui.JBUI;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.config.PhpLanguageLevel;
import com.jetbrains.php.lang.PhpFileType;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.Field;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.ParameterList;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpClassMember;
import com.jetbrains.php.lang.psi.elements.PhpReturnType;
import com.jetbrains.php.lang.psi.elements.PhpTypeDeclaration;
import com.jetbrains.php.refactoring.PhpFileCreationInfo;
import com.jetbrains.php.refactoring.PhpMemberInfo;
import com.jetbrains.php.refactoring.PhpNameUtil;
import com.jetbrains.php.refactoring.extractClass.PhpExtractClassDialogOptionsLogger;
import com.jetbrains.php.refactoring.extractClass.PhpExtractMembersToClassProcessor;
import com.jetbrains.php.refactoring.extractClass.ui.PhpClassSignaturePreview;
import com.jetbrains.php.refactoring.extractClass.ui.PhpMemberModelInfo;
import com.jetbrains.php.refactoring.ui.PhpMemberSelectionTable;
import com.jetbrains.php.refactoring.validation.PhpFilePathValidationException;
import com.jetbrains.php.roots.ui.PhpPsrNamespacePanel;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u008c\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0007\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bB\u001f\b\u0016\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u0007\u0010\u000bB'\b\u0016\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\u000fJ\b\u0010(\u001a\u00020)H\u0016J\b\u0010*\u001a\u00020+H\u0002J\b\u0010,\u001a\u00020+H\u0014J\b\u0010-\u001a\u00020\rH\u0002J\u0010\u0010.\u001a\u00020\r2\u0006\u0010/\u001a\u00020\u0006H\u0002J\u0010\u00100\u001a\u00020\r2\u0006\u00101\u001a\u000202H\u0002J\u0010\u00103\u001a\u00020\r2\u0006\u00101\u001a\u000204H\u0002J\b\u00105\u001a\u00020)H\u0014J\f\u00106\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005J\u0012\u00107\u001a\u00020+2\b\b\u0001\u00108\u001a\u00020\rH\u0002J\n\u00109\u001a\u0004\u0018\u00010:H\u0016J\b\u0010;\u001a\u00020\nH\u0014J\b\u0010<\u001a\u00020\rH\u0014J\n\u0010=\u001a\u0004\u0018\u00010:H\u0002J\b\u0010>\u001a\u00020+H\u0014J\b\u0010?\u001a\u00020+H\u0016R\u000e\u0010\u0010\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0015\u0010\u0011\u001a\t\u0018\u00010\u0012\u00a2\u0006\u0002\b\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R \u0010\u0019\u001a\u0014\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u001b0\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001c\u001a\u00020\u001dX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R\u000e\u0010\"\u001a\u00020#X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010$\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030&0%X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010'\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006@"}, d2={"Lcom/jetbrains/php/refactoring/extractClass/PhpExtractMembersToClassDialog;", "Lcom/intellij/refactoring/ui/RefactoringDialog;", "initialMember", "Lcom/jetbrains/php/lang/psi/elements/PhpClassMember;", "memberInfos", "", "Lcom/jetbrains/php/refactoring/PhpMemberInfo;", "<init>", "(Lcom/jetbrains/php/lang/psi/elements/PhpClassMember;Ljava/util/List;)V", "invokedExplicitly", "", "(Ljava/util/List;Z)V", "myClassName", "", "function", "(Ljava/lang/String;Lcom/jetbrains/php/lang/psi/elements/PhpClassMember;Ljava/util/List;)V", "mySelectedMember", "myContainingClass", "Lcom/jetbrains/php/lang/psi/elements/PhpClass;", "Lorg/jetbrains/annotations/Nullable;", "myMemberInfos", "myClassNameToTextField", "Lcom/intellij/ui/components/JBTextField;", "myPsrNamespacePanel", "Lcom/jetbrains/php/roots/ui/PhpPsrNamespacePanel;", "mySelectedMembersPanel", "Lcom/intellij/refactoring/ui/MemberSelectionPanelBase;", "Lcom/jetbrains/php/refactoring/ui/PhpMemberSelectionTable;", "myGenerateAccessors", "Ljavax/swing/JCheckBox;", "getMyGenerateAccessors", "()Ljavax/swing/JCheckBox;", "setMyGenerateAccessors", "(Ljavax/swing/JCheckBox;)V", "myExtractClassPreview", "Lcom/jetbrains/php/refactoring/extractClass/ui/PhpClassSignaturePreview;", "myStatisticsData", "", "Lcom/intellij/internal/statistic/eventLog/events/EventPair;", "myInvokedExplicitly", "getPreferredFocusedComponent", "Ljavax/swing/JComponent;", "updateSignaturePreview", "", "doAction", "getMembersPreviewString", "memberDeclarationText", "memberInfo", "fieldType", "phpClassMember", "Lcom/jetbrains/php/lang/psi/elements/Field;", "returnType", "Lcom/jetbrains/php/lang/psi/elements/Method;", "createCenterPanel", "getSelectedMemberInfos", "showErrorMessage", "message", "doValidate", "Lcom/intellij/openapi/ui/ValidationInfo;", "postponeValidation", "getHelpId", "findValidationError", "doRefactorAction", "doCancelAction", "intellij.php.impl"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nPhpExtractMembersToClassDialog.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PhpExtractMembersToClassDialog.kt\ncom/jetbrains/php/refactoring/extractClass/PhpExtractMembersToClassDialog\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,240:1\n774#2:241\n865#2,2:242\n774#2:244\n865#2,2:245\n*S KotlinDebug\n*F\n+ 1 PhpExtractMembersToClassDialog.kt\ncom/jetbrains/php/refactoring/extractClass/PhpExtractMembersToClassDialog\n*L\n72#1:241\n72#1:242,2\n186#1:244\n186#1:245,2\n*E\n"})
public final class PhpExtractMembersToClassDialog
extends RefactoringDialog {
    @NotNull
    private final PhpClassMember mySelectedMember;
    @Nullable
    private final PhpClass myContainingClass;
    @NotNull
    private List<? extends PhpMemberInfo> myMemberInfos;
    @NotNull
    private final JBTextField myClassNameToTextField;
    @NotNull
    private PhpPsrNamespacePanel myPsrNamespacePanel;
    @NotNull
    private MemberSelectionPanelBase<PhpClassMember, PhpMemberInfo, PhpMemberSelectionTable> mySelectedMembersPanel;
    public JCheckBox myGenerateAccessors;
    @NotNull
    private PhpClassSignaturePreview myExtractClassPreview;
    @NotNull
    private final List<EventPair<?>> myStatisticsData;
    private boolean myInvokedExplicitly;

    /*
     * WARNING - void declaration
     */
    public PhpExtractMembersToClassDialog(@NotNull PhpClassMember initialMember, @NotNull List<? extends PhpMemberInfo> memberInfos) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        Intrinsics.checkNotNullParameter((Object)initialMember, (String)"initialMember");
        Intrinsics.checkNotNullParameter(memberInfos, (String)"memberInfos");
        super(initialMember.getProject(), false);
        this.mySelectedMember = initialMember;
        this.myContainingClass = initialMember.getContainingClass();
        this.myClassNameToTextField = new JBTextField();
        Project project = this.mySelectedMember.getProject();
        Object object = this.myContainingClass;
        if (object == null || (object = object.getNamespaceName()) == null) {
            object = "";
        }
        this.myPsrNamespacePanel = new PhpPsrNamespacePanel(project, (String)object, (PsiFileSystemItem)this.mySelectedMember.getContainingFile(), JBUI.insets((int)2));
        this.myExtractClassPreview = new PhpClassSignaturePreview("", this.getProject(), (FileType)PhpFileType.INSTANCE);
        this.myInvokedExplicitly = true;
        Disposer.register((Disposable)this.getDisposable(), (Disposable)this.myPsrNamespacePanel);
        this.myMemberInfos = memberInfos;
        Object[] objectArray = new EventPair[2];
        objectArray[0] = PhpExtractClassDialogOptionsLogger.NUMBER_OF_MEMBERS.with((Object)this.myMemberInfos.size());
        Iterable iterable = this.myMemberInfos;
        EventField<Integer> eventField = PhpExtractClassDialogOptionsLogger.NUMBER_OF_PRESELECTED_MEMBERS;
        int n = 1;
        Object[] objectArray2 = objectArray;
        PhpExtractMembersToClassDialog phpExtractMembersToClassDialog = this;
        boolean $i$f$filter = false;
        void var6_10 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            PhpMemberInfo e = (PhpMemberInfo)element$iv$iv;
            boolean bl = false;
            if (!e.isChecked()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List list = (List)destination$iv$iv;
        objectArray2[n] = eventField.with((Object)list.size());
        phpExtractMembersToClassDialog.myStatisticsData = CollectionsKt.mutableListOf((Object[])objectArray);
        PhpMemberSelectionTable table = new PhpMemberSelectionTable(memberInfos, null);
        table.setMemberInfoModel((MemberInfoModel)new PhpMemberModelInfo((MemberInfoModel<PhpClassMember, PhpMemberInfo>)table.getMemberInfoModel(), initialMember.getContainingClass(), this));
        this.mySelectedMembersPanel = new MemberSelectionPanelBase(PhpBundle.message("refactoring.extract.class.dialog.members.to.be.extracted", new Object[0]), (AbstractMemberSelectionTable)table);
        this.mySelectedMembersPanel.setMinimumSize(new Dimension(-1, 200));
        this.myExtractClassPreview.setMinimumSize(new Dimension(-1, 130));
        this.setTitle(PhpBundle.message("refactoring.extract.class.extract.to.class", new Object[0]));
        this.init();
        this.myClassNameToTextField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.updateSignaturePreview();
            }
        });
        ((PhpMemberSelectionTable)this.mySelectedMembersPanel.getTable()).addMemberInfoChangeListener(arg_0 -> PhpExtractMembersToClassDialog._init_$lambda$1(this, arg_0));
        this.updateSignaturePreview();
    }

    @NotNull
    public final JCheckBox getMyGenerateAccessors() {
        JCheckBox jCheckBox = this.myGenerateAccessors;
        if (jCheckBox != null) {
            return jCheckBox;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"myGenerateAccessors");
        return null;
    }

    public final void setMyGenerateAccessors(@NotNull JCheckBox jCheckBox) {
        Intrinsics.checkNotNullParameter((Object)jCheckBox, (String)"<set-?>");
        this.myGenerateAccessors = jCheckBox;
    }

    public PhpExtractMembersToClassDialog(@NotNull List<? extends PhpMemberInfo> memberInfos, boolean invokedExplicitly) {
        Intrinsics.checkNotNullParameter(memberInfos, (String)"memberInfos");
        PsiElement psiElement = memberInfos.get(0).getMember();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getMember(...)");
        this((PhpClassMember)psiElement, memberInfos);
        this.myInvokedExplicitly = invokedExplicitly;
    }

    public PhpExtractMembersToClassDialog(@NotNull String myClassName, @NotNull PhpClassMember function, @NotNull List<? extends PhpMemberInfo> memberInfos) {
        Intrinsics.checkNotNullParameter((Object)myClassName, (String)"myClassName");
        Intrinsics.checkNotNullParameter((Object)function, (String)"function");
        Intrinsics.checkNotNullParameter(memberInfos, (String)"memberInfos");
        this(function, memberInfos);
        this.myClassNameToTextField.setText(myClassName);
    }

    @NotNull
    public JComponent getPreferredFocusedComponent() {
        return (JComponent)this.myClassNameToTextField;
    }

    private final void updateSignaturePreview() {
        this.myExtractClassPreview.setSignature("class " + this.myClassNameToTextField.getText() + "{\n" + this.getMembersPreviewString() + "\n}");
    }

    protected void doAction() {
        ValidationInfo error = this.findValidationError();
        if (error != null) {
            CommonRefactoringUtil.showErrorMessage((String)this.getTitle(), (String)error.message, (String)this.getHelpId(), (Project)this.myProject);
            return;
        }
        try {
            Project project = this.mySelectedMember.getProject();
            PhpClass phpClass = this.myContainingClass;
            Intrinsics.checkNotNull((Object)phpClass);
            this.invokeRefactoring(new PhpExtractMembersToClassProcessor(project, phpClass, this.getSelectedMemberInfos(), this.myClassNameToTextField.getText(), this.myPsrNamespacePanel.getNamespaceName(), PhpFileCreationInfo.generateConfiguration(this.myProject, this.myPsrNamespacePanel.getSelectedDirectory(), this.myClassNameToTextField.getText() + ".php"), this.getMyGenerateAccessors().isSelected()));
        }
        catch (PhpFilePathValidationException e) {
            String string = e.getMessage();
            Intrinsics.checkNotNull((Object)string);
            this.showErrorMessage(string);
        }
    }

    private final String getMembersPreviewString() {
        Object previewString = "";
        for (PhpMemberInfo memberInfo : this.getSelectedMemberInfos()) {
            previewString = (String)previewString + "\t" + this.memberDeclarationText(memberInfo);
            if (!(memberInfo.getMember() instanceof Field)) continue;
            previewString = (String)previewString + "\n";
        }
        return previewString;
    }

    private final String memberDeclarationText(PhpMemberInfo memberInfo) {
        PhpClassMember phpClassMember = (PhpClassMember)memberInfo.getMember();
        Object memberDeclarationText = "";
        if (phpClassMember instanceof Method) {
            ParameterList childByCondition = (ParameterList)PhpPsiUtil.getChildByCondition((PsiElement)phpClassMember, (Condition<? super PsiElement>)ParameterList.INSTANCEOF);
            ParameterList parameterList = childByCondition;
            memberDeclarationText = "public function " + ((Method)phpClassMember).getName() + "(" + (parameterList != null ? parameterList.getText() : null) + ")" + this.returnType((Method)phpClassMember) + " {}\n";
        } else if (phpClassMember instanceof Field) {
            memberDeclarationText = "public " + this.fieldType((Field)phpClassMember) + ((Field)phpClassMember).getText() + ";";
        }
        return memberDeclarationText;
    }

    private final String fieldType(Field phpClassMember) {
        PhpTypeDeclaration typeDeclaration;
        PhpTypeDeclaration phpTypeDeclaration = typeDeclaration = phpClassMember.getTypeDeclaration();
        return phpTypeDeclaration != null ? phpTypeDeclaration.getText() + " " : "";
    }

    private final String returnType(Method phpClassMember) {
        PhpReturnType typeDeclaration;
        PhpReturnType phpReturnType = typeDeclaration = (PhpReturnType)phpClassMember.getTypeDeclaration();
        return phpReturnType != null ? ":" + phpReturnType.getText() : "";
    }

    @NotNull
    protected JComponent createCenterPanel() {
        return (JComponent)BuilderKt.panel(arg_0 -> PhpExtractMembersToClassDialog.createCenterPanel$lambda$0(this, arg_0));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<PhpMemberInfo> getSelectedMemberInfos() {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = this.myMemberInfos;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            PhpMemberInfo it = (PhpMemberInfo)element$iv$iv;
            boolean bl = false;
            if (!it.isChecked()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final void showErrorMessage(@NlsContexts.DialogMessage String message) {
        CommonRefactoringUtil.showErrorMessage((String)this.getTitle(), (String)message, (String)this.getHelpId(), (Project)this.myProject);
    }

    @Nullable
    public ValidationInfo doValidate() {
        return this.findValidationError();
    }

    protected boolean postponeValidation() {
        return false;
    }

    @NotNull
    protected String getHelpId() {
        return "refactorj.extractClass";
    }

    private final ValidationInfo findValidationError() {
        String string = this.myPsrNamespacePanel.getNamespaceName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getNamespaceName(...)");
        String namespaceName = string;
        String string2 = this.myClassNameToTextField.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getText(...)");
        String className = string2;
        if (!PhpNameUtil.isValidClassName(className)) {
            Object[] objectArray = new Object[]{className};
            return new ValidationInfo(PhpBundle.message("validation.class.not.valid.name", objectArray), (JComponent)this.myClassNameToTextField);
        }
        if (StringUtil.isNotEmpty((String)namespaceName) && !PhpNameUtil.isValidNamespaceFullName(namespaceName, PhpLanguageLevel.current((Project)this.getProject()))) {
            Object[] objectArray = new Object[]{namespaceName};
            return new ValidationInfo(PhpBundle.message("refactoring.common.validation.namespace.name", objectArray), (JComponent)((Object)this.myPsrNamespacePanel.getNamespaceField()));
        }
        PhpClass phpClass = this.myContainingClass;
        Intrinsics.checkNotNull((Object)phpClass);
        if (phpClass.findFieldByName((CharSequence)className, false) != null) {
            Object[] objectArray = new Object[]{className};
            return new ValidationInfo(PhpBundle.message("refactoring.validation.class.error.property.with.name.0.is.already.exists", objectArray), (JComponent)this.myClassNameToTextField);
        }
        return null;
    }

    protected void doRefactorAction() {
        this.myStatisticsData.add(PhpExtractClassDialogOptionsLogger.INVOKED_EXPLICITLY.with((Object)this.myInvokedExplicitly));
        this.myStatisticsData.add(PhpExtractClassDialogOptionsLogger.NUMBER_OF_SELECTED_MEMBERS.with((Object)this.getSelectedMemberInfos().size()));
        this.myStatisticsData.add(PhpExtractClassDialogOptionsLogger.GENERATE_ACCESSORS.with((Object)this.getMyGenerateAccessors().isSelected()));
        this.myStatisticsData.add(PhpExtractClassDialogOptionsLogger.REFACTORING_APPLIED.with((Object)true));
        PhpExtractClassDialogOptionsLogger.DIALOG_CLOSED.log(this.myProject, this.myStatisticsData);
        super.doRefactorAction();
    }

    public void doCancelAction() {
        this.myStatisticsData.add(PhpExtractClassDialogOptionsLogger.INVOKED_EXPLICITLY.with((Object)this.myInvokedExplicitly));
        this.myStatisticsData.add(PhpExtractClassDialogOptionsLogger.REFACTORING_APPLIED.with((Object)false));
        PhpExtractClassDialogOptionsLogger.DIALOG_CLOSED.log(this.myProject, this.myStatisticsData);
        super.doCancelAction();
    }

    private static final void _init_$lambda$1(PhpExtractMembersToClassDialog this$0, MemberInfoChange it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.updateSignaturePreview();
    }

    private static final Unit createCenterPanel$lambda$0(PhpExtractMembersToClassDialog this$0, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        Panel.row$default((Panel)$this$panel, null, arg_0 -> PhpExtractMembersToClassDialog.createCenterPanel$lambda$0$0(this$0, arg_0), (int)1, null);
        Panel.row$default((Panel)$this$panel, null, arg_0 -> PhpExtractMembersToClassDialog.createCenterPanel$lambda$0$1(this$0, arg_0), (int)1, null);
        Panel.row$default((Panel)$this$panel, null, arg_0 -> PhpExtractMembersToClassDialog.createCenterPanel$lambda$0$2(this$0, arg_0), (int)1, null).resizableRow();
        Panel.row$default((Panel)$this$panel, null, arg_0 -> PhpExtractMembersToClassDialog.createCenterPanel$lambda$0$3(this$0, arg_0), (int)1, null);
        Panel.row$default((Panel)$this$panel, null, arg_0 -> PhpExtractMembersToClassDialog.createCenterPanel$lambda$0$4(this$0, arg_0), (int)1, null).resizableRow();
        return Unit.INSTANCE;
    }

    private static final Unit createCenterPanel$lambda$0$0(PhpExtractMembersToClassDialog this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.cell((JComponent)this$0.myPsrNamespacePanel).align((Align)AlignX.FILL.INSTANCE);
        return Unit.INSTANCE;
    }

    private static final Unit createCenterPanel$lambda$0$1(PhpExtractMembersToClassDialog this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        Cell cell = $this$row.cell((JComponent)this$0.myClassNameToTextField);
        String string = PhpBundle.message("refactoring.extract.class.dialog.class", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        cell.label(string, LabelPosition.TOP).align((Align)AlignX.FILL.INSTANCE);
        return Unit.INSTANCE;
    }

    private static final Unit createCenterPanel$lambda$0$2(PhpExtractMembersToClassDialog this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.cell((JComponent)this$0.mySelectedMembersPanel).align(Align.FILL);
        return Unit.INSTANCE;
    }

    private static final Unit createCenterPanel$lambda$0$3(PhpExtractMembersToClassDialog this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        String string = PhpBundle.message("refactoring.extract.class.dialog.generate.accessors", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        this$0.setMyGenerateAccessors((JCheckBox)ButtonKt.selected((Cell)$this$row.checkBox(string), (boolean)true).getComponent());
        return Unit.INSTANCE;
    }

    private static final Unit createCenterPanel$lambda$0$4(PhpExtractMembersToClassDialog this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.cell((JComponent)((Object)this$0.myExtractClassPreview)).align(Align.FILL);
        return Unit.INSTANCE;
    }
}

