/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.refactoring.inline;

import com.intellij.lang.LangBundle;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.inline.AbstractInlineLocalDialog;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.refactoring.PhpRefactoringSettings;
import org.jetbrains.annotations.NotNull;

public class PhpInlineVariableDialog
extends AbstractInlineLocalDialog {
    private final Variable myVariable;
    private final int myOccurrencesCount;

    protected PhpInlineVariableDialog(Project project, @NotNull Variable element, int occurrencesCount) {
        if (element == null) {
            PhpInlineVariableDialog.$$$reportNull$$$0(0);
        }
        super(project, (PsiElement)element, (PsiReference)element, occurrencesCount);
        this.myVariable = element;
        this.myOccurrencesCount = occurrencesCount;
        this.myInvokedOnReference = true;
        this.setTitle(PhpInlineVariableDialog.getRefactoringName());
        this.init();
    }

    protected String getNameLabelText() {
        return LangBundle.message((String)"label.local.variable", (Object[])new Object[]{this.myVariable.getName()});
    }

    protected String getBorderTitle() {
        return RefactoringBundle.message((String)"inline.method.border.title");
    }

    protected String getInlineAllText() {
        return RefactoringBundle.message((String)"all.references.and.remove.the.local") + " " + RefactoringBundle.message((String)"occurrences.string", (Object[])new Object[]{this.myOccurrencesCount});
    }

    protected String getInlineThisText() {
        return RefactoringBundle.message((String)"this.reference.only.and.keep.the.variable");
    }

    protected boolean isInlineThis() {
        return PhpRefactoringSettings.getInstance().INLINE_LOCAL_THIS;
    }

    protected String getHelpId() {
        return "refactoring.inlineVariable";
    }

    protected boolean hasPreviewButton() {
        return false;
    }

    protected void doAction() {
        PhpRefactoringSettings settings = PhpRefactoringSettings.getInstance();
        if (this.myRbInlineThisOnly.isEnabled() && this.myRbInlineAll.isEnabled()) {
            settings.INLINE_LOCAL_THIS = this.isInlineThisOnly();
        }
        this.close(0);
    }

    @NlsContexts.DialogTitle
    public static String getRefactoringName() {
        return RefactoringBundle.message((String)"inline.variable.title");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/php/refactoring/inline/PhpInlineVariableDialog", "<init>"));
    }
}

