/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.refactoring.move.clazz;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.php.codeInsight.PhpCodeInsightUtil;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.formatter.PhpFormatterUtil;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpNamespace;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.refactoring.PhpNamespaceBraceConverter;
import com.jetbrains.php.refactoring.move.clazz.PhpMoveClassDeclarationInfo;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PhpMoveClassMultiDeclarationInfo
extends PhpMoveClassDeclarationInfo {
    protected PhpPsiElement myScopeHolder;

    public PhpMoveClassMultiDeclarationInfo(@NotNull PhpClass clazz, @Nullable PhpPsiElement scopeHolder) {
        if (clazz == null) {
            PhpMoveClassMultiDeclarationInfo.$$$reportNull$$$0(0);
        }
        super((PsiElement)clazz, clazz.getFQN());
        this.myScopeHolder = scopeHolder;
    }

    @Override
    protected PsiElement moveClass(@NotNull Project project, @NotNull String namespaceName, @NotNull PhpClass clazz) {
        if (project == null) {
            PhpMoveClassMultiDeclarationInfo.$$$reportNull$$$0(1);
        }
        if (namespaceName == null) {
            PhpMoveClassMultiDeclarationInfo.$$$reportNull$$$0(2);
        }
        if (clazz == null) {
            PhpMoveClassMultiDeclarationInfo.$$$reportNull$$$0(3);
        }
        PsiFile file = clazz.getContainingFile();
        Document document = PsiDocumentManager.getInstance((Project)project).getDocument(file);
        if (document == null) {
            return null;
        }
        boolean braceNamespace = PhpMoveClassMultiDeclarationInfo.shouldBracedNamespaces(file, namespaceName) || "\\".equals(clazz.getNamespaceName());
        String namespace = PhpMoveClassMultiDeclarationInfo.createNamespaceContent(namespaceName, clazz, braceNamespace, true);
        PsiElement parent = PsiTreeUtil.getStubOrPsiParent((PsiElement)clazz);
        assert (parent != null);
        PhpMoveClassMultiDeclarationInfo.deleteClassWithPhpDoc(clazz);
        PsiDocumentManager.getInstance((Project)project).doPostponedOperationsAndUnblockDocument(document);
        int offset = this.updateNamespaceContent(project, document, parent, braceNamespace);
        if (offset > 0) {
            document.insertString(offset, (CharSequence)namespace);
            PsiDocumentManager.getInstance((Project)project).commitDocument(document);
            CodeStyleManager.getInstance((Project)project).reformatText(file, offset, offset + namespace.length());
            PsiDocumentManager.getInstance((Project)project).commitDocument(document);
            return PhpMoveClassMultiDeclarationInfo.getNamespaceByFqn(file, namespaceName);
        }
        return null;
    }

    protected static boolean shouldBracedNamespaces(@NotNull PsiFile file, @NotNull String newNamespaceName) {
        if (file == null) {
            PhpMoveClassMultiDeclarationInfo.$$$reportNull$$$0(4);
        }
        if (newNamespaceName == null) {
            PhpMoveClassMultiDeclarationInfo.$$$reportNull$$$0(5);
        }
        if (PhpLangUtil.isGlobalNamespaceName(newNamespaceName)) {
            return true;
        }
        List<PhpNamespace> namespaces = PhpCodeInsightUtil.collectNamespaces(file);
        for (PhpNamespace namespace : namespaces) {
            if (!namespace.isBraced()) continue;
            return true;
        }
        return false;
    }

    protected abstract int updateNamespaceContent(@NotNull Project var1, @NotNull Document var2, @NotNull PsiElement var3, boolean var4);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namespaceName";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newNamespaceName";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/refactoring/move/clazz/PhpMoveClassMultiDeclarationInfo";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "moveClass";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "shouldBracedNamespaces";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class MultiFileScopeHolderUsage
    extends PhpMoveClassMultiDeclarationInfo {
        public MultiFileScopeHolderUsage(@NotNull PhpClass element, @Nullable PhpPsiElement scopeHolder) {
            if (element == null) {
                MultiFileScopeHolderUsage.$$$reportNull$$$0(0);
            }
            super(element, scopeHolder);
        }

        @Override
        protected int updateNamespaceContent(@NotNull Project project, @NotNull Document document, @NotNull PsiElement parent, boolean shouldBrace) {
            if (project == null) {
                MultiFileScopeHolderUsage.$$$reportNull$$$0(1);
            }
            if (document == null) {
                MultiFileScopeHolderUsage.$$$reportNull$$$0(2);
            }
            if (parent == null) {
                MultiFileScopeHolderUsage.$$$reportNull$$$0(3);
            }
            PsiFile file = parent.getContainingFile();
            PsiElement firstChild = MultiFileScopeHolderUsage.getFirstElementInFile(parent, (PhpClass)this.getElement());
            assert (firstChild != null);
            int startOffset = firstChild.getTextRange().getStartOffset();
            String declaration = "namespace {\n\n";
            PsiElement lastElement = MultiFileScopeHolderUsage.getLastElementInFile(parent);
            int endOffset = lastElement == null ? document.getTextLength() : "namespace {\n\n".length() + lastElement.getTextRange().getEndOffset();
            document.insertString(startOffset, (CharSequence)"namespace {\n\n");
            document.insertString(endOffset, (CharSequence)"\n}");
            MultiFileScopeHolderUsage.commitAndReformat(project, file, document);
            return startOffset;
        }

        @Nullable
        private static PsiElement getLastElementInFile(@NotNull PsiElement groupStatement) {
            if (groupStatement == null) {
                MultiFileScopeHolderUsage.$$$reportNull$$$0(4);
            }
            PsiElement child = groupStatement.getLastChild();
            while (child instanceof PsiWhiteSpace || PhpPsiUtil.isOfType(child, PhpTokenTypes.PHP_CLOSING_TAG)) {
                child = child.getPrevSibling();
            }
            return child;
        }

        @Nullable
        private static PsiElement getFirstElementInFile(@NotNull PsiElement oldGroupStatement, @Nullable PhpClass phpClass) {
            PsiElement child;
            if (oldGroupStatement == null) {
                MultiFileScopeHolderUsage.$$$reportNull$$$0(5);
            }
            for (child = oldGroupStatement.getFirstChild(); child != null && (child instanceof PsiWhiteSpace || PhpTokenTypes.tsPHP_OPENING_TAGS.contains(child.getNode().getElementType()) || !PhpMoveClassDeclarationInfo.canInsertNamespaceBefore(child, phpClass)); child = child.getNextSibling()) {
            }
            return child;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "document";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parent";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "groupStatement";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "oldGroupStatement";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/php/refactoring/move/clazz/PhpMoveClassMultiDeclarationInfo$MultiFileScopeHolderUsage";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "updateNamespaceContent";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getLastElementInFile";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getFirstElementInFile";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class MultiNamespaceScopeHolderUsage
    extends PhpMoveClassMultiDeclarationInfo {
        public MultiNamespaceScopeHolderUsage(@NotNull PhpClass clazz, @Nullable PhpNamespace scopeHolder) {
            if (clazz == null) {
                MultiNamespaceScopeHolderUsage.$$$reportNull$$$0(0);
            }
            super(clazz, (PhpPsiElement)scopeHolder);
        }

        @Override
        protected int updateNamespaceContent(@NotNull Project project, @NotNull Document document, @NotNull PsiElement parent, boolean braceNamespaces) {
            if (project == null) {
                MultiNamespaceScopeHolderUsage.$$$reportNull$$$0(1);
            }
            if (document == null) {
                MultiNamespaceScopeHolderUsage.$$$reportNull$$$0(2);
            }
            if (parent == null) {
                MultiNamespaceScopeHolderUsage.$$$reportNull$$$0(3);
            }
            assert (this.myScopeHolder instanceof PhpNamespace);
            PhpNamespace namespace = (PhpNamespace)this.myScopeHolder;
            if (namespace.isBraced() || !braceNamespaces) {
                return MultiNamespaceScopeHolderUsage.getOffset(namespace);
            }
            String namespaceName = namespace.getFQN();
            PsiFile file = this.myScopeHolder.getContainingFile();
            PhpNamespaceBraceConverter.braceAllInFile(project, document, file);
            PhpNamespace namespaceByFqn = MultiNamespaceScopeHolderUsage.getNamespaceByFqn(file, namespaceName);
            return namespaceByFqn == null ? -1 : MultiNamespaceScopeHolderUsage.getOffset(namespaceByFqn);
        }

        private static int getOffset(@NotNull PhpNamespace namespace) {
            if (namespace == null) {
                MultiNamespaceScopeHolderUsage.$$$reportNull$$$0(4);
            }
            int offset = namespace.getTextRange().getStartOffset();
            PsiElement prevSibling = PhpPsiUtil.getPrevSiblingIgnoreWhitespace((PsiElement)namespace, true);
            if (prevSibling instanceof PsiComment && !PhpFormatterUtil.isFileHeader((PsiElement)prevSibling)) {
                offset = Math.min(offset, prevSibling.getTextRange().getStartOffset());
            }
            return offset;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "clazz";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "document";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parent";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "namespace";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/php/refactoring/move/clazz/PhpMoveClassMultiDeclarationInfo$MultiNamespaceScopeHolderUsage";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "updateNamespaceContent";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getOffset";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

