/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.refactoring.move.member.instance;

import com.intellij.lang.Language;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.refactoring.move.MoveHandlerDelegate;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.PhpLanguage;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.refactoring.move.member.instance.PhpMoveInstanceMethodHandler;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpMoveInstanceMethodHandlerDelegate
extends MoveHandlerDelegate {
    public boolean canMove(PsiElement[] elements, @Nullable PsiElement targetContainer, @Nullable PsiReference reference) {
        if (elements.length != 1) {
            return false;
        }
        PsiElement element = elements[0];
        return PhpMoveInstanceMethodHandlerDelegate.isSuitableMethod(element);
    }

    private static boolean isSuitableMethod(PsiElement method) {
        return method instanceof Method && !((Method)method).isStatic();
    }

    public boolean isValidTarget(PsiElement targetElement, PsiElement[] sources) {
        return targetElement instanceof PhpClass && !((PhpClass)targetElement).isAnonymous();
    }

    public boolean tryToMove(PsiElement element, Project project, DataContext dataContext, PsiReference reference, Editor editor) {
        if (PhpMoveInstanceMethodHandlerDelegate.isSuitableMethod(element)) {
            new PhpMoveInstanceMethodHandler().invoke(project, new PsiElement[]{element}, dataContext);
            return true;
        }
        return false;
    }

    @Nls(capitalization=Nls.Capitalization.Title)
    @Nullable
    public String getActionName(PsiElement @NotNull [] elements) {
        if (elements == null) {
            PhpMoveInstanceMethodHandlerDelegate.$$$reportNull$$$0(0);
        }
        return PhpBundle.message("refactoring.move.instance.method.action.name", new Object[0]);
    }

    public boolean supportsLanguage(@NotNull Language language) {
        if (language == null) {
            PhpMoveInstanceMethodHandlerDelegate.$$$reportNull$$$0(1);
        }
        return language == PhpLanguage.INSTANCE;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/refactoring/move/member/instance/PhpMoveInstanceMethodHandlerDelegate";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getActionName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "supportsLanguage";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

