/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.refactoring.move.namespace;

import com.intellij.DynamicBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.ui.EnableDisableAction;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.ui.BooleanTableCellRenderer;
import com.intellij.ui.GuiUtils;
import com.intellij.ui.TableUtil;
import com.intellij.ui.components.JBBox;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.table.JBTable;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.usageView.UsageInfo;
import com.intellij.usages.UsageViewPresentation;
import com.intellij.usages.impl.UsagePreviewPanel;
import com.intellij.util.PathUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.psi.elements.PhpNamespace;
import com.jetbrains.php.refactoring.PhpFileCreationInfo;
import com.jetbrains.php.refactoring.move.namespace.PhpMoveNamespaceData;
import com.jetbrains.php.refactoring.validation.PhpFilePathValidationException;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.jetbrains.annotations.NotNull;

public final class PhpMoveRelatedNamespacesDialog
extends DialogWrapper {
    private static final Logger LOG = Logger.getInstance(PhpMoveRelatedNamespacesDialog.class);
    private static final String DIMENSION_KEY = "#com.jetbrains.php.refactoring.move.namespace.PhpMoveRelatedNamespacesDialog";
    private static final int CHECK_COLUMN = 0;
    private static final int NAMESPACE_NAME_COLUMN = 1;
    private static final int DIRECTORY_COLUMN = 2;
    private final Project myProject;
    private final List<? extends PhpMoveNamespaceData> myNamespacesToMove;
    private Map<String, PhpFileCreationInfo> myPathMapper;
    private final UsagePreviewPanel myUsagePreviewPanel;
    private final JLabel myUsageFileLabel;
    private boolean[] myShouldRename;
    private String[] myNewRelativeDirectories;
    private final MyTableModel myTableModel;
    private JBTable myTable;
    private JPanel myPanelForPreview;
    private JButton mySelectAllButton;
    private JButton myUnselectAllButton;
    private JPanel myPanel;
    private JSplitPane mySplitPane;
    private ListSelectionListener myListSelectionListener;

    public PhpMoveRelatedNamespacesDialog(@NotNull Project project, @NotNull List<? extends PhpMoveNamespaceData> namespacesToMove) {
        if (project == null) {
            PhpMoveRelatedNamespacesDialog.$$$reportNull$$$0(0);
        }
        if (namespacesToMove == null) {
            PhpMoveRelatedNamespacesDialog.$$$reportNull$$$0(1);
        }
        super(project, true);
        this.myNamespacesToMove = namespacesToMove;
        this.myProject = project;
        this.$$$setupUI$$$();
        this.myUsagePreviewPanel = new UsagePreviewPanel(this.myProject, new UsageViewPresentation());
        this.myUsageFileLabel = new JLabel();
        this.populateData();
        this.myTableModel = new MyTableModel();
        this.setTitle(PhpBundle.message("refactoring.move.related.namespace.title", new Object[0]));
        this.init();
    }

    public Map<String, PhpFileCreationInfo> getFileMoveData() {
        return this.myPathMapper;
    }

    private void populateData() {
        String basePath = this.myProject.getBasePath();
        this.myNewRelativeDirectories = new String[this.myNamespacesToMove.size()];
        for (int i = 0; i < this.myNewRelativeDirectories.length; ++i) {
            String absolutePath = this.myNamespacesToMove.get(i).getNewDirectory();
            String relativePath = FileUtil.getRelativePath((String)basePath, (String)absolutePath, (char)'/');
            assert (relativePath != null) : "Can not evaluate relative path, base dir: " + basePath + ", absolute path: " + absolutePath;
            this.myNewRelativeDirectories[i] = FileUtil.toSystemDependentName((String)relativePath);
        }
        this.myShouldRename = new boolean[this.myNamespacesToMove.size()];
        Arrays.fill(this.myShouldRename, true);
    }

    protected String getDimensionServiceKey() {
        return DIMENSION_KEY;
    }

    protected JComponent createNorthPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)new JLabel(PhpBundle.message("refactoring.move.related.namespace.description", new Object[0])), "Center");
        JBBox box = JBBox.createHorizontalBox();
        box.add((Component)panel);
        box.add(Box.createHorizontalGlue());
        return box;
    }

    public void show() {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        super.show();
    }

    private void handleChanges() {
        int selectedRow = this.myTable.getSelectedRow();
        if (selectedRow > -1) {
            boolean isValid = PhpMoveRelatedNamespacesDialog.validatePath(PhpMoveRelatedNamespacesDialog.prepareRelativePath(this.myNewRelativeDirectories[selectedRow]));
            this.getOKAction().setEnabled(isValid);
            this.setErrorText(isValid ? null : PhpBundle.message("path.0.is.invalid", this.myNewRelativeDirectories[selectedRow]), (JComponent)this.myTable);
        }
    }

    private static boolean validatePath(@NotNull String relativePath) {
        if (relativePath == null) {
            PhpMoveRelatedNamespacesDialog.$$$reportNull$$$0(2);
        }
        List split = StringUtil.split((String)relativePath, (String)"/");
        for (String path : split) {
            if (PathUtil.isValidFileName((String)path)) continue;
            return false;
        }
        return true;
    }

    protected JComponent createCenterPanel() {
        this.myTable.setModel((TableModel)this.myTableModel);
        this.myTableModel.getSpaceAction().register();
        this.myTableModel.addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                PhpMoveRelatedNamespacesDialog.this.handleChanges();
            }
        });
        this.setCustomColumnsSize();
        this.mySelectAllButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Arrays.fill(PhpMoveRelatedNamespacesDialog.this.myShouldRename, true);
                PhpMoveRelatedNamespacesDialog.this.fireDataChanged();
            }
        });
        this.myUnselectAllButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Arrays.fill(PhpMoveRelatedNamespacesDialog.this.myShouldRename, false);
                PhpMoveRelatedNamespacesDialog.this.fireDataChanged();
            }
        });
        this.myListSelectionListener = new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                PhpMoveRelatedNamespacesDialog.this.myUsageFileLabel.setText("");
                int index = PhpMoveRelatedNamespacesDialog.this.myTable.getSelectionModel().getLeadSelectionIndex();
                if (index != -1) {
                    VirtualFile virtualFile;
                    PhpNamespace element = PhpMoveRelatedNamespacesDialog.this.myNamespacesToMove.get(index).getNamespace();
                    UsageInfo usageInfo = new UsageInfo((PsiElement)element);
                    PhpMoveRelatedNamespacesDialog.this.myUsagePreviewPanel.updateLayout(PhpMoveRelatedNamespacesDialog.this.myProject, Collections.singletonList(usageInfo));
                    PsiFile containingFile = element.getContainingFile();
                    if (containingFile != null && (virtualFile = containingFile.getVirtualFile()) != null) {
                        PhpMoveRelatedNamespacesDialog.this.myUsageFileLabel.setText(virtualFile.getName());
                    }
                } else {
                    PhpMoveRelatedNamespacesDialog.this.myUsagePreviewPanel.updateLayout(PhpMoveRelatedNamespacesDialog.this.myProject, null);
                }
            }
        };
        this.myTable.getSelectionModel().addListSelectionListener(this.myListSelectionListener);
        this.myPanelForPreview.add((Component)this.myUsagePreviewPanel, "Center");
        this.myUsagePreviewPanel.updateLayout(this.myProject, null);
        this.myPanelForPreview.add((Component)this.myUsageFileLabel, "North");
        this.mySplitPane.setDividerLocation(0.5);
        GuiUtils.replaceJSplitPaneWithIDEASplitter((JComponent)this.myPanel);
        if (this.myTableModel.getRowCount() != 0) {
            this.myTable.getSelectionModel().addSelectionInterval(0, 0);
        }
        return this.myPanel;
    }

    private void setCustomColumnsSize() {
        TableColumnModel columnModel = this.myTable.getColumnModel();
        TableColumn checkBoxColumn = columnModel.getColumn(0);
        TableUtil.setupCheckboxColumn((TableColumn)checkBoxColumn);
        checkBoxColumn.setCellRenderer((TableCellRenderer)new BooleanTableCellRenderer());
        int tableWidth = 60 * this.getTableFontMetrics().charWidth('A');
        int namespaceWidth = tableWidth / 3;
        columnModel.getColumn(1).setPreferredWidth(namespaceWidth);
        columnModel.getColumn(2).setPreferredWidth(tableWidth - namespaceWidth - checkBoxColumn.getMaxWidth());
    }

    private void fireDataChanged() {
        int[] selectedRows = this.myTable.getSelectedRows();
        this.myTable.getSelectionModel().removeListSelectionListener(this.myListSelectionListener);
        this.myTableModel.fireTableDataChanged();
        for (int selectedRow : selectedRows) {
            this.myTable.addRowSelectionInterval(selectedRow, selectedRow);
        }
        this.myTable.getSelectionModel().addListSelectionListener(this.myListSelectionListener);
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myTable;
    }

    protected void doOKAction() {
        TableUtil.stopEditing((JTable)this.myTable);
        String message = this.fillPathMappings();
        if (message != null) {
            CommonRefactoringUtil.showErrorMessage((String)this.getTitle(), (String)message, (String)this.getHelpId(), (Project)this.myProject);
        }
        super.doOKAction();
    }

    protected void dispose() {
        Disposer.dispose((Disposable)this.myUsagePreviewPanel);
        super.dispose();
    }

    @NlsSafe
    private String fillPathMappings() {
        try {
            this.myPathMapper = new HashMap<String, PhpFileCreationInfo>();
            String basePath = this.myProject.getBasePath();
            for (int i = 0; i < this.myNamespacesToMove.size(); ++i) {
                PhpMoveNamespaceData data;
                PhpNamespace namespace;
                if (!this.myShouldRename[i] || !(namespace = (data = this.myNamespacesToMove.get(i)).getNamespace()).isValid() || !namespace.isPhysical()) continue;
                String newFile = basePath + PhpMoveRelatedNamespacesDialog.prepareRelativePath(this.myNewRelativeDirectories[i]);
                VirtualFile virtualFile = namespace.getContainingFile().getVirtualFile();
                if (FileUtil.namesEqual((String)virtualFile.getParent().getPath(), (String)newFile)) continue;
                PhpFileCreationInfo newFileConfiguration = PhpFileCreationInfo.generateConfiguration(this.myProject, newFile, virtualFile.getName());
                this.myPathMapper.put(virtualFile.getPath(), newFileConfiguration);
            }
        }
        catch (PhpFilePathValidationException e) {
            return e.getMessage();
        }
        return null;
    }

    private static String prepareRelativePath(@NotNull String dependentPath) {
        if (dependentPath == null) {
            PhpMoveRelatedNamespacesDialog.$$$reportNull$$$0(3);
        }
        String independent = FileUtil.toSystemIndependentName((String)dependentPath);
        List split = StringUtil.split((String)independent, (String)"/");
        StringBuilder newPath = new StringBuilder();
        for (String path : split) {
            if (StringUtil.equals((CharSequence)path, (CharSequence)".")) continue;
            newPath.append("/");
            newPath.append(path);
        }
        return newPath.toString();
    }

    private void createUIComponents() {
        this.myTable = new JBTable();
        this.myTable.setRowHeight(this.getTableFontMetrics().getHeight() + 4);
    }

    private FontMetrics getTableFontMetrics() {
        return this.myTable.getFontMetrics(UIManager.getFont("Table.font").deriveFont(1));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namespacesToMove";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relativePath";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependentPath";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/refactoring/move/namespace/PhpMoveRelatedNamespacesDialog";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "validatePath";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "prepareRelativePath";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JButton jButton;
        JButton jButton2;
        JPanel jPanel;
        JSplitPane jSplitPane;
        JPanel jPanel2;
        this.createUIComponents();
        this.myPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.mySplitPane = jSplitPane = new JSplitPane();
        jSplitPane.setDividerLocation(300);
        jSplitPane.setOrientation(0);
        jPanel2.add((Component)jSplitPane, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, new Dimension(200, 200), null));
        jSplitPane.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(), null, 0, 0, null, null));
        this.myPanelForPreview = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jSplitPane.setRightComponent(jPanel);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(2, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jSplitPane.setLeftComponent(jPanel3);
        JBScrollPane jBScrollPane = new JBScrollPane();
        jPanel3.add((Component)jBScrollPane, new GridConstraints(0, 0, 1, 3, 0, 1, 7, 3, null, new Dimension(700, -1), null));
        JBTable jBTable = this.myTable;
        jBScrollPane.setViewportView((Component)jBTable);
        this.mySelectAllButton = jButton2 = new JButton();
        this.$$$loadButtonText$$$(jButton2, DynamicBundle.getBundle((String)"messages/RefactoringBundle", PhpMoveRelatedNamespacesDialog.class).getString("select.all.button"));
        jPanel3.add((Component)jButton2, new GridConstraints(1, 1, 1, 1, 0, 1, 3, 0, null, null, null));
        this.myUnselectAllButton = jButton = new JButton();
        this.$$$loadButtonText$$$(jButton, DynamicBundle.getBundle((String)"messages/RefactoringBundle", PhpMoveRelatedNamespacesDialog.class).getString("unselect.all.button"));
        jPanel3.add((Component)jButton, new GridConstraints(1, 2, 1, 1, 0, 1, 3, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel3.add((Component)spacer, new GridConstraints(1, 0, 1, 1, 0, 1, 6, 1, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    private final class MyTableModel
    extends AbstractTableModel {
        private MyTableModel() {
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public int getRowCount() {
            return PhpMoveRelatedNamespacesDialog.this.myShouldRename.length;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            return switch (columnIndex) {
                case 0 -> PhpMoveRelatedNamespacesDialog.this.myShouldRename[rowIndex];
                case 1 -> {
                    String newName = PhpLangUtil.toName(PhpMoveRelatedNamespacesDialog.this.myNamespacesToMove.get(rowIndex).getNewNamespaceName());
                    yield "<html><nobr>" + CommonRefactoringUtil.htmlEmphasize((String)newName) + "</nobr></html>";
                }
                case 2 -> PhpMoveRelatedNamespacesDialog.this.myNewRelativeDirectories[rowIndex];
                default -> {
                    LOG.assertTrue(false);
                    yield null;
                }
            };
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    PhpMoveRelatedNamespacesDialog.this.myShouldRename[rowIndex] = (Boolean)aValue;
                    break;
                }
                case 2: {
                    PhpMoveRelatedNamespacesDialog.this.myNewRelativeDirectories[rowIndex] = (String)aValue;
                    break;
                }
                default: {
                    LOG.assertTrue(false);
                }
            }
            PhpMoveRelatedNamespacesDialog.this.handleChanges();
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex != 1;
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return switch (columnIndex) {
                case 0 -> Boolean.class;
                case 1, 2 -> String.class;
                default -> null;
            };
        }

        @Override
        public String getColumnName(int column) {
            return switch (column) {
                case 1 -> PhpBundle.message("refactoring.move.related.namespace.name.column", new Object[0]);
                case 2 -> PhpBundle.message("refactoring.move.related.namespace.directory.column", new Object[0]);
                default -> " ";
            };
        }

        private MyEnableDisable getSpaceAction() {
            return new MyEnableDisable();
        }

        private class MyEnableDisable
        extends EnableDisableAction {
            private MyEnableDisable() {
            }

            protected JTable getTable() {
                return PhpMoveRelatedNamespacesDialog.this.myTable;
            }

            protected boolean isRowChecked(int row) {
                return PhpMoveRelatedNamespacesDialog.this.myShouldRename[row];
            }

            protected void applyValue(int[] rows, boolean valueToBeSet) {
                for (int row : rows) {
                    PhpMoveRelatedNamespacesDialog.this.myShouldRename[row] = valueToBeSet;
                }
                PhpMoveRelatedNamespacesDialog.this.fireDataChanged();
            }
        }
    }
}

