/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.refactoring.pullPush;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.lang.ElementsHandler;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.Field;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PhpPullPushBaseHandler
implements RefactoringActionHandler,
ElementsHandler {
    protected Editor myEditor;

    public void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file, DataContext dataContext) {
        if (project == null) {
            PhpPullPushBaseHandler.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            PhpPullPushBaseHandler.$$$reportNull$$$0(1);
        }
        if (file == null) {
            PhpPullPushBaseHandler.$$$reportNull$$$0(2);
        }
        this.myEditor = editor;
        int offset = editor.getCaretModel().getOffset();
        editor.getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
        Object element = file.findElementAt(offset);
        while (true) {
            if (element == null || element instanceof PsiFile) {
                String refactoringErrorMessage = RefactoringBundle.getCannotRefactorMessage((String)this.getErrorMessageForCaretPosition());
                if (!ApplicationManager.getApplication().isUnitTestMode()) {
                    CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)refactoringErrorMessage, (String)this.getRefactoringName(), (String)this.getHelpId());
                }
                return;
            }
            if (element instanceof PhpClass || element instanceof Field || element instanceof Method) {
                this.invoke(project, new PsiElement[]{element}, dataContext);
                return;
            }
            if (PhpPsiUtil.isOfType(element, new IElementType[]{PhpElementTypes.CLASS_FIELDS, PhpElementTypes.CLASS_CONSTANTS})) {
                element = PhpPsiUtil.getChildByCondition(element, (Condition<? super PsiElement>)Field.INSTANCEOF);
                continue;
            }
            element = element.getParent();
        }
    }

    @Nullable
    protected PhpClass extractClass(@NotNull PsiElement element) {
        if (element == null) {
            PhpPullPushBaseHandler.$$$reportNull$$$0(3);
        }
        if (element instanceof PhpClass) {
            return (PhpClass)element;
        }
        if (element instanceof Method) {
            return ((Method)element).getContainingClass();
        }
        if (element instanceof Field) {
            return ((Field)element).getContainingClass();
        }
        return null;
    }

    public boolean isEnabledOnElements(PsiElement @NotNull [] elements) {
        if (elements == null) {
            PhpPullPushBaseHandler.$$$reportNull$$$0(4);
        }
        return elements.length == 1 && elements[0] instanceof PhpClass;
    }

    protected abstract String getHelpId();

    @NlsContexts.DialogTitle
    protected abstract String getRefactoringName();

    @NlsContexts.DialogMessage
    protected abstract String getErrorMessageForCaretPosition();

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/refactoring/pullPush/PhpPullPushBaseHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "invoke";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "extractClass";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "isEnabledOnElements";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

