/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.refactoring.rename;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.refactoring.rename.RenameHandler;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.intentions.stringDoc.PhpHeredocToStringIntention;
import com.jetbrains.php.lang.intentions.stringDoc.PhpStringToHeredocIntention;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.StringLiteralExpression;
import com.jetbrains.php.refactoring.PhpNameUtil;
import com.jetbrains.php.ui.DialogWrapperWithValidation;
import com.jetbrains.php.ui.SimpleRenameDialog;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpHeredocRenameHandler
implements RenameHandler {
    public boolean isAvailableOnDataContext(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            PhpHeredocRenameHandler.$$$reportNull$$$0(0);
        }
        return PhpHeredocRenameHandler.getTargetElement(dataContext) != null;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file, DataContext dataContext) {
        if (project == null) {
            PhpHeredocRenameHandler.$$$reportNull$$$0(1);
        }
        PsiElement heredocStart = PhpHeredocRenameHandler.getTargetElement(editor, file);
        assert (heredocStart != null);
        @NlsSafe String heredocStartText = heredocStart.getText();
        int index = 3;
        String binStr = "";
        if (heredocStartText.startsWith("b") || heredocStartText.startsWith("B")) {
            binStr = heredocStartText.substring(0, 1);
        }
        String oldName = PhpNameUtil.trim(heredocStartText.substring(index + binStr.length()).trim(), '\'', '\"');
        PsiElement parent = heredocStart.getParent();
        if (parent == null) {
            return;
        }
        boolean isNowDoc = PhpHeredocToStringIntention.isNowdoc(parent);
        String newName = this.getName(project, PhpBundle.message("rename", new Object[0]), heredocStart.getNextSibling(), oldName, !isNowDoc);
        if (newName == null) {
            return;
        }
        if (newName.equals(oldName)) {
            return;
        }
        String newHeredocStartText = StringUtil.replace((String)heredocStartText, (String)oldName, (String)newName);
        String dummyHeredoc = newHeredocStartText + "\nheredoc\n" + PhpStringToHeredocIntention.cutQuotes(newName) + ";\n";
        PsiElement heredocEnd = PhpPsiUtil.getChildOfType(parent, PhpTokenTypes.HEREDOC_END);
        PsiElement newElement = PhpPsiElementFactory.createFromText(project, PhpTokenTypes.HEREDOC_START, dummyHeredoc);
        PsiElement builtHeredoc = PhpPsiElementFactory.createFromText(project, PhpTokenTypes.HEREDOC_END, dummyHeredoc);
        if (builtHeredoc != null && newElement != null) {
            CommandProcessor.getInstance().executeCommand(project, () -> ApplicationManager.getApplication().runWriteAction(() -> {
                heredocStart.replace(newElement);
                if (heredocEnd != null) {
                    heredocEnd.replace(builtHeredoc);
                }
            }), PhpBundle.message("rename", new Object[0]), null);
        }
    }

    public void invoke(@NotNull Project project, PsiElement @NotNull [] elements, DataContext dataContext) {
        if (project == null) {
            PhpHeredocRenameHandler.$$$reportNull$$$0(2);
        }
        if (elements == null) {
            PhpHeredocRenameHandler.$$$reportNull$$$0(3);
        }
    }

    @Nullable
    protected String getName(@NotNull Project project, @NlsContexts.DialogTitle String dialogTitle, PsiElement expression, @NotNull @Nls String oldName, boolean doubleQuotes) {
        if (project == null) {
            PhpHeredocRenameHandler.$$$reportNull$$$0(4);
        }
        if (oldName == null) {
            PhpHeredocRenameHandler.$$$reportNull$$$0(5);
        }
        return PhpHeredocRenameHandler.getNameFromDialog(project, dialogTitle, expression, oldName, doubleQuotes, false);
    }

    @Nullable
    public static String getNameFromDialog(Project project, @NlsContexts.DialogTitle String dialogTitle, final @Nullable PsiElement expression, @Nullable @Nls String oldName, final boolean doubleQuotesAreAvailable, final boolean isString) {
        SimpleRenameDialog dialog = new SimpleRenameDialog(project, dialogTitle, oldName){

            @Override
            public void init() {
                this.scheduleInitialValidation();
                super.init();
            }

            @Override
            @NotNull
            protected DialogWrapperWithValidation.ValidationResult doValidateForm() {
                String name = this.getName();
                if (!PhpNameUtil.isValidHeredocIdentifier(name, doubleQuotesAreAvailable)) {
                    return new DialogWrapperWithValidation.ValidationResult(false, PhpBundle.message("validation.invalid.identifier", name));
                }
                String text = null;
                if (expression != null) {
                    text = expression.getText();
                }
                if (text != null) {
                    if (isString && text.length() > 2) {
                        text = text.substring(1, text.length() - 1);
                    }
                    String nameWithSemicolon = name + ";";
                    String nameWithSemicolonWithLineBreakFirst = "\n" + nameWithSemicolon;
                    String nameWithSemicolonWithLineBreakLast = nameWithSemicolon + "\n";
                    String nameWithSemicolonWithLineBreaks = "\n" + nameWithSemicolon + "\n";
                    String nameWithLineBreakLast = name + "\n";
                    String nameWithLineBreakFirst = "\n" + name;
                    String nameWithLineBreaks = "\n" + name + "\n";
                    if (text.equals(nameWithSemicolon) || text.startsWith(nameWithSemicolonWithLineBreakLast) || text.endsWith(nameWithSemicolonWithLineBreakFirst) || text.contains(nameWithSemicolonWithLineBreaks)) {
                        return new DialogWrapperWithValidation.ValidationResult(false, PhpBundle.message("conflict.tag.name.contains.close.tag", nameWithSemicolon));
                    }
                    if (text.equals(name) || text.startsWith(nameWithLineBreakLast) || text.endsWith(nameWithLineBreakFirst) || text.contains(nameWithLineBreaks)) {
                        return new DialogWrapperWithValidation.ValidationResult(false, PhpBundle.message("conflict.tag.name.contains.close.tag", name));
                    }
                }
                DialogWrapperWithValidation.ValidationResult validationResult = DialogWrapperWithValidation.ValidationResult.VALID;
                if (validationResult == null) {
                    1.$$$reportNull$$$0(0);
                }
                return validationResult;
            }

            @Override
            protected boolean isOKActionEnabledOnInit() {
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/php/refactoring/rename/PhpHeredocRenameHandler$1", "doValidateForm"));
            }
        };
        if (!dialog.showAndGet()) {
            return null;
        }
        return dialog.getName();
    }

    @Nullable
    private static PsiElement getTargetElement(@Nullable DataContext context) {
        PsiFile psiFile;
        if (context == null) {
            return null;
        }
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(context);
        if (editor != null && (psiFile = (PsiFile)CommonDataKeys.PSI_FILE.getData(context)) != null) {
            return PhpHeredocRenameHandler.getTargetElement(editor, psiFile);
        }
        return null;
    }

    @Nullable
    private static PsiElement getTargetElement(@NotNull Editor editor, @NotNull PsiFile psiFile) {
        ASTNode node;
        PsiElement element;
        if (editor == null) {
            PhpHeredocRenameHandler.$$$reportNull$$$0(6);
        }
        if (psiFile == null) {
            PhpHeredocRenameHandler.$$$reportNull$$$0(7);
        }
        if ((element = psiFile.findElementAt(editor.getCaretModel().getOffset())) != null && (node = element.getNode()) != null) {
            PsiElement parent;
            IElementType type = node.getElementType();
            if (PhpTokenTypes.HEREDOC_START.equals(type)) {
                return element;
            }
            if (PhpTokenTypes.HEREDOC_END.equals(type) && (parent = element.getParent()) instanceof StringLiteralExpression) {
                return PhpPsiUtil.getChildOfType(parent, PhpTokenTypes.HEREDOC_START);
            }
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldName";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/refactoring/rename/PhpHeredocRenameHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isAvailableOnDataContext";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "invoke";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "getName";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "getTargetElement";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

