/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.restClient.guzzle;

import com.intellij.psi.ResolveResult;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.MethodReference;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class GuzzleCallMatcher {
    private final String myClassName;
    private final Set<String> myMethodsNames;

    GuzzleCallMatcher(@NotNull String className, String ... methodNames) {
        if (className == null) {
            GuzzleCallMatcher.$$$reportNull$$$0(0);
        }
        this.myMethodsNames = ContainerUtil.newHashSet((Object[])methodNames);
        this.myClassName = className;
    }

    boolean matches(@Nullable MethodReference methodReference) {
        ResolveResult[] results;
        if (methodReference == null) {
            return false;
        }
        String methodName = methodReference.getName();
        if (methodName == null) {
            return false;
        }
        if (!this.myMethodsNames.contains(methodName)) {
            return false;
        }
        for (ResolveResult result : results = methodReference.multiResolve(false)) {
            PhpClass containingClass;
            Method method = (Method)ObjectUtils.tryCast((Object)result.getElement(), Method.class);
            if (method == null || (containingClass = method.getContainingClass()) == null || !this.myClassName.equals(containingClass.getFQN())) continue;
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "className", "com/jetbrains/php/restClient/guzzle/GuzzleCallMatcher", "<init>"));
    }
}

