/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.restClient.guzzle;

import com.intellij.httpClient.execution.RestClientRequest;
import com.intellij.httpClient.execution.auth.HttpClientAuthData;
import com.intellij.httpClient.execution.auth.HttpRequestAuthCredentials;
import com.intellij.httpClient.execution.auth.HttpRequestAuthScope;
import com.intellij.openapi.util.Pair;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.jetbrains.php.restClient.guzzle.GuzzleRequestObligatoryParameters;
import com.jetbrains.php.restClient.guzzle.GuzzleRequestOptions;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class RestClientRequestBuilder {
    private RestClientRequestBuilder() {
    }

    @NotNull
    public static RestClientRequest build(@NotNull GuzzleRequestObligatoryParameters obligatoryParameters, @Nullable GuzzleRequestOptions requestOptions, @Nullable GuzzleRequestOptions clientOptions) {
        String body;
        if (obligatoryParameters == null) {
            RestClientRequestBuilder.$$$reportNull$$$0(0);
        }
        URL url = obligatoryParameters.getUrl();
        String urlBase = RestClientRequestBuilder.getUrlBase(url);
        String path = url.getPath();
        HttpClientAuthData authData = null;
        GuzzleRequestOptions.AuthOptions authOptions = (GuzzleRequestOptions.AuthOptions)RestClientRequestBuilder.mergeOption(requestOptions, clientOptions, GuzzleRequestOptions::getAuthOptions);
        if (authOptions != null) {
            HttpRequestAuthScope authScope = new HttpRequestAuthScope(authOptions.getScheme());
            HttpRequestAuthCredentials.UsernamePassword credentials = new HttpRequestAuthCredentials.UsernamePassword(authOptions.getUser(), authOptions.getPassword());
            authData = new HttpClientAuthData(authScope, (HttpRequestAuthCredentials)credentials);
        }
        List<Pair.NonNull<String, String>> query = RestClientRequestBuilder.parseQueryString(url.getQuery());
        List<Pair.NonNull<String, String>> optionsQuery = RestClientRequestBuilder.mergeQuery(requestOptions, clientOptions);
        if (!optionsQuery.isEmpty()) {
            query = optionsQuery;
        }
        MultiMap headers = MultiMap.createLinked();
        headers.putAllValues(RestClientRequestBuilder.mergeHeaders(requestOptions, clientOptions));
        String optionsJsonBody = (String)RestClientRequestBuilder.mergeOption(requestOptions, clientOptions, GuzzleRequestOptions::getJsonBody);
        if (optionsJsonBody != null) {
            body = optionsJsonBody;
            if (!headers.containsKey((Object)"Content-Type")) {
                headers.put((Object)"Content-Type", Collections.singletonList("application/json"));
            }
        } else {
            body = (String)RestClientRequestBuilder.mergeOption(requestOptions, clientOptions, GuzzleRequestOptions::getBody);
        }
        RestClientRequest request = new RestClientRequest();
        request.httpMethod = obligatoryParameters.getHttpMethod();
        request.urlBase = urlBase;
        request.urlPath = path;
        request.parameters = ContainerUtil.map(query, pair -> new RestClientRequest.KeyValuePair((String)pair.first, (String)pair.second));
        request.parametersEnabled = !query.isEmpty();
        request.authData = authData;
        request.headers = RestClientRequestBuilder.toRestClientHeaders((MultiMap<String, String>)headers);
        request.textToSend = body;
        request.haveTextToSend = body != null;
        RestClientRequest restClientRequest = request;
        if (restClientRequest == null) {
            RestClientRequestBuilder.$$$reportNull$$$0(1);
        }
        return restClientRequest;
    }

    @NotNull
    private static List<Pair.NonNull<String, String>> mergeQuery(@Nullable GuzzleRequestOptions requestOptions, @Nullable GuzzleRequestOptions clientOptions) {
        if (requestOptions == null && clientOptions == null) {
            List<Pair.NonNull<String, String>> list = Collections.emptyList();
            if (list == null) {
                RestClientRequestBuilder.$$$reportNull$$$0(2);
            }
            return list;
        }
        if (requestOptions == null) {
            List<Pair.NonNull<String, String>> list = clientOptions.getQuery();
            if (list == null) {
                RestClientRequestBuilder.$$$reportNull$$$0(3);
            }
            return list;
        }
        if (clientOptions == null) {
            List<Pair.NonNull<String, String>> list = requestOptions.getQuery();
            if (list == null) {
                RestClientRequestBuilder.$$$reportNull$$$0(4);
            }
            return list;
        }
        List<Pair.NonNull<String, String>> optionsQuery = clientOptions.getQuery();
        if (!requestOptions.getQuery().isEmpty()) {
            optionsQuery = requestOptions.getQuery();
        }
        List<Pair.NonNull<String, String>> list = optionsQuery;
        if (list == null) {
            RestClientRequestBuilder.$$$reportNull$$$0(5);
        }
        return list;
    }

    @NotNull
    public static MultiMap<String, String> mergeHeaders(@Nullable GuzzleRequestOptions requestOptions, @Nullable GuzzleRequestOptions clientOptions) {
        if (requestOptions == null && clientOptions == null) {
            MultiMap multiMap = MultiMap.empty();
            if (multiMap == null) {
                RestClientRequestBuilder.$$$reportNull$$$0(6);
            }
            return multiMap;
        }
        if (requestOptions == null) {
            MultiMap<String, String> multiMap = clientOptions.getHeaders().getHeaders();
            if (multiMap == null) {
                RestClientRequestBuilder.$$$reportNull$$$0(7);
            }
            return multiMap;
        }
        if (clientOptions == null) {
            MultiMap<String, String> multiMap = requestOptions.getHeaders().getHeaders();
            if (multiMap == null) {
                RestClientRequestBuilder.$$$reportNull$$$0(8);
            }
            return multiMap;
        }
        GuzzleRequestOptions.HeadersOptions clientHeaders = clientOptions.getHeaders();
        GuzzleRequestOptions.HeadersOptions requestHeaders = requestOptions.getHeaders();
        if (requestHeaders == GuzzleRequestOptions.HeadersOptions.EMPTY) {
            MultiMap<String, String> multiMap = clientHeaders.getHeaders();
            if (multiMap == null) {
                RestClientRequestBuilder.$$$reportNull$$$0(9);
            }
            return multiMap;
        }
        if (clientHeaders == GuzzleRequestOptions.HeadersOptions.EMPTY) {
            MultiMap<String, String> multiMap = requestHeaders.getHeaders();
            if (multiMap == null) {
                RestClientRequestBuilder.$$$reportNull$$$0(10);
            }
            return multiMap;
        }
        MultiMap headers = MultiMap.createLinked();
        if (!requestHeaders.isDefaultDisabled()) {
            headers.putAllValues(clientHeaders.getHeaders());
        }
        for (Map.Entry entry : requestHeaders.getHeaders().entrySet()) {
            headers.put((Object)((String)entry.getKey()), (Collection)entry.getValue());
        }
        MultiMap multiMap = headers;
        if (multiMap == null) {
            RestClientRequestBuilder.$$$reportNull$$$0(11);
        }
        return multiMap;
    }

    private static <T> T mergeOption(@Nullable GuzzleRequestOptions requestOptions, @Nullable GuzzleRequestOptions clientOptions, @NotNull Function<GuzzleRequestOptions, T> getter) {
        if (getter == null) {
            RestClientRequestBuilder.$$$reportNull$$$0(12);
        }
        if (requestOptions == null && clientOptions == null) {
            return null;
        }
        if (requestOptions == null) {
            return (T)getter.fun((Object)clientOptions);
        }
        if (clientOptions == null) {
            return (T)getter.fun((Object)requestOptions);
        }
        Object requestOption = getter.fun((Object)requestOptions);
        return (T)(requestOption != null ? requestOption : getter.fun((Object)clientOptions));
    }

    @NotNull
    private static List<RestClientRequest.KeyValuePair> toRestClientHeaders(@NotNull MultiMap<String, String> optionsHeaders) {
        if (optionsHeaders == null) {
            RestClientRequestBuilder.$$$reportNull$$$0(13);
        }
        ArrayList<RestClientRequest.KeyValuePair> headers = new ArrayList<RestClientRequest.KeyValuePair>();
        for (Map.Entry entry : optionsHeaders.entrySet()) {
            for (String value : (Collection)entry.getValue()) {
                headers.add(new RestClientRequest.KeyValuePair((String)entry.getKey(), value));
            }
        }
        ArrayList<RestClientRequest.KeyValuePair> arrayList = headers;
        if (arrayList == null) {
            RestClientRequestBuilder.$$$reportNull$$$0(14);
        }
        return arrayList;
    }

    @NotNull
    private static String getUrlBase(@NotNull URL url) {
        if (url == null) {
            RestClientRequestBuilder.$$$reportNull$$$0(15);
        }
        String urlBase = url.getProtocol() + "://" + url.getHost();
        int port = url.getPort();
        if (port != -1) {
            urlBase = urlBase + ":" + port;
        }
        String string = urlBase;
        if (string == null) {
            RestClientRequestBuilder.$$$reportNull$$$0(16);
        }
        return string;
    }

    @NotNull
    public static List<Pair.NonNull<String, String>> parseQueryString(@Nullable String value) {
        if (value == null) {
            List<Pair.NonNull<String, String>> list = Collections.emptyList();
            if (list == null) {
                RestClientRequestBuilder.$$$reportNull$$$0(17);
            }
            return list;
        }
        ArrayList<Pair.NonNull<String, String>> query = new ArrayList<Pair.NonNull<String, String>>();
        for (String part : value.split("&")) {
            String[] pair = part.split("=");
            if (pair.length != 2) continue;
            query.add((Pair.NonNull<String, String>)Pair.createNonNull((Object)pair[0], (Object)pair[1]));
        }
        ArrayList<Pair.NonNull<String, String>> arrayList = query;
        if (arrayList == null) {
            RestClientRequestBuilder.$$$reportNull$$$0(18);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 14, 16, 17, 18 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "obligatoryParameters";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 14: 
            case 16: 
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/restClient/guzzle/RestClientRequestBuilder";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "getter";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "optionsHeaders";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/restClient/guzzle/RestClientRequestBuilder";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "build";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "mergeQuery";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "mergeHeaders";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "toRestClientHeaders";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getUrlBase";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "parseQueryString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "build";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 14: 
            case 16: 
            case 17: 
            case 18: {
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "mergeOption";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "toRestClientHeaders";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getUrlBase";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 14, 16, 17, 18 -> new IllegalStateException(string);
        };
    }
}

