/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.roots;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.roots.PhpNamespaceByFilesProvider;
import com.jetbrains.php.roots.PhpNamespaceProvider;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class PhpNamespaceByParentDirContentsProvider
implements PhpNamespaceProvider {
    public static final PhpNamespaceProvider INSTANCE = new PhpNamespaceByParentDirContentsProvider();
    private static final int MAX_VISITED_DIRS = 5;

    @Override
    @NotNull
    public List<String> suggestNamespaces(@NotNull PsiDirectory currentDir) {
        PsiDirectory parentDirectory;
        if (currentDir == null) {
            PhpNamespaceByParentDirContentsProvider.$$$reportNull$$$0(0);
        }
        if ((parentDirectory = currentDir.getParentDirectory()) != null) {
            String commonNamespace;
            HashSet<String> possibleParentNamespaces = new HashSet<String>();
            ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)currentDir.getProject()).getFileIndex();
            int visitedDirsCount = 0;
            for (PsiElement siblingOfCurrentDir : parentDirectory.getChildren()) {
                PsiDirectory dir;
                PsiFileSystemItem fileOrDir;
                if (!(siblingOfCurrentDir instanceof PsiFileSystemItem) || !fileIndex.isInProject((fileOrDir = (PsiFileSystemItem)siblingOfCurrentDir).getVirtualFile())) continue;
                if (!siblingOfCurrentDir.equals((Object)currentDir) && siblingOfCurrentDir instanceof PsiDirectory && !(dir = (PsiDirectory)siblingOfCurrentDir).getName().equals("vendor")) {
                    suggestedNamespace = (String)ContainerUtil.getOnlyItem(PhpNamespaceByFilesProvider.INSTANCE.suggestNamespaces(dir));
                    ++visitedDirsCount;
                    if (suggestedNamespace != null) {
                        possibleParentNamespaces.add(PhpLangUtil.getParentQualifiedName(suggestedNamespace));
                    }
                } else if (siblingOfCurrentDir instanceof PsiFile) {
                    PsiFile file = (PsiFile)siblingOfCurrentDir;
                    suggestedNamespace = PhpNamespaceByFilesProvider.extractNamespace(file);
                    ContainerUtil.addIfNotNull(possibleParentNamespaces, (Object)suggestedNamespace);
                }
                if (visitedDirsCount >= 5 || possibleParentNamespaces.size() > 1) break;
            }
            if ((commonNamespace = (String)ContainerUtil.getOnlyItem(possibleParentNamespaces)) != null) {
                String fqn = commonNamespace + "\\" + currentDir.getName();
                return new SmartList((Object)PhpLangUtil.toPresentableFQN(fqn));
            }
        }
        List<String> list = Collections.emptyList();
        if (list == null) {
            PhpNamespaceByParentDirContentsProvider.$$$reportNull$$$0(1);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentDir";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/roots/PhpNamespaceByParentDirContentsProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/roots/PhpNamespaceByParentDirContentsProvider";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "suggestNamespaces";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "suggestNamespaces";
                break;
            }
            case 1: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

